@extends('medical_record.e_rekam_medis.dokumen_kunjungan.layout')
@section('content')
<style>
    .inputan {
        border: none;
        border-bottom: 1px dotted;
    }

    p {
        margin-bottom: 0;
    }

    #tabel_riwayat_kehamilan tr th {
        text-align: center;
    }
</style>
<form style="border:1px solid;" class="container pl-0 pr-0" id="form_dokumen">
    @csrf
    <input type="hidden" name="dokumen" value="{{ $dokumen->id }}">
    <input type="hidden" name="password">
    <input type="hidden" name="id_diagnosa" value="{{ $data->id_diagnosa ?? 0 }}">
    <input type="hidden" name="id_lab" value="{{ $data->id_lab ?? 0 }}">
    <input type="hidden" name="id_resep" value="{{ $data->id_resep ?? 0 }}">
    @include('medical_record.e_rekam_medis.dokumen_kunjungan.kop')

    <div class="row" style="width:100%;;border-left:none;">
        <div class="col-md-12">
            <table class="tabel_layout" style="width: 100%; border-collapse: collapse;">
                <tr>
                    <td class="pl-2">
                        Tanggal :
                        <input type="text" name="tanggal" id="tanggal" class="datepicker inputan" value="{{ $data->tanggal ?? ''}}" style="height:20px; width:27%; margin-left:10px;">
                    </td>
                    <td>
                        Jam :
                        <input type="text" name="jam" id="jam" class="timepicker inputan" value="{{ $data->jam ?? ''}}" style="height:20px; width:18%; margin-left:10px;">
                    </td>
                </tr>
                <tr>
                    <td colspan="2" class="pl-2 pt-2">
                        Kategori Skrining Visual :
                        <input type="radio" name="opsi_kategori_skrining" value="hijau" {{ $data && $data->kategori_skrining == 'hijau' ? 'checked' : ''}}> hijau&emsp;
                        <input type="radio" name="opsi_kategori_skrining" value="kuning" {{ $data && $data->kategori_skrining == 'kuning' ? 'checked' : ''}}> kuning&emsp;
                        <input type="radio" name="opsi_kategori_skrining" value="merah" {{ $data && $data->kategori_skrining == 'merah' ? 'checked' : ''}}> merah
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row pl-2 pr-2">
        <div class="col-md-12">
            <table class="tabel_layout" style="margin-bottom: 10px;margin-top:10px; width: 100%;">
                <tr>
                    <td style="width: 20%;">Nama Suami</td>
                    <td class="pl-2 pr-2" style="width: 3%;"> : </td>
                    <td style="width: 77%;">
                        <input type="text" name="nama_suami" id="nama_suami" class="inputan" value="{{ $data ? $data->nama_suami : ($data_sebelumnya ? $data_sebelumnya->nama_suami : '') }}" style="width: 100%;">
                    </td>
                </tr>
                <tr>
                    <td>NO KK</td>
                    <td class="pl-2 pr-2"> : </td>
                    <td>
                        <input type="number" name="no_kk" id="no_kk" class="inputan" value="{{ $data ? $data->no_kk : ($data_sebelumnya ? $data_sebelumnya->no_kk : '') }}" style="width: 100%;">
                    </td>
                </tr>
                <tr>
                    <td colspan="3">
                        <h6>ANAMNESIS</h6>
                    </td>
                </tr>
                <tr>
                    <td>Keluhan Utama</td>
                    <td class="pl-2 pr-2"> : </td>
                    <td>
                        <input type="text" name="keluhan_utama" id="keluhan_utama" class="inputan" style="width: 100%;" value="{{ $diagnosa && $diagnosa->keluhan ? $diagnosa->keluhan : '' }}" readonly>
                    </td>
                </tr>
                <tr>
                    <td>Riwayat kehamilan sekarang</td>
                    <td class="pl-2 pr-2"> : </td>
                    <td>
                        <input type="text" name="riwayat_kehamilan_sekarang" id="riwayat_kehamilan_now" value="{{ $data ? $data->riwayat_kehamilan_sekarang : '' }}" class="inputan" style="width: 100%;">
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row pl-2 pr-2">
        <div class="col-md-12">
            <p>
                Golongan Darah : <input type="text" value="{{ $data ? $data->golongan_darah : '' }}" name="golongan_darah" class="inputan" style="width: 10%">
                Imunisasi TT :
                <input type="radio" name="imunisasi_tt" value="tidak" {{ $data && $data->imunisasi_tt == 'tidak' ? 'checked' : ''}}>Tidak
                <input style="margin-left: 2%" type="radio" name="imunisasi_tt" value="ya" {{ $data && $data->imunisasi_tt == 'ya' ? 'checked' : ''}}> Ya, kapan
                <input type="text" value="{{ $data ? $data->waktu_imunisasi : '' }}" style="width:10%;" class="inputan" name="waktu_imunisasi" id="waktu_imunisasi">
            </p>
            <p>
                Lama menikah : <input value="{{ $data->lama_menikah ?? '' }}" type="text" style="width: 10%" name="lama_menikah" class="inputan">
                <span style="margin-left: 2%"></span>
                KB :
                <input type="radio" name="opsi_kb" value="tidak" {{ $data && $data->kb == 'tidak' ? 'checked' : '' }}> Tidak
                <input style="margin-left: 2%" type="radio" name="opsi_kb" value="ya" {{ $data && $data->kb == 'ya' ? 'checked' : 'checked' }}> Ya, jenis alat
                kontrasepsi :
                <input type="text" value="{{ $data->alat_kb ?? '' }}" name="alat_kb" class="inputan" id="alat_kb">
            </p>
            <p>
                <span style="margin-left: 2%"></span>
                Gravida <input style="width:10%" type="text" class="inputan" name="gravida" value="{{ $data ? $data->gravida : ($data_sebelumnya ? $data_sebelumnya->gravida : '' ) }}">
                Para <input style="width:10%" type="text" class="inputan" name="para" value="{{ $data ? $data->para : ($data_sebelumnya ? $data_sebelumnya->para : '' ) }}">
                Abortus <input style="width:10%" type="text" class="inputan" name="abortus" value="{{ $data ? $data->abortus : ($data_sebelumnya ? $data_sebelumnya->abortus : '' ) }}">
                HPHT <input value="{{ $data ? $data->hpht : ($data_sebelumnya->hpht ?? '') }}" style="width:10%" type="text" class="inputan" id="hpht" name="hpht">
                HPL <input value="{{ $data ? $data->hpl : ($data_sebelumnya->hpl ?? '') }}" style="width:10%" type="text" class="inputan" id="hpl" name="hpl">
            </p>
        </div>
        <div class="col-md-12" style="margin-top:10px;">
            Riwayat Kehamilan dan Persalinan yang lalu :
            <table class="tabel_layout" id="tabel_riwayat_kehamilan" border="1" style="width: 100%; font-size: 12px;">
                <thead>
                    <tr>
                        <th rowspan="2">Tahun</th>
                        <th colspan="6">IBU</th>
                        <th colspan="4">BAYI</th>
                        <th rowspan="2" class="no-print">
                            <button class="btn btn-success no-print btn-sm" onclick="open_modal_form_riwayat()" type="button">
                                <i class="fa fa-plus"></i>
                            </button>
                        </th>
                    </tr>
                    <tr>
                        <th>Umur Kehamilan</th>
                        <th>Jenis Partus</th>
                        <th>Tempat Partus</th>
                        <th>Penolong</th>
                        <th>Penyulit</th>
                        <th>Nifas</th>
                        <th>Anak Ke</th>
                        <th>♂ | ♀</th>
                        <th>BB</th>
                        <th>Usia Anak</th>
                    </tr>
                </thead>
                <tbody id="list_riwayat_kehamilan"></tbody>
            </table>
        </div>
    </div>
    <div class="row pl-2 pr-2" style="padding-top:20px;">
        <div class="col-md-12">
            <table class="tabel_layout" style="width: 100%;">
                <tr>
                    <td style="width: 25%">Riwayat Penyakit Dahulu / kronis</td>
                    <td style="width: 3%;" class="pl-2 pr-2"> : </td>
                    <td style="width: 72%;">
                        <input type="text" name="riwayat_penyakit" id="riwayat_penyakit" class="inputan" style="width: 100%;" value="{{ $data? $data->riwayat_penyakit : '' }}">
                    </td>
                </tr>
                <tr>
                    <td>Obat yang Diminum Rutin</td>
                    <td style="width: 3%;" class="pl-2 pr-2"> : </td>
                    <td>
                        <input type="text" name="obat_diminum" id="obat_diminum" class="inputan" style="width: 100%;" value="{{ $data? $data->obat_diminum : '' }}">
                    </td>
                </tr>
                <tr>
                    <td>Riwayat Penyakit Keluarga</td>
                    <td style="width: 3%;" class="pl-2 pr-2"> : </td>
                    <td>
                        <input type="text" name="riwayat_penyakit_keluarga" id="riwayat_penyakit_keluarga" class="inputan" style="width: 100%;" value="{{ $data? $data->riwayat_penyakit_keluarga : '' }}">
                    </td>
                </tr>
                <tr>
                    <td>Alergi Obat</td>
                    <td style="width: 3%;" class="pl-2 pr-2"> : </td>
                    <td>
                        <input type="text" name="alergi_obat" id="alergi_obat" class="inputan" style="width: 100%;" value="{{ $data? $data->alergi_obat : '' }}">
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row pl-2 pr-2 pt-2">
        <div class="col-md-12">
            <h6>PEMERIKSAAN FISIK</h6>
            <p style="font-weight:bold">Tanda Vital</p>
            <table style="width: 100%; border-collapse: collapse;">
                <tr>
                    <td class="text-center">
                        TTV : TD {{ $diagnosa ? $diagnosa->sistole."/".$diagnosa->diastole : '..../....' }} mmHg
                    </td>
                    <td class="text-center">
                        RR {{ $diagnosa->rr ?? '....' }} x/menit
                    </td>
                    <td class="text-center">
                        Nadi {{ $diagnosa->nadi ?? '....' }} x/menit
                    </td>
                    <td class="text-center">
                        Suhu {{ $diagnosa->suhu ?? '....' }} ᵒC
                    </td>
                </tr>
            </table>
            <p style="font-weight:bold">Status Generalis</p>
            <div class="col-md-12">
                <ul>
                    <li> Kepala/Leher : Normal</li>
                    <li> Thorax : Normal</li>
                    <li> Abdomen : Normal</li>
                    <li> Ekstremitas : Normal</li>
                    <li> Lain-lain :<input type="text" name="generalis_lain" id="generalis_lain" class="inputan" value="{{ $data->generalis_lain ?? '' }}"></li>
                </ul>
            </div>
        </div>
    </div>
    <div class="row pl-2 pr-2">
        <div class="col-md-12">
            <p style="font-weight:bold">Periksaan Kehamilan</p>
            <div class="col-md-12">
                <ul>
                    <li> Tinggi fundus :<input type="text" name="tinggi_fundus" id="tinggi_fundus" class="inputan" value="{{ $data->tinggi_fundus ?? '' }}"></li>
                    <li> Letak Janin :<input type="text" name="letak_janin" id="letak_janin" class="inputan" value="{{ $data->letak_janin ?? '' }}"></li>
                    <li> Usia kehamilan :<input type="text" name="usia_kehamilan" id="usia_kehamilan" class="inputan" value="{{ $data->usia_kehamilan ?? '' }}"></li>
                    <li> DJJ :<input type="text" name="djj" id="djj" class="inputan" value="{{ $data->djj ?? '' }}"></li>
                    <li> Lain-lain :<input type="text" name="periksaan_lain" id="periksaan_lain" class="inputan" value="{{ $data->periksaan_lain ?? '' }}"></li>
                </ul>
            </div>
        </div>
    </div>
    <div class="row pl-2 pr-2">
        <div class="col-md-12">
            <h6>ASSESMEN</h6>
            <div id="box_button_diagnosa">
                <button type="button" style="color: #fff; font-weight: bold;" class="btn btn-sm btn-{{ $diagnosa ? 'warning' : 'dark' }}" onclick="open_form_diagnosa()"><i class="fa fa-{{ $diagnosa ? 'pencil' : 'plus' }}"></i></button>
            </div>
            <table class="table_layout" style="width: 100%;">
                <tr>
                    <td style="width: 15%;">Catatan Diagnosa</td>
                    <td style="width: 3%;"> : </td>
                    <td style="width: 82%;">
                        <input type="text" id="tmp_catatan_diagnosa" class="inputan" style="width: 100%;" value="{{ $diagnosa->diagnosa ?? ''}} " readonly>
                    </td>
                </tr>
                <tr>
                    <td style="width: 15%;">Diagnosa utama</td>
                    <td style="width: 3%;"> : </td>
                    <td style="width: 82%;">
                        <input type="text" id="box_diagnosa" class="inputan" style="width: 100%;" value="{{ $diagnosa ? ($diagnosa->kode_icd != '' ? $diagnosa->kode_icd . ' - ' . $diagnosa->nama_icd : $diagnosa->nama_icd) : '' }}" readonly>
                    </td>
                </tr>
                <tr>
                    <td style="width: 15%;">Diagnosa sekunder</td>
                    <td style="width: 3%;"> : </td>
                    <td style="width: 82%;">
                        <input type="text" id="box_diagnosa_sekunder" class="inputan" style="width: 100%;" value="{{ $diagnosa ? ($diagnosa->kode_icd_sekunder != '' ? $diagnosa->kode_icd_sekunder . ' - ' . $diagnosa->nama_icd_sekunder : $diagnosa->nama_icd_sekunder) : '' }}" readonly>
                    </td>
                </tr>
            </table>
            <h6>PLANNING</h6>
            <p>Pemeriksaan Penunjang</p>
            <table class="table_layout" style="width: 100%;">
                <!-- <tr>
                    <td style="width: 20%;">A. Laboratorium</td>
                    <td style="width: 3%;" class="pl-2 pr-2"> : </td>
                    <td style="width: 77%;">
                        <div style="display: flex; flex-direction: row" class="pb-2">
                            <div id="box_button_pesanan_lab" class="mr-2">
                                @if($laboratorium)
                                <button class="btn btn-warning btn-sm" type="button" style="color: #fff" onclick="open_modal_lab()">
                                    <i class="fa fa-pencil"></i>
                                </button>
                                <button class="btn btn-info btn-sm" type="button" style="color: #fff" onclick="open_modal_hasil_lab()">
                                    <i class="fa fa-book"></i>
                                </button>
                                @else
                                <button class="btn btn-dark btn-sm" type="button" onclick="open_modal_lab()">
                                    <i class="fa fa-plus"></i>
                                </button>
                                @endif
                            </div>
                            <div id="list_pesanan_lab">
                                <?php
                                if ($laboratorium) {
                                    $temp = '';
                                    $iteration = 0;
                                    $json = (array) json_decode($laboratorium->periksa);

                                    for ($i = 0; $i < sizeof($pemeriksaan); $i++) {
                                        if ($json[$pemeriksaan[$i]->slug] == 1) {
                                            $temp .= ($iteration > 0 ? ', ' : '') . $pemeriksaan[$i]->nama;
                                            $iteration++;
                                        }
                                    }
                                ?>
                                    {{ $laboratorium->no_lab }} - {{ $temp }}
                                <?php } ?>
                            </div>
                        </div>
                    </td>
                </tr> -->
                <!-- <tr>
                    <td colspan="3">A. Pemeriksaan Penunjang Lain</td>
                </tr> -->
                <tr>
                    <td>Terapi</td>
                    <td class="pl-2 pr-2"> : </td>
                    <td>
                        <div id="box_btn_terapi">
                            @if ($resep == null)
                            <button class="btn btn-dark btn-sm" type="button" onclick="open_modal_resep()">
                                <i class="fa fa-plus"></i>
                            </button>
                            @else
                            @if ($resep->locked == 0)
                            <button class="btn btn-warning btn-sm" type="button" onclick="open_modal_resep()">
                                <i class="fa fa-pencil" style="color:#fff;"></i>
                            </button>
                            <button class="btn btn-info btn-sm" type="button" onclick="lock_terapi()">Kirim ke farmasi</button>
                            @endif
                            <button class="btn btn-info btn-sm" type="button" onclick="preview_terapi()">Preview</button>
                            No. Resep Elektronik {{ $resep->id ?? '' }}
                            <table style="border-collapse: collapse; width:50%;">
                                @foreach ($resep->detail as $ar_det)
                                <tr>
                                    <td style="width:20px;">{{ 'R/' }}</td>
                                    <td>{{ $ar_det->nama_obat }}</td>
                                    <td>{{ $ar_det->signa }}</td>
                                    <td style="padding-left: 20px;">
                                        {{ $ar_det->jumlah . ' ' . $ar_det->satuan }}
                                    </td>
                                </tr>
                                @endforeach
                            </table>
                            {{ $resep->catatan_obat_racikan }}
                            @endif
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>Tindakan Medis</td>
                    <td class="pl-2 pr-2"> : </td>
                    <td>
                        <input type="text" name="tindakan_medis" id="tindakan_medis" class="inputan" value="{{$data?$data->tindakan_medis:''}}" style="width: 100%;">
                    </td>
                </tr>
                <tr>
                    <td>Tindak Lanjut</td>
                    <td class="pl-2 pr-2"> : </td>
                    <td>
                        <input type="text" name="tindak_lanjut" id="tindak_lanjut" class="inputan" value="{{$data?$data->tindak_lanjut:''}}" style="width: 100%;">
                    </td>
                </tr>

            </table>
        </div>
    </div>
    <div class="row pt-5 d-flex flex-row-reverse">
        <table style="width: 100%; border-collapse: collapse;">
            <tr>
                <td style="width: 50%;"></td>
                <td style="width: 50%; text-align: center;" onclick="open_modal_verifikasi()">
                    <p>Profesional Pemberi Asuhan</p>
                    @if($dokumen->status == 1)
                    <img src="{{ env('SMIS_UPLOAD_URL') . '/' . ($employee->ttd_foto ?? '') }}" style="height: 2.5cm; width: 5cm;" alt="">
                    <br>
                    ({{ $dokumen->nama_verifikator }})
                    @else
                    <br>
                    <br>
                    Simpan & verifikasi
                    <br>
                    <br>
                    (Bidan)
                    @endif
                </td>
            </tr>
        </table>
    </div>

    <textarea name="riwayat_kehamilan_dan_persalinan" hidden></textarea>
</form>

<div class="modal fade" id="modal_form_riwayat" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Riwayat Kehamilan</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="form_riwayat">
                <input type="hidden" id="index_riwayat">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="">Tahun</label>
                        <input type="number" id="tahun_riwayat" min="1900" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">Umur Kehamilan</label>
                        <input type="text" id="umur_kehamilan_riwayat" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">Jenis partus</label>
                        <select id="jenis_partus_riwayat" class="form-control">
                            <option value="">--Select Here--</option>
                            <option value="Normal">Normal</option>
                            <option value="SC">SC</option>
                            <option value="Vacuum Extractor">Vacuum Extractor</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Tempat partus</label>
                        <select id="tempat_partus_riwayat" class="form-control">
                            <option value="">--Select Here--</option>
                            <option value="BPM">BPM</option>
                            <option value="Rumah Sakit">Rumah Sakit</option>
                            <option value="Dukun">Dukun</option>
                            <option value="Rumah">Rumah</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Penolong</label>
                        <input type="text" class="form-control" id="penolong_riwayat">
                    </div>
                    <div class="form-group">
                        <label for="">Penyulit</label>
                        <input type="text" class="form-control" id="penyulit_riwayat">
                    </div>
                    <div class="form-group">
                        <label for="">Nifas</label>
                        <input type="text" class="form-control" id="nifas_riwayat">
                    </div>
                    <div class="form-group">
                        <label for="">Anak-Ke</label>
                        <input type="number" min="1" class="form-control" id="anak_ke_riwayat">
                    </div>
                    <div class="form-group">
                        <label for="">Jenis Kelamin</label>
                        <select id="kelamin_riwayat" class="form-control">
                            <option value="">--Select Here--</option>
                            <option value="0">Laki-Laki</option>
                            <option value="1">Perempuan</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Berat Badan</label>
                        <input type="number" min="0" step="0.1" class="form-control" id="bb_riwayat">
                    </div>
                    <div class="form-group">
                        <label for="">Usia Anak</label>
                        <input type="text" class="form-control" id="usia_anak_riwayat">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

@include('medical_record.e_rekam_medis.dokumen_kunjungan.popup_verifikasi')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.laboratorium')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.diagnosa')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.resep')
@endsection
@push('scripts')
<script>
    let riwayat_kehamilan_dan_persalinan = [];

    $(document).ready(function() {
        $('#pesan_pemeriksaan').select2();
        <?php if ($data && $data->riwayat_kehamilan_dan_persalinan != null) { ?>
            riwayat_kehamilan_dan_persalinan = <?php echo $data->riwayat_kehamilan_dan_persalinan ?>;
            console.log(riwayat_kehamilan_dan_persalinan);
            render_riwayat();
        <?php } ?>
    })

    function open_modal_form_riwayat(index = '') {
        $('#form_riwayat')[0].reset();

        if (index != '') {
            $('#index_riwayat').val(index);
            $('#tahun_riwayat').val(riwayat_kehamilan_dan_persalinan[index].tahun);
            $('#umur_kehamilan_riwayat').val(riwayat_kehamilan_dan_persalinan[index].umur_kehamilan);
            $('#jenis_partus_riwayat').val(riwayat_kehamilan_dan_persalinan[index].jenis_partus);
            $('#tempat_partus_riwayat').val(riwayat_kehamilan_dan_persalinan[index].tempat_partus);
            $('#penolong_riwayat').val(riwayat_kehamilan_dan_persalinan[index].penolong);
            $('#penyulit_riwayat').val(riwayat_kehamilan_dan_persalinan[index].penyulit);
            $('#nifas_riwayat').val(riwayat_kehamilan_dan_persalinan[index].nifas);
            $('#anak_ke_riwayat').val(riwayat_kehamilan_dan_persalinan[index].anak_ke);
            $('#kelamin_riwayat').val(riwayat_kehamilan_dan_persalinan[index].kelamin);
            $('#bb_riwayat').val(riwayat_kehamilan_dan_persalinan[index].bb);
            $('#usia_anak_riwayat').val(riwayat_kehamilan_dan_persalinan[index].usia_anak);
        }

        $('#modal_form_riwayat').modal('show');
    }

    $('#form_riwayat').submit(function(e) {
        e.preventDefault();

        let obj_json = {
            tahun: $('#tahun_riwayat').val(),
            umur_kehamilan: $('#umur_kehamilan_riwayat').val(),
            jenis_partus: $('#jenis_partus_riwayat').val(),
            tempat_partus: $('#tempat_partus_riwayat').val(),
            penolong: $('#penolong_riwayat').val(),
            penyulit: $('#penyulit_riwayat').val(),
            nifas: $('#nifas_riwayat').val(),
            anak_ke: $('#anak_ke_riwayat').val(),
            kelamin: $('#kelamin_riwayat').val(),
            bb: $('#bb_riwayat').val(),
            usia_anak: $('#usia_anak_riwayat').val(),
        }

        if ($('#index_riwayat').val() != '') {
            riwayat_kehamilan_dan_persalinan[$('#index_riwayat').val()] = obj_json;
        } else {
            riwayat_kehamilan_dan_persalinan.push(obj_json);
        }

        $('#modal_form_riwayat').modal('hide');

        render_riwayat();
    })

    function render_riwayat() {
        var ins = '';

        for (let i = 0; i < riwayat_kehamilan_dan_persalinan.length; i++) {
            ins += '<tr>' +
                '<td class="text-center">' + riwayat_kehamilan_dan_persalinan[i].tahun + '</td>' +
                '<td class="pl-2">' + riwayat_kehamilan_dan_persalinan[i].umur_kehamilan + '</td>' +
                '<td class="pl-2">' + riwayat_kehamilan_dan_persalinan[i].jenis_partus + '</td>' +
                '<td class="pl-2">' + riwayat_kehamilan_dan_persalinan[i].tempat_partus + '</td>' +
                '<td class="pl-2">' + riwayat_kehamilan_dan_persalinan[i].penolong + '</td>' +
                '<td class="pl-2">' + riwayat_kehamilan_dan_persalinan[i].penyulit + '</td>' +
                '<td class="pl-2">' + riwayat_kehamilan_dan_persalinan[i].nifas + '</td>' +
                '<td class="text-center">' + riwayat_kehamilan_dan_persalinan[i].anak_ke + '</td>' +
                '<td class="text-center">' + (riwayat_kehamilan_dan_persalinan[i].kelamin == 1 ? 'Perempuan' : (riwayat_kehamilan_dan_persalinan[i].kelamin == 0 ? 'Laki-Laki' : '')) + '</td>' +
                '<td class="text-center">' + riwayat_kehamilan_dan_persalinan[i].bb + '</td>' +
                '<td class="pl-2">' + riwayat_kehamilan_dan_persalinan[i].usia_anak + '</td>' +
                '<td class="pl-2">' +
                '<div style="display:flex; flex-direction:row;">' +
                '<button type="button" class="btn btn-warning btn-sm" style="color:#fff;" onclick="open_modal_form_riwayat(' + "'" + i + "'" + ')">' +
                '<i class="fa fa-pencil"></i>' +
                '</button>' +
                '<button type="button" class="btn btn-danger ml-1 btn-sm" style="color:#fff;" onclick="hapus_riwayat(' + "'" + i + "'" + ')">' +
                '<i class="fa fa-trash"></i>' +
                '</button>' +
                '</div>' +
                '</td>' +
                '</tr>';
        }

        $('#list_riwayat_kehamilan').html(ins);
    }

    function hapus_riwayat(index) {
        if (!confirm('Yakin hapus riwayat kehamilan ?')) {
            return;
        }
        riwayat_kehamilan_dan_persalinan.splice(index, 1);
        render_riwayat();
    }

    function open_modal_verifikasi() {
        $('#modal_verifikasi').modal('show');
    }

    $('#modal_verifikasi').submit(function(e) {
        e.preventDefault();
        $('[name=password]').val($('#pass').val());
        $('#modal_verifikasi').modal('hide');
        $('#form_verifikasi')[0].reset();
        $('#form_dokumen').submit();
    })

    $('#form_dokumen').submit(function(e) {
        e.preventDefault();

        toastr.warning('Sedang menyimpan dokumen, harap tunggu...');

        $('[name=riwayat_kehamilan_dan_persalinan]').val(JSON.stringify(riwayat_kehamilan_dan_persalinan));

        $.ajax({
            url: "{{ url('medical_record/e_rekam_medis/asesmen_kebidanan/store') }}",
            data: $('#form_dokumen').serialize(),
            method: 'post',
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }
                toastr.success(response.message);
            }
        })
    })
</script>
@include('medical_record.e_rekam_medis.dokumen_kunjungan.script.laboratorium')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.script.diagnosa')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.script.resep')
@endpush