@extends('layouts.app')
@section('content')
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Laporan Jasa Dokter (BPJS)</h1>
            </div>
            <div class="section-body">
                <div class="card">
                    @if ($errors->any())
                        <div class="col-lg-12 mt-3">
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    @endif
                </div>
                <div class="card">
                    <form method="get" action="{{ route('jasa_dokter_bpjs.filter') }}">
                        <div class="col-lg-12 row">
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label for="">Tanggal Dari :</label>
                                    <input type="text" id="tanggal_dari" name="tanggal_dari"
                                        class="datetimepicker form-control col-lg-12" placeholder="Pilih Tanggal"
                                        value="@date($tanggal_dari)">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label for="">Tanggal Sampai :</label>
                                    <input type="text" id="tanggal_sampai" name="tanggal_sampai"
                                        class="datetimepicker form-control col-lg-12" placeholder="Pilih Tanggal"
                                        value="@date($tanggal_sampai)">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Nama Dokter</label>
                                    <select class="form-control select-nama-dokter" name="nama_dokter" id="nama_dokter"
                                        required>
                                        <option value="">--Plih Nama Dokter--</option>
                                        @foreach ($list_nama_dokter as $dokter)
                                            <option {{ $req_nama_dokter == $dokter->nama_dokter ? 'selected' : ' ' }}
                                                value="{{ $dokter->nama_dokter }}">{{ $dokter->nama_dokter }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group" style="">
                                <button class="btn btn-primary" type="submit">
                                    Cari</button>
                                <a onclick="downloadExcel()" class="btn btn-success" data-toggle="tooltip"
                                    data-placement="top" title="Download Data"
                                    style="margin-left:8px ; color:white; cursor:pointer;">Download Excel</a>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="card">
                    <div class="card-header">
                        <h4>Operator</h4>
                    </div>
                    <div class="table-responsive" style="overflow-x:auto;">
                        @inject('nilai_tagihan', 'App\Services\JasaDokterBpjsService')
                        <table class="table table-bordered table-striped" style="">
                            <thead class="text-center">
                                <th>No</th>
                                <th>Tanggal Transaksi</th>
                                <th>Nama Pasien</th>
                                <th>Dokter Tindakan</th>
                                <th>Layanan</th>
                                <th>Nominal</th>
                                <th>Nilai Operator</th>
                            </thead>
                            <tbody>
                                @if (isset($data_operator))
                                    @forelse ($data_operator as $key => $dt)
                                        <tr>
                                            <td class="align-top">{{ $key + $data_operator->firstItem() }}</td>
                                            <td class="align-top">@date($dt->tanggal)</td>
                                            <td class="align-top">{{ $dt->nama_pasien }}</td>
                                            <td class="align-top">{{ $dt->nama_dokter }}</td>
                                            <td class="align-top">{{ $dt->nama_tagihan }}</td>
                                            <td class="align-top">@currency($dt->nilai)</td>
                                            <td class="align-top">
                                                    @currency($nilai_tagihan->getTindakan($dt->nama_tagihan, $dt->nilai)['operator'] ?? 0)
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="16" class="text-center">Data tidak ditemukan pada tanggal
                                                @date($tanggal_dari) s/d @date($tanggal_sampai)</td>
                                        </tr>
                                    @endforelse
                                @else
                                    <tr>
                                        <th colspan="8" class="text-center">Silahkan gunakan fitur cari untuk menampilkan
                                            data</th>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                    <div class="row mt-5" style="width: 100%; margin-left:0;">
                        <div class="col-lg-6" style="display: flex; align-items: center;">
                        </div>
                        <div class="col-lg-6" style="justify-content: flex-end; display: flex;">
                            {{ isset($data_operator) ? $data_operator->appends(Request::only('tanggal_dari', 'tanggal_sampai', 'nama_dokter'))->links('pagination::bootstrap-4') : '' }}
                        </div>
                    </div>
                </div>
            </div>
    </div>
    </div>
    </section>
    </div>

    <script src="https://code.jquery.com/jquery-3.3.1.min.js"
        integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.26.0/moment.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.2.0/css/datepicker.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.2.0/js/bootstrap-datepicker.min.js"></script>

    <script>
        $(".datetimepicker")
            .datepicker({
                format: "dd-mm-yyyy",
                startView: "day",
                minViewMode: "day",
                autoclose: true,
            });

        function downloadExcel() {

            var tanggal_dari = $('input[name=tanggal_dari]').val();
            var tanggal_sampai = $('input[name=tanggal_sampai]').val();
            var nama_dokter = $('select[name=nama_dokter] option').filter(':selected').val();

            var url = "{{ route('jasa_dokter_bpjs.download') }}?tanggal_dari=" + tanggal_dari +
                "&tanggal_sampai=" + tanggal_sampai + "&nama_dokter=" + nama_dokter
            if (confirm("Apakah anda ingin melanjutkan download ?")) {
                window.location.href = url;
            } else {
                return false;
            }
        }
    </script>
@endsection

@push('scripts')
<script>
  $(document).ready(function() {
    $('.select-nama-dokter').select2({
      templateSelection: function(data) {
        var $result = $(
          '<span class="select2-selection__rendered pt-1">' +
            data.text +
            '</span>'
        );

        return $result;
      },
    });
  });
</script>
@endpush
