<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Pengkajian Awal Medis</title>

    <link rel="stylesheet" href="{{ asset('app-assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.7/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="{{ asset('app-assets/css/select2-bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('app-assets/css/select2.min.css') }}" />
    <!-- <link type="text/css" href="//ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/south-street/jquery-ui.css" rel="stylesheet"> -->
    <!-- <link rel="stylesheet" type="text/css" href="//keith-wood.name/css/jquery.signature.css"> -->
    <style>
        #tabel_data_umum tr td {
            padding-top: 10px;
            padding-bottom: 10px;
        }

        #tabel_pemeriksaan_fisik tr {
            vertical-align: middle;
        }

        #tabel_pemeriksaan_fisik tr td {
            padding-bottom: 15px;
        }

        #tabel_lokalis tr td {
            border: 1px solid;
        }

        .kbw-signature {
            width: 100%;
            height: 200px;
        }

        #sig canvas {
            width: 100% !important;
            height: auto;
            position: relative;
            left: 0;
            top: 0;
            border: 1px solid;
        }

        #sig {
            opacity: 0.5;
        }

        .autocomplete-suggestions {
            border: 1px solid #999;
            background: #FFF;
            overflow: auto;
            cursor: pointer;
        }

        .autocomplete-suggestion {
            padding: 2px 5px;
            white-space: nowrap;
            overflow: hidden;
        }

        .autocomplete-selected {
            background: #F0F0F0;
        }

        .autocomplete-suggestions strong {
            font-weight: normal;
            color: #3399FF;
        }

        .autocomplete-group {
            padding: 2px 5px;
        }

        .autocomplete-group strong {
            display: block;
            border-bottom: 1px solid #000;
        }
    </style>
</head>

<body class="container">
    @if ($errors->any())
        @foreach ($errors->all() as $error)
            <div class="alert alert-danger">
                {{ $error }}
            </div>
        @endforeach
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">
            {{ Session::get('success') }}
        </div>
    @endif
    @if (Session::has('failed'))
        <div class="alert alert-danger">
            {{ Session::get('failed') }}
        </div>
    @endif

    <div class="modal fade" id="modal_diagnosa" style="overflow-y: scroll;" tabindex="-1" role="dialog"
        aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Asesmen</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="form_asesmen">
                    <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                    <input type="hidden" name="_method" value="POST" />
                    <input type="hidden" name="kode_icd_tindakan" id="kode_icd_tindakan" />
                    <input type="hidden" name="noreg" value="{{ $layanan->id }}" />
                    <input type="hidden" name="dokumen" value="{{ $dokumen->id }}" />
                    <input type="hidden" name="id_dokter" id="id_dokter" value="{{ Auth::user()->id }}" />
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="">Tanggal</label>
                            <input type="date" name="tanggal" id="tanggal_diagnosa" readonly class="form-control"
                                value="{{ date('Y-m-d', strtotime($dokumen->created_at)) }}" required>
                        </div>
                        <div class="form-group">
                            <label for="">Asal Ruangan</label>
                            <input type="text" name="ruangan" id="ruangan_diagnosa"
                                value="{{ $layanan->last_ruangan }}" readonly class="form-control">
                        </div>
                        <hr>
                        <p style="font-weight: bold; font-size:14px;">DATA DOKTER / PSIKOLOG</p>
                        <div class="form-group">
                            <label for="">Dokter / Psikolog</label>
                            <input type="text" name="dokter" value="{{ Auth::user()->realname }}" id="dokter"
                                readonly class="form-control">
                        </div>
                        {{-- <input type="hidden" name="nip_dokter" value="{{ $employee ? $employee->nip : '' }}"
                            id="nip_dokter" readonly class="form-control"> --}}
                        <hr>
                        <p style="font-weight: bold; font-size:14px;">DIAGNOSA</p>
                        <div class="form-group">
                            <label for="">Diagnosa Utama</label>
                            <input type="text" class="form-control" name="diagnosa" id="diagnosa_primer">
                        </div>
                        <div class="form-group">
                            <label for="">Diagnosa Sekunder 1</label>
                            <div class="input-group">
                                <input type="text" class="form-control" name="diagnosa_sekunder_satu"
                                    id="diagnosa_sekunder_satu">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="">Diagnosa Sekunder 2</label>
                            <input type="text" class="form-control" name="diagnosa_sekunder_dua"
                                id="diagnosa_sekunder_dua">
                        </div>
                        <div class="form-group">
                            <label for="">Diagnosa Sekunder 3</label>
                            <input type="text" class="form-control" name="diagnosa_sekunder_tiga"
                                id="diagnosa_sekunder_tiga">
                        </div>
                        <div id="box_msg"></div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="btn_simpan_diagnosa" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal_hasil_lab" tabindex="-1" role="dialog"
        aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Hasil Laboratorium</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table class="table table-bordered">
                        <thead>
                            <tr class="text-center">
                                <th>Jenis Pemeriksaan</th>
                                <th>Hasil</th>
                                <th>Nilai Rujukan</th>
                            </tr>
                        </thead>
                        <tbody id="list_hasil_lab">
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    {{-- <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button> --}}
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal_employee" tabindex="-1" style="overflow-y: scroll;" role="dialog"
        aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="judul_employee"></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="col-lg-12">
                        <table class="table" id="tabel_employee">
                            <thead>
                                <tr class="text-center">
                                    <th>Nama</th>
                                    <th>Jabatan</th>
                                    <th>NIP</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal_lab" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true" style="overflow-y: scroll">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Pesanan Lab</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="" id="form_laboratorium" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="">No. Reg</label>
                            <input type="text" class="form-control" name="noreg" value="{{ $layanan->id }}"
                                readonly>
                        </div>
                        <div class="form-group">
                            <label for="">Nama Pasien</label>
                            <input type="text" name="nama_pasien" value="{{ $layanan->nama_pasien }}"
                                class="form-control" readonly>
                        </div>
                        <div class="form-group">
                            <label for="">NRM</label>
                            <input type="text" name="nrm" value="{{ $layanan->nrm }}" readonly
                                class="form-control">
                        </div>
                        <div class="form-group">
                            <label for="">L/P</label>
                            <select name="kelamin" class="form-control">
                                <option value="1" @if ($layanan->kelamin == 1) {{ 'selected' }} @endif>
                                    Perempuan</option>
                                <option value="0" @if ($layanan->kelamin == 0) {{ 'selected' }} @endif>
                                    Laki-Laki</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="">Umur</label>
                            <input type="text" value="{{ $layanan->umur }}" name="umur" class="form-control">
                        </div>
                        <div class="form-group">
                            <label for="">Alamat</label>
                            <textarea name="alamat" class="form-control" style="height: 100%;" cols="30" rows="5">{{ $layanan->alamat }}</textarea>
                        </div>
                        <div class="form-group">
                            <label for="">Ibu Kandung</label>
                            <input type="text" name="ibu" value="{{ $layanan->ibu }}" class="form-control">
                        </div>
                        <div class="form-group">
                            <label for="">Jenis Pasien</label>
                            <input type="text" name="jenis_pasien" value="{{ $layanan->carabayar }}"
                                class="form-control">
                        </div>
                        <div class="form-group">
                            <label for="">Ruangan</label>
                            <select name="ruangan" id="ruangan" class="form-control">
                                <option value="">--Select Here--</option>
                                @foreach ($ruangan as $ru)
                                    <option value="{{ $ru->slug }}"
                                        @if ($layanan->last_ruangan == $ru->slug) {{ 'selected' }} @endif>
                                        {{ $ru->nama }}
                                    </option>
                                @endforeach
                                <option value="pendaftaran"
                                    @if ($layanan->last_ruangan == 'pendaftaran') {{ 'selected' }} @endif>Pendaftaran</option>
                                <option value="laboratory"
                                    @if ($layanan->last_ruangan == 'laboratory') {{ 'selected' }} @endif>Laboratory</option>
                                <option value="radiology"
                                    @if ($layanan->last_ruangan == 'radiology') {{ 'selected' }} @endif>
                                    Radiology</option>
                                <option value="elektromedis"
                                    @if ($layanan->last_ruangan == 'elektromedis') {{ 'selected' }} @endif>Elektromedis
                                </option>
                                <option value="medical_checkup"
                                    @if ($layanan->last_ruangan == 'medical_checkup') {{ 'selected' }} @endif>Medical Checkup
                                </option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="">Tanggal</label>
                            <input type="date" value="{{ date('Y-m-d') }}" name="tanggal" class="form-control">
                        </div>
                        <div class="form-group">
                            <label for="">Kelas</label>
                            <select name="kelas" id="kelas" class="form-control">
                                <option value="">--Select Here--</option>
                                @foreach ($list_kelas as $kls)
                                    <option value="{{ $kls->slug }}"
                                        @if ($kelas) @if ($kls->slug == $kelas->value) {{ 'selected' }} @endif
                                        @endif>{{ $kls->nama }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="">Dokter</label>
                            <div class="input-group">
                                <input type="text" id="dokter_lab" value="{{ Auth::user()->realname }}"
                                    name="dokter" readonly placeholder="Pilih dokter" class="form-control">
                                <input type="hidden" id="id_dokter_lab" value="{{ Auth::user()->id }}"
                                    name="id_dokter">
                                <div class="input-group-append">
                                    <button type="button" onclick="open_modal_employee('Dokter','dokter')"
                                        class="btn btn-primary"><i class="fa fa-list"></i></button>
                                </div>
                            </div>
                        </div>
                        {{-- <div class="form-group">
                            <label for="">Konsultan</label>
                            <div class="input-group">
                                <input type="text" name="konsultan" id="konsultan_lab" readonly
                                    placeholder="Pilih konsultan" class="form-control">
                                <input type="hidden" name="id_konsultan" id="id_konsultan_lab">
                                <div class="input-group-append">
                                    <button type="button" onclick="open_modal_employee('Konsultan','konsultan')"
                                        class="btn btn-primary"><i class="fa fa-list"></i></button>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="">Petugas</label>
                            <div class="input-group">
                                <input type="text" name="petugas" id="petugas_lab" readonly
                                    placeholder="Pilih petugas" class="form-control">
                                <input type="hidden" name="id_petugas" id="id_petugas_lab">
                                <div class="input-group-append">
                                    <button type="button" onclick="open_modal_employee('Petugas','petugas')"
                                        class="btn btn-primary"><i class="fa fa-list"></i></button>
                                </div>
                            </div>
                        </div> --}}
                        <div class="form-group">
                            <label for="">Diagnosa</label>
                            <input type="text" name="diagnosa" id="diagnosa_lab" class="form-control">
                        </div>
                        <div class="form-group">
                            <label for="">Pesan Pemeriksaan</label>
                            <select name="pemeriksaan[]" multiple="multiple" id="pemeriksaan" style="width: 100%"
                                class="form-control">
                                @foreach ($pemeriksaan as $pe)
                                    <option value="{{ $pe->slug }}">{{ $pe->nama }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div id="loading_pesanan_lab"></div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal_verifikasi" tabindex="-1" role="dialog"
        aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Verifikasi</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ url('medical_record/e_rekam_medis/verifikasi_dokumen_kunjungan') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <input type="hidden" name="id_dokumen" value="{{ $dokumen->id }}" id="id_dokumen">
                        <input type="hidden" name="slug_dokumen"
                            value="{{ strtolower(str_replace(' ', '_', $dokumen->nama_dokumen)) }}">
                        <div class="form-group">
                            <label for="">Password</label>
                            <input type="password" placeholder="Masukkan password untuk melanjutkan"
                                class="form-control" name="password" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Verifikasi</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="row pt-3" style="width: 100%; margin-left: 0;">
        <div class="col-md-2 pl-0">
            <img src="{{ asset('filelogo/logo_new.png') }}" alt="" style="width: 100%; position: absolute">
        </div>
        <div class="col-md-4">
            <div style="display: flex; flex-direction: row">
                <hr style="width: 80px; border:1px solid #111; margin-top: 18px;">
                <span style="font-size: 22px">Klinik Utama</span>
                <hr style="width: 80px; border:1px solid #111; margin-top: 18px;">
            </div>
            <p style="width: 100%; font-size: 29px; text-align: center; margin-top: -10px; font-weight:bold;">
                Dharmahusada Premier
            </p>
            <p style="width: 100%; text-align: center; font-size: 14px; margin-top: -20px;">
                Jl. Raya Dharmahusada Indah No. 26, Mojo,<br>Kec. Gubeng, Kota Surabaya, Jawa Timur, 60285.<br>
                Telp : (031) 5921101 | 0851 3366 4118<br>
                Email : klinik.dharmahusadaoremier@gmail.com
            </p>
        </div>
        <div class="col-md-7" style="text-align: center;">
        </div>
        <div class="col-md-12 mt-3" style="border:1px solid; border-width: 1px;">
            <p style="text-align: center; font-weight:bold; padding-top: 12px;">
                PENGKAJIAN AWAL MEDIS
            </p>
        </div>
    </div>
    <form class="row pt-3 pb-3" style="width: 100%; margin-left: 0;" method="post"
        action="{{ url('medical_record/e_rekam_medis/pengkajian_awal_medis/save') }}">
        @csrf
        <input type="hidden" name="dokumen" value="{{ $dokumen->id }}">
        <div class="col-md-12 pl-0">
            <p>
                Tanggal / Pukul :
                <input type="date"
                    value="{{ $dokumen->pengkajian_awal_medis ? date('Y-m-d', strtotime($dokumen->pengkajian_awal_medis->tanggal)) : '' }}"
                    name="tanggal" id="tanggal">
                /
                <input type="time" name="pukul" id="pukul"
                    value="{{ $dokumen->pengkajian_awal_medis ? date('H:i', strtotime($dokumen->pengkajian_awal_medis->tanggal)) : '' }}">
            </p>
            <p>
                <span style="font-weight: bold">I. ANAMNESA UMUM</span>
                <input class="ml-4"
                    {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->anamnesa_umum == 'autoanamnesa' ? 'checked' : '') : '' }}
                    type="radio" value="autoanamnesa" name="anamnesa_umum" id="autoanamnesa" required>
                Autoanamnesa
                <input class="ml-4"
                    {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->anamnesa_umum == 'alloanamnesa' ? 'checked' : '') : '' }}
                    type="radio" value="alloanamnesa" name="anamnesa_umum" id="alloanamnesa">
                Alloanamnesa diperoleh dari : <input
                    value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->diperoleh_dari : '' }}"
                    type="text" name="diperoleh_dari" id="diperoleh_dari"
                    {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->anamnesa_umum == 'alloanamnesa' ? 'readonly' : '') : '' }}>
            </p>
            <ul style="padding-left: 16px; list-style-type: numeric;">
                <li>
                    Keluhan Utama :
                    <textarea name="keluhan_utama" id="keluhan_utama" cols="30" rows="5" style="height: 100%"
                        class="form-control" required>{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->keluhan_utama : '' }}</textarea>
                </li>
                <li style="padding-top: 15px;">
                    Riwayat Penyakit Sekarang :
                    <textarea name="riwayat_penyakit_sekarang" id="riwayat_penyakit_sekarang" cols="30" rows="5"
                        style="height: 100%" class="form-control" required>{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->riwayat_penyakit_sekarang : '' }}</textarea>
                </li>
                <li style="padding-top: 15px;">
                    Riwayat Penyakit Dahulu :
                    <textarea name="riwayat_penyakit_dahulu" id="riwayat_penyakit_dahulu" cols="30" rows="5"
                        style="height: 100%" class="form-control" required>{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->riwayat_penyakit_dahulu : '' }}</textarea>
                </li>
                <li style="padding-top: 15px;">
                    Riwayat Obat-obatan Terdahulu :
                    <textarea name="riwayat_obat_obatan" id="riwayat_obat_obatan" cols="30" rows="5" style="height: 100%"
                        class="form-control" required>{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->riwayat_obat_obatan : '' }}</textarea>
                </li>
                <li style="padding-top: 15px;">
                    Riwayat Kebiasaan dan Pekerjaan :
                    <textarea name="riwayat_kebiasaan_pekerjaan" id="riwayat_kebiasaan_pekerjaan" cols="30" rows="5"
                        style="height: 100%" class="form-control" required>{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->riwayat_kebiasaan_pekerjaan : '' }}</textarea>
                </li>
                <li style="padding-top: 15px;">
                    Riwayat Alergi Obat / Makanan :
                    <textarea name="riwayat_alergi_obat" id="riwayat_alergi_obat" cols="30" rows="5" style="height: 100%"
                        class="form-control" required>{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->riwayat_alergi_obat : '' }}</textarea>
                </li>
                <li style="padding-top: 15px;">
                    Masalah Kejiwaan : Adakah masalah mental seperti kurang semangat, rasa tertekan, depresi, sulit
                    tidur, lekas lelah, kurang nafsu makan,
                    merasa bersalah, sulit konsentrasi, sulit berbicara, menggunakan obat penenang dan ada keinginan
                    bunuh diri ?
                    <input
                        {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->masalah_kejiwaan == '1' ? 'checked' : '') : '' }}
                        style="margin-left: 15px" type="radio" name="masalah_kejiwaan" value="1" required> Ya
                    <input
                        {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->masalah_kejiwaan == '0' ? 'checked' : '') : '' }}
                        style="margin-left: 15px" type="radio" name="masalah_kejiwaan" value="0"> Tidak
                </li>
            </ul>
            <p>
                <span style="font-weight: bold">II. Data Umum</span>
            </p>
            <table id="tabel_data_umum" style="border-collapse: collapse; width:100%">
                <tr style="line-height: 1.5">
                    <td style="width: 2%; vertical-align: top;">1.</td>
                    <td style="width: 14%; vertical-align: top;">Keadaan umum</td>
                    <td style="width: 3%; vertical-align: top;"> : </td>
                    <td style="width: 81%; vertical-align: top;">
                        <input style="margin-left: 20px"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->keadaan_umum == 'sakit_ringan' ? 'checked' : '') : '' }}
                            type="radio" name="keadaan_umum" value="sakit_ringan" required>
                        Sakit Ringan
                        <input style="margin-left: 20px"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->keadaan_umum == 'sakit_sedang' ? 'checked' : '') : '' }}
                            type="radio" name="keadaan_umum" value="sakit_sedang">
                        Sakit Sedang
                        <input style="margin-left: 20px"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->keadaan_umum == 'sakit_berat' ? 'checked' : '') : '' }}
                            type="radio" name="keadaan_umum" value="sakit_berat">
                        Sakit Berat
                    </td>
                </tr>
                <tr style="line-height: 1.5">
                    <td style="width: 2%; vertical-align: top;">2.</td>
                    <td style="width: 14%; vertical-align: top;">Kesadaran</td>
                    <td style="width: 3%; vertical-align: top;"> : </td>
                    <td style="width: 81%; vertical-align: top;">
                        GCS : E
                        <input style="width: 50px; margin-right:20px;" type="number" step="0.01" min="0"
                            name="gcs_e" id="gcs_e"
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->gcs_e : '' }}"
                            required>
                        M
                        <input style="width: 50px; margin-right:20px;" type="number" step="0.01" min="0"
                            name="gcs_m" id="gcs_m"
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->gcs_m : '' }}"
                            required>
                        V
                        <input style="width: 50px; margin-right:20px;" type="number" step="0.01" min="0"
                            name="gcs_v" id="gcs_v"
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->gcs_v : '' }}"
                            required>;
                        Total
                        <input style="width: 50px; margin-right:20px;" type="text" name="gcs_total"
                            id="gcs_total"
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->gcs_total : '' }}"
                            readonly>
                    </td>
                </tr>
                <tr style="line-height: 1.5">
                    <td style="width: 2%; vertical-align: top;">3.</td>
                    <td style="width: 14%; vertical-align: top;">Tanda vital</td>
                    <td style="width: 3%; vertical-align: top;"> : </td>
                    <td style="width: 81%; vertical-align: top;">
                        Tekanan darah : ............../.............mmHg; Suhu : ..............°C
                    </td>
                </tr>
                <tr style="line-height: 1.5">
                    <td style="width: 2%; vertical-align: top;"></td>
                    <td style="width: 14%; vertical-align: top; padding-left: 20px;">Nadi</td>
                    <td style="width: 3%; vertical-align: top;"> : </td>
                    <td style="width: 81%; vertical-align: top;">
                        .............. x/mnt;
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->nadi == 'reguler' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="radio" name="nadi" value="reguler" required>
                        Reguler
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->nadi == 'irreguler' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="radio" name="nadi" value="irreguler"> Irreguler
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->nadi == 'pulsus_defisit' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="radio" name="nadi" value="pulsus_defisit">
                        Pulsus Defisit
                    </td>
                </tr>
                <tr style="line-height: 1.5">
                    <td style="width: 2%; vertical-align: top;"></td>
                    <td style="width: 14%; vertical-align: top; padding-left: 20px;">Pernafasan</td>
                    <td style="width: 3%; vertical-align: top;"> : </td>
                    <td style="width: 81%; vertical-align: top;">
                        .............. x/mnt;
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->pernafasan == 'reguler' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="radio" name="pernafasan" value="reguler" required>
                        Reguler
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->pernafasan == 'kussmaul' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="radio" name="pernafasan" value="kussmaul">
                        Kussmaul
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->pernafasan == 'chyene_stokes' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="radio" name="pernafasan" value="chyene_stokes">
                        Chyene-Stokes
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->pernafasan == 'lain_lain' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="radio" name="pernafasan" value="lain_lain"> Lain
                        lain <input
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->pernafasan_lain : '' }}"
                            type="text" name="pernafasan_lain" id="pernafasan_lain"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->pernafasan != 'lain_lain' ? 'readonly' : '') : '' }}>
                    </td>
                </tr>
                <tr style="line-height: 1.5">
                    <td style="width: 2%; vertical-align: top; "></td>
                    <td style="width: 14%; vertical-align: top;  padding-left: 20px;">Nyeri</td>
                    <td style="width: 3%; vertical-align: top; "> : </td>
                    <td style="width: 81%; vertical-align: top; ">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->nyeri == '0' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="radio" name="nyeri" value="0" required>
                        Tidak Ada
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->nyeri == '1' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="radio" name="nyeri" value="1"> Ada, Lokasi
                        : <input
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->lokasi_nyeri : '' }}"
                            type="text" name="lokasi_nyeri" id="lokasi_nyeri"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->nyeri == '0' ? 'readonly' : '') : '' }}>
                        Skala Nyeri : <input
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->skala_nyeri : '' }}"
                            type="number" name="skala_nyeri" id="skala_nyeri" min="1" max="10"
                            style="width: 50px;"> (1-10)
                    </td>
                </tr>
                <tr style="line-height: 1.5">
                    <td style="width: 2%; vertical-align: top; "></td>
                    <td style="width: 14%; vertical-align: top;  padding-left: 20px;">Jenis</td>
                    <td style="width: 3%; vertical-align: top; "> : </td>
                    <td style="width: 81%; vertical-align: top; ">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->jenis == 'nosiseptik' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="radio" name="jenis" value="nosiseptik" required>
                        Nosiseptik
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->jenis == 'neuropatik' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="radio" name="jenis" value="neuropatik">
                        Neuropatik
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->jenis == 'kombinasi' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="radio" name="jenis" value="kombinasi"> Kombinasi
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->jenis == 'lain_lain' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="radio" name="jenis" value="lain_lain"> Lain-lain
                        <input
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->jenis_lain : '' }}"
                            type="text" name="jenis_lain" id="jenis_lain"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->jenis != 'lain_lain' ? 'readonly' : '') : '' }}>
                    </td>
                </tr>
            </table>
            <p>
                <span style="font-weight: bold">III. Pemeriksaan Fisik : </span>
            </p>
            <table style="border-collapse: collapse; width: 100%;" id="tabel_pemeriksaan_fisik">
                <tr>
                    <td style="width: 3%">1.</td>
                    <td style="width: 25%">Kepala</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->kepala == 'normal' ? 'checked' : '') : '' }}
                            type="radio" name="kepala" value="normal" id="kepala" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->kepala == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="radio" name="kepala" value="tidak_normal"> Tidak Normal,
                        Jelaskan : <input
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_kepala : '' }}"
                            type="text" name="tn_kepala" id="tn_kepala" style="width: 400px;"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->kepala == 'normal' ? 'readonly' : '') : '' }}>
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">2.</td>
                    <td style="width: 25%">Mata</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->mata == 'normal' ? 'checked' : '') : '' }}
                            type="radio" name="mata" value="normal" id="mata" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->mata == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="radio" name="mata" value="tidak_normal"> Tidak Normal,
                        Jelaskan : <input type="text" name="tn_mata" id="tn_mata" style="width: 400px;"
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_mata : '' }}"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->mata == 'normal' ? 'readonly' : '') : '' }}>
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">3.</td>
                    <td style="width: 25%">THT</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->tht == 'normal' ? 'checked' : '') : '' }}
                            type="radio" name="tht" value="normal" id="tht" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->tht == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="radio" name="tht" value="tidak_normal"> Tidak Normal,
                        Jelaskan : <input type="text" name="tn_tht" id="tn_tht" style="width: 400px;"
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_tht : '' }}"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->tht == 'normal' ? 'readonly' : '') : '' }}>
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">4.</td>
                    <td style="width: 25%">Leher</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->leher == 'normal' ? 'checked' : '') : '' }}
                            type="radio" name="leher" value="normal" id="leher" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->leher == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="radio" name="leher" value="tidak_normal"> Tidak Normal,
                        Jelaskan : <input type="text" name="tn_leher" id="tn_leher" style="width: 400px;"
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_leher : '' }}"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->leher == 'normal' ? 'readonly' : '') : '' }}>
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">5.</td>
                    <td style="width: 25%">Mulut</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->mulut == 'normal' ? 'checked' : '') : '' }}
                            type="radio" name="mulut" value="normal" id="mulut" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->mulut == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="radio" name="mulut" value="tidak_normal"> Tidak Normal,
                        Jelaskan : <input type="text" name="tn_mulut" id="tn_mulut" style="width: 400px;"
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_mulut : '' }}"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->mulut == 'normal' ? 'readonly' : '') : '' }}>
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">6.</td>
                    <td style="width: 25%">Jantung dan Pembuluh Darah</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->jantung == 'normal' ? 'checked' : '') : '' }}
                            type="radio" name="jantung" value="normal" id="jantung" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->jantung == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="radio" name="jantung" value="tidak_normal"> Tidak Normal,
                        Jelaskan : <input type="text" name="tn_jantung" id="tn_jantung" style="width: 400px;"
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_jantung : '' }}"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->jantung == 'normal' ? 'readonly' : '') : '' }}>
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">7.</td>
                    <td style="width: 25%">Thoraks, Paru-paru dan Payudara</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->thoraks == 'normal' ? 'checked' : '') : '' }}
                            type="radio" name="thoraks" value="normal" id="thoraks" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->thoraks == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="radio" name="thoraks" value="tidak_normal"> Tidak Normal,
                        Jelaskan : <input type="text" name="tn_thoraks" id="tn_thoraks" style="width: 400px;"
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_thoraks : '' }}"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->thoraks == 'normal' ? 'readonly' : '') : '' }}>
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">8.</td>
                    <td style="width: 25%">Abdomen</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->abdomen == 'normal' ? 'checked' : '') : '' }}
                            type="radio" name="abdomen" value="normal" id="abdomen" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->abdomen == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="radio" name="abdomen" value="tidak_normal"> Tidak Normal,
                        Jelaskan : <input type="text" name="tn_abdomen" id="tn_abdomen" style="width: 400px;"
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_abdomen : '' }}"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->abdomen == 'normal' ? 'readonly' : '') : '' }}>
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">9.</td>
                    <td style="width: 25%">Kulit dan Sistem Limfatik</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->kulit == 'normal' ? 'checked' : '') : '' }}
                            type="radio" name="kulit" value="normal" id="kulit" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->kulit == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="radio" name="kulit" value="tidak_normal"> Tidak Normal,
                        Jelaskan : <input type="text" name="tn_kulit" id="tn_kulit" style="width: 400px;"
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_kulit : '' }}"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->kulit == 'normal' ? 'readonly' : '') : '' }}>
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">10.</td>
                    <td style="width: 25%">Tulang Belakang dan Anggota Tubuh</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->tulang == 'normal' ? 'checked' : '') : '' }}
                            type="radio" name="tulang" value="normal" id="tulang" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->tulang == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="radio" name="tulang" value="tidak_normal"> Tidak Normal,
                        Jelaskan : <input type="text" name="tn_tulang" id="tn_tulang" style="width: 400px;"
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_tulang : '' }}"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->tulang == 'normal' ? 'readonly' : '') : '' }}>
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">11.</td>
                    <td style="width: 25%">Sistem Saraf</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input type="radio"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->saraf == 'normal' ? 'checked' : '') : '' }}
                            name="saraf" value="normal" id="saraf" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input type="radio"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->saraf == 'tidak_normal' ? 'checked' : '') : '' }}
                            name="saraf" value="tidak_normal"> Tidak Normal,
                        Jelaskan : <input type="text" name="tn_saraf" id="tn_saraf" style="width: 400px;"
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_saraf : '' }}"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->saraf == 'normal' ? 'readonly' : '') : '' }}>
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">12.</td>
                    <td style="width: 25%">Genitalia, anus dan rektum</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input type="radio"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->genitalia == 'normal' ? 'checked' : '') : '' }}
                            name="genitalia" value="normal" id="genitalia" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input type="radio"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->genitalia == 'tidak_normal' ? 'checked' : '') : '' }}
                            name="genitalia" value="tidak_normal"> Tidak Normal,
                        Jelaskan : <input type="text" name="tn_genitalia" id="tn_genitalia" style="width: 400px;"
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_genitalia : '' }}"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->genitalia == 'normal' ? 'readonly' : '') : '' }}>
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">13.</td>
                    <td style="width: 25%">Ekstremitas</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input type="radio"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->ekstremitas == 'normal' ? 'checked' : '') : '' }}
                            name="ekstremitas" value="normal" id="ekstremitas" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input type="radio"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->ekstremitas == 'tidak_normal' ? 'checked' : '') : '' }}
                            name="ekstremitas" value="tidak_normal"> Tidak
                        Normal, Jelaskan : <input type="text" name="tn_ekstremitas" id="tn_ekstremitas"
                            value="{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_ekstremitas : '' }}"
                            style="width: 400px;"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->ekstremitas == 'normal' ? 'readonly' : '') : '' }}>
                    </td>
                </tr>
            </table>
            <table style="border-collapse: collapse; width:100%;" id="tabel_lokalis">
                <tr>
                    <td style="width: 25%; text-align:center; vertical-align: top">
                        @if ($dokumen->pengkajian_awal_medis)
                            @if ($dokumen->pengkajian_awal_medis->gambar_status_lokalis != '')
                                <div
                                    style="background-repeat: no-repeat; width: 100%; background-image: url('{{ asset('images/status_lokalis.jpg') }}')">
                                    <img style="position: relative; top:0px; opacity: 0.5;"
                                    src="{{ asset('status_lokalis/' . $dokumen->pengkajian_awal_medis->gambar_status_lokalis) }}"
                                    alt="">
                                </div>
                            @else
                                <div
                                    style="background-repeat: no-repeat; width: 100%; background-image: url('{{ asset('images/status_lokalis.jpg') }}')">
                                    <div id="sig"></div>
                                </div>
                            @endif
                        @else
                            <div
                                style="background-repeat: no-repeat; width: 100%; background-image: url('{{ asset('images/status_lokalis.jpg') }}')">
                                <div id="sig"></div>
                            </div>
                        @endif
                        {{-- <img style="position: relative; top:-180px; z-index: -1;"
                            src="{{ asset('images/status_lokalis.jpg') }}" alt=""> --}}
                        <p>Gambar lokasi</p>
                        @if ($dokumen->pengkajian_awal_medis)
                            @if ($dokumen->pengkajian_awal_medis->gambar_status_lokalis != '')
                                <a style="position:relative; top:0px;"
                                    onclick="return confirm('Yakin gambar ulang status lokalis ?')"
                                    class="btn btn-dark"
                                    href="{{ url('medical_record/e_rekam_medis/pengkajian_awal_medis/hapus_gambar_status_lokalis?dokumen=' . $dokumen->id) }}">Gambar
                                    ulang</a>
                            @else
                                <button style="position:relative; top:0px;" type="button" class="btn btn-danger"
                                    id="btn_clear">Clear</button>
                            @endif
                        @else
                            <button style="position:relative; top:0px;" type="button" class="btn btn-danger"
                                id="btn_clear">Clear</button>
                        @endif
                    </td>
                    <td style="width: 75%; padding:10px; vertical-align: top">
                        <p>III. STATUS LOKALIS : </p>
                        <textarea required name="status_lokalis" id="status_lokalis" cols="30" rows="5"
                            style="height: 100%; width:100%">{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->status_lokalis : '' }}</textarea>
                        <p style="margin-top: 15px;">IV. PEMERIKSAAN PENUNJANG : <br>
                        <div style="display: flex; flex-direction: row">
                            <div id="box_button_pesanan_lab">
                                @if (sizeof($dokumen->pesanan_lab) < 1)
                                    <button type="button" class="btn btn-dark" data-toggle="tooltip"
                                        title="Tambah pemeriksaan" onclick="open_modal_lab()"><i
                                            class="fa fa-plus"></i></button>
                                @else
                                    @foreach ($dokumen->pesanan_lab as $pl)
                                        <button type="button" data-toggle="tooltip" title="Ubah Pemeriksaan"
                                            class="btn btn-warning" onclick="open_modal_lab()"><i
                                                class="fa fa-pencil" style="color:#fff;"></i></button>
                                        <button type="button" data-toggle="tooltip" title="Hasil Lab"
                                            class="btn btn-info" data-toggle="tooltip" title="Hasil"
                                            onclick="open_modal_hasil_lab('{{ $pl->id }}')"><i
                                                class="fa fa-book" style="color:#fff;"></i></button>
                                    @endforeach
                                @endif
                            </div>
                            <div id="list_pesanan" class="pl-3 pt-1">
                                @if ($dokumen->pesanan_lab)
                                    @foreach ($dokumen->pesanan_lab as $pl)
                                        @php
                                            $iterasi_pesanan_lab = 0;
                                            $pesan = '';
                                        @endphp
                                        <?php $yang_dipesan = json_decode($pl->periksa); ?>
                                        @foreach ($pemeriksaan as $pem)
                                            @php
                                                $temp_slug = $pem->slug;
                                            @endphp
                                            @if ($yang_dipesan->$temp_slug == 1)
                                                @if ($iterasi_pesanan_lab > 0)
                                                    @php
                                                        $pesan .= ', ' . $pem->nama;
                                                    @endphp
                                                @else
                                                    @php
                                                        $pesan .= $pem->nama;
                                                    @endphp
                                                @endif
                                                @php
                                                    $iterasi_pesanan_lab++;
                                                @endphp
                                            @endif
                                        @endforeach
                                        {{ $pl->no_lab }} - {{ $pesan }}
                                    @endforeach
                                @endif
                            </div>
                        </div>
                        </p>
                        <p style="margin-top: 15px;">V. DIAGNOSA :
                        <div style="display: flex; flex-direction: row">
                            <div id="box_button_diagnosa">
                                @if ($layanan->diagnosa == null)
                                    <button type="button" class="btn btn-success"
                                        onclick="open_form_tambah_diagnosa()"><i class="fa fa-plus"></i></button>
                                @else
                                    <button type="button" class="btn btn-warning"
                                        onclick="open_form_tambah_diagnosa()"
                                        style="color:#fff; font-weight: bold;"><i class="fa fa-pencil"></i></button>
                                @endif
                            </div>
                            <div id="box_diagnosa" class="ml-2" style="margin-top: -5px">
                                {{ $layanan->diagnosa ? $layanan->diagnosa->kode_icd . ' - ' . $layanan->diagnosa->nama_icd : '' }}
                                <div id="box_diagnosa_sekunder">
                                    <?php
                                    if ($layanan->diagnosa != null) {
                                        $temp = '';
                                        if ($layanan->diagnosa->diagnosa_sekunder1 != null) {
                                            $temp .= ($kode_sekunder1 ? $kode_sekunder1->icd : '') . ' - ' . $layanan->diagnosa->diagnosa_sekunder1;
                                        }
                                        if ($layanan->diagnosa->diagnosa_sekunder2 != null) {
                                            $temp .= '<br>' . ($kode_sekunder2 ? $kode_sekunder2->icd : '') . ' - ' . $layanan->diagnosa->diagnosa_sekunder2;
                                        }
                                        if ($layanan->diagnosa->diagnosa_sekunder3 != null) {
                                            $temp .= '<br>' . ($kode_sekunder3 ? $kode_sekunder3->icd : '') . ' - ' . $layanan->diagnosa->diagnosa_sekunder3;
                                        }
                                        echo $temp;
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                        </p>
                        <p style="margin-top: 15px;">VI. RENCANA DAN TERAPI : <br>
                            @foreach ($dokumen->resep as $r)
                                <span style="border-bottom: 2px solid;">{{ 'R/ ' . $r->nomor_resep }}</span><br>
                                @if (isset($r->obat_jadi))
                                    @foreach ($r->obat_jadi as $oj)
                                        <span>{{ '- ' . $oj->nama_obat }}</span><br>
                                    @endforeach
                                @endif
                                @if (isset($r->obat_racik))
                                    @foreach ($r->obat_racik as $or)
                                        @foreach ($or->bahan as $ba)
                                            <span>{{ '- ' . $ba->nama_obat }}</span><br>
                                        @endforeach
                                    @endforeach
                                @endif
                                <br>
                                <br>
                            @endforeach
                        </p>
                    </td>
                </tr>
            </table>
        </div>
        <textarea id="signature64" name="signed" style="display: none"></textarea>
        <div class="col-lg-12 text-center pt-3 pb-3">
            <button type="submit" class="btn btn-success"><i class="fa fa-save"></i> Simpan</button>
        </div>
        <div class="col-lg-8 text-center">
        </div>
        <div class="col-lg-4 text-center">
            <p>Tandatangan dan nama<br>Dokter</p>
            @if ($dokumen->status == 0)
                <a onclick="open_modal_verifikasi()" style="text-decoration: none; color:#111;" href="#">
                    <br>
                    <p>Klik disini</p>
                    <br>
                    <p>(_____________________)</p>
                </a>
            @else
                <a onclick="open_modal_verifikasi()" style="text-decoration: none; color:#111;" href="#">
                    <img src="{{ env('SMIS_UPLOAD_URL') . '/' . ($employee ? $employee->ttd : '') }}" alt=""
                        style="height: 2.5cm; width: 5cm;">
                    <p>{{ $dokumen->nama_verifikator }}</p>
                </a>
            @endif
        </div>
        @if ($dokumen->status == 1)
            <div class="col-lg-12 pt-3 text-center">
                <a href="{{ url('medical_record/e_rekam_medis/pengkajian_awal_medis/pdf?dokumen=' . $dokumen->id) }}"
                    target="_blank" class="btn btn-success"><i class="fa fa-arrow-down"></i> Download Pdf</a>
            </div>
        @endif
    </form>
</body>
<script src="https://code.jquery.com/jquery-3.3.1.min.js"
    integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<script type="text/javascript" src="{{ asset('app-assets/js/jquery-ui.min.js') }}"></script>
<script src="https://cdn.datatables.net/1.10.7/js/jquery.dataTables.min.js"></script>
<script src="{{ asset('app-assets/js/bootstrap.min.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.devbridge-autocomplete/1.4.7/jquery.autocomplete.min.js">
</script>
<script type="text/javascript" src="{{ asset('app-assets/js/signaturepad.js') }}"></script>
<script src="{{ asset('app-assets/js/select2.min.js') }}"></script>
<script>
    // var loading = '<div class="spinner-border spinner-border-sm" role="status">' +
    // '<span class="sr-only">Loading...</span>' +
    // '</div>';
    $(document).ready(function() {
        $("#diagnosa_primer").devbridgeAutocomplete({
            serviceUrl: "{{ url('ajax_request/autocomplete_diagnosa') }}", // Kode php untuk prosesing data
            dataType: "JSON", // Tipe data JSON
            onSelect: function(suggestion) {
                $("#diagnosa_primer").val(suggestion.nama);
            }
        });

        $("#diagnosa_sekunder_dua").devbridgeAutocomplete({
            serviceUrl: "{{ url('ajax_request/autocomplete_diagnosa') }}", // Kode php untuk prosesing data
            dataType: "JSON", // Tipe data JSON
            onSelect: function(suggestion) {
                $("#diagnosa_sekunder_dua").val(suggestion.nama);
            }
        });

        $("#diagnosa_sekunder_satu").devbridgeAutocomplete({
            serviceUrl: "{{ url('ajax_request/autocomplete_diagnosa') }}", // Kode php untuk prosesing data
            dataType: "JSON", // Tipe data JSON
            onSelect: function(suggestion) {
                $("#diagnosa_sekunder_satu").val(suggestion.nama);
            }
        });

        $("#diagnosa_sekunder_tiga").devbridgeAutocomplete({
            serviceUrl: "{{ url('ajax_request/autocomplete_diagnosa') }}", // Kode php untuk prosesing data
            dataType: "JSON", // Tipe data JSON
            onSelect: function(suggestion) {
                $("#diagnosa_sekunder_tiga").val(suggestion.nama);
            }
        });
    })

    function loading(message, tipe) {
        return '<div class="alert alert-' + tipe + '">' +
            '<div class="spinner-border spinner-border-sm mr-1"></div>' +
            message +
            '</div>';
    }

    $('#form_asesmen').submit(function(e) {
        window.event.preventDefault();
        if ($('#tanggal_diagnosa').val() == '') {
            alert('Pilih tanggal dahulu');
            return;
        }
        if ($('#dokter').val() == '') {
            alert('Pilih dokter dahulu');
            return;
        }
        if ($('#diagnosa_primer').val() == '') {
            alert('Pilih diagnosa dahulu');
            return;
        }
        if ($('#icd').val() == '') {
            alert('Pilih diagnosa dahulu');
            return;
        }
        if ($('#kode_icd').val() == '') {
            alert('Pilih diagnosa dahulu');
            return;
        }
        if ($('#penyebab').val() == '') {
            alert('Pilih diagnosa dahulu');
            return;
        }
        $('#box_msg').html(loading('Sedang menyimpan data...', 'info'));
        $('#btn_simpan_diagnosa').attr('disabled', true);
        $.ajax({
            url: "{{ url('ajax_request/update_diagnosa') }}",
            method: 'post',
            data: $('#form_asesmen').serialize(),
            success: function(response) {
                console.log(response);
                if (!response.status) {
                    alert(response.message);
                    $('#box_msg').html('<div class="alert alert-danger">' + response.message +
                        '</div>');
                } else {
                    $('#box_msg').html('<div class="alert alert-success">' + response.message +
                        '</div>');
                    let data = response.data;
                    var temp = '';
                    if (data.diagnosa_sekunder1 != '') {
                        temp += response.kode_sekunder1.icd + ' - ' + data.diagnosa_sekunder1;
                    }
                    if (data.diagnosa_sekunder2 != '') {
                        temp += '<br>' + response.kode_sekunder2.icd + ' - ' + data
                            .diagnosa_sekunder2;
                    }
                    if (data.diagnosa_sekunder3 != '') {
                        temp += '<br>' + response.kode_sekunder3.icd + ' - ' + data
                            .diagnosa_sekunder3;
                    }
                    $('#box_diagnosa').html(data.kode_icd + ' - ' + data.nama_icd +
                        '<div id="box_diagnosa_sekunder"></div>');
                    $('#box_diagnosa_sekunder').html(temp);
                    $('#box_button_diagnosa').html(
                        '<button type="button" class="btn btn-warning" onclick="open_form_tambah_diagnosa()" style="color:#fff; font-weight: bold;"><i class="fa fa-pencil"></i></button>'
                    );
                }
                $('#btn_simpan_diagnosa').removeAttr('disabled');
                $('#box_msg').html('');
                $('#modal_diagnosa').modal('hide');
            }
        })
    })

    function open_form_tambah_diagnosa() {
        $.ajax({
            url: "{{ url('ajax_request/diagnosa_by_noreg') }}",
            data: {
                noreg: '{{ $layanan->id }}',
            },
            success: function(response) {
                console.log(response);
                if (Object.keys(response).length !== 0) {
                    $('#tanggal').val(response.tanggal);
                    $('#dokter').val(response.nama_dokter);
                    // $('#nip_dokter').val(response.id_dokter);
                    $('#id_dokter').val(response.id_dokter);
                    $('#diagnosa_primer').val(response.diagnosa);
                    $('#diagnosa_sekunder_satu').val(response.diagnosa_sekunder1);
                    $('#diagnosa_sekunder_dua').val(response.diagnosa_sekunder2);
                    $('#diagnosa_sekunder_tiga').val(response.diagnosa_sekunder3);
                }
                $('#modal_diagnosa').modal('show');
            }
        })
    }

    var sig = $('#sig').signature({
        syncField: '#signature64',
        syncFormat: 'PNG',
    });

    function open_modal_lab() {
        $.ajax({
            url: "{{ url('ajax_request/pesanan_lab_by_noreg') }}",
            data: {
                noreg: '{{ $layanan->id }}',
            },
            success: function(response) {
                console.log(response);
                let temp = [];
                if (response.diagnosa) {
                    $('#diagnosa_lab').val(response.diagnosa.nama_icd);
                }
                if (response.pesanan_lab) {
                    $('#kelas').val(response.pesanan_lab.kelas).trigger('change');
                    $('#ruangan').val(response.pesanan_lab.ruangan).trigger('change');
                    // $('#id_konsultan_lab').val(response.pesanan_lab.id_konsultan)
                    // $('#konsultan_lab').val(response.pesanan_lab.nama_konsultan)
                    // $('#id_petugas_lab').val(response.pesanan_lab.id_petugas)
                    // $('#petugas_lab').val(response.pesanan_lab.nama_petugas)
                    const periksa = JSON.parse(response.pesanan_lab.periksa);
                    console.log(periksa);
                    Object.entries(periksa).forEach(([key, value]) => {
                        if (`${value}` == 1) {
                            temp.push(`${key}`);
                        }
                        console.log(`${key} ${value}`);
                    });
                    console.log('-------------------');
                    $('#pemeriksaan').val(temp).change();
                }
                $('#modal_lab').modal('show');
            }
        })
    }

    function open_modal_employee(judul, tipe) {
        $('#judul_employee').html(judul);
        if ($.fn.DataTable.isDataTable('#tabel_employee')) {
            $('#tabel_employee').dataTable().fnClearTable();
            $('#tabel_employee').dataTable().fnDestroy();
        }

        var url = tipe == 'dokter' ? "{{ url('ajax_request/datatable_dokter') }}" :
            "{{ url('ajax_request/datatable_karyawan') }}";

        $('#tabel_employee').DataTable({
            processing: true,
            serverSide: true,
            ajax: url,
            columns: [{
                    data: 'nama',
                    name: 'nama'
                },
                {
                    data: 'jabatan',
                    name: 'jabatan'
                },
                {
                    data: 'nip',
                    name: 'nip'
                },
                {
                    data: 'id',
                    name: 'id',
                    orderable: false,
                    searchable: false,
                    render: function(data, type, row) {
                        return '<div class="text-center"><button class="btn btn-dark" onclick = "set_employee(' +
                            "'" + row.nama + "','" + data + "','" + tipe + "'" +
                            ')"><i class="fa fa-check"></i></button></div>';
                    }
                },
            ]
        });
        $('#modal_lab').modal('hide');
        $('#modal_employee').modal('show');
    }

    function set_employee(nama, id, tipe) {
        switch (tipe) {
            case 'dokter':
                $('#id_dokter_lab').val(id);
                $('#dokter_lab').val(nama);
                $('#modal_employee').modal('hide');
                $('#modal_lab').modal('show');
                break;
            case 'konsultan':
                $('#id_konsultan_lab').val(id);
                $('#konsultan_lab').val(nama);
                $('#modal_employee').modal('hide');
                $('#modal_lab').modal('show');
                break;
            case 'petugas':
                $('#id_petugas_lab').val(id);
                $('#petugas_lab').val(nama);
                $('#modal_employee').modal('hide');
                $('#modal_lab').modal('show');
                break;
            default:
                $('#modal_employee').modal('hide');
                $('#modal_lab').modal('show');
                break;
        }
    }
    $('#pemeriksaan').select2();
    $('#form_laboratorium').submit(function(e) {
        e.preventDefault();
        $('#loading_pesanan_lab').html('<div class = "alert alert-info" > ' + loading(
            'Sedang menyimpan data...', 'sm') + '</div>');
        console.log($('#form_laboratorium').serialize());
        $.ajax({
            url: "{{ url('ajax_request/pesanan_lab_store') }}",
            method: 'post',
            data: $('#form_laboratorium').serialize(),
            success: function(response) {
                if (!response.status) {
                    $('#loading_pesanan_lab').html('<div class="alert alert-danger">' + response
                        .message + '</div>');
                    return;
                }
                $('#modal_lab').modal('hide');
                let data = response.data;
                console.log(data);
                $('#loading_pesanan_lab').html('<div class="alert alert-success">' + response
                    .message + '</div>');
                let pemeriksaan = <?php echo $pemeriksaan; ?>;
                var ins = '';
                let iterasi_pesanan = 0;
                for (let i = 0; i < data.length; i++) {
                    ins += data[i].no_lab + ' - ';
                    var temp = JSON.parse(data[i].periksa);
                    console.log(temp);
                    for (let j = 0; j < pemeriksaan.length; j++) {
                        var temp_slug = pemeriksaan[j].slug;
                        if (temp[temp_slug] == 1) {
                            if (iterasi_pesanan < 1) {
                                ins += pemeriksaan[j].nama;
                            } else {
                                ins += ', ' +
                                    pemeriksaan[j].nama;
                            }
                            iterasi_pesanan++;
                        }
                    }
                    $('#box_button_pesanan_lab').html(
                        '<button type="button" class="btn btn-warning" onclick="open_modal_lab()"><i class="fa fa-pencil" style="color:#fff;"></i></button>' +
                        '<button type="button" class="btn btn-info ml-1" data-toggle="tooltip" title="Hasil" onclick="open_modal_hasil_lab(' +
                        "'" + data[i].id + "'" +
                        ' )"><i class="fa fa-book" style="color:#fff;"></i></button>'
                    );
                }
                $('#list_pesanan').html(ins);
            }
        })
    })

    function open_modal_hasil_lab(param) {
        let cek = false
        $.ajax({
            url: "{{ url('ajax_request/pesanan_lab_by_id') }}",
            data: {
                id: param
            },
            success: function(response) {
                console.log(response);
                if (response == null) {
                    return;
                }
                let temp = JSON.parse(response.hasil);
                let hasil = Object.entries(temp);
                let key_hasil = Object.keys(hasil);
                for (let i = 0; i < hasil.length; $i++) {
                    if (hasil[key_hasil[i]] != '') {
                        cek = true;
                        break;
                    }
                }
                var ins = '';
                if (cek) {
                    let temp_grup = '';
                    let master_hasil = <?php echo $master_hasil; ?>;
                    console.log(master_hasil);
                    for (let i = 0; i <
                        master_hasil.length; i++) {
                        if (temp[master_hasil[i].slug] != '') {
                            if (temp_grup != master_hasil[i].grup) {
                                ins += '<tr>' + '<th colspan="3">' + master_hasil[i].grup + '</th>' +
                                    '</tr>';
                                temp_grup = master_hasil[i].grup;
                            }
                            ins += '<tr>' + '<td style="padding-left: 40px">' + master_hasil[i].name +
                                '</td>' +
                                '<td class="text-center" style="' + cek_nilai_normal(temp[master_hasil[i]
                                    .slug], master_hasil[i]) + '">' +
                                temp[master_hasil[i].slug] + '</td>' + '<td class="text-center">' +
                                master_hasil[i].nt + '</td>' +
                                '</tr>';
                        }
                    }
                } else {
                    ins = '<tr>' + '<th colspan="3" class="text-center">Tidak ada hasil</th>' +
                        '</tr>';
                }
                $('#list_hasil_lab').html(ins);
                $('#modal_hasil_lab').modal('show');
            }
        })
    }

    function open_modal_verifikasi() {
        window.event.preventDefault();
        $('#modal_verifikasi').modal('show');
    }

    $('#btn_clear').click(function() {
        sig.signature('clear');
    })

    $('[name=anamnesa_umum]').change(function() {
        if ($('[name=anamnesa_umum]:checked').val() == 'alloanamnesa') {
            $('#diperoleh_dari').removeAttr('readonly');
            return;
        }
        $('#diperoleh_dari').val('');
        $('#diperoleh_dari').attr('readonly', true);
    })

    $('[name=pernafasan]').change(function() {
        if ($('[name=pernafasan]:checked').val() == 'lain_lain') {
            $('#pernafasan_lain').removeAttr('readonly');
            return;
        }
        $('#pernafasan_lain').val('');
        $('#pernafasan_lain').attr('readonly', true);
    })
    $('[name=nyeri]').change(function() {
        if ($('[name=nyeri]:checked').val() == '1') {
            $('#lokasi_nyeri').removeAttr('readonly');
            return;
        }
        $('#lokasi_nyeri').val('');
        $('#lokasi_nyeri').attr('readonly', true);
    })
    $('[name=jenis]').change(function() {
        if ($('[name=jenis]:checked').val() == 'lain_lain') {
            $('#jenis_lain').removeAttr('readonly');
            return;
        }
        $('#jenis_lain').val('');
        $('#jenis_lain').attr('readonly', true);
    })
    $('[name=kepala]').change(function() {
        if ($('[name=kepala]:checked').val() == 'tidak_normal') {
            $('#tn_kepala').removeAttr('readonly');
            return;
        }
        $('#tn_kepala').val('');
        $('#tn_kepala').attr('readonly', true);
    })
    $('[name=mata]').change(function() {
        if ($('[name=mata]:checked').val() == 'tidak_normal') {
            $('#tn_mata').removeAttr('readonly');
            return;
        }
        $('#tn_mata').val('');
        $('#tn_mata').attr('readonly', true);
    })
    $('[name=tht]').change(function() {
        if ($('[name=tht]:checked').val() == 'tidak_normal') {
            $('#tn_tht').removeAttr('readonly');
            return;
        }
        $('#tn_tht').val('');
        $('#tn_tht').attr('readonly', true);
    })
    $('[name=leher]').change(function() {
        if ($('[name=leher]:checked').val() == 'tidak_normal') {
            $('#tn_leher').removeAttr('readonly');
            return;
        }
        $('#tn_leher').val('');
        $('#tn_leher').attr('readonly', true);
    })
    $('[name=mulut]').change(function() {
        if ($('[name=mulut]:checked').val() == 'tidak_normal') {
            $('#tn_mulut').removeAttr('readonly');
            return;
        }
        $('#tn_mulut').val('');
        $('#tn_mulut').attr('readonly', true);
    })
    $('[name=jantung]').change(function() {
        if ($('[name=jantung]:checked').val() == 'tidak_normal') {
            $('#tn_jantung').removeAttr('readonly');
            return;
        }
        $('#tn_jantung').val('');
        $('#tn_jantung').attr('readonly', true);
    })
    $('[name=thoraks]').change(function() {
        if ($('[name=thoraks]:checked').val() == 'tidak_normal') {
            $('#tn_thoraks').removeAttr('readonly');
            return;
        }
        $('#tn_thoraks').val('');
        $('#tn_thoraks').attr('readonly', true);
    })
    $('[name=abdomen]').change(function() {
        if ($('[name=abdomen]:checked').val() == 'tidak_normal') {
            $('#tn_abdomen').removeAttr('readonly');
            return;
        }
        $('#tn_abdomen').val('');
        $('#tn_abdomen').attr('readonly', true);
    })
    $('[name=kulit]').change(function() {
        if ($('[name=kulit]:checked').val() == 'tidak_normal') {
            $('#tn_kulit').removeAttr('readonly');
            return;
        }
        $('#tn_kulit').val('');
        $('#tn_kulit').attr('readonly', true);
    })
    $('[name=tulang]').change(function() {
        if ($('[name=tulang]:checked').val() == 'tidak_normal') {
            $('#tn_tulang').removeAttr('readonly');
            return;
        }
        $('#tn_tulang').val('');
        $('#tn_tulang').attr('readonly', true);
    })
    $('[name=saraf]').change(function() {
        if ($('[name=saraf]:checked').val() == 'tidak_normal') {
            $('#tn_saraf').removeAttr('readonly');
            return;
        }
        $('#tn_saraf').val('');
        $('#tn_saraf').attr('readonly', true);
    })
    $('[name=genitalia]').change(function() {
        if ($('[name=genitalia]:checked').val() == 'tidak_normal') {
            $('#tn_genitalia').removeAttr('readonly');
            return;
        }
        $('#tn_genitalia').val('');
        $('#tn_genitalia').attr('readonly', true);
    })
    $('[name=ekstremitas]').change(function() {
        if ($('[name=ekstremitas]:checked').val() == 'tidak_normal') {
            $('#tn_ekstremitas').removeAttr('readonly');
            return;
        }
        $('#tn_ekstremitas').val('');
        $('#tn_ekstremitas').attr('readonly', true);
    })
    $('#gcs_e').keyup(function() {
        hitung_total_gcs();
    })
    $('#gcs_v').keyup(function() {
        hitung_total_gcs();
    })
    $('#gcs_m').keyup(function() {
        hitung_total_gcs();
    })

    function hitung_total_gcs() {
        let temp = 0;
        if ($('#gcs_e').val() != '' && $('#gcs_v').val() != '' &&
            $('#gcs_m').val() != '') {
            temp += parseFloat($('#gcs_e').val()) + parseFloat($('#gcs_v').val()) +
                parseFloat($('#gcs_m').val());
            $('#gcs_total').val(temp);
            return;
        }
        $('#gcs_total').val('');
    }
</script>

</html>
