<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Catatan Perkembangan Pasien</title>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="{{ asset('app-assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.7/css/jquery.dataTables.min.css">
</head>

<body>
<div class="modal fade" id="modal_yth" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
     aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Kepada Yth.</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table id="tabel_kepada" class="table table-striped mt-2">
                    <thead>
                    <tr class="text-center">
                        <th>No</th>
                        <th>Nama</th>
                        <th>Jabatan</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                </table>
            </div>
            <div class="modal-footer">
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_verifikasi" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Verifikasi</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ url('medical_record/e_rekam_medis/catatan_perkembangan_pasien/save') }}" method="post"
            onsubmit="return cek_form()">
                @csrf
                <div class="modal-body">
                    <input type="hidden" value="{{ $dokumen->id }}" name="id_dokumen">
                    <input type="hidden" id="hide_nrm" name="nrm" value="{{ $pasien->id }}">
                    <input type="hidden" id="hide_tanggal" name="tanggal">
                    <input type="hidden" id="hide_id_ppa" name="id_ppa">
                    <input type="hidden" id="hide_ppa" name="ppa">
                    <input type="hidden" id="hide_hasil_pemeriksaan" name="hasil_pemeriksaan">
                    <input type="hidden" id="hide_intruksi_ppa" name="intruksi_ppa">
                    <div class="form-group">
                        <label for="">Password</label>
                        <input type="password" placeholder="Masukkan password untuk melanjutkan"
                               class="form-control" name="password" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Verifikasi</button>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="container">
    @if ($errors->any())
        @foreach ($errors->all() as $error)
            <div class="alert alert-danger">{{ $error }}</div>
        @endforeach
    @endif
    @if (Session::get('sukses'))
        <script>
            alert('{{ Session::get('sukses') }}')
        </script>
    @endif
    @if (Session::get('gagal'))
        <script>
            alert('{{ Session::get('gagal') }}')
        </script>
    @endif
    <div class="row pt-3 pb-3" style="width: 100%; margin-left: 0;">
        <div class="col-md-6"
             style="text-align: left; display: flex; flex-direction: row; justify-content: left">
            <img src="{{ asset('filelogo/logo-dhp.png') }}" alt="" style="width: 70%;">
        </div>
        <div class="col-md-6" style="border:1px solid">
            <table style="border-collapse:collapse;" id="stiker_pasien">
                <tr>
                    <td style="width: 40%;">Nama</td>
                    <td style="padding-left:10px; padding-right:5px"> :</td>
                    <td>{{ $pasien->nama }}</td>
                </tr>
                <tr>
                    <td style="width: 40%;">No. RM</td>
                    <td style="padding-left:10px; padding-right:5px"> :</td>
                    <td>{{ $pasien->id }}</td>
                </tr>
                <tr>
                    <td style="width: 40%;">Tempat, Tgl Lahir</td>
                    <td style="padding-left:10px; padding-right:5px"> :</td>
                    <td>{{ $pasien->tempat_lahir }}, {{ date('d-m-Y', strtotime($pasien->tgl_lahir)) }}</td>
                </tr>
                <tr>
                    <td style="width: 40%;">Jenis Kelamin</td>
                    <td style="padding-left:10px; padding-right:5px"> :</td>
                    <td>{{ $pasien->kelamin ? 'Perempuan' : 'Laki-Laki' }}</td>
                </tr>
            </table>
        </div>
        <div class="col-md-12 my-5"
             style="border:1px solid; text-align: center; justify-content: center; background: #DCDCDC;">
            <p style="margin: 0px;">CATATAN PERKEMBANGAN PASIEN TERINTEGRASI</p>
        </div>
        <div class="col-md-12">
            <table class="table table-bordered" style="font-size: 12px;">
                <thead>
                <tr class="text-center">
                    <th style="vertical-align: middle; width: 10%">Tgl/Pkl</th>
                    <th style="vertical-align: middle; width: 20%">PPA</th>
                    <th style="vertical-align: middle; width: 40%">HASIL PEMERIKSAAN, ANALISA/ASESMEN
                        RENCANA PENATALAKSANAAN PASIEN – IAR
                        (tulis dengan format SOAP/ADIME, disertai
                        sasaran, tulis nama dan Paraf, pada akhir catatan)
                    </th>
                    <th style="vertical-align: middle; width: 30%">
                        Intruksi PPA termasuk Pasca
                        Bedah (Instruksi ditulis dg rinci
                        dan jelas)
                    </th>
                    <th style="vertical-align: middle; width: 10%">
                        Verifikasi DPJP <br>
                        (Nama, Paraf, <br>
                        Tgl, dan Pkl)
                    </th>
                </tr>
                </thead>
                <tbody>
                <tr class="text-center">
                    <td style="vertical-align: middle">
                        <input type="datetime-local" class="form-control" id="tanggal"
                               value="{{ $dokumen->catatan_perkembangan_pasien ? $dokumen->catatan_perkembangan_pasien->tanggal : date('Y-m-d H:i', strtotime($dokumen->created_at)) }}">
                    </td>
                    <td style="vertical-align: middle">
                        <div class="input-group">
                            <input type="text" hidden id="id_ppa">
                            <input type="text" readonly
                                   value="{{ $dokumen->catatan_perkembangan_pasien ? $dokumen->catatan_perkembangan_pasien->ppa : ''}}"
                                   id="ppa" class="form-control">
                            <div class="input-group-append">
                                <button class="btn btn-dark" type="button" onclick="open_modal_yth()"><i
                                        class="fa fa-list"></i></button>
                            </div>
                        </div>
                    </td>
                    <td>
                        <textarea id="hasil_pemeriksaan" cols="30" rows="5" class="form-control" style="width: 100%;">{{ $dokumen->catatan_perkembangan_pasien ? $dokumen->catatan_perkembangan_pasien->hasil_pemeriksaan : ''}}</textarea>
                    </td>
                    <td>
                        <textarea id="intruksi_ppa" cols="30" rows="5" class="form-control" style="width: 100%;">{{ $dokumen->catatan_perkembangan_pasien ? $dokumen->catatan_perkembangan_pasien->intruksi_ppa : ''}}</textarea>
                    </td>
                    <td>
                        @if ($dokumen->status == 1)
                            <a href="#" onclick="open_modal_verifikasi('{{ $dokumen->id }}')"
                               style="width:100%; height:120px; display: flex; justify-content: center; align-items: center; text-decoration: none; color:#111;">
                                <img src="{{ env('SMIS_UPLOAD_URL') . '/' . $employee->ttd }}"
                                     style="height: 2.5cm; width: 5cm;" alt="">
                            </a>
                            {{ $dokumen->nama_verifikator }}
                        @else
                            <a href="#" onclick="open_modal_verifikasi('{{ $dokumen->id }}')" class="col-md-12"
                               style="text-decoration:none; color:#111; border: 1px solid; justify-content: center; align-items: center; display: flex; height:120px;">
                                <p style="font-weight: bold; font-size: 20px; margin: 10px;">Klik disini untuk verifikasi</p>
                            </a>
                        @endif
                    </td>
                </tr>
                <tr>
                    <td colspan="5">
                        <div class="row">
                            <div class="col-3" style="text-align: right">PPA:</div>
                            <div class="col-2">Dr: Dokter</div>
                            <div class="col-2">Ns: Perawat</div>
                            <div class="col-2">Fp: Fisioterapist</div>
                            <div class="col-3">Apt: Apoteker</div>
                        </div>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
        @if ($dokumen->status == 1)
            <div class="col-lg-12 text-center pt-4">
                <a target="_blank" href="{{ url('medical_record/e_rekam_medis/catatan_perkembangan_pasien/pdf?dokumen='.$dokumen->id) }}" class="btn btn-success">Download PDF</a>
            </div>
        @endif
    </div>
</div>
</body>
<script src="https://code.jquery.com/jquery-3.3.1.min.js"
        integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<script src="{{ asset('app-assets/js/bootstrap.min.js') }}"></script>
<script src="https://cdn.datatables.net/1.10.7/js/jquery.dataTables.min.js"></script>
<script>
    var loading = '<div class="spinner-border spinner-border-sm" role="status">' +
        '<span class="sr-only">Loading...</span>' +
        '</div>';

    $('#tabel_kepada').DataTable({
        processing: true,
        serverSide: true,
        ajax: '{{ url("ajax_request/employee") }}', // memanggil route yang menampilkan data json
        columns: [{ // mengambil & menampilkan kolom sesuai tabel database
            data: 'id',
            name: 'id',
            render(data, type, row, meta) {
                return '<p class="text-center">' + (meta.row + meta.settings._iDisplayStart + 1) + '</p>';
            }
        },
            {
                data: 'nama',
                name: 'nama'
            },
            {
                data: 'nama_jabatan',
                name: 'nama_jabatan',
                render(data, type, row) {
                    return '<p class="text-center">' + data + '</p>';
                }
            },
            {
                data: 'id',
                name: 'id',
                render(data, type, row) {
                    var fungsi_set = 'set_kepada(' + "'" + data + "','" + row.nama + "','" + row.nama_jabatan +"'"+ ')';
                    return '<div class="text-center"><button type="button" onclick="' + fungsi_set + '" class="btn btn-dark"><i class="fa fa-check"></i></button></div>';
                }
            }
        ]
    });

    function set_kepada(id, nama) {
        $('#ppa').val(nama);
        $('#id_ppa').val(id);
        $('#modal_yth').modal('hide');
    }

    function open_modal_yth() {
        $('#modal_yth').modal('show');
    }

    function open_modal_verifikasi(id_dokumen) {
        $('#id_dokumen').val(id_dokumen);
        $('#modal_verifikasi').modal('show');
    }

    function cek_form() {
        if ($('#tanggal').val() == '') {
            alert('Tambahkan tanggal dahulu');
            return false;
        }
        if ($('#ppa').val() == '') {
            alert('Tambahkan PPA dahulu');
            return false;
        }
        if ($('#hasil_pemeriksaan').val() == '') {
            alert('Tambahkan hasil pemeriksaan dahulu');
            return false;
        }
        if ($('#intruksi_ppa').val() == '') {
            alert('Tambahkan intruksi PPA dahulu');
            return false;
        }
        $('#hide_tanggal').val($('#tanggal').val());
        $('#hide_id_ppa').val($('#id_ppa').val());
        $('#hide_ppa').val($('#ppa').val());
        $('#hide_hasil_pemeriksaan').val($('#hasil_pemeriksaan').val());
        $('#hide_intruksi_ppa').val($('#intruksi_ppa').val());
        if (!confirm('Yakin melanjutkan verifikasi dokumen ?')) {
            return false;
        }
    }
</script>

</html>
