@extends('layouts.app')
@section('content')
    <div class="modal fade" id="modalAdd" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header" style="margin-top: -15px;">
                    <h5 class="modal-title text-primary" id="exampleModalLongTitle">Tambah Jenis Pasien</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('jenis_pasien.store') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body mt-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="">Nama</label>
                                    <input type="text" class="form-control" required name="nama" id="nama"
                                        placeholder="" value="{{ old('nama') }}">
                                </div>
                                <div class="form-group">
                                    <label for="">Slug</label>
                                    <input type="text" class="form-control" required name="slug" id="slug"
                                        placeholder="" value="{{ old('slug') }}">
                                </div>
                                <div class="form-group">
                                    <div class="control-label">BPJS</div>
                                    <label class="custom-switch mt-2">
                                        <input type="radio" name="bpjs" id="bpjs" value="1"
                                            class="custom-switch-input" required>
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Aktif</span>
                                    </label>
                                    <label class="custom-switch mt-2">
                                        <input type="radio" name="bpjs" id="bpjs" value="0"
                                            class="custom-switch-input" required>
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Pasif</span>
                                    </label>
                                </div>
                                <div class="form-group">
                                    <div class="control-label">Perusahaan</div>
                                    <label class="custom-switch mt-2">
                                        <input type="radio" name="perusahaan" id="perusahaan" value="1"
                                            class="custom-switch-input" required>
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Aktif</span>
                                    </label>
                                    <label class="custom-switch mt-2">
                                        <input type="radio" name="perusahaan" id="perusahaan" value="0"
                                            class="custom-switch-input" required>
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Pasif</span>
                                    </label>
                                </div>
                                <div class="form-group">
                                    <div class="control-label">Asuransi</div>
                                    <label class="custom-switch mt-2">
                                        <input type="radio" name="asuransi" id="asuransi" value="1"
                                            class="custom-switch-input" required>
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Aktif</span>
                                    </label>
                                    <label class="custom-switch mt-2">
                                        <input type="radio" name="asuransi" id="asuransi" value="0"
                                            class="custom-switch-input" required>
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Pasif</span>
                                    </label>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="">Plafon</label>
                                    <input type="text" class="form-control" required name="plafon" id="plafon"
                                        placeholder="" value="{{ old('slug') }}">
                                </div>
                                <div class="form-group">
                                    <label for="">Keterangan</label>
                                    <textarea class="form-control" name="keterangan" id="keterangan" style="height: 150px;"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" id="modalEdit" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header" style="margin-top: -15px;">
                    <h5 class="modal-title text-primary" id="exampleModalLongTitle">Ubah Jenis Pasien</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('jenis_pasien.update', 0) }}" method="post" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <input type="text" hidden id="id_edit" name="id">
                    <div class="modal-body mt-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="">Nama</label>
                                    <input type="text" class="form-control" required name="nama" id="nama_edit"
                                        placeholder="" value="{{ old('nama') }}">
                                </div>
                                <div class="form-group">
                                    <label for="">Slug</label>
                                    <input type="text" class="form-control" required name="slug" id="slug_edit"
                                        placeholder="" value="{{ old('slug') }}">
                                </div>
                                <div class="form-group">
                                    <div class="control-label">BPJS</div>
                                    <label class="custom-switch mt-2">
                                        <input type="radio" name="bpjs" id="bpjs_edit" value="1"
                                            class="custom-switch-input" required>
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Aktif</span>
                                    </label>
                                    <label class="custom-switch mt-2">
                                        <input type="radio" name="bpjs" id="bpjs_edit" value="0"
                                            class="custom-switch-input" required>
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Pasif</span>
                                    </label>
                                </div>
                                <div class="form-group">
                                    <div class="control-label">Perusahaan</div>
                                    <label class="custom-switch mt-2">
                                        <input type="radio" name="perusahaan" id="perusahaan_edit" value="1"
                                            class="custom-switch-input" required>
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Aktif</span>
                                    </label>
                                    <label class="custom-switch mt-2">
                                        <input type="radio" name="perusahaan" id="perusahaan_edit" value="0"
                                            class="custom-switch-input" required>
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Pasif</span>
                                    </label>
                                </div>
                                <div class="form-group">
                                    <div class="control-label">Asuransi</div>
                                    <label class="custom-switch mt-2">
                                        <input type="radio" name="asuransi" id="asuransi_edit" value="1"
                                            class="custom-switch-input" required>
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Aktif</span>
                                    </label>
                                    <label class="custom-switch mt-2">
                                        <input type="radio" name="asuransi" id="asuransi_edit" value="0"
                                            class="custom-switch-input" required>
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Pasif</span>
                                    </label>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="">Plafon</label>
                                    <input type="text" class="form-control" required name="plafon" id="plafon_edit"
                                        placeholder="" value="{{ old('slug') }}">
                                </div>
                                <div class="form-group">
                                    <label for="">Keterangan</label>
                                    <textarea class="form-control" name="keterangan" id="keterangan_edit" style="height: 150px;"></textarea>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Data Induk Pendaftaran</h1>
            </div>
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="section-body">
                <div class="card">
                    @include('data_induk_pendaftaran.nav_tab')
                    <h4></h4>
                    <div class="card-body">
                        <div class="card-header" style="margin-left: -25px;">
                            <div class="card-header-form">
                                <form method="get" action="{{ route('jenis_pasien.search') }}">
                                    <div class="input-group">
                                        <input type="text" name="keyword" class="form-control" placeholder="Search"
                                            value="{{ $keyword ?? '' }}">
                                        <div class="input-group-btn ml-2">
                                            <button type="submit" class="btn btn-primary"><i
                                                    class="fas fa-search"></i></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-striped" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Nama</th>
                                        <th>Slug</th>
                                        <th>Keterangan</th>
                                        <th>BPJS</th>
                                        <th>Perusahaan</th>
                                        <th>Asuransi</th>
                                        <th>Plafon</th>
                                        <th>
                                            <div class="row">
                                                <button class="btn btn-primary" data-toggle="modal"
                                                    data-target="#modalAdd"><i class="fas fa-plus"></i></button>
                                                <button onclick="downloadExcel()"class="btn btn-info"
                                                    style="margin-left:3px ;"><i style="font-size:12pt;"
                                                        class="fa fa-print"></i></button>
                                            </div>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($data as $key => $dt)
                                        <tr class="">
                                            <td>{{ $key + $data->firstItem() }}</td>
                                            <td>{{ $dt->nama }}</td>
                                            <td>{{ $dt->slug }}</td>
                                            <td>{{ $dt->keterangan }}</td>
                                            <td>{{ $dt->nobpjs == 1 ? '✓' : '-' }}</td>
                                            <td>{{ $dt->nama_perusahaan == 1 ? '✓' : '-' }}</td>
                                            <td>{{ $dt->asuransi == 1 ? '✓' : '-' }}</td>
                                            <td>@currency($dt->plafon)</td>
                                            </td>
                                            <td style="width:5%;">
                                                <div style="display: flex; flex-direction: row;">
                                                    <button onclick="showEditModal('{{ $dt->id }}')"
                                                        class="btn btn-warning mr-1"><i class="fa fa-pencil"></i></button>
                                                    <form action="{{ route('jenis_pasien.destroy', $dt->id) }}" method="post"
                                                        enctype="multipart/form-data">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button
                                                            onclick="return confirm('Yakin melanjutkan hapus data {{ $dt->nama }} ?')"
                                                            class="btn btn-danger"><i class="fas fa-trash"></i></button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr class="text-center">
                                            <td colspan="10">Data tidak ditemukan</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        <div class="row mt-3" style="width: 100%; margin-left:0;">
                            <div class="col-lg-6" style="display: flex; align-items: center;">
                                @if (sizeof($data) > 0)
                                    Showing data {{ $data->firstItem() }} to {{ $data->lastItem() }}, Page
                                    {{ $data->currentPage() }} of {{ $data->lastPage() }} @if ($keyword != '')
                                        (Filtered)
                                    @endif
                                @else
                                    Empty result @if ($keyword != '')
                                        (Filtered)
                                    @endif
                                @endif
                            </div>
                            <div class="col-lg-6" style="justify-content: flex-end; display: flex;">
                                {{ $data->appends(Request::only('keyword'))->links('pagination::bootstrap-4') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script></script>
    <script src="https://code.jquery.com/jquery-3.3.1.min.js"
        integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
    <script>
        $(document).ready(function() {
            // saat input1 berubah ke input-input
            $('#nama, #nama_edit').on('change', function() {
                var text = $(this).val().toLowerCase().replace(/ /g, "-").replace(/\//g, "-");
                $('#slug, #slug_edit').val(text);
            });
        });


        function showEditModal(param) {
            var url = "{{ route('jenis_pasien.edit', ':id') }}";
            url = url.replace(':id', param);

            $.ajax({
                url: url,
                type: 'GET',
                success: function(response) {
                    if (response == null) {
                        return;
                    }
                    $('#id_edit').val(response.id);
                    $('#nama_edit').val(response.nama);
                    $('#slug_edit').val(response.slug);
                    $('input[id="bpjs_edit"]').filter('[value="' + response.nobpjs + '"]').prop('checked', true);
                    $('input[id="perusahaan_edit"]').filter('[value="' + response.nama_perusahaan + '"]').prop('checked', true);
                    $('input[id="asuransi_edit"]').filter('[value="' + response.asuransi + '"]').prop('checked', true);
                    $('#plafon_edit').val(response.plafon);
                    $('#keterangan_edit').text(response.keterangan);
                    $('#modalEdit').modal('show');
                },
                error: function(request, status, error) {
                    alert("Terjadi error saat edit data, silahkan hubungi admin");
                }
            })
        }

        function downloadExcel() {

            var keyword = $('input[name=keyword]').val();
            var url = "{{ route('jenis_pasien.download') }}/?keyword=" + keyword;
            if (confirm("Apakah anda ingin melanjutkan download ?")) {
                window.location.href = url;
            } else {
                return false;
            }
        }
    </script>
@endsection
