@extends('layouts.app')
@section('content')
<div class="modal fade" id="modal_konfirmasi" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Konfirmasi</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="hide_id_konfirmasi">
                <p>Lanjut ke farmasi atau tidak ?</p>
            </div>
            <div class="modal-footer">
                <button type="button" onclick="do_selesai('Lanjut')" class="btn btn-success">Lanjut</button>
                <button type="button" onclick="do_selesai('Selesai')" class="btn btn-primary">Selesai</button>
            </div>
        </div>
    </div>
</div>
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Antrian Poli</h1>
        </div>

        <div class="section-body">
            @if (Session::has('berhasil'))
            <div class="row" style="width:100%; margin-left: 0;">
                <div class="col-lg-12 alert alert-success">
                    {{ Session::get('berhasil') }}
                </div>
            </div>
            @endif
            @if (Session::has('gagal'))
            <div class="row" style="width:100%; margin-left: 0;">
                <div class="col-lg-12 alert alert-danger">
                    {{ Session::get('gagal') }}
                </div>
            </div>
            @endif
            <div class="card pt-3">
                <div class="row" style="width: 100%; margin-left: 0;">
                    <div class="col-lg-12" id="box_msg"></div>
                    <div class="col-lg-3">
                        <div class="form-group">
                            <label for="">Poli</label>
                            <select id="poli" class="form-control">
                                <option value="">--Select Here--</option>
                                @foreach ($poli as $p)
                                <option value="{{ $p->nama }}">{{ $p->nama }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="form-group">
                            <label for="">Dokter</label>
                            <select id="dokter" class="form-control">
                                <option value="">--Select Here--</option>
                                @foreach ($dokter as $d)
                                <option value="{{ $d->nama }}">{{ $d->nama }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="form-group" style="padding-top: 30px;">
                            <button id="btn_tampilkan" class="btn btn-primary">Tampilkan</button>
                        </div>
                    </div>
                    <div class="col-lg-12 table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr class="text-center">
                                    <th>No</th>
                                    <th>Source</th>
                                    <th>Nomor Antrian</th>
                                    <th>Nama Dokter</th>
                                    <th>Poli</th>
                                    <th>Keluhan</th>
                                    <th>Nama Pasien</th>
                                    <th>No. RM</th>
                                    <th>No. BPJS</th>
                                    <th>Jenis Kunjungan</th>
                                    <th>Pembayaran</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody id="list">
                                <tr class="text-center">
                                    <td colspan="14">Filter terlebih dahaulu</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<div class="modal fade" id="modal_batal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Batal Antrian</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="form_batal">
                @csrf
                <div class="modal-body">
                    <input type="hidden" name="id" id="id_batal">
                    <div class="form-group">
                        <label for="">Keterangan</label>
                        <textarea name="keterangan" id="keterangan_batal" rows="5" style="height: 100%;" class="form-control"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-danger">Batal</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    function loading(param) {
        return '<tr class="text-center"><td colspan="14"><div class="spinner-border spinner-border-sm" role="status">' +
            '<span class="sr-only">Loading...</span>' +
            '</div> ' + param + '</td></tr>';
    }

    function spinner(param) {
        return '<div class="spinner-border spinner-border-sm" role="status">' +
            '<span class="sr-only">Loading...</span>' +
            '</div> ' + param;
    }


    let synth = window.speechSynthesis;

    setInterval(function() {
        if ($('#dokter').val() == '' && $('#poli').val() == '') {
            $('#list').html('<tr class="text-center"><td colspan="14">Data tidak ditemukan</td></tr>')
        }
        ajax_get_data();
    }, 120000)

    function panggil(nomor, poli, pasien, jadwal_id) {
        $.ajax({
            url: "{{ url('ajax_request/send_broadcast') }}",
            method: 'post',
            data: {
                id_jadwal : jadwal_id,
                loket: poli,
                nomor: nomor,
                bagian: 'poli',
                _token: '{{ csrf_token() }}',
                pasien: pasien,
                lantai: ''
            },
            success: function(response) {
                if (response) {
                    console.log(response)
                }
            }
        })
    }

    $("#btn_tampilkan").click(function() {
        if ($('#poli').val() == '' && $('#dokter').val() == '') {
            alert('Pilih filter dahulu');
            return;
        }

        $('#btn_tampilkan').attr('disabled', true);
        $('#list').html(loading('Sedang mengambil data'));
        ajax_get_data();
    });

    function ajax_get_data() {
        console.log($('#poli').val());
        $.ajax({
            url: "{{ url('ajax_request/filter_antrian_poli') }}",
            data: {
                poli: $('#poli').val(),
                dokter: $('#dokter').val()
            },
            success: function(response) {
                console.log(response);
                render_data(response);
                $('#btn_tampilkan').removeAttr('disabled');
            }
        })
    }

    function render_data(param) {
        if (param.length == 0) {
            $('#list').html('<tr class="text-center"><td colspan="14">Data tidak ditemukan</td></tr>')
        } else {
            var ins = '';
            for (let i = 0; i < param.length; i++) {
                ins += '<tr>' +
                    '<td class="text-center">' + (i + 1) + '</td>' +
                    '<td>' + (param[i].source == 1 ? 'Mobile JKN' : 'Anjungan Mandiri') + '</td>' +
                    '<td>' + param[i].nomorantrean + '</td>' +
                    '<td>' + param[i].namadokter + '</td>' +
                    '<td>' + param[i].namapoli + '</td>' +
                    '<td>' + param[i].keluhan + '</td>' +
                    '<td>' + param[i].nama_pasien + '</td>' +
                    '<td>' + param[i].norm + '</td>' +
                    '<td>' + param[i].nobpjs + '</td>' +
                    '<td>' + param[i].jenis_kunjungan + '</td>' +
                    '<td>' + param[i].carabayar.toUpperCase() + '</td>' +
                    '<td>' + check_task_id(param[i].taskid) + '</td>' +
                    '<td>' + check_button(param[i].taskid, param[i].id, param[i].nomorantrean, param[i].namapoli, param[
                        i].nama_pasien, param[i].noreg, param[i].jadwal_id) + '</td>' +
                    '</tr>';
            }
            $('#list').html(ins);
        }
        $('#btn_tampilkan').removeAttr('disabled');
    }

    function check_task_id(param) {
        switch (param) {
            case 0:
                return 'Belum Checkin';
                break;
            case 3:
                return 'Menunggu Dilayani';
                break;
            case 4:
                return 'Selesai Dilayani';
                break;
            default:
                return '';
                break;
        }
    }

    function check_button(param, id, nomor, poli, pasien, noreg, jadwal_id) {
        switch (param) {
            case 0:
                return '<div style="display:inline-flex">' +
                    '<button onclick="panggil(' + "'" + nomor + "','" + poli + "','" + pasien + "','" + jadwal_id + "'" + ')" class="btn btn-dark mr-1 tbl_panggil">Panggil</button>' +
                    '<button onclick="checkin(' + id + ')" class="btn btn-info btn_checkin">Checkin</button>' +
                    '<button onclick="batal_antrian(' + id + ')" class="btn btn-danger ml-1 btn_batal">Batal</button>' +
                    '</div>';
                break;
            case 3:
                var checkin = noreg == '' ? '<button onclick="checkin(' + id + ')" class="btn btn-info btn_checkin mr-1">Checkin</button>' : '';
                return '<div style="display:inline-flex">' +
                    '<button onclick="panggil(' + "'" + nomor + "','" + poli + "','" + pasien + "','" + jadwal_id + "'" + ')" class="btn btn-dark mr-1 tbl_panggil">Panggil</button>' +
                    checkin +
                    '<button onclick="layani(' + id + ')" class="btn btn-warning tbl_layani">Layani</button>' +
                    '</div>';
                break;
            case 4:
                var checkin = noreg == '' ? '<button onclick="checkin(' + id + ')" class="btn btn-info btn_checkin ml-1">Checkin</button>' : '';
                return '<div style="display:inline-flex">' +
                    '<button onclick="selesai(' + id + ')" class="btn btn-success tbl_selesai">Selesai</button>' +
                    checkin +
                    '</div>';
                break;
            default:
                return '';
                break;
        }
    }

    function batal_antrian(param) {
        $('#id_batal').val(param);
        $('#modal_batal').modal('show');
    }

    $('#form_batal').submit(function(e) {
        e.preventDefault();
        if (!confirm('Yakin melakukan batal antrian ?')) {
            return;
        }

        if($('#keterangan_batal').val() == ''){
            toastr.error('Keterangan wajib diisi !');
            return;
        }

        toastr.warning(spinner('Harap tunggu, sedang melakukan batal antrian...'));

        $.ajax({
            url: "{{ url('antrian/poli/batal_antrian') }}",
            data: $('#form_batal').serialize(),
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }
                $('#modal_batal').modal('hide');
                toastr.success(response.message);
                ajax_get_data();
            }
        })
    })

    function checkin(param) {
        $('.btn_batal').attr('disabled', true);
        $('.btn_checkin').attr('disabled', true);
        $('#btn_tampilkan').attr('disabled', true);
        $('.tbl_layani').attr('disabled', true);
        $('.tbl_selesai').attr('disabled', true);
        toastr.warning(spinner('Harap tunggu, sedang melakukan checkin...'));
        $.ajax({
            url: "{{ url('ajax_request/checkin') }}",
            data: {
                id: param
            },
            success: function(response) {
                console.log(response);
                if (response.status) {
                    toastr.success(response.message);
                    ajax_get_data();
                } else {
                    toastr.error(response.message);
                }
                $('.btn_batal').removeAttr('disabled');
                $('.btn_checkin').removeAttr('disabled');
                $('.tbl_layani').removeAttr('disabled');
                $('#btn_tampilkan').removeAttr('disabled');
                $('.tbl_selesai').removeAttr('disabled');
            }
        })
    }

    function layani(param) {
        $('.btn_batal').attr('disabled', true);
        $('.btn_checkin').attr('disabled', true);
        $('#btn_tampilkan').attr('disabled', true);
        $('.tbl_layani').attr('disabled', true);
        $('.tbl_selesai').attr('disabled', true);
        toastr.warning(spinner('Sedang mengupdate data, harap tunggu...'));
        $.ajax({
            url: "{{ url('ajax_request/layani_poli') }}",
            data: {
                id: param
            },
            success: function(response) {
                if (response.status) {
                    toastr.success(response.message);
                    ajax_get_data();
                } else {
                    toastr.error(response.message);
                }
                $('.btn_batal').removeAttr('disabled');
                $('.btn_checkin').removeAttr('disabled');
                $('.tbl_layani').removeAttr('disabled');
                $('#btn_tampilkan').removeAttr('disabled');
                $('.tbl_selesai').removeAttr('disabled');
            }
        })
    }

    function selesai(param) {
        $('#hide_id_konfirmasi').val(param);
        $('#modal_konfirmasi').modal('show');
    }

    function do_selesai(param) {
        var next = 0;
        var farmasi = 0;
        if (param == 'Lanjut') {
            next = 1;
        }
        $('.btn_batal').attr('disabled', true);
        $('.btn_checkin').attr('disabled', true);
        $('#btn_tampilkan').attr('disabled', true);
        $('.tbl_layani').attr('disabled', true);
        $('.tbl_selesai').attr('disabled', true);
        toastr.warning(spinner('Sedang mengupdate data, harap tunggu...'));
        $.ajax({
            url: "{{ url('ajax_request/selesai_poli') }}",
            data: {
                id: $('#hide_id_konfirmasi').val(),
                lanjut: next,
            },
            success: function(response) {
                if (response.status) {
                    toastr.success(response.message);
                    ajax_get_data();
                } else {
                    toastr.error(response.message);
                }
                $('#modal_konfirmasi').modal('hide');
                $('.btn_batal').removeAttr('disabled');
                $('.btn_checkin').removeAttr('disabled');
                $('.tbl_layani').removeAttr('disabled');
                $('#btn_tampilkan').removeAttr('disabled');
                $('.tbl_selesai').removeAttr('disabled');
            }
        })
    }

    $(document).ready(function() {
        $('#poli').select2();
        $('#dokter').select2();
    })
</script>
@endpush