@extends('layouts.app')
@section('content')
<div class="modal fade" id="modal_edit_mjkn" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Ubah Pasien</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="form_ubah_mjkn">
                @csrf
                <input type="hidden" name="id" id="edit_id_mjkn">
                <input type="hidden" name="_method" value="put">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="">No. Rekam Medis</label>
                        <input type="number" name="nrm" id="edit_nrm_mjkn" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">NIK/KTP</label>
                        <input type="number" name="nik" id="edit_nik_mjkn" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">No. BPJS</label>
                        <input type="number" name="nobpjs" id="edit_nobpjs_mjkn" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">Nama</label>
                        <input type="text" name="nama" id="edit_nama_pasien_mjkn" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">Jenis Kelamin</label>
                        <select name="kelamin" id="edit_kelamin_mjkn" class="form-control">
                            <option value="0">Laki-Laki</option>
                            <option value="1">Perempuan</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Tanggal Lahir</label>
                        <input type="date" name="tanggal_lahir" id="edit_tanggal_lahir_mjkn" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">Alamat</label>
                        <input type="text" name="alamat" id="edit_alamat_mjkn" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">Propinsi</label>
                        <select name="propinsi" id="edit_propinsi_mjkn" class="form-control">
                            <option value="">--Select Here--</option>
                            @foreach ($propinsi as $prop)
                            <option value="{{ $prop->id }}">{{ $prop->nama }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Kabupaten</label>
                        <select name="kabupaten" id="edit_kabupaten_mjkn" class="form-control">
                            <option value="">--Select Here--</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Kecamatan</label>
                        <select name="kecamatan" id="edit_kecamatan_mjkn" class="form-control">
                            <option value="">--Select Here--</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Kelurahan</label>
                        <select name="kelurahan" id="edit_kelurahan_mjkn" class="form-control">
                            <option value="">--Select Here--</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">RT</label>
                        <input type="number" name="rt" id="edit_rt_mjkn" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">RW</label>
                        <input type="number" name="rw" id="edit_rw_mjkn" class="form-control">
                    </div>
                    <div id="msg_ubah_mjkn"></div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Antrian Pendaftaran</h1>
        </div>

        <div class="section-body">
            @if (Session::has('berhasil'))
            <div class="row" style="width:100%; margin-left: 0;">
                <div class="col-lg-12 alert alert-success">
                    {{ Session::get('berhasil') }}
                </div>
            </div>
            @endif
            @if (Session::has('gagal'))
            <div class="row" style="width:100%; margin-left: 0;">
                <div class="col-lg-12 alert alert-danger">
                    {{ Session::get('gagal') }}
                </div>
            </div>
            @endif
            @if ($errors->any())
            @foreach ($errors->all() as $error)
            <div class="alert alert-danger col-lg-12">{{ $error }}</div>
            @endforeach
            @endif
            <div class="card pt-3">
                <div class="row" style="width: 100%; margin-left: 0;">
                    <div class="col-lg-3">
                        <div class="form-group">
                            <select id="loket" class="form-control">
                                <option value="pendaftaran">Pendaftaran</option>
                                <option value="loket 1">Loket 1</option>
                                <option value="loket 2">Loket 2</option>
                                <option value="loket 3">Loket 3</option>
                                <option value="loket 4">Loket 4</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-lg-9">

                    </div>
                </div>
                <div class="row" style="width: 100%; margin-left: 0;">
                    <div class="col-lg-12">
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" id="antrian-manual-tab" data-toggle="tab" href="#antrian_manual" role="tab" aria-controls="antrian-manual" aria-selected="true">Antrian manual</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="antrian-pasien-tab" data-toggle="tab" href="#antrian_pasien" role="tab" aria-controls="antrian-pasien" aria-selected="true">Antrian pasien
                                    online</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="pasien-baru-tab" data-toggle="tab" href="#pasien_baru" role="tab" aria-controls="pasien-baru" aria-selected="false">Pasien baru</a>
                            </li>
                        </ul>
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="antrian_manual" role="tabpanel" aria-labelledby="antrian-manual-tab">
                                <div class="row pt-5 pb-5">
                                    <div class="col-lg-3"></div>
                                    <div class="col-lg-6">
                                        <div class="input-group">
                                            <div class="input-group-append">
                                                <button class="btn btn-danger pl-4 pr-4" onclick="panggil_ulang()">Panggil ulang</button>
                                            </div>
                                            <input type="text" class="form-control" style="text-align:center;" id="nomorantrian_manual" readonly>
                                            <div class="input-group-append">
                                                <button class="btn btn-success" onclick="panggil_berikutnya()">Panggil
                                                    berikutnya</button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3"></div>
                                </div>
                            </div>
                            <!-- Form pendaftaran pasien -->
                            <div class="tab-pane fade" id="pendaftaran_pasien" role="tabpanel" aria-labelledby="pendaftaran-pasien-tab">
                            </div>
                            <div class="tab-pane fade" id="antrian_pasien" role="tabpanel" aria-labelledby="antrian-pasien-tab">
                                <div id="msg"></div>
                                <div class="table-responsive">
                                    <table class="table table-striped" id="tabel_antrian_online" style="font-size: 14px;">
                                        <thead>
                                            <tr>
                                                <th class="text-center">No</th>
                                                <th class="text-center">Asal Data</th>
                                                <th class="text-center">Nomor Antrian</th>
                                                <th class="text-center">Nama Pasien</th>
                                                <th class="text-center">No. RM</th>
                                                <th class="text-center">No. BPJS</th>
                                                <th class="text-center">NIK</th>
                                                <th class="text-center">Status</th>
                                                <th class="text-center">Action</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="pasien_baru" role="tabpanel" aria-labelledby="pasien-baru-tab">
                                <div class="table-responsive">
                                    <table class="table table-striped" id="tabel_pasien_baru" style="font-size: 14px;">
                                        <thead>
                                            <tr>
                                                <th class="text-center">No</th>
                                                <th class="text-center">Asal Data</th>
                                                <th class="text-center">Nama Pasien</th>
                                                <th class="text-center">No. RM</th>
                                                <th class="text-center">No. BPJS</th>
                                                <th class="text-center">NIK</th>
                                                <th class="text-center">Action</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<div class="modal fade" id="modal_batal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Batal Antrian</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="form_batal">
                @csrf
                <div class="modal-body">
                    <input type="hidden" name="id" id="id_batal">
                    <div class="form-group">
                        <label for="">Keterangan</label>
                        <textarea name="keterangan" id="keterangan_batal" rows="5" style="height: 100%;" class="form-control"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-danger">Batal</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    $(document).ready(function() {
        get_antrian_manual();
        get_antrian_online();
        get_pasien_baru();
    })

    function get_antrian_manual() {
        $.ajax({
            url: "{{ url('antrian/pendaftaran/ajax_antrian_manual') }}",
            success: function(response) {
                if (Object.keys(response).length === 0) {
                    $('#nomorantrian_manual').val('');
                    return;
                }
                console.log(response);
                $('#nomorantrian_manual').val('A' + response.last_call + ' / A' + response.last_queue);
            }
        })
    }

    function get_antrian_online() {
        if ($.fn.DataTable.isDataTable("#tabel_antrian_online")) {
            $('#tabel_antrian_online').DataTable().clear().destroy();
        }
        $('#tabel_antrian_online').DataTable({
            processing: true,
            serverSide: true,
            theme: 'bootstrap',
            ajax: "{{ url('antrian/datatable/antrian_online') }}",
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    orderable: false,
                    searchable: false,
                    render: function(data, type, row) {
                        return '<div class="text-center">' + data + '</div>';
                    }
                },
                {
                    data: 'unit_kerja',
                    name: 'unit_kerja'
                },
                {
                    data: 'nomorantrean',
                    name: 'nomorantrean'
                },
                {
                    data: 'pasien',
                    name: 'pasien'
                },
                {
                    data: 'norm',
                    name: 'norm'
                },
                {
                    data: 'nobpjs',
                    name: 'nobpjs'
                },
                {
                    data: 'ktp',
                    name: 'ktp'
                },
                {
                    data: 'taskid',
                    name: 'taskid',
                    render: function(data, meta, row) {
                        switch (data) {
                            case 0:
                                return 'Belum Checkin';
                                break;
                            case 1:
                                return 'Belum Dilayani';
                                break;
                            case 2:
                                return 'Sedang Dilayani';
                                break;
                            default:
                                return '';
                                break;
                        }
                    }
                },
                {
                    data: 'id',
                    name: 'id',
                    orderable: false,
                    searchable: false,
                    render: function(data, type, row) {
                        return '<div style="display:flex; justify-content:center">' + render_button(row) + '</div>';
                    }
                }
            ]
        });
    }

    function get_pasien_baru() {
        if ($.fn.DataTable.isDataTable("#tabel_pasien_baru")) {
            $('#tabel_pasien_baru').DataTable().clear().destroy();
        }
        $('#tabel_pasien_baru').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ url('antrian/datatable/pasien_baru') }}",
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    orderable: false,
                    searchable: false,
                    render: function(data, type, row) {
                        return '<div class="text-center">' + data + '</div>';
                    }
                },
                {
                    data: 'unit_kerja',
                    name: 'unit_kerja'
                },
                {
                    data: 'nama',
                    name: 'nama'
                },
                {
                    data: 'nrm',
                    name: 'nrm'
                },
                {
                    data: 'nobpjs',
                    name: 'nobpjs'
                },
                {
                    data: 'nik',
                    name: 'nik'
                },
                {
                    data: 'id',
                    name: 'id',
                    orderable: false,
                    searchable: false,
                    render: function(data, type, row) {
                        return '<div style="display:flex; justify-content:center;"><button class="btn btn-warning mr-1" onclick="open_modal_edit_mjkn(' +
                            "'" + data + "'" +
                            ')">Ubah</button><button class="btn btn-dark mr-1" onclick="panggil_pasien_baru(' +
                            "'" + row.nama + "'" +
                            ')">Panggil</button><button class="btn btn-primary" onclick="tambah_mjkn(' +
                            "'" +
                            data + "'" +
                            ')">Tambah</button><button class="btn btn-danger ml-1" onclick="hapus_mjkn(' +
                            "'" +
                            data + "'" + ')">Hapus</button></div>';
                    }
                },
            ]
        });
    }

    function render_button(param) {
        var checkin = '';
        switch (param.taskid) {
            case 0:
                var tgl = "{{ date('Y-m-d') }}";
                checkin = param.noreg == '' ? '<button class="btn btn-primary mr-1 checkin" onclick="checkin(' + "'" +
                    param.id + "'" + ')">Checkin</button>' : '';
                return '<div style="display:flex;">' + checkin +
                    '<button class="btn btn-danger mr-1" onclick="batal_antrian(' + param.id +
                    ')">Batal</button><a class="btn btn-info" target="_blank" href="../cetak_antrian?nomor=' +
                    param.id + '">Cetak</a></div>';
                break;
            case 1:
                checkin = param.noreg == '' ? '<button class="btn btn-primary mr-1 checkin" onclick="checkin(' + "'" +
                    param.id + "'" + ')">Checkin</button>' : '';
                return '<div style="display:flex;">' + checkin + '<button class="btn btn-dark mr-1" onclick="panggil(' +
                    "'" + param.id + "'" +
                    ')">Panggil</button><a class="btn btn-warning" href="./pendaftaran_layani_antrian?id=' + param.id +
                    '">Layani</a><button class="btn btn-danger ml-1 mr-1" onclick="batal_antrian(' + param.id +
                    ')">Batal</button><a class="btn btn-info" target="_blank" href="../cetak_antrian?nomor=' +
                    param.id + '">Cetak</a></div>';
                break;
            case 2:
                return '<div style="display:flex;"><a class="btn btn-success mr-1" href="./pendaftaran_selesai_antrian?id=' +
                    id + '">Selesai</a><a class="btn btn-info" target="_blank" href="../cetak_antrian?nomor=' +
                    param.id + '">Cetak</a></div>';
                break;
            case 3:
                checkin = param.noreg == '' ? '<button class="btn btn-primary mr-1 checkin" onclick="checkin(' + "'" +
                    param.id + "'" + ')">Checkin</button>' : '';
                return '<div style="display:flex;">' + checkin + '<a class="btn btn-info" target="_blank" href="../cetak_antrian?nomor=' +
                    param.id + '">Cetak</a></div>';
                break;
            default:
                return '';
                break;
        }
    }

    function batal_antrian(param) {
        $('#id_batal').val(param);
        $('#modal_batal').modal('show');
    }

    $('#form_batal').submit(function(e) {
        e.preventDefault();
        if (!confirm('Yakin melakukan batal antrian ?')) {
            return;
        }

        if($('#keterangan_batal').val() == ''){
            toastr.error('Keterangan wajib diisi !');
            return;
        }

        $.ajax({
            url: "{{ url('antrian/pendaftaran/batal_antrian') }}",
            data: $('#form_batal').serialize(),
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }
                $('#modal_batal').modal('hide');
                toastr.success(response.message);
                get_antrian_online();
            }
        })
    })

    function panggil_berikutnya() {
        $.ajax({
            url: "{{ url('antrian/pendaftaran/panggil_antrian') }}",
            data: {
                manual: true,
                tipe: 'next',
                bagian: 'pendaftaran',
                loket: $('#loket').val(),
                pasien_baru: false,
                pasien: ''
            },
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }
                toastr.success(response.message);
                get_antrian_manual();
            }
        })
    }

    function panggil_ulang() {
        $.ajax({
            url: "{{ url('antrian/pendaftaran/panggil_antrian') }}",
            data: {
                manual: true,
                tipe: 'repeat',
                bagian: 'pendaftaran',
                loket: $('#loket').val(),
                pasien_baru: false,
                pasien: ''
            },
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }
                toastr.success(response.message);
                get_antrian_manual();
            }
        })
    }

    function panggil(param) {
        $.ajax({
            url: "{{ url('antrian/pendaftaran/panggil_antrian') }}",
            data: {
                manual: false,
                tipe: '',
                bagian: 'pendaftaran',
                loket: $('#loket').val(),
                id: param,
                pasien_baru: false,
                pasien: ''
            },
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }
                toastr.success(response.message);
                get_antrian_online();
            }
        })
    }

    function panggil_pasien_baru(param) {
        $.ajax({
            url: "{{ url('antrian/pendaftaran/panggil_antrian') }}",
            data: {
                manual: false,
                tipe: '',
                bagian: 'pendaftaran',
                loket: $('#loket').val(),
                id: param,
                pasien_baru: true,
                pasien: param
            },
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }
                toastr.success(response.message);
                get_pasien_baru();
            }
        })
    }

    function checkin(param) {
        toastr.warning(loading('Sedang melakukan checkin, harap tunggu...'));
        $.ajax({
            url: "{{ url('antrian/pendaftaran/checkin') }}",
            data: {
                id: param
            },
            success: function(response) {
                console.log(response);
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }
                toastr.success(response.message);
                get_antrian_online();
            }
        })
    }

    function loading(msg) {
        return '<div class="spinner-border spinner-border-sm" role="status">' +
            '<span class="sr-only">Loading...</span>' +
            '</div> ' + msg;
    }

    function open_modal_edit_mjkn(param) {
        $.ajax({
            url: "{{ url('ajax_request/select_mjkn_patient') }}",
            data: {
                pasien: param
            },
            success: function(response) {
                if (response == null) {
                    return;
                }
                $('#edit_id_mjkn').val(response.id);
                $('#edit_nama_pasien_mjkn').val(response.nama);
                $('#edit_nrm_mjkn').val(response.nrm);
                $('#edit_nik_mjkn').val(response.nik);
                $('#edit_nobpjs_mjkn').val(response.nobpjs);
                $('#edit_kelamin_mjkn').val(response.kelamin);
                $('#edit_tanggal_lahir_mjkn').val(response.tgl_lahir);
                $('#edit_alamat_mjkn').val(response.alamat);
                $('#edit_rt_mjkn').val(response.rt);
                $('#edit_rw_mjkn').val(response.rw);
                $('#edit_propinsi_mjkn').val(response.id_propinsi).trigger('change');
                get_kabupaten(response.id_kabupaten, response.id_kecamatan, response.id_kelurahan);
                $('#msg_ubah_mjkn').html('');
                $('#modal_edit_mjkn').modal('show');
                console.log(response);
            }
        })
    }

    function get_kabupaten(kab, kec, kel) {
        $('#edit_kabupaten_mjkn').html('<option value="">-- Sedang mengambil data --</option>');
        $.ajax({
            url: "{{ url('ajax_request/get_kabupaten') }}",
            data: {
                propinsi: $('#edit_propinsi_mjkn').val()
            },
            success: function(response) {
                if (response == null) {
                    $('#edit_kabupaten_mjkn').html('<option value="">-- Tidak ada data --</option>');
                    return;
                }

                var ins = '<option value="">-- Select Here --</option>';
                for (let i = 0; i < response.length; i++) {
                    ins += '<option value="' + response[i].id + '">' + response[i].nama + '</option>';
                }
                $('#edit_kabupaten_mjkn').html(ins);
                $('#edit_kabupaten_mjkn').val(kab);
                get_kecamatan(kec, kel);
            }
        })
    }

    function get_kecamatan(kec, kel) {
        $('#edit_kecamatan_mjkn').html('<option value="">-- Sedang mengambil data --</option>');
        $.ajax({
            url: "{{ url('ajax_request/get_kecamatan') }}",
            data: {
                kabupaten: $('#edit_kabupaten_mjkn').val()
            },
            success: function(response) {
                if (response == null) {
                    $('#edit_kecamatan').html('<option value="">-- Tidak ada data --</option>');
                    return;
                }

                var ins = '<option value="">-- Select Here --</option>';
                for (let i = 0; i < response.length; i++) {
                    ins += '<option value="' + response[i].id + '">' + response[i].nama + '</option>';
                }
                $('#edit_kecamatan_mjkn').html(ins);
                $('#edit_kecamatan_mjkn').val(kec);
                get_kelurahan(kel)
            }
        })
    }

    function get_kelurahan(kel) {
        $('#edit_kelurahan_mjkn').html('<option value="">-- Sedang mengambil data --</option>');
        $.ajax({
            url: "{{ url('ajax_request/get_kelurahan') }}",
            data: {
                kecamatan: $('#edit_kecamatan_mjkn').val()
            },
            success: function(response) {
                if (response == null) {
                    $('#edit_kelurahan_mjkn').html('<option value="">-- Tidak ada data --</option>');
                    return;
                }

                var ins = '<option value="">-- Select Here --</option>';
                for (let i = 0; i < response.length; i++) {
                    ins += '<option value="' + response[i].id + '">' + response[i].nama + '</option>';
                }
                $('#edit_kelurahan_mjkn').html(ins);
                $('#edit_kelurahan_mjkn').val(kel);
            }
        })
    }

    function validasi_form_mjkn() {
        if ($('#edit_nama_pasien_mjkn').val() == '') {
            alert('Nama pasien harus diisi');
            return false;
        }
        if ($('#edit_nrm_mjkn').val() == '') {
            alert('No. rekam medis harus diisi');
            return false;
        }
        if ($('#edit_nik_mjkn').val() == '') {
            alert('NIK harus diisi');
            return false;
        }
        if ($('#edit_nobpjs_mjkn').val() == '') {
            alert('No. BPJS harus diisi');
            return false;
        }
        if ($('#edit_kelamin_mjkn').val() == '') {
            alert('Pilih jenis kelamin dahulu');
            return false;
        }
        if ($('#edit_tanggal_lahir_mjkn').val() == '') {
            alert('Pilih tanggal lahir dahulu');
            return false;
        }
        if ($('#edit_alamat_mjkn').val() == '') {
            alert('Alamat harus diisi');
            return false;
        }
        if ($('#edit_rt_mjkn').val() == '') {
            alert('RT harus diisi');
            return false;
        }
        if ($('#edit_rw_mjkn').val() == '') {
            alert('RW harus diisi');
            return false;
        }
        if ($('#edit_propinsi_mjkn').val() == '') {
            alert('Pilih propinsi dahulu');
            return false;
        }
        if ($('#edit_kabupaten_mjkn').val() == '') {
            alert('Pilih kabupaten dahulu');
            return false;
        }
        if ($('#edit_kecamatan_mjkn').val() == '') {
            alert('Pilih kecamatan dahulu');
            return false;
        }
        if ($('#edit_kelurahan_mjkn').val() == '') {
            alert('Pilih kelurahan dahulu');
            return false;
        }
        return true;
    }

    $('#form_ubah_mjkn').submit(function(e) {
        e.preventDefault();
        if (validasi_form_mjkn() === false) {
            return;
        }
        $('#msg_ubah_mjkn').html('<div class="alert alert-info">' + loading('Sedang menyimpan data, harap tunggu...') + '</div>');
        $.ajax({
            url: "{{ url('ajax_request/update_mjkn') }}",
            method: "post",
            data: $('#form_ubah_mjkn').serialize(),
            success: function(response) {
                if (!response.status) {
                    $('#msg_ubah_mjkn').html('<div class="alert alert-danger">' + response.message + '</div>');
                    return;
                }
                $('#msg_ubah_mjkn').html('<div class="alert alert-success">' + response.message + '</div>');
                $('#modal_edit_mjkn').modal('hide');
                get_pasien_baru();
            }
        })
    })

    $('#edit_propinsi_mjkn').change(function() {
        $('#edit_kabupaten_mjkn').html('<option value=""><-- Select Here --/option>');
        $('#edit_kecamatan_mjkn').html('<option value=""><-- Select Here --/option>');
        $('#edit_kelurahan_mjkn').html('<option value=""><-- Select Here --/option>');
        get_kabupaten('', '', '');
    })

    $('#edit_kabupaten_mjkn').change(function() {
        $('#edit_kecamatan_mjkn').html('<option value=""><-- Select Here --/option>');
        $('#edit_kelurahan_mjkn').html('<option value=""><-- Select Here --/option>');
        get_kecamatan('', '');
    })

    $('#edit_kecamatan_mjkn').change(function() {
        $('#edit_kelurahan_mjkn').html('<option value=""><-- Select Here --/option>');
        get_kelurahan('');
    })

    function tambah_mjkn(id) {
        $.ajax({
            url: "{{ url('ajax_request/pasien_mjkn_daftar') }}",
            data: {
                pasien: id
            },
            success: function(response) {
                if (!response.status) {
                    alert(response.message);
                    return;
                }
                get_pasien_baru();
            }
        })
    }

    function hapus_mjkn(id) {
        if (!confirm('Yakin melanjutkan hapus data ? data yang dihapus tidak dapat dikembalikan')) {
            return;
        }
        $.ajax({
            url: "{{ url('ajax_request/hapus_mjkn') }}",
            data: {
                pasien: id
            },
            success: function(response) {
                if (!response.status) {
                    alert(response.message);
                    return;
                }
                get_pasien_baru();
            }
        })
    }
</script>
@endpush