<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;

/**
 * Class PenerimaanKasirService 
 * @author rivaldo 
 */

class PenerimaanKasirService
{

    public function getRekapTindakanDokter($param)
    {
        $queryTindakanDokter = DB::table('smis_ksr_kolektif as kolektif')
            ->join('smis_rg_layananpasien as pasien', 'kolektif.noreg_pasien', 'pasien.id')
            ->select('kolektif.nama_tagihan as tindakan_dokter', DB::raw('COUNT(kolektif.id) as jumlah'), DB::raw('SUM(kolektif.total) as total'))
            ->where([
                ['kolektif.jenis_tagihan', 'tindakan_dokter'],
                ['kolektif.prop', ' '],
                ['pasien.prop', ' '],
                ['kolektif.nilai', '>', 0],
                ['pasien.selesai', 1],
                ['pasien.carapulang', '<>', 'Tidak Datang'],
                [DB::raw('DATE(pasien.tanggal)'), '>=', $param->tanggal_dari_conv],
                [DB::raw('DATE(pasien.tanggal)'), '<=', $param->tanggal_sampai_conv]
            ])
            ->groupBy('kolektif.nama_tagihan');

        return $queryTindakanDokter;
    }

    public function getNoInvoice($param, $date)
    {

        $whereVar = $param != 0 ? [['noreg_pasien', $param]]  : [['nama_pasien', $param], [DB::raw('DATE(waktu)'), date('Y-m-d', strtotime($date))]];
        $invoice = DB::table('smis_ksr_bayar')->select('no_kwitansi')
            ->where($whereVar)
            ->where('prop', ' ')
            ->get();
        return $invoice;
    }

    public function getItemByFilter($param)
    {
        $item = DB::table('smis_ksr_kolektif')
            ->select(DB::raw('distinct(nama_tagihan)'))
            ->where([
                ['noreg_pasien', $param],
                ['prop', ' ']
            ])
            ->get();
        return $item;
    }

    public function getPaymentByFilter($param, $date)
    {
        $whereVar = is_numeric($param) ? [['noreg_pasien', $param], ['prop', ' ']]  : [['prop', ' '], ['nama_pasien', $param], [DB::raw('DATE(waktu)'), date('Y-m-d', strtotime($date))]];
        $item = DB::table('smis_ksr_bayar')
            ->select('metode', 'nama_bank', 'nama_asuransi', 'keterangan', 'nilai')
            ->where($whereVar)
            ->get();

        $postArr = [];
        $cash = 0;
        $asuransi = 0;
        $qr = 0;
        $transfer = 0;
        $setoranTunai = 0;
        $bankKartuKredit = 0;
        $bankKartuDebit = 0;

        foreach ($item as $value) {
            $postArr[] = [$value->metode, $value->nama_bank, $value->nama_asuransi, $value->keterangan];
            if ($value->metode == "cash" || $value->metode == "cash_resep") {
                $cash += $value->nilai;
            }
            if ($value->metode == "asuransi") {
                $asuransi += $value->nilai;
            }
            if ($value->keterangan == "QR") {
                $qr += $value->nilai;
            }
            if ($value->keterangan == "Transfer") {
                $transfer += $value->nilai;
            }
            if ($value->keterangan == "Setoran Tunai") {
                $setoranTunai += $value->nilai;
            }
            if ($value->keterangan == "Bank Kartu Debit" || $value->metode == "bank_resep") {
                $bankKartuDebit += $value->nilai;
            }
            if ($value->keterangan == "Bank Kartu Kredit") {
                $bankKartuKredit += $value->nilai;
            }
        }

        return [
            "payment" => $postArr,
            "cash" => $cash,
            "asuransi" => $asuransi,
            "qr" => $qr,
            "transfer" => $transfer,
            "setoran_tunai" => $setoranTunai,
            "bank_kartu_kredit" => $bankKartuKredit,
            "bank_kartu_debit" => $bankKartuDebit
        ];
    }

    public function getByFilter($param)
    {
        $filter = DB::table('smis_rg_layananpasien as pasien')
            ->leftJoin(DB::raw('(select noreg_pasien,
                                    no_kwitansi, metode, 
                                    nama_bank, nama_asuransi, 
                                    keterangan, 
                                    SUM(CASE WHEN metode != "diskon" THEN nilai ELSE 0 END) as total_bayar, 
                                    SUM(CASE WHEN metode = "diskon" THEN nilai ELSE 0 END) as nilai_diskon,
                                    max(waktu) as waktu 
              from smis_ksr_bayar
              where prop = " " 
              group by noreg_pasien 
              order by waktu desc) AS bayar'), 'bayar.noreg_pasien', '=', 'pasien.id')
            ->join(DB::raw('(select noreg_pasien, nama_tagihan, sum(nilai) as total_tagihan
              from smis_ksr_kolektif
              where prop = " " group by noreg_pasien) AS kolektif'), 'kolektif.noreg_pasien', '=', 'pasien.id')
            ->select(
                'pasien.id',
                'bayar.waktu as tanggal',
                'pasien.nama_pasien',
                'pasien.jenislayanan',
                'pasien.nama_dokter',
                'pasien.carabayar',
                'bayar.no_kwitansi',
                'bayar.metode',
                'bayar.nama_bank',
                'bayar.nama_asuransi',
                'bayar.total_bayar',
                'bayar.nilai_diskon',
                'bayar.keterangan',
                'kolektif.total_tagihan',
            )
            ->where([
                ['pasien.prop', ' '],
                ['pasien.selesai', 1],
                ['pasien.carapulang', '<>', 'Tidak Datang'],
                [DB::raw('DATE(bayar.waktu)'), '>=', $param->tanggal_dari_conv],
                [DB::raw('DATE(bayar.waktu)'), '<=', $param->tanggal_sampai_conv]
            ]);

        $ksrBayar = DB::table('smis_ksr_bayar')
            ->select(DB::raw("nama_pasien as id"), 'waktu', 'nama_pasien', DB::raw("'-' as jenislayanan"), DB::raw("'-' as nama_dokter"), 'carabayar', 'no_kwitansi', 'metode', 'nama_bank', 'nama_asuransi', DB::raw("sum(nilai) as total_bayar"), DB::raw("0 as nilai_diskon"), 'keterangan', DB::raw("0 as total_tagihan"))
            ->where('prop', '=', '')
            ->where('noreg_pasien', '=', 0)
            ->where([
                [DB::raw('DATE(waktu)'), '>=', $param->tanggal_dari_conv],
                [DB::raw('DATE(waktu)'), '<=', $param->tanggal_sampai_conv]
            ])
            ->whereIn('metode', ['cash_resep', 'bank_resep'])
            ->groupBy('nama_pasien');
        //->get();

        return $filter->unionAll($ksrBayar);
    }
}
