<?php

namespace App\Services\MedicalRecord\ERekamMedis\DokumenKunjungan;

use App\Models\DokumenKunjungan;
use App\Models\Smis_Er_Resep;
use App\Services\LaboratoriumService;
use App\Services\MedicalRecord\ERekamMedisService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class CatatanPerkembanganPasienService
{
    function data($req)
    {
        $dokumen = DB::table('dokumen_kunjungan_pasien')->where('id', $req->dokumen)->first();
        $layanan = DB::table('smis_rg_layananpasien')->where('id', $dokumen->noreg)->first();
        $data = DB::table('smis_doc_catatan_perkembangan_pasien')->where('id_dokumen', $req->dokumen)->first();

        $diagnosa = DB::table('smis_mr_diagnosa')->where('id', $data->id_diagnosa ?? 0)->first();

        if (is_null($diagnosa)) {
            $diagnosa = DB::table('smis_mr_diagnosa')->where('noreg_pasien', $layanan->id)->where('prop','')->first();
        }

        $json_ns = $data ? json_decode($data->ns) : null;
        $json_dr = $data ? json_decode($data->dr) : null;
        $json_fp = $data ? json_decode($data->fp) : null;
        $json_apt = $data ? json_decode($data->apt) : null;

        return [
            'dokumen' => $dokumen,
            'data' => $data,
            'layanan' => $layanan,
            'pasien' => DB::table('smis_rg_patient')->where('id', $layanan->id_pasien)->first(),
            'dokumen_kunjungan_sebelumnya' => (new ERekamMedisService)->get_dokumen_kunjungan_sebelumnya($req),
            'diagnosa' => $diagnosa,
            'laboratorium' => $data ? (new LaboratoriumService)->select($data->id_lab) : null,
            'kelas' => DB::table('smis_adm_settings')->where('name', 'laboratory-ui-pemeriksaan-default-kelas')->first(),
            'master_hasil' => DB::table('smis_lab_hasil')->where('prop', '')->orderBy('grup')->get(),
            'resep' => $data ? Smis_Er_Resep::with('detail')->where('id', $data->id_resep)->first() : null,
            'ruangan' => DB::table('smis_adm_prototype')->where('slug', 'like', env('slug_klinik'))->where('prop', '')->get(),
            'list_kelas' =>  DB::table('smis_mjm_kelas')->where('prop', '')->get(),
            'pemeriksaan' => DB::table('smis_lab_layanan')->where('prop', '')->get(),
            'employee_auth' => DB::table('smis_hrd_employee')->where('nama', Auth::user()->realname)->where('unit_kerja', env('NAMA_KLINIK'))->first(),
            'dokumen2' => DokumenKunjungan::with('asesmen_medis_awal_rajal')
                ->where('dokumen_kunjungan_pasien.prop', '')
                ->where('dokumen_kunjungan_pasien.noreg', "!=", $dokumen->noreg)
                ->where('dokumen_kunjungan_pasien.nrm', $dokumen->nrm)
                ->where('dokumen_kunjungan_pasien.noreg', 'like', '%'.env('slug_klinik').'%')
                ->where('dokumen_kunjungan_pasien.nama_dokumen', 'like', '%Asesmen Medis Awal Rawat Jalan')
                ->orderBy('id', 'desc')
                ->first(),
            'asesmen_rajal_gigi' => DokumenKunjungan::with('asesmen_medis_awal_rajal_gigi')
                ->where('dokumen_kunjungan_pasien.prop', '')
                ->where('dokumen_kunjungan_pasien.noreg', "!=", $dokumen->noreg)
                ->where('dokumen_kunjungan_pasien.nrm', $dokumen->nrm)
                ->where('dokumen_kunjungan_pasien.noreg', 'like', '%'.env('slug_klinik').'%')
                ->where('dokumen_kunjungan_pasien.nama_dokumen', 'like', '%Asesmen Medis Awal Rawat Jalan Gigi')
                ->orderBy('id', 'desc')
                ->first(),
            'dokumen3' => DokumenKunjungan::with('catatan_perkembangan_pasien')
                ->where('dokumen_kunjungan_pasien.prop', '')
                ->where('dokumen_kunjungan_pasien.noreg', "!=", $dokumen->noreg)
                ->where('dokumen_kunjungan_pasien.nrm', $dokumen->nrm)
                ->where('dokumen_kunjungan_pasien.noreg', 'like', '%'.env('slug_klinik').'%')
                ->where('dokumen_kunjungan_pasien.nama_dokumen', 'like', '%Catatan Perkembangan Pasien')
                ->orderBy('id', 'desc')
                ->first(),
            'dokumen4' => DokumenKunjungan::with('pengkajian_keperawatan_rawat_jalan')
                ->where('dokumen_kunjungan_pasien.prop', '')
                ->where('dokumen_kunjungan_pasien.noreg', "!=", $dokumen->noreg)
                ->where('dokumen_kunjungan_pasien.nrm', $dokumen->nrm)
                ->where('dokumen_kunjungan_pasien.noreg', 'like', '%'.env('slug_klinik').'%')
                ->where('dokumen_kunjungan_pasien.nama_dokumen', 'like', '%Pengkajian Keperawatan Rawat Jalan')
                ->orderBy('dokumen_kunjungan_pasien.id', 'desc')
                ->first(),
            'employee_ns' => DB::table('smis_hrd_employee')->where('id', $json_ns && isset($json_ns->verifikator) ? $json_ns->verifikator->id : '')->first(),
            'employee_dr' => DB::table('smis_hrd_employee')->where('id', $json_dr && isset($json_dr->verifikator) ? $json_dr->verifikator->id : '')->first(),
            'employee_fp' => DB::table('smis_hrd_employee')->where('id', $json_fp && isset($json_fp->verifikator) ? $json_fp->verifikator->id : '')->first(),
            'employee_apt' => DB::table('smis_hrd_employee')->where('id', $json_apt && isset($json_apt->verifikator) ? $json_apt->verifikator->id : '')->first(),
        ];
    }

    function store($req)
    {
        $arr_ins = $req->all();

        foreach ($arr_ins as $ins => $value) {
            if (is_null($value)) {
                $arr_ins[$ins] = "";
            }
        }

        $employee_auth = DB::table('smis_hrd_employee')->where('nama', Auth::user()->realname)->where('unit_kerja', env('NAMA_KLINIK'))->first();

        $json = (array) json_decode($arr_ins[$arr_ins['ppa_submit']]);
        $json['verifikator'] = json_decode(json_encode([
            'id' => $employee_auth->id ?? 0,
            'nama' => $employee_auth->nama ?? '',
        ]));
        $arr_ins[$arr_ins['ppa_submit']] = json_encode($json);

        unset($arr_ins['ppa_submit']);
        unset($arr_ins['_token']);
        unset($arr_ins['password']);
        unset($arr_ins['dokumen']);

        $arr_ins['updated_at'] = date('Y-m-d H:i:s');

        $query = DB::table('smis_doc_catatan_perkembangan_pasien')->updateOrInsert([
            'id_dokumen' => $req->dokumen
        ], $arr_ins);

        if (isset($req->password)) {
            (new ERekamMedisService)->verifikasi_dokumen_kunjungan($req);
        }

        return DB::table('smis_doc_catatan_perkembangan_pasien')->where('id_dokumen', $req->dokumen)->first();
    }
}
