<?php

namespace App\Services\MedicalRecord\ERekamMedis\DokumenKunjungan;

use App\Models\Smis_Er_Resep;
use App\Services\LaboratoriumService;
use App\Services\MedicalRecord\ERekamMedisService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class AsesmenKebidananService {
    function data($req)
    {
        $dokumen = DB::table('dokumen_kunjungan_pasien')->where('id', $req->dokumen)->first();
        $layanan = DB::table('smis_rg_layananpasien')->where('id', $dokumen->noreg)->first();
        $data = DB::table('smis_doc_asesmen_kebidanan')->where('id_dokumen', $req->dokumen)->first();

        $dokumen_sebelumnya = DB::table('dokumen_kunjungan_pasien')->where('id', '<', $data->id ?? 0)
        ->where('noreg', 'like', env('slug_klinik'))
        ->where('nrm', $dokumen->nrm)->orderBy('id', 'desc')
        ->first();

        $data_sebelumnya = DB::table('smis_doc_asesmen_kebidanan')->where('id', $dokumen_sebelumnya->id ?? 0)->first();

        return [
            'dokumen' => $dokumen,
            'data' => $data,
            'data_sebelumnya' => $data_sebelumnya,
            'layanan' => $layanan,
            'pasien' => DB::table('smis_rg_patient')->where('id', $layanan->id_pasien)->first(),
            'diagnosa' => DB::table('smis_mr_diagnosa')->where('id', $data->id_diagnosa ?? 0)->first(),
            'laboratorium' => $data ? (new LaboratoriumService)->select($data->id_lab) : null,
            'kelas' => DB::table('smis_adm_settings')->where('name', 'laboratory-ui-pemeriksaan-default-kelas')->first(),
            'master_hasil' => DB::table('smis_lab_hasil')->where('prop', '')->orderBy('grup')->get(),
            'resep' => $data ? Smis_Er_Resep::with('detail')->where('id', $data->id_resep)->first() : null,
            'ruangan' => DB::table('smis_adm_prototype')->where('slug', 'like', env('slug_klinik'))->where('prop', '')->get(),
            'list_kelas' =>  DB::table('smis_mjm_kelas')->where('prop', '')->get(),
            'pemeriksaan' => DB::table('smis_lab_layanan')->where('prop', '')->get(),
            'employee_auth' => DB::table('smis_hrd_employee')->where('nama', Auth::user()->realname)->where('unit_kerja', env('NAMA_KLINIK'))->first(),
        ];
    }

    function store($req)
    {
        $arr_ins = $req->all();

        $arr_ins['kategori_skrining'] = $arr_ins['opsi_kategori_skrining'];
        $arr_ins['kb'] = $arr_ins['opsi_kb'];

        foreach ($arr_ins as $ins => $value) {
            if (is_null($value)) {
                $arr_ins[$ins] = "";
            }
        }

        unset($arr_ins['opsi_kb']);
        unset($arr_ins['opsi_kategori_skrining']);
        unset($arr_ins['_token']);
        unset($arr_ins['password']);
        unset($arr_ins['dokumen']);

        $query = DB::table('smis_doc_asesmen_kebidanan')->updateOrInsert([
            'id_dokumen' => $req->dokumen
        ], $arr_ins);

        if (isset($req->password)) {
            (new ERekamMedisService)->verifikasi_dokumen_kunjungan($req);
        }

        return $query;
    }
}