<?php


namespace App\Services;

use Illuminate\Support\Facades\DB;

/**
 * Class Services
 * @author rivald 
 */
class LaporanTindakanDetailDokterService
{
    public function getKonsultasi($caraDatang, $namaDokter, $namaRujukan, $nilai)
    {
        $namaDokterArr = [
            "dr. Budi Bakti, SpJP" => "lama",
            "dr. Achmad Lefi, SpJP" => "lama",
            "dr. Liliek Murtiningsih, Sp.JP" => "lama",
            "dr. Triningsih Savitri, Sp.JP" => "lama",
            "dr. Lely Puspita Candra Dewi, Sp.JP(K)" => "lama",
            "dr. Ajeng Tribawati, Sp.B" => "baru",
            "Dr. dr. Sri Mardjiati Mei Wulan, Sp.KFR(K)" => "baru",
            "dr. Sarah Yunara, Sp.PD" => "baru",
            "dr. Karina Dyahtantri Pratiwi, M.Ked.Klin, Sp.DV" => "baru",
            "dr. Ivana Sajogo, Sp.KJ(K)" => "baru",
            "dr. Azimatul Karimah, Sp.KJ(K)" => "baru",
            "dr. Dion Andriawan Wisnu, Sp.N" => "baru",
            "dr. Peni Hardjanti, Sp.KFR" => "baru",
            "Dr. dr. Dyana Sarvasti, Sp.JP(K)" => "baru",
            "dr. Dian Prakoso, Sp.N" => "baru",
            "dr. Nur Alim Basyir Hutasuhut, SP.M" => "baru",
            "dr. Nur Sulastri, Sp.KFR" => "baru",
        ];

        $returnArray = null;
        if ($caraDatang == "Datang Sendiri") {
            $result = $nilai * 0.75;
            return ['operator' => $result, 'referal' => 0];
        }
        if ($namaRujukan == "") {
            $returnArray =  ['operator' => $nilai * 0.75, 'referal' => 0];
        } else {
            foreach ($namaDokterArr as $key => $value) {
                if ($namaDokter == $key) {
                    if ($namaRujukan == $namaDokter) {
                        if ($value == "baru") {
                            $hasilBaru = $nilai * 0.8;
                            $returnArray =  ['operator' => $hasilBaru, 'referal' => 0];
                        } else {
                            $hasilLama = $nilai * 0.85;
                            $returnArray =  ['operator' => $hasilLama, 'referal' => 0];
                        }
                    }
                    if ($namaDokter != $namaRujukan) {
                        $returnArray = ['operator' => $nilai * 0.75, 'referal' => $nilai * 0.1];
                    }
                }
            }
        }

        return $returnArray;
    }

    public function getTindakan($label, $tindakan, $nilai)
    {
        $tindakanArr = [
            'ECHOCARDIOGRAFI ' => ['operator' => 250000, 'referal' => 200000],
            'TREADMILL ' => ['operator' => 200000, 'referal' => 75000],
            'ELEKTROCARDIOGRAM (ECG) ' => ['operator' => 15000, 'referal' => 10000],
            'HOLTER MONITORING 1 HARI ' => ['operator' => 250000, 'referal' => 100000],
            'VASCULAR SCREANING (ABICAVI) ' => ['operator' => 50000, 'referal' => 50000],
            'RAWAT LUKA KECIL ' => ['operator' => 0.8, 'referal' => 0],
            'RAWAT LUKA SEDANG ' => ['operator' => 0.8, 'referal' => 0],
            'RAWAT LUKA BESAR ' => ['operator' => 0.8, 'referal' => 0],
            'HIPNOTERAPI ' => ['operator' => 0.8, 'referal' => 0],
            'TEST MMPI ' => ['operator' => 0.8, 'referal' => 0]
        ];

        if ($label == "LAB") {
            $result = $nilai * 0.05;
            return ['operator' => 0, 'referal' => $result];
        } else {
            foreach ($tindakanArr as $key => $key_value) {
                if ($tindakan == $key) {
                    if ($key_value['operator'] < 1) {
                        $key_value['operator'] = $nilai * $key_value['operator'];
                        return $key_value;
                    } else {
                        return $key_value;
                    }
                }
            }
        }
    }

    public function getDataByFilter($param, $role)
    {
        //$tindakan = ['ECHOCARDIOGRAFI', 'TREADMILL', 'VASCULAR SCREANING (ABICAVI)', 'DOPPLER VASCULAR 1 KAKI', 'DOPPLER VASCULAR 2 KAKI', 'RAWAT LUKA KECIL', 'RAWAT LUKA SEDANG', 'RAWAT LUKA BESAR', 'HIPNOTERAPI', 'TEST MMPI'];
        $getData = DB::table('smis_rg_layananpasien as pasien')
            ->join(
                DB::raw("(SELECT nama_dokter, noreg_pasien, ruangan, 'LAB' as label, nama_tagihan, nilai FROM smis_ksr_kolektif WHERE ruangan = 'laboratory' and prop = ' '
                        UNION ALL
                        SELECT nama_dokter, noreg_pasien, ruangan, 'KONSUL' as label, nama_tagihan, nilai FROM smis_ksr_kolektif
                        WHERE prop = ' ' and nama_grup = 'tindakan_dokter' and nama_tagihan like '%konsultasi%'
                        UNION ALL
                        SELECT nama_dokter, noreg_pasien, ruangan, 'non_lab' as label , SUBSTR(nama_tagihan, 1, INSTR(nama_tagihan, 'Oleh') - 1) as nama_tagihan, nilai FROM smis_ksr_kolektif 
                        WHERE SUBSTR(nama_tagihan, 1, INSTR(nama_tagihan, 'Oleh') - 1) IN(
                            'ECHOCARDIOGRAFI', 
                            'TREADMILL',
                            'ELEKTROCARDIOGRAM (ECG)',
                            'HOLTER MONITORING 1 HARI',
                            'VASCULAR SCREANING (ABICAVI)', 
                            'RAWAT LUKA KECIL', 
                            'RAWAT LUKA SEDANG', 
                            'RAWAT LUKA BESAR', 
                            'HIPNOTERAPI', 
                            'TEST MMPI') AND ruangan <> 'laboratory' and prop = ' ' ) as kolektif"),
                'pasien.id',
                '=',
                'kolektif.noreg_pasien'
            )
            ->select(
                'pasien.tanggal',
                'pasien.nama_pasien',
                'pasien.nama_rujukan',
                'pasien.caradatang',
                'kolektif.nama_dokter',
                'kolektif.nama_tagihan',
                'kolektif.label',
                'kolektif.nilai'
            )
            ->where([
                ['pasien.prop', ' '],
                ['pasien.selesai', 1],
                ['pasien.carabayar', '<>', 'bpjs'],
                ['pasien.carabayar', '<>', 'bpjs_kesehatan'],
                [DB::raw('DATE(pasien.tanggal)'), '>=', $param->tanggal_dari_conv],
                [DB::raw('DATE(pasien.tanggal)'), '<=', $param->tanggal_sampai_conv]
            ])
            ->orderBy('pasien.tanggal', 'ASC');

        if ($role == "operator") {
            $getData->where([
                ['kolektif.nama_dokter', $param->nama_dokter],
                ['kolektif.ruangan', '<>', 'laboratory']
            ]);
            return $getData;
        }
        if ($role == "lab") {
            $getData->where([
                ['pasien.nama_rujukan', $param->nama_dokter],
                ['kolektif.ruangan', 'laboratory']
            ]);
            return $getData;
        } else {
            $getData->where([
                ['pasien.nama_rujukan', $param->nama_dokter],
                ['kolektif.ruangan', '<>', 'laboratory']
            ]);
            return $getData;
        }
    }

    public function getDokterName()
    {
        $nameDokter = DB::table('smis_hrd_employee')
            ->select('nama as nama_dokter')
            ->where('jabatan', 2)
            ->where('prop', '')
            ->union(DB::table('smis_rg_perujuk')
                ->select('nama as nama_dokter')->where('prop', ''))
            ->orderBy('nama_dokter', 'ASC')
            ->get();
        return $nameDokter;
    }
}
