<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class KonsultasiPoliLain extends Model
{
    use HasFactory;

    protected $table = 'smis_doc_konsultasi_poli_lain';

    protected $guarded = ['id'];

    protected $fillable = [
        'id_dokumen',
        'id_user',
        'nama_user',
        'tanggal',
        'jenis',
        'id_kepada',
        'kepada',
        'keterangan',
    ];

    function jawaban()
    {
        return $this->hasOne('App\Models\JawabanKonsultasiPoliLain', 'id_konsultasi');
    }
}
