<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PersetujuanTindakanDokterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'sign_menyatakan' => 'required',
            'nama_wali' => 'required',
            'hubungan_wali' => 'required',
            'usia_wali' => 'required',
            'kelamin_wali' => 'required',
            'alamat_wali' => 'required',
            'wali_menyatakan' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'sign_menyatakan.required' => 'Tambahkan tanda tangan dahulu',
            'nama_wali.required' => 'Nama wali harus diisi',
            'hubungan_wali.required' => 'Pilih hubungan wali dahulu',
            'usia_wali.required' => 'Umur wali harus diisi',
            'kelamin_wali.required' => 'Pilih jenis kelamin wali dahulu',
            'alamat_wali.required' => 'Alamat wali harus diisi',
            'wali_menyatakan.required' => 'Pilih menyatakan atau menolak',
        ];
    }
}
