<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PengkajianAwalMedisRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'tanggal' => 'required|date_format:Y-m-d',
            'pukul' => 'required|date_format:H:i',
            'anamnesa_umum' => 'required',
            'keluhan_utama' => 'required',
            'riwayat_penyakit_sekarang' => 'required',
            'riwayat_penyakit_dahulu' => 'required',
            'riwayat_obat_obatan' => 'required',
            'riwayat_kebiasaan_pekerjaan' => 'required',
            'riwayat_alergi_obat' => 'required',
            'masalah_kejiwaan' => 'required',
            'keadaan_umum' => 'required',
            'gcs_e' => 'required|numeric',
            'gcs_m' => 'required|numeric',
            'gcs_v' => 'required|numeric',
            'gcs_total' => 'required|numeric',
            'nadi' => 'required',
            'pernafasan' => 'required',
            'nyeri' => 'required',
            'jenis' => 'required',
            'kepala' => 'required',
            'mata' => 'required',
            'tht' => 'required',
            'leher' => 'required',
            'mulut' => 'required',
            'jantung' => 'required',
            'thoraks' => 'required',
            'abdomen' => 'required',
            'kulit' => 'required',
            'tulang' => 'required',
            'saraf' => 'required',
            'genitalia' => 'required',
            'ekstremitas' => 'required',
            'status_lokalis' => 'required',
        ];
    }

    public function messages(){
        return [
            'tanggal.required' => 'Tanggal harus diisi',
            'tanggal.date_format' => 'Format tanggal salah',
            'pukul.required' => 'Jam harus diisi',
            'pukul.date_format' => 'Format jam salah',
            'anamnesa_umum.required' => 'Anamnesa umum harus diisi',
            'keluhan_utama.required' => 'Keluhan utama harus diisi',
            'riwayat_penyakit_sekarang.required' => 'Riwayat penyakit sekarang harus diisi',
            'riwayat_penyakit_dahulu.required' => 'Riwayat penyakit dahulu harus diisi',
            'riwayat_obat_obatan.required' => 'Riwayat obat obatan harus diisi',
            'riwayat_kebiasaan_pekerjaan.required' => 'Riwayat kebiasaan pekerjaan harus diisi',
            'riwayat_alergi_obat.required' => 'Riwayat alergi obat harus diisi',
            'masalah_kejiwaan.required' => 'Masalah kejiwaan harus diisi',
            'keadaan_umum.required' => 'Keadaan umum harus diisi',
            'gcs_e.required' => 'Gcs e harus diisi',
            'gcs_e.numeric' => 'Gcs e harus angka',
            'gcs_m.required' => 'Gcs m harus diisi',
            'gcs_m.numeric' => 'Gcs m harus angka',
            'gcs_v.required' => 'Gcs v harus diisi',
            'gcs_v.numeric' => 'Gcs v harus angka',
            'gcs_total.required' => 'Gcs total harus diisi',
            'gcs_total.numeric' => 'Gcs total harus angka',
            'nadi.required' => 'Nadi harus diisi',
            'pernafasan.required' => 'Pernafasan harus diisi',
            'nyeri.required' => 'Nyeri harus diisi',
            'jenis.required' => 'Jenis harus diisi',
            'kepala.required' => 'Kepala harus diisi',
            'mata.required' => 'Mata harus diisi',
            'tht.required' => 'THT harus diisi',
            'leher.required' => 'Leher harus diisi',
            'mulut.required' => 'Mulut harus diisi',
            'jantung.required' => 'Jantung dan Pembuluh Darah harus diisi',
            'thoraks.required' => 'Thoraks, Paru-paru dan Payudara harus diisi',
            'abdomen.required' => 'Abdomen harus diisi',
            'kulit.required' => 'Kulit dan Sistem Limfatik harus diisi',
            'tulang.required' => 'Tulang Belakang dan Anggota Tubuh harus diisi',
            'saraf.required' => 'Sistem saraf harus diisi',
            'genitalia.required' => 'Genitalia, anus dan rektum harus diisi',
            'ekstremitas.required' => 'Ekstremitas harus diisi',
            'status_lokalis.required' => 'Status lokalis harus diisi',
        ];
    }
}
