<?php

namespace App\Http\Controllers\SatuSehat;

use App\Http\Controllers\Controller;
use App\Models\SmisHrdEmployee;
use App\Services\SatuSehat\PractionerService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Yajra\DataTables\Facades\DataTables;

class PractionerController extends Controller
{
    function __construct()
    {
        $this->middleware(function ($request, $next) {
            $menu = json_decode(Auth::user()->menu);
            if (property_exists($menu, 'satu_sehat')) {
                $arr = (array) $menu->satu_sehat;
                if ($arr['practioner'] == 0) {
                    return redirect('home');
                }
            } else {
                return redirect('home');
            }
            return $next($request);
        });
    }

    function index(){
        return view('satu_sehat.practioner.index');
    }

    function datatable(){
        $data = SmisHrdEmployee::where('prop', '')->whereIn('jabatan', [1,2,22,23]);
        return DataTables::of($data)->toJson();
    }

    function update_ihs(Request $req, PractionerService $ps)
    {
        try {
            $ihs = $ps->update_ihs($req);
            return response()->json($ihs);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }
}
