<?php

namespace App\Http\Controllers\SatuSehat;

use App\Http\Controllers\Controller;
use App\Models\SatuSehat\Location;
use App\Models\SatuSehat\LocationReference;
use App\Models\SatuSehat\Organization;
use App\Models\SmisAdmPrototype;
use App\Services\SatuSehat\LocationService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Yajra\DataTables\Facades\DataTables;

class LocationController extends Controller
{
    function __construct()
    {
        $this->middleware(function ($request, $next) {
            $menu = json_decode(Auth::user()->menu);
            if (property_exists($menu, 'satu_sehat')) {
                $arr = (array) $menu->satu_sehat;
                if ($arr['location'] == 0) {
                    return redirect('home');
                }
            } else {
                return redirect('home');
            }
            return $next($request);
        });
    }

    function index(Request $req){
        $data['referensi'] = LocationReference::all();
        $data['prototype'] = SmisAdmPrototype::all();
        $data['organisasi'] = Organization::where('slug_klinik', env('slug_klinik'))->get();
        return view('satu_sehat.location.index', $data);
    }

    function datatable(Request $req){
        $data = Location::leftJoin('smis_ss_organisasi', 'smis_ss_organisasi.id_organisasi', 'smis_ss_location.dikelola_oleh')->select('smis_ss_location.*', 'smis_ss_organisasi.nama as organisasi')
        ->where('smis_ss_location.slug_klinik', env('slug_klinik'));
        return DataTables::of($data)->toJson();
    }

    function datatable_referensi(Request $req){
        $data = LocationReference::select('*');
        return DataTables::of($data)->toJson();
    }

    function update_referensi(Request $req, LocationService $ls){
        try {
            $ls->update_referensi();
            return response()->json([
                'status' => true,
                'message' => 'Update data referensi lokasi berhasil'
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }

    function store(Request $req, LocationService $ls){
        try {
            $store = $ls->store($req);
            return response()->json($store);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }

    function update(Request $req, LocationService $ls){
        try {
            $store = $ls->update($req);
            return response()->json($store);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }

    function select_location(Request $req){
        $data = Location::where('id', $req->id)->first();
        return response()->json($data);
    }
}
