<?php

namespace App\Http\Controllers;

use App\Exports\PenerimaanKasirExport;
use App\Http\Requests\PenerimaanKasirRequest;
use App\Services\PenerimaanKasirService;
use Maatwebsite\Excel\Facades\Excel;

class PenerimaanKasirController extends Controller
{
    public function index()
    {
        return view('laporan_penerimaan_kasir.index', [
            'tanggal_dari' => date('Y-m-d'),
            'tanggal_sampai' => date('Y-m-d'),
        ]);
    }

    public function filter(PenerimaanKasirRequest $request, PenerimaanKasirService $penerimaanKasirService)
    {
        $data = $penerimaanKasirService->getByFilter($request)->paginate(10);
        $rekapTindakanDokter = $penerimaanKasirService->getRekapTindakanDokter($request)->get();

        return view('laporan_penerimaan_kasir.index', [
            'tanggal_dari' => $request->tanggal_dari,
            'tanggal_sampai' => $request->tanggal_sampai,
            'data' => $data,
            'rekap_tindakan_dokter' => $rekapTindakanDokter
        ]);
    }

    public function download(PenerimaanKasirRequest $request)
    {
        return Excel::download(new PenerimaanKasirExport($request), 'Penerimaan_Kasir_' . $request->tanggal_dari . ' sd ' . $request->tanggal_sampai . '.xlsx');
    }
}
