<?php

namespace App\Http\Controllers\MedicalRecord\ERekamMedis\DokumenPasien;

use App\Http\Controllers\Controller;
use App\Services\MedicalRecord\ERekamMedis\DokumenPasien\PersetujuanUmumRawatJalanService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class PersetujuanUmumRawatJalanController extends Controller
{
    function index(Request $req)
    {
        return view('medical_record.e_rekam_medis.dokumen_pasien.persetujuan_umum_rawat_jalan', (new PersetujuanUmumRawatJalanService)->data($req));
    }

    function store(Request $req)
    {
        try {
            $result = (new PersetujuanUmumRawatJalanService)->store($req);

            return response()->json([
                'code' => 200,
                'message' => 'Berhasil simpan dokumen',
                'status' => true,
                'data' => $result,
                'employee' => DB::table('smis_hrd_employee')->where('nama', Auth::user()->realname)->first()
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'code' => 500,
                'message' => $th->getMessage(),
                'status' => false
            ]);
        }
    }
}
