<?php

namespace App\Http\Controllers\MedicalRecord\ERekamMedis\DokumenKunjungan;

use App\Http\Controllers\Controller;
use App\Services\MedicalRecord\ERekamMedis\DokumenKunjungan\PengkajianKeperawatanRawatJalanService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class PengkajianKeperawatanRawatJalanController extends Controller
{
    function index(Request $req)
    {
        return view('medical_record.e_rekam_medis.dokumen_kunjungan.pengkajian_keperawatan_rawat_jalan', (new PengkajianKeperawatanRawatJalanService)->data($req));
    }

    function store(Request $req)
    {
        try {
            if (isset($req->password) && (Auth::user()->password != md5($req->password))) {
                return response()->json([
                    'status' => false,
                    'message' => 'Password anda salah',
                    'code' => 401
                ]);
            }

            (new PengkajianKeperawatanRawatJalanService)->store($req);

            return response()->json([
                'status' => true,
                'message' => 'Ok',
                'code' => 200,
                'employee' => DB::table('smis_hrd_employee')->where('nama', Auth::user()->realname ?? '')->where('prop','')->first()
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage(),
                'code' => 500
            ]);
        }
    }
}
