<?php

namespace App\Http\Controllers\MedicalRecord\ERekamMedis\DokumenKunjungan;

use App\Http\Controllers\Controller;
use App\Services\MedicalRecord\ERekamMedis\DokumenKunjungan\CatatanPerkembanganPasienService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class CatatanPerkembanganPasienController extends Controller
{
    function index(Request $req)
    {
        return view('medical_record.e_rekam_medis.dokumen_kunjungan.catatan_perkembangan_pasien', (new CatatanPerkembanganPasienService)->data($req));
    }

    function store(Request $req)
    {
        try {
            if (isset($req->password) && (Auth::user()->password != md5($req->password))) {
                return response()->json([
                    'status' => false,
                    'message' => 'Password anda salah',
                    'code' => 401
                ]);
            }

            $result = (new CatatanPerkembanganPasienService)->store($req);

            return response()->json([
                'status' => true,
                'message' => 'Ok',
                'code' => 200,
                'data' => $result,
                'employee' => DB::table('smis_hrd_employee')->where('nama', Auth::user()->realname)->where('unit_kerja', env('NAMA_KLINIK'))->first()
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage(),
                'code' => 500
            ]);
        }
    }
}
