<?php

namespace App\Http\Controllers;

use App\Http\Requests\InformedConsentRequest;
use App\Http\Requests\JawabanKonsultasiPoliLainRequest;
use App\Http\Requests\KonsultasiPoliLainRequest;
use App\Http\Requests\PengkajianAwalMedisRequest;
use App\Http\Requests\PersetujuanTindakanDokterRequest;
use App\Http\Requests\SuratKeteranganSakitRequest;
use App\Models\DokumenKunjungan;
use App\Models\SMIS_DFM_Penjualan_Resep;
use App\Models\Smis_Doc_Pengkajian_Awal_Medis;
use App\Models\SmisHrdEmployee;
use App\Models\User;
use App\Services\ERekamMedisService;
use App\Services\LaporanTindakanDetailDokterService;
use Illuminate\Http\Request;
use Auth;
use PDF;
use iio\libmergepdf\Merger;
use Illuminate\Http\Response;

class ERekamMedisController extends Controller
{
    function index(Request $req)
    {
        return view('e_rekam_medis.index');
    }

    function dokumen_identitas(Request $req, ERekamMedisService $erms)
    {
        $data = $erms->dokumen_identitas($req);
        return view('e_rekam_medis.identitas', $data);
    }

    function pdf_dokumen_identitas(Request $req, ERekamMedisService $erms)
    {
        try {
            PDF::setOptions(['dpi' => 150, 'defaultFont' => 'sans-serif']);
            $data = $erms->dokumen_identitas($req);
            $pdf_one = PDF::loadView('e_rekam_medis.pdf.identitas', $data)->setPaper('A4');
            $m = new Merger();
            $m->addRaw($pdf_one->output());
            $contents = $m->merge();
            return new Response($contents, 200, array('Content-Type' => 'application/pdf'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('gagal', $th->getMessage());
        }
    }

    function upload_signature_dokumen_identitas(Request $req, ERekamMedisService $erms)
    {
        if ($req->signed == null || $req->signed == '') {
            return redirect()->back()->with('failed', 'Tambahkan tanda tangan dahulu');
        }
        try {
            $namafile = $erms->upload_signature($req, 'signed');
            $erms->update_signature_erm($namafile, $req);
            return redirect('medical_record/e_rekam_medis/identitas?dokumen=' . $req->dokumen)->with('sukses', 'Tanda tangan dokumen identitas berhasil.');
        } catch (\Throwable $th) {
            return redirect()->back()->with('gagal', $th->getMessage());
        }
    }

    function verifikasi_dokumen_identitas(Request $req, ERekamMedisService $erms)
    {
        if (Auth::user()->password != md5($req->pass)) {
            return redirect()->back()->with('gagal', 'Password yang anda masukkan salah');
        }
        try {
            $erms->verifikasi_erm($req);
            return redirect('medical_record/e_rekam_medis/identitas?dokumen=' . $req->dokumen)->with('sukses', 'Dokumen identitas berhasil diverifikasi.');
        } catch (\Throwable $th) {
            return redirect()->back()->with('gagal', $th->getMessage());
        }
    }

    function asesmen_medis_rawat_jalan(Request $req, ERekamMedisService $erms)
    {
        $data = $erms->select_asesmen_medis_rawat_jalan($req);
        return view('e_rekam_medis.dokumen_kunjungan.asesmen_medis_rawat_jalan', $data);
    }

    function pdf_asesmen_medis_rawat_jalan(Request $req, ERekamMedisService $erms)
    {
        try {
            PDF::setOptions(['dpi' => 150, 'defaultFont' => 'sans-serif']);
            $data = $erms->get_asesmen_medis_rawat_jalan($req);
            $pdf_one = PDF::loadView('e_rekam_medis.dokumen_kunjungan.pdf.asesmen_medis_rawat_jalan', $data)->setPaper('A4', 'landscape');
            $m = new Merger();
            $m->addRaw($pdf_one->output());
            $contents = $m->merge();
            return new Response($contents, 200, array('Content-Type' => 'application/pdf'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('failed', $th->getMessage());
        }
    }

    function konsultasi_poli_lain(Request $req, ERekamMedisService $erms)
    {
        $data = $erms->konsultasi_poli_lain($req);
        return view('e_rekam_medis.dokumen_kunjungan.konsultasi_poli_lain', $data);
    }

    function save_konsultasi_poli_lain(KonsultasiPoliLainRequest $req, ERekamMedisService $erms)
    {
        try {
            if (Auth::user()->password != md5($req->pass)) {
                return redirect()->back()->with('gagal', 'Password yang anda masukkan salah');
            }
            $erms->save_konsultasi_poli_lain($req);
            return redirect('medical_record/e_rekam_medis/konsultasi_poli_lain?dokumen=' . $req->dokumen)->with('sukses', 'Konsultasi berhasil disimpan');
        } catch (\Throwable $th) {
            return redirect()->back()->with('gagal', $th->getMessage());
        }
    }

    function save_jawaban_konsultasi_poli_lain(JawabanKonsultasiPoliLainRequest $req, ERekamMedisService $erms)
    {
        try {
            if (Auth::user()->password != md5($req->pass)) {
                return redirect()->back()->with('gagal', 'Password yang anda masukkan salah');
            }
            $erms->verifikasi_dokumen_kunjungan($req);
            $erms->save_jawaban_konsultasi_poli_lain($req);
            return redirect('medical_record/e_rekam_medis/konsultasi_poli_lain?dokumen=' . $req->id_dokumen)->with('sukses', 'Jawaban konsultasi berhasil disimpan');
        } catch (\Throwable $th) {
            return redirect()->back()->with('gagal', $th->getMessage());
        }
    }

    function pdf_konsultasi_poli_lain(Request $req, ERekamMedisService $erms)
    {
        try {
            $data = $erms->konsultasi_poli_lain($req);
            PDF::setOptions(['dpi' => 150, 'defaultFont' => 'sans-serif']);
            $pdf_one = PDF::loadView('e_rekam_medis.dokumen_kunjungan.pdf.konsultasi_poli_lain', $data);
            $m = new Merger();
            $m->addRaw($pdf_one->output());
            $contents = $m->merge();
            return new Response($contents, 200, array('Content-Type' => 'application/pdf'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('gagal', $th->getMessage());
        }
    }

    function informed_consent(Request $req, ERekamMedisService $erms)
    {
        $data = $erms->informed_consent($req);
        return view('e_rekam_medis.dokumen_kunjungan.informed_consent', $data);
    }

    function save_informed_consent(InformedConsentRequest $req, ERekamMedisService $erms)
    {
        try {
            if (Auth::user()->password != md5($req->pass)) {
                return redirect()->back()->with('gagal', 'Password yang anda masukkan salah');
            }
            $erms->save_informed_consent($req);
            $erms->verifikasi_dokumen_kunjungan($req);
            return redirect('medical_record/e_rekam_medis/informed_consent?dokumen=' . $req->id_dokumen)->with('sukses', 'Data berhasil disimpan');
        } catch (\Throwable $th) {
            return redirect()->back()->with('gagal', $th->getMessage());
        }
    }

    function terima_informasi_information_consent(Request $req, ERekamMedisService $erms)
    {
        try {
            $filename = $erms->upload_signature($req, 'signed');
            $erms->save_signature_informed_consent($filename, $req->informed);
            return redirect('medical_record/e_rekam_medis/informed_consent?dokumen=' . $req->id_dokumen)->with('sukses', 'Informasi diterima');
        } catch (\Throwable $th) {
            return redirect()->back()->with('gagal', $th->getMessage());
        }
    }

    function save_persetujuan_tindakan_dokter(PersetujuanTindakanDokterRequest $req, ERekamMedisService $erms)
    {
        try {
            $saksi1 = '';
            $saksi2 = '';
            if (isset($req->sign_saksi_satu)) {
                $saksi1 = $erms->upload_signature($req, 'signed_satu');
            }
            if (isset($req->sign_saksi_dua)) {
                $saksi2 = $erms->upload_signature($req, 'signed_dua');
            }
            $ttd = $erms->upload_signature($req, 'signed_menyatakan');
            $erms->save_persetujuan_tindakan_dokter_informed_consent($req, $ttd, $saksi1, $saksi2);
            return redirect('medical_record/e_rekam_medis/informed_consent?dokumen=' . $req->dokumen)->with('sukses', 'Pernyataan berhasil disimpan');
        } catch (\Throwable $th) {
            return redirect()->back()->with('gagal', $th->getMessage());
        }
    }

    function pdf_informed_consent(Request $req, ERekamMedisService $erms)
    {
        $data = $erms->informed_consent($req);
        PDF::setOptions(['dpi' => 150, 'defaultFont' => 'sans-serif']);
        $pdf_one = PDF::loadView('e_rekam_medis.dokumen_kunjungan.pdf.informed_consent', $data);
        $m = new Merger();
        $m->addRaw($pdf_one->output());
        $contents = $m->merge();
        return new Response($contents, 200, array('Content-Type' => 'application/pdf'));
    }

    function pembedahan_operasi_kecil(Request $req, ERekamMedisService $erms)
    {
        $data = $erms->pembedahan_operasi_kecil($req);
        return view('e_rekam_medis.dokumen_kunjungan.pembedahan_operasi_kecil', $data);
    }

    function save_pembedahan_operasi_kecil(Request $req, ERekamMedisService $erms)
    {
        try {
            if (Auth::user()->password != md5($req->pass)) {
                return redirect()->back()->with('gagal', 'Password yang anda masukkan salah');
            }
            $erms->save_pembedahan_operasi_kecil($req);
            $erms->verifikasi_dokumen_kunjungan($req);
            return redirect('medical_record/e_rekam_medis/pembedahan_operasi_kecil?dokumen=' . $req->id_dokumen)->with('sukses', 'Dokumen pembedahan operasi kecil berhasil disimpan');
        } catch (\Throwable $th) {
            return redirect()->back()->with('gagal', $th->getMessage());
        }
    }

    function pdf_pembedahan_operasi_kecil(Request $req, ERekamMedisService $erms)
    {
        $data = $erms->pembedahan_operasi_kecil($req);
        PDF::setOptions(['dpi' => 150, 'defaultFont' => 'sans-serif']);
        $pdf_one = PDF::loadView('e_rekam_medis.dokumen_kunjungan.pdf.pembedahan_operasi_kecil', $data);
        $m = new Merger();
        $m->addRaw($pdf_one->output());
        $contents = $m->merge();
        return new Response($contents, 200, array('Content-Type' => 'application/pdf'));
    }

    function surat_keterangan_sakit(Request $req, ERekamMedisService $erms, LaporanTindakanDetailDokterService $laporanTindakanDetailDokterService)
    {
        $data = $erms->surat_keterangan_sakit($req);
        $data['dokters'] = $laporanTindakanDetailDokterService->getDokterName();
        return view('e_rekam_medis.dokumen_kunjungan.surat_keterangan_sakit', $data);
    }

    function save_surat_keterangan_sakit(SuratKeteranganSakitRequest $req, ERekamMedisService $erms, LaporanTindakanDetailDokterService $laporanTindakanDetailDokterService)
    {
        try {
            if (Auth::user()->password != md5($req->password)) {
                return redirect()->back()->with('gagal', 'Password yang anda masukkan salah');
            }
            $erms->save_surat_keterangan_sakit($req);
            $erms->verifikasi_dokumen_kunjungan($req);
            return redirect('medical_record/e_rekam_medis/surat_keterangan_sakit?dokumen=' . $req->id_dokumen)->with('sukses', 'Dokumen surat keterangan sakit berhasil disimpan');
        } catch (\Throwable $th) {
            return redirect()->back()->with('gagal', $th->getMessage());
        }
    }

    function pdf_surat_keterangan_sakit(Request $req, ERekamMedisService $erms)
    {
        $data = $erms->surat_keterangan_sakit($req);
        PDF::setOptions(['dpi' => 150, 'defaultFont' => 'sans-serif']);
        $pdf_one = PDF::loadView('e_rekam_medis.dokumen_kunjungan.pdf.surat_keterangan_sakit', $data);
        $m = new Merger();
        $m->addRaw($pdf_one->output());
        $contents = $m->merge();
        return new Response($contents, 200, array('Content-Type' => 'application/pdf'));
    }

    function catatan_perkembangan_pasien(Request $req, ERekamMedisService $erms)
    {
        $data = $erms->catatan_perkembangan_pasien($req);
        return view('e_rekam_medis.dokumen_kunjungan.catatan_perkembangan_pasien', $data);
    }

    function save_catatan_perkembangan_pasien(Request $req, ERekamMedisService $erms)
    {
        try {
            if (Auth::user()->password != md5($req->password)) {
                return redirect()->back()->with('gagal', 'Password yang anda masukkan salah');
            }
            $erms->save_catatan_perkembangan_pasien($req);
            $erms->verifikasi_dokumen_kunjungan($req);
            return redirect('medical_record/e_rekam_medis/catatan_perkembangan_pasien?dokumen=' . $req->id_dokumen)
                ->with('sukses', 'Dokumen catatan perkembangan pasien berhasil disimpan');
        } catch (\Throwable $th) {
            return redirect()->back()->with('gagal', $th->getMessage());
        }
    }

    function pdf_catatan_perkembangan_pasien(Request $req, ERekamMedisService $erms)
    {
        $data = $erms->catatan_perkembangan_pasien($req);
        PDF::setOptions(['dpi' => 150, 'defaultFont' => 'sans-serif']);
        $pdf_one = PDF::loadView('e_rekam_medis.dokumen_kunjungan.pdf.catatan_perkembangan_pasien', $data);
        $m = new Merger();
        $m->addRaw($pdf_one->output());
        $contents = $m->merge();
        return new Response($contents, 200, array('Content-Type' => 'application/pdf'));
    }

    function verifikasi_dokumen_kunjungan(Request $req, ERekamMedisService $erms)
    {
        $req->validate([
            'password' => 'required',
        ], [
            'password.required' => 'Password harus diisi'
        ]);

        try {
            if (Auth::user()->password != md5($req->password)) {
                return redirect()->back()->with('failed', 'Password anda salah');
            }
            $erms->verifikasi_dokumen_kunjungan($req);
            return redirect('medical_record/e_rekam_medis/' . $req->slug_dokumen . '?dokumen=' . $req->id_dokumen)->with('success', 'Verifikasi dokumen berhasil');
        } catch (\Throwable $th) {
            return redirect()->back()->with('failed', $th->getMessage());
        }
    }

    function pengkajian_awal_medis(Request $req, ERekamMedisService $ers){
        $data = $ers->data_pengkajian_awal_medis($req);
        return view('e_rekam_medis.dokumen_kunjungan.pengkajian_awal_medis', $data);
    }

    function pdf_pengkajian_awal_medis(Request $req, ERekamMedisService $ers){
        $data = $ers->data_pengkajian_awal_medis($req);
        PDF::setOptions(['dpi' => 150, 'defaultFont' => 'sans-serif']);
        $pdf_one = PDF::loadView('e_rekam_medis.dokumen_kunjungan.pdf.pengkajian_awal_medis', $data);
        $m = new Merger();
        $m->addRaw($pdf_one->output());
        $contents = $m->merge();
        return new Response($contents, 200, array('Content-Type' => 'application/pdf'));
    }

    function save_pengkajian_awal_medis(PengkajianAwalMedisRequest $req, ERekamMedisService $ers){
        try {
            $ers->save_pengkajian_awal_medis($req);
            if(!is_null($req->signed)){
                $ers->save_gambar_lokasi_pengkajian_awal_medis($req);
            }
            return redirect('medical_record/e_rekam_medis/pengkajian_awal_medis?dokumen=' . $req->dokumen)->with('success', 'Dokumen berhasil disimpan');
        } catch (\Throwable $th) {
            return redirect()->back()->with('failed', $th->getMessage());
        }
    }

    function hapus_status_lokalis_pengkajian_awal_medis(Request $req){
        try {
            $data = Smis_Doc_Pengkajian_Awal_Medis::where('id_dokumen', $req->dokumen)->first();
            if ($data->gambar_status_lokalis != '') {
                unlink('status_lokalis/'.$data->gambar_status_lokalis);
            }
            Smis_Doc_Pengkajian_Awal_Medis::where('id_dokumen', $req->dokumen)->update([
                'gambar_status_lokalis' => ''
            ]);
            return redirect('medical_record/e_rekam_medis/pengkajian_awal_medis?dokumen=' . $req->dokumen)->with('success', 'Gambar status lokalis berhasil dihappus');
        } catch (\Throwable $th) {
            return redirect()->back()->with('failed', $th->getMessage());
        }
    }
}
