<?php

namespace App\Http\Controllers\DataIndukPendaftaran;

use App\Http\Controllers\Controller;
use App\Services\DataIndukPendaftaranService;
use Illuminate\Http\Request;
use PDF;
use RealRashid\SweetAlert\Facades\Alert;

class KecamatanController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        return view('data_induk_pendaftaran.kecamatan', [
            'role' => 'kecamatan',
            'data' => $dataIndukPendaftaranService->getDataKec()->paginate(10),
            'provinsi' => $dataIndukPendaftaranService->getData('smis_rg_propinsi')->get(),
            'keyword' => ''
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        $store = $dataIndukPendaftaranService->createKecamatan($request);
        if ($store == 'sukses') {
            Alert::success('Berhasil', 'Kecamatan berhasil ditambahkan');
        } else {
            Alert::error('Gagal', $store);
        }
        return redirect()->route('kecamatan.index');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        return response()->json($dataIndukPendaftaranService->getDataKecById($id));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        $update = $dataIndukPendaftaranService->updateKecamatan($request);
        if ($update == 'sukses') {
            Alert::success('Berhasil', 'Kecamatan berhasil diperbarui');
        } else {
            Alert::error('Gagal', $update);
        }
        return redirect()->route('kecamatan.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        $delete = $dataIndukPendaftaranService->deleteData($id, 'smis_rg_kec');
        if ($delete == 'sukses') {
            Alert::success('Berhasil', 'Kecamatan berhasil dihapus');
        } else {
            Alert::error('Gagal', $delete);
        }
        return redirect()->route('kecamatan.index');
    }

    public function search(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        return view('data_induk_pendaftaran.kecamatan', [
            'role' => 'kecamatan',
            'data' => $dataIndukPendaftaranService->getSearchKecamatan($request)->paginate(10),
            'provinsi' => $dataIndukPendaftaranService->getData('smis_rg_propinsi')->get(),
            'keyword' => $request->keyword
        ]);
    }

    public function download(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        PDF::setOptions(['dpi' => 150, 'defaultFont' => 'sans-serif']);
        $pdf = PDF::loadView('data_induk_pendaftaran.pdf_kecamatan', [
            'data' => $dataIndukPendaftaranService->getSearchKecamatan($request)->get()
        ])->setPaper('a4', 'portrait');
        return $pdf->download('Kecamatan.pdf');
    }

    public function getKabupaten($id, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        return response()->json($dataIndukPendaftaranService->getKabupatenByProvinsi($id));
    }
}
