<?php

namespace App\Http\Controllers\DataIndukPendaftaran;

use App\Http\Controllers\Controller;
use App\Services\DataIndukPendaftaranService;
use Illuminate\Http\Request;
use PDF;
use RealRashid\SweetAlert\Facades\Alert;

class KabupatenController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        return view('data_induk_pendaftaran.kabupaten', [
            'role' => 'kabupaten',
            'data' => $dataIndukPendaftaranService->getDataKab()->paginate(10),
            'provinsi' => $dataIndukPendaftaranService->getData('smis_rg_propinsi')->get(),
            'keyword' => ''
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        $store = $dataIndukPendaftaranService->createKabupaten($request);
        if ($store == 'sukses') {
            Alert::success('Berhasil', 'Kabupaten berhasil ditambahkan');
        } else {
            Alert::error('Gagal', $store);
        }
        return redirect()->route('kabupaten.index');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        return response()->json($dataIndukPendaftaranService->getDataById($id, 'smis_rg_kabupaten'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        $update = $dataIndukPendaftaranService->updateKabupaten($request);
        if ($update == 'sukses') {
            Alert::success('Berhasil', 'Kabupaten berhasil diperbarui');
        } else {
            Alert::error('Gagal', $update);
        }
        return redirect()->route('kabupaten.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        $delete = $dataIndukPendaftaranService->deleteData($id, 'smis_rg_kabupaten');
        if ($delete == 'sukses') {
            Alert::success('Berhasil', 'Kabupaten berhasil dihapus');
        } else {
            Alert::error('Gagal', $delete);
        }
        return redirect()->route('kabupaten.index');
    }

    public function search(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        return view('data_induk_pendaftaran.kabupaten', [
            'role' => 'kabupaten',
            'data' => $dataIndukPendaftaranService->getSearchKabupaten($request)->paginate(10),
            'provinsi' => $dataIndukPendaftaranService->getData('smis_rg_propinsi')->get(),
            'keyword' => $request->keyword
        ]);
    }

    public function download(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        PDF::setOptions(['dpi' => 150, 'defaultFont' => 'sans-serif']);
        $pdf = PDF::loadView('data_induk_pendaftaran.pdf_kabupaten', [
            'data' => $dataIndukPendaftaranService->getSearchKabupaten($request)->get()
        ])->setPaper('a4', 'portrait');
        return $pdf->download('Kabupaten.pdf');
    }
}
