<?php

namespace App\Http\Controllers\DataIndukKepegawaian;

use App\Exports\DataIndukKepegawaian\GolonganExport;
use App\Exports\DataIndukKepegawaian\RuanganPegawaiExport;
use App\Http\Controllers\Controller;
use App\Services\DataIndukKepegawaianService;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use RealRashid\SweetAlert\Facades\Alert;

class RuanganPegawaiController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        return view('data_induk_kepegawaian.ruangan_pegawai', [
            'role' => 'ruangan_pegawai',
            'keyword' => '',
            'data' => $dataIndukKepegawaianService->getData('smis_hrd_ruangan_pegawai')->paginate(10)
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        $store = $dataIndukKepegawaianService->createRuanganPegawai($request);
        if ($store == 'sukses') {
            Alert::success('Berhasil', 'Data Induk Kepegawaian Ruangan Pegawai berhasil ditambahkan');
        } else {
            Alert::error('Gagal', $store);
        }
        return redirect()->route('ruangan_pegawai.index');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        return response()->json($dataIndukKepegawaianService->getDataById($id, 'smis_hrd_ruangan_pegawai'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        $update = $dataIndukKepegawaianService->updateRuanganPegawai($request);
        if ($update == 'sukses') {
            Alert::success('Berhasil', 'Data Induk Kepegawaian Ruangan Pegawai berhasil diperbarui');
        } else {
            Alert::error('Gagal', $update);
        }
        return redirect()->route('ruangan_pegawai.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        $delete = $dataIndukKepegawaianService->deleteData($id, 'smis_hrd_ruangan_pegawai');
        if ($delete == 'sukses') {
            Alert::success('Berhasil', 'Data Induk Ruangan Pegawai berhasil dihapus');
        } else {
            Alert::error('Gagal', $delete);
        }
        return redirect()->route('ruangan_pegawai.index');
    }

    public function search(Request $request, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        return view('data_induk_kepegawaian.ruangan_pegawai', [
            'data' => $dataIndukKepegawaianService->getSearchRuanganPegawai($request)->paginate(10),
            'keyword' => $request->keyword,
            'role' => 'ruangan_pegawai'
        ]);
    }

    public function download(Request $request)
    {
        return Excel::download(new RuanganPegawaiExport($request), 'Data_Induk_Ruangan_Pegawai.xlsx');
    }
}
