<?php

namespace App\Exports;

use App\Services\DiskonPenjualanObatDokterService;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Sheet;

class DiskonPenjualanObatDokterExport implements FromView, WithEvents
{
    private $request;
    /**
     * @param $dependencies
     */
    public function __construct($dependencies)
    {
        $this->request = $dependencies;
    }

    public function view(): View
    {
        $diskonPenjualanObatDokterService = new DiskonPenjualanObatDokterService();
        return view('diskon_penjualan_obat_dokter.excel', [
            'tanggal_dari' => $this->request->tanggal_dari,
            'tanggal_sampai' => $this->request->tanggal_sampai,
            'req_nama_dokter' => $this->request->nama_dokter,
            'penjualan_resep' => $diskonPenjualanObatDokterService->getPenjualanResep($this->request)->get()
        ]);
    }

    public function registerEvents(): array
    {
        Sheet::macro('styleCells', function (Sheet $sheet, string $cellRange, array $style) {
            $sheet->getDelegate()->getStyle($cellRange)->applyFromArray($style);
        });
        return [
            AfterSheet::class => function (AfterSheet $event) {

                $event->sheet->getColumnDimension('A')->setWidth(15);
                $event->sheet->getColumnDimension('B')->setWidth(15);
                $event->sheet->getColumnDimension('C')->setWidth(20);
                $event->sheet->getColumnDimension('D')->setWidth(20);
                $event->sheet->getColumnDimension('E')->setWidth(20);
                $event->sheet->getColumnDimension('F')->setWidth(5);
                $event->sheet->getColumnDimension('G')->setWidth(10);
                $event->sheet->getColumnDimension('H')->setWidth(10);
                $event->sheet->getColumnDimension('I')->setWidth(10);
                $event->sheet->getColumnDimension('J')->setWidth(12);
                $event->sheet->getColumnDimension('K')->setWidth(10);
                $event->sheet->getColumnDimension('L')->setWidth(10);
                $event->sheet->getColumnDimension('M')->setWidth(10);

                $event->sheet->getStyle('F:M')->getNumberFormat()
                    ->setFormatCode('_(* #,##0_);_(* \(#,##0\);_(* "-"??_);_(@_)');
            },

        ];
    }
}
