<?php

namespace App\Exports\DataIndukKepegawaian;

use App\Services\DataIndukKepegawaianService;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Sheet;

class GolonganExport implements FromView, WithEvents
{
    private $request;
    /**
     * @param $dependencies
     */
    public function __construct($request)
    {
        $this->request = $request;
    }

    public function view(): View
    {
        $dataIndukKepegawaianService = new DataIndukKepegawaianService();

        return view('data_induk_kepegawaian.excel_golongan', [
            'data' => $dataIndukKepegawaianService->getSearchGolongan($this->request)->get(),
            'kop' => $dataIndukKepegawaianService->getKopExcel()
        ]);
    }

    public function registerEvents(): array
    {
        Sheet::macro('styleCells', function (Sheet $sheet, string $cellRange, array $style) {
            $sheet->getDelegate()->getStyle($cellRange)->applyFromArray($style);
        });

        return [
            AfterSheet::class => function (AfterSheet $event) {

                $event->sheet->getColumnDimension('A')->setWidth(4);
                $event->sheet->getColumnDimension('B')->setWidth(15);
                $event->sheet->getColumnDimension('C')->setWidth(50);
            },

        ];
    }
}
