@extends('layouts.app')
<!-- Main Content -->
@section('content')
    <div class="main-content">
        <section class="section">
            <div class="section-header" style="">
                <div class="text-left">
                    <h1>Form Tambah Tukar Tanda Terima</h1>
                </div>
            </div>

            <div class="section-body">
                <div class="card">
                    @if ($errors->any())
                        <div class="col-lg-12 mt-3">
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    @endif

                    <form action="{{ route('tukar_tanda_terima.store') }}" method="post">
                        @csrf
                        <input hidden type="text" value="{{ Auth::user()->username }}" name="username" id="username" />
                        <div class="card-body">
                            <div class="col-lg-12 row">
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label>No. Tanda Terima</label>
                                        <input readonly class="form-control" type="text" value="{{ $no_tt }}"
                                            name="no" id="no" />
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label>Tanggal Tanda Terima</label>
                                        <input class="form-control datetimepicker" type="text" value=""
                                            name="tanggal" id="tanggal" />
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label>Nama Supplier</label>
                                        <select class="form-control select-2" name="nama_supplier" id="nama_supplier">
                                            <option value="">--Pilih Pilihan--</option>
                                            @foreach ($nama_suppliers as $nama_supplier)
                                                <option value="{{ $nama_supplier->nama }}">{{ $nama_supplier->nama }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12 table-responsive">
                            <a id="tambah_tt" class="btn btn-primary mb-3" style="color: white; cursor: pointer;">Tambah</a>
                            <table class="table table-bordered table-striped" id="table_tt" width="100%">
                                <thead>
                                    <tr class="text-center">
                                        <th style="width: 5%;">No.</th>
                                        <th style="width: 31.7%;">Nomor Faktur</th>
                                        <th style="width: 31.7%;">Nilai</th>
                                        <th style="width: 31.7%;">Tgl Jatuh Tempo</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr id="message">
                                        <td colspan="4" class="text-center">Silahkan gunakan tombol tambah untuk
                                            memasukan data</td>
                                    </tr>
                                    <tr class="template-row" style="display: none;">
                                        <td class="text-center no">1</td>
                                        <td>
                                            <select onchange="setItem(this)" class="form-control" id="no_faktur-0"
                                                name="no_faktur[]">
                                                <option value="">--Silahkan Pilih No. Faktur--</option>
                                                @foreach ($fakturs as $faktur)
                                                    <option value="{{ $faktur->no_faktur }}" data-id="{{ $faktur->id }}"
                                                        data-nilai="{{ $faktur->total_tagihan }}"
                                                        data-tgl-tempo="{{ $faktur->tanggal_tempo }}"
                                                        data-label="{{ $faktur->label }}">{{ $faktur->no_faktur }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </td>
                                        <td class="text-center nilai" id="nilai-0">0</td>
                                        <td class="text-center tgl-tempo" id="tgl_tempo-0">-</td>
                                        <td hidden class="text-center id-faktur" id="id_faktur-0"> <input
                                                class="id_faktur_input" type="text" value="" name="id_faktur[]"
                                                id="id_faktur-0" /> </td>
                                        <td hidden class="text-center label" id="label-0"> <input class="label_input"
                                                type="text" value="" name="label[]" id="label-0" /> </td>
                                    </tr>
                                </tbody>
                            </table>
                            <div class="col-lg-12">
                                <p>Terakhir diupdate pada tanggal --- oleh ---</p>
                            </div>
                            <div class="col-lg-12">
                                <button class="btn btn-primary float-right mr-4">Simpan</button>
                                <a class="btn btn-dark float-right mr-3"
                                    href="route('tukar_tanda_terima.index')">Kembali</a>
                            </div>
                        </div>
                        <div class="row mt-3" style="width: 100%; margin-left:0;">
                        </div>

                    </form>
                </div>
            </div>
        </section>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.26.0/moment.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.2.0/css/datepicker.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.2.0/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(".datetimepicker")
            .datepicker({
                format: "dd-mm-yyyy",
                startView: "day",
                minViewMode: "day",
                autoclose: true,
            });
    </script>
    <script>
        function downloadExcel() {
            var date = $('input[name=date]').val();
            var url = "{{ URL::to('finance/rekap_honor_dokterr/download') }}/?date=" + date + ""
            if (confirm("Apakah anda ingin mendownload data ini?")) {
                window.location.href = url;
            } else {
                return false;
            }
        }
    </script>
@endsection
@push('scripts')
    <script>
        function setItem(select) {
            var selectedOption = select.options[select.selectedIndex];
            var nilai = selectedOption.getAttribute('data-nilai');
            var tglTempo = selectedOption.getAttribute('data-tgl-tempo');
            var id_faktur = selectedOption.getAttribute('data-id');
            var label = selectedOption.getAttribute('data-label');
            var nilaiTd = select.parentNode.parentNode.querySelector('.nilai');
            var tglTempoTd = select.parentNode.parentNode.querySelector('.tgl-tempo');
            var idFakturInput = select.parentNode.parentNode.querySelector('.id-faktur .id_faktur_input');
            var labelInput = select.parentNode.parentNode.querySelector('.label .label_input');
            nilaiTd.textContent = buatRibuan(nilai);
            tglTempoTd.textContent = formatDate(tglTempo);
            $('#' + idFakturInput.id).val(id_faktur);
            $('#' + labelInput.id).val(label);

            console.log(nilai, tglTempo, id_faktur, $('#' + idFakturInput.id).val(), $('#' + label.id).val());
        }
        $(document).ready(function() {
            // Menangani klik tombol "Tambah Baris"
            $('#tambah_tt').click(function() {
                $('#message').attr('style', 'display:none');
                var table = $('#table_tt');
                var row = table.find('.template-row').clone();

                // Hitung jumlah baris saat ini
                var count = table.find('tbody tr').length;

                // Ubah nomor urut pada kolom pertama
                row.find('td:first').text(count - 1);
                row.find("td:eq(1) select").attr('id', 'no_faktur-' + (count - 1));
                row.find("td:eq(2)").attr('id', 'nilai-' + (count - 1));
                row.find("td:eq(3)").attr('id', 'tgl_tempo-' + (count - 1));
                row.find("td:eq(4) input").attr('id', 'id_faktur-' + (count - 1));
                row.find("td:eq(5) input").attr('id', 'label-' + (count - 1));

                // Tampilkan baris dan tambahkan ke tabel
                row.removeClass('template-row');
                row.show();
                table.find('tbody').append(row);
                $('#no_faktur-' + (count - 1)).select2({
                    templateSelection: function(data) {
                        var $result = $(
                            '<span class="select2-selection__rendered pt-1">' +
                            data.text +
                            '</span>'
                        );

                        return $result;
                    },
                });
            });

            $('.select-2').select2({
                templateSelection: function(data) {
                    var $result = $(
                        '<span class="select2-selection__rendered pt-1">' +
                        data.text +
                        '</span>'
                    );

                    return $result;
                },
            });
        });

        function buatRibuan(param) {
            var inputValue = param;
            var parsedValue = inputValue.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
            return parsedValue;
        }

        function formatDate(inputDate) {
            var dateArray = inputDate.split('-');
            var day = dateArray[2];
            var month = dateArray[1];
            var year = dateArray[0];
            return day + '-' + month + '-' + year;
        }
    </script>
@endpush
