@extends('layouts.app')
@section('content')
    <div class="modal fade" id="modal_pasien" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Pilih Pasien</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-12 table-responsive">
                            <table class="table table-hover table-striped" style="font-size: 13px;" id="tabelListPasien">
                                <thead>
                                    <tr>
                                        <th scope="col">No. RM</th>
                                        <th scope="col">Nama</th>
                                        <th scope="col">Tempat Lahir</th>
                                        <th scope="col">Tanggal Lahir</th>
                                        <th scope="col">Jenis Kelamin</th>
                                        <th scope="col">Alamat</th>
                                        <th scope="col">NIK</th>
                                        <th scope="col">Umur</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Surat Hasil Pemeriksaan PCR & Antigen</h1>
            </div>
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="section-body">
                <div class="card">
                    <form action="{{ route('pemeriksaan_pcr_antigen.store') }}" method="POST">
                        @csrf
                        <input type="hidden" value="{{ $data->nrm ?? '' }}" name="nrm" id="nrm" />
                        <input type="hidden" value="{{ $data->id_surat ?? '' }}" name="id" id="id" />
                        <div class="col-lg-12 row mt-4 ">
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Nama</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" onclick="openPasienModal()"
                                            id="nama" name="nama" value="{{ $data->nama ?? '' }}" readonly 
                                            style="width: 300px;" required>
                                        <a href="#" class="btn btn-info" onclick="openPasienModal()"
                                            data-toggle="tooltip" title="Pilih Klien"><i class="fas fa-list"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>NIK</label>
                                    <input class="form-control" type="text" value="{{$data->ktp ?? ''}}" name="nik" id="nik"
                                        disabled />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Tempat/Tgl Lahir</label>
                                    <input class="form-control" type="text"
                                        value="{{ ($data->tempat_lahir ?? '') . ' ' . date('d-m-Y', strtotime($data->tgl_lahir ?? ''))}}"
                                        name="ttl" id="ttl" disabled />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Jenis Kelamin</label>
                                    <input class="form-control" type="text"
                                        value="{{ $data->kelamin ?? '' == 1 ? 'Perempuan' : 'Laki-laki' }} "
                                        name="kelamin" id="kelamin" disabled />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Alamat</label>
                                    <input class="form-control" type="text" value="{{ $data->alamat ?? '' }}"
                                        name="alamat" id="alamat" disabled />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Umur</label>
                                    <input class="form-control" type="text" value=""
                                        name="umur" id="umur" disabled />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>No. Telepon</label>
                                    <input disabled class="form-control" type="text"
                                        value="{{ $data->telpon ?? '' }}" name="no_tlp" id="no_tlp" />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Tanggal Periksa</label>
                                    <input class="form-control dateformat" type="text"
                                        value="{{ $data->tgl_periksa ?? $tanggal }}" name="tgl_periksa"
                                        id="tgl_periksa" />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Jam Pemeriksaan</label>
                                    <input class="form-control" type="time" value="{{$data->jam_pemeriksaan ?? date("H:i")}}" onfocus="this.showPicker()"
                                        name="jam_pemeriksaan" id="jam_pemeriksaan" />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Pemeriksaan</label>
                                    <select class="form-control" name="pemeriksaan" id="pemeriksaan" required>
                                        <option value="">--Pilih Plihan--</option>
                                        <option {{ ( $data->pemeriksaan ?? '' ) == 'Test PCR' ? 'selected' : ''  }} value="Test PCR">Test PCR</option>
                                        <option {{ ( $data->pemeriksaan ?? '' ) == 'Rapid Test Antigen' ? 'selected' : ''  }} value="Rapid Test Antigen">Rapid Test Antigen</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Hasil Pemeriksaan</label>
                                    <select class="form-control" name="hasil_pemeriksaan" id="hasil_pemeriksaan" required>
                                        <option value="">--Pilih Plihan--</option>
                                        <option {{( $data->hasil_pemeriksaan ?? '' ) == 'Negatif' ? 'selected' : '' }} value="Negatif">Negatif</option>
                                        <option {{( $data->hasil_pemeriksaan ?? '' ) == 'Positif' ? 'selected' : '' }} value="Positif">Positif</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Tanggal Dikeluarkan</label>
                                    <input class="form-control dateformat" type="text" value="{{$data->tgl_dikeluarkan ?? ''}}"
                                        name="tgl_dikeluarkan" id="tgl_dikeluarkan" />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Jam Keluar Hasil</label>
                                    <input class="form-control" type="time" name="jam_keluar_hasil" onfocus="this.showPicker()"
                                        id="jam_keluar_hasil" value="{{ $data->jam_keluar_hasil ?? '' }}" />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Petugas yang Memeriksa</label>
                                    <select name="nama_petugas" id="nama_petugas" class="form-control" required>
                                        <option value="">--Pilh Pilihan--</option>
                                        @foreach ($petugas as $item)
                                            <option {{ ($data->nama_petugas ?? '') == $item->nama ? 'selected' : '' }}
                                                value="{{ $item->nama }}">{{ $item->nama }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div style="margin-top: 32px;">
                                    <a class="btn btn-dark" href="{{ route('pemeriksaan_pcr_antigen.index') }}"
                                        onclick="return confirm('Semua perubahan data tidak akan tersimpan, apakah anda yakin?')">Kembali</a>
                                    <button class="btn btn-primary float-right">Simpan</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>
@endsection
@push('scripts')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.2.0/css/datepicker.min.css"
        rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/jquery-timepicker/1.13.18/jquery.timepicker.min.css"
        rel="stylesheet">

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-timepicker/1.13.18/jquery.timepicker.min.js"></script>
    <script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.2.0/js/bootstrap-datepicker.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/locales/bootstrap-datepicker.id.min.js">
    </script>
    <script>
        $(document).ready(function() {
            $('#umur').val(countUmur('{{$data->tgl_lahir ?? ""}}'));
            $('#nama_petugas').select2({
                templateSelection: function(data) {
                    var $result = $(
                        '<span class="select2-selection__rendered pt-1">' +
                        data.text +
                        '</span>'
                    );

                    return $result;
                },
            });

            $(".dateformat")
                .datepicker({
                    format: "dd MM yyyy",
                    autoclose: true,
                    language: 'id'
                });

        });

        function openPasienModal() {
            $('#tabelListPasien').dataTable().fnClearTable();
            $('#tabelListPasien').dataTable().fnDestroy();

            $('#tabelListPasien').DataTable({
                serverSide: 'true',
                processing: 'true',
                pagingType: "full",
                deferRender: 'true',
                ajax: "{{ route('surat_keterangan_sehat.pasien') }}", // memanggil route yang menampilkan data json
                columns: [{ // mengambil & menampilkan kolom sesuai tabel database
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'nama',
                        name: 'nama'
                    },
                    {
                        data: 'tempat_lahir',
                        name: 'tempat_lahir'
                    },
                    {
                        data: 'tgl_lahir',
                        name: 'tgl_lahir',
                        render: function(data, type, row) {
                            var tmp2 = data.split('-');
                            return tmp2[2] + '-' + tmp2[1] + '-' + tmp2[0];
                        }
                    },
                    {
                        data: 'kelamin',
                        name: 'kelamin',
                        render: function(data, type, row) {
                            if (data == 1) {
                                return 'Perempuan'
                            } else if (data == 0) {
                                return 'Laki-Laki'
                            }
                        }
                    },
                    {
                        data: 'alamat',
                        name: 'alamat'
                    },
                    {
                        data: 'ktp',
                        name: 'ktp'
                    },
                    {
                        data: 'tgl_lahir',
                        name: 'tgl_lahir',
                        render: function(data, type, row) {
                            return countUmur(data);
                        }
                    },
                    {
                        data: 'id',
                        name: 'id',
                        render: function(data, type, row, meta) {
                            return '<div class="text-center"><button onclick="setPasien(' + "'" + row.nama +
                                "', '" + row.tempat_lahir + "', '" + row.tgl_lahir + "', '" + row.kelamin +
                                "', '" + row.alamat + "', '" + row.ktp + "', '" + row.umur + "','" +
                                data + "', '" + row.telpon + "'" +
                                ')" class="btn btn-dark"><i class="fas fa-check"></i></button></div>';
                        }
                    }
                ]
            });
            $('#modal_pasien').modal('show');
        }

        function setPasien(nama, tempat_lahir, tgl_lahir, jenis_kelamin, alamat, nik, umur, nrm, tlp) {
            document.getElementById("nama").value = nama;
            document.getElementById("nik").value = nik;
            document.getElementById("ttl").value = tempat_lahir + " " + convTanggal(tgl_lahir);
            document.getElementById("umur").value = countUmur(tgl_lahir);
            document.getElementById("kelamin").value = jenis_kelamin == 1 ? "Perempuan" : "Laki-Laki";
            document.getElementById("alamat").value = alamat;
            document.getElementById("nrm").value = nrm;
            document.getElementById("no_tlp").value = tlp;

            $('#modal_pasien').modal('hide');
        }

        function convTanggal(param) {
            var tmp2 = param.split('-');
            return tmp2[2] + '-' + tmp2[1] + '-' + tmp2[0];
        }

        function countUmur(tgl) {
            var dobDate = new Date(tgl);
            var todayDate = new Date();
            var diff = todayDate.getTime() - dobDate.getTime();
            var age = new Date(diff);
            var year = age.getUTCFullYear() - 1970;
            var month = age.getUTCMonth();
            var day = age.getUTCDate() - 1;
            return year + ' tahun ' + month + ' bulan ' + day +
                ' hari';
        }
    </script>
@endpush
