@extends('layouts.app')
@section('content')
<div class="modal fade" id="modalAdd" data-backdrop="static" data-keyboard="false" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Tambah Jadwal Poli</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ url('jadwal_poli/create') }}" method="POST">
                @csrf
                <input type="hidden" name="filter_hari" value="{{ $filter_hari ?? '' }}">
                <input type="hidden" name="filter_dokter" value="{{ $filter_dokter ?? '' }}">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="">Tanggal</label>
                        <input type="date" name="tanggal" value="{{ date('Y-m-d') }}" id="tanggal" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">Nama Poli</label>
                        <select style="height:100%;" name="poli" id="poli" required class="form-control pilihan">
                            <option value="">--Select Here--</option>
                            @foreach($poli_local as $pl)
                            <option value="{{$pl->slug}}">{{$pl->nama}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Poli Ke-</label>
                        <select name="poli_ke" id="poli_ke" class="form-control">
                            <option value="">--Select Here--</option>
                            <option value="1">1</option>
                            <option value="2">2</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Poli PCARE</label>
                        <select style="height:100%;" required name="poli_pcare" id="poli_bpjs" class="form-control pilihan">
                            <option value="">--Select Here--</option>
                            @foreach($poli as $p)
                            <option value="{{$p->kode_poli}}">{{$p->kode_poli.' - '.$p->nama_poli}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Nama Dokter</label>
                        <select style="height:100%;" name="dokter" required id="dokter" class="form-control pilihan">
                            <option value="">--Select Here--</option>
                            @foreach($dokter_local as $dl)
                            <option value="{{$dl->id}}">{{$dl->nama}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Nama Dokter BPJS</label>
                        <select style="height:100%;" name="dokter_bpjs" required id="dokter_bpjs" onchange="select_dokter('add', this.selectedIndex)" class="form-control pilihan">
                            <option value="">--Select Here--</option>
                            <!-- @foreach($dokter as $d)
                            <option value="{{$d->kode_dokter}}">{{$d->kode_dokter.' - '.$d->nama_dokter}}</option>
                            @endforeach -->
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Hari</label>
                        <select name="hari" required id="hari" class="form-control">
                            <option value="">--Select Here--</option>
                            <option value="1">Senin</option>
                            <option value="2">Selasa</option>
                            <option value="3">Rabu</option>
                            <option value="4">Kamis</option>
                            <option value="5">Jumat</option>
                            <option value="6">Sabtu</option>
                            <option value="7">Minggu</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Jam Mulai</label>
                        <input type="text" readonly required name="jam_mulai" id="jam_mulai" class="form-control waktu">
                    </div>
                    <div class="form-group">
                        <label for="">Jam Selesai</label>
                        <input type="text" readonly required name="jam_selesai" id="jam_selesai" class="form-control waktu">
                    </div>
                    <div class="form-group">
                        <label for="">Estimasi Layanan</label>
                        <input type="number" min="0" class="form-control" name="estimasi" placeholder="dalam menit">
                    </div>
                    <div class="form-group">
                        <label for="">Kuota</label>
                        <input type="number" required name="kuota" id="kuota" min="0" value="0" class="form-control">
                    </div>
                    {{-- <div class="form-group">
                        <label for="">Kuota non JKN</label>
                        <input type="number" required name="kuota_non_jkn" min="0" value="0" class="form-control">
                    </div> --}}
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEdit" data-backdrop="static" data-keyboard="false" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Ubah Jadwal Poli</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ url('jadwal_poli/update') }}" method="POST">
                @csrf
                <input type="hidden" name="id" id="edit_id">
                <input type="hidden" name="_method" value="put">
                <input type="hidden" name="filter_hari" value="{{ $filter_hari ?? '' }}">
                <input type="hidden" name="filter_dokter" value="{{ $filter_dokter ?? '' }}">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="">Tanggal</label>
                        <input type="date" name="tanggal" value="{{ date('Y-m-d') }}" id="edit_tanggal" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">Nama Poli</label>
                        <select style="height:100%;" name="poli" id="edit_poli" required class="form-control pilihan">
                            <option value="">--Select Here--</option>
                            @foreach($poli_local as $pl)
                            <option value="{{$pl->slug}}">{{$pl->nama}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Poli Ke-</label>
                        <select name="poli_ke" id="edit_poli_ke" class="form-control">
                            <option value="">--Select Here--</option>
                            <option value="1">1</option>
                            <option value="2">2</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Poli PCARE</label>
                        <select style="height:100%;" required name="poli_pcare" id="edit_poli_bpjs" class="form-control pilihan">
                            <option value="">--Select Here--</option>
                            @foreach($poli as $p)
                            <option value="{{$p->kode_poli}}">{{$p->kode_poli.' - '.$p->nama_poli}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Nama Dokter</label>
                        <select style="height:100%;" name="dokter" required id="edit_dokter" class="form-control pilihan">
                            <option value="">--Select Here--</option>
                            @foreach($dokter_local as $dl)
                            <option value="{{$dl->id}}">{{$dl->nama}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Nama Dokter BPJS</label>
                        <select style="height:100%;" name="dokter_bpjs" required id="edit_dokter_bpjs" onchange="select_dokter('edit', this.selectedIndex)" class="form-control pilihan">
                            <option value="">--Select Here--</option>
                            <!-- @foreach($dokter as $d)
                            <option value="{{$d->kode_dokter}}">{{$d->kode_dokter.' - '.$d->nama_dokter}}</option>
                            @endforeach -->
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Hari</label>
                        <select name="hari" required id="edit_hari" class="form-control">
                            <option value="">--Select Here--</option>
                            <option value="1">Senin</option>
                            <option value="2">Selasa</option>
                            <option value="3">Rabu</option>
                            <option value="4">Kamis</option>
                            <option value="5">Jumat</option>
                            <option value="6">Sabtu</option>
                            <option value="7">Minggu</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Jam Mulai</label>
                        <input type="text" readonly required value="{{ date('H:i', strtotime('+7 hours')) }}" id="edit_jam_mulai" name="jam_mulai" class="form-control waktu">
                    </div>
                    <div class="form-group">
                        <label for="">Jam Selesai</label>
                        <input type="text" readonly required value="{{ date('H:i', strtotime('+7 hours')) }}" id="edit_jam_selesai" name="jam_selesai" class="form-control waktu">
                    </div>
                    <div class="form-group">
                        <label for="">Estimasi Layanan</label>
                        <input type="number" id="edit_estimasi" min="0" class="form-control" name="estimasi" placeholder="dalam menit">
                    </div>
                    <div class="form-group">
                        <label for="">Kuota</label>
                        <input type="number" required name="kuota" id="edit_kuota" min="0" value="0" class="form-control">
                    </div>
                    {{-- <div class="form-group">
                        <label for="">Kuota non JKN</label>
                        <input type="number" required name="kuota_non_jkn" id="edit_kuota_non_jkn" min="0" value="0" class="form-control">
                    </div> --}}
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Jadwal Poli</h1>
        </div>
        @if ($errors->any())
        @foreach ($errors->all() as $error)
        <div class="alert alert-danger col-lg-12">{{$error}}</div>
        @endforeach
        @endif
        @if(Session::has('sukses'))
        <div class="alert alert-success col-lg-12">
            {{Session::get('sukses')}}
        </div>
        @endif
        @if(Session::has('gagal'))
        <div class="alert alert-danger col-lg-12">
            {{Session::get('gagal')}}
        </div>
        @endif
        <div class="section-body">
            <div class="card">
                <form class="row pt-3" style="width: 100%; margin-left: 0;" action="">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="">Dokter</label>
                            <select name="dokter" class="form-control select2">
                                <option value="">Semua</option>
                                @foreach ($dokter_local as $dl)
                                <option {{ $filter_dokter && $filter_dokter == $dl->id ? 'selected' : '' }} value="{{ $dl->id }}">{{ $dl->nama }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="">Hari</label>
                            <select name="hari" class="form-control">
                                <option value="">Semua</option>
                                <?php
                                $hari = ['Senin', 'Selasa', 'Rabu', 'Kamis', "jum'at", 'Sabtu', 'Minggu'];
                                for ($i = 0; $i < 7; $i++) {
                                ?>
                                    <option {{ $filter_hari && $filter_hari == $i+1 ? 'selected' : '' }} value="{{ $i+1 }}">{{ $hari[$i] }}</option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group" style="padding-top: 30px;">
                            <button type="submit" class="btn btn-primary">Terapkan</button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="card pt-3 pb-3">
                <div class="row" style="margin-left: 0; width:100%;">
                    <div class="col-lg-12">
                        <button class="btn btn-success" id="btn_tambah" data-toggle="modal" data-target="#modalAdd"><i class="fas fa-plus"></i> Tambah</button>
                    </div>
                    <div class="col-lg-12 table-responsive pt-3">
                        <table class="table table-striped" style="width:1200px;">
                            <thead>
                                <tr class="text-center">
                                    <th>No</th>
                                    <th>Kuota</th>
                                    <th>Kode Poli</th>
                                    <th>Nama Poli</th>
                                    <th>Nama Dokter</th>
                                    <th>Jam Mulai</th>
                                    <th>Jam Selesai</th>
                                    <th>Hari</th>
                                    <th>Estimasi Pelayanan</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if(sizeof($data) < 1) <tr class="text-center">
                                    <td colspan="11">Data tidak ditemukan.</td>
                                    </tr>
                                    @else
                                    @foreach($data as $d)
                                    <tr>
                                        <td class="text-center">{{$loop->iteration}}</td>
                                        <td class="text-center">{{$d->kuota}}</td>
                                        <td>{{$d->kodepoli_bpjs}}</td>
                                        <td>{{$d->nama_poli}}</td>
                                        <td>{{$d->nama_dokter}}</td>
                                        <td class="text-center">{{$d->jam_mulai}}</td>
                                        <td class="text-center">{{$d->jam_selesai}}</td>
                                        <td class="text-center">
                                            <?php
                                            switch ($d->hari) {
                                                case '1':
                                                    echo 'Senin';
                                                    break;
                                                case '2':
                                                    echo 'Selasa';
                                                    break;
                                                case '3':
                                                    echo 'Rabu';
                                                    break;
                                                case '4':
                                                    echo 'Kamis';
                                                    break;
                                                case '5':
                                                    echo 'Jumat';
                                                    break;
                                                case '6':
                                                    echo 'Sabtu';
                                                    break;
                                                case '7':
                                                    echo 'Minggu';
                                                    break;
                                                default:
                                                    echo '';
                                                    break;
                                            }
                                            ?>
                                        </td>
                                        <td class="text-center">{{$d->estimasi_layanan}} Menit</td>
                                        <td>
                                            <div style="display: inline-flex;">
                                                <button data-toggle="tooltip" data-placement="top" title="Ubah" class="btn btn-warning mr-1" onclick="open_modal_edit('{{$d->id}}')"><i class="fas fa-pencil-alt"></i></button>
                                                <a data-toggle="tooltip" data-placement="top" href="{{ url('jadwal_poli/delete?id='.$d->id) }}" title="Hapus" class="btn btn-danger" onclick="return confirm('Yakin melanjutkan hapus data ? data yang dihapus tidak dapat dikembalikan')"><i class="fas fa-trash"></i></a>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                    @endif
                            </tbody>
                        </table>
                    </div>
                    <div class="row" style="width: 100%; margin-left:0;">
                        <div class="col-lg-6" style="display: flex; align-items: center;">
                            @if(sizeof($data) > 0)
                            Showing data {{$data->firstItem()}} to {{$data->lastItem()}}, Page {{ $data->currentPage() }} of {{$data->lastPage()}} @if($keyword != '' || $filter_hari != '' || $filter_dokter != '') (Filtered) @endif
                            @else
                            Empty result @if($keyword != '' || $filter_hari != '' || $filter_dokter != '') (Filtered) @endif
                            @endif
                        </div>
                        <div class="col-lg-6" style="justify-content: flex-end; display:flex;">
                            {{ $data->links('pagination::bootstrap-4') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection
@push('scripts')
<script>
    let dokter_bpjs = [];
    let poli_bpjs = [];
    var edited_kodedokter = '';

    $('#poli_bpjs').change(function() {
        if ($('#tanggal').val() == '') {
            $('#poli_bpjs').val('');
            alert('Pilih tanggal dahulu');
            return;
        }
        get_dokter_pcare('add');
    })

    function get_dokter_pcare() {
        $.ajax({
            url: "{{ url('ajax_request/dokter_pcare') }}",
            data: {
                poli: $('#poli_bpjs').val(),
                tanggal: $('#tanggal').val()
            },
            success: function(response) {
                console.log(response);
            }
        })
    }

    $('#tanggal').change(function() {
        if ($('#poli_bpjs').val() != '') {
            get_dokter_pcare('add');
        }
    })

    $('#edit_poli_bpjs').change(function() {
        if ($('#edit_tanggal').val() == '') {
            $('#edit_poli_bpjs').val('');
            alert('Pilih tanggal dahulu');
            return;
        }
        get_dokter_pcare('edit');
    })

    $('#edit_tanggal').change(function() {
        if ($('#edit_poli_bpjs').val() != '') {
            get_dokter_pcare('edit');
        }
    })

    function select_dokter(tipe, index) {
        // console.log(dokter_bpjs);
        // $('#kodedokter_bpjs').val(dokter_bpjs[index-1].kodedokter);
        let jam = dokter_bpjs[index - 1].jampraktek.split('-');
        tipe == 'add' ? $('#jam_mulai').val(jam[0]) : $('#edit_jam_mulai').val(jam[0]);
        tipe == 'add' ? $('#jam_selesai').val(jam[1]) : $('#edit_jam_selesai').val(jam[1]);
        tipe == 'add' ? $('#kuota').val(dokter_bpjs[index - 1].kapasitas) : $('#edit_kuota').val(dokter_bpjs[index - 1].kapasitas);
    }

    function get_dokter_pcare(tipe, dokter = null) {
        $('#dokter_bpjs').html('<option value="">--Select Here--</option>');
        $.ajax({
            url: "{{ url('ajax_request/dokter_pcare') }}",
            data: {
                poli: tipe == 'add' ? $('#poli_bpjs').val() : $('#edit_poli_bpjs').val(),
                tanggal: tipe == 'add' ? $('#tanggal').val() : $('#edit_tanggal').val()
            },
            success: function(response) {
                console.log(response);
                if (!response.status) {
                    $('#dokter_bpjs').html('<option value="">--Gagal mendapatkan data--</option>');
                    return;
                }
                dokter_bpjs = response.data;
                render_dokter_bpjs(tipe, dokter);
            }
        })
    }

    function render_dokter_bpjs(tipe, dokter) {
        var ins = '<option value="">--Select Here--</option>';
        for (let i = 0; i < dokter_bpjs.length; i++) {
            ins += `<option value="` + dokter_bpjs[i].kodedokter + `">` + dokter_bpjs[i].namadokter + `</option>`;
        }
        tipe == 'add' ? $('#dokter_bpjs').html(ins) : $('#edit_dokter_bpjs').html(ins);
        console.log(dokter);
        if (dokter != null) {
            $('#edit_dokter_bpjs').val(dokter).trigger('change');
        }
    }

    function get_poli_pcare(tipe, poli = null) {
        $('#poli_bpjs').html('<option value="">--Select Here--</option>');
        $.ajax({
            url: "{{ url('ajax_request/poli_pcare') }}",
            data: {
                tanggal: tipe == 'add' ? $('#tanggal').val() : $('#edit_tanggal').val()
            },
            success: function(response) {
                console.log(response);
                if (!response.status) {
                    $('#poli_bpjs').html('<option value="">--Gagal mendapatkan data--</option>');
                    return;
                }
                poli_bpjs = response.data;
                render_poli_pcare(tipe, poli);
            }
        })
    }

    function render_poli_pcare(tipe, poli) {
        var ins = '<option value="">--Select Here--</option>';
        for (let i = 0; i < poli_bpjs.length; i++) {
            ins += `<option value="` + poli_bpjs[i].kodepoli + `">` + poli_bpjs[i].kodepoli + ` - ` + poli_bpjs[i].namapoli + `</option>`;
        }
        tipe == 'add' ? $('#poli_bpjs').html(ins) : $('#edit_poli_bpjs').html(ins);
        if (poli != null) {
            $('#edit_poli_bpjs').val(poli).trigger('change');
            get_dokter_pcare('edit', edited_kodedokter);
        }
    }

    $('.modal').on('shown.bs.modal', function(e) {
        $(this).find('.pilihan').select2({
            dropdownParent: $(this).find('.modal-content')
        });
    })

    $('#btn_tambah').click(function() {
        get_poli_pcare('add');
    })

    function open_modal_edit(param) {
        $.ajax({
            url: '{{ url("ajax_request/select_jadwal_poli") }}',
            data: {
                id: param
            },
            success: function(response) {
                console.log(response);
                if (response == null) {
                    return;
                }
                $('#edit_id').val(response.id);
                $('#edit_kuota').val(response.kuota);
                $('#edit_poli').val(response.slug_poli).trigger('change');
                $('#edit_poli_ke').val(response.poli_ke).trigger('change');
                // $('#edit_poli_bpjs').val(response.kodepoli_bpjs).trigger('change');
                edited_kodedokter = response.kodedokter_bpjs;
                get_poli_pcare('edit', response.kodepoli_bpjs);

                $('#edit_dokter').val(response.id_dokter).trigger('change');
                $('#edit_jam_mulai').val(response.jam_mulai);
                $('#edit_jam_selesai').val(response.jam_selesai);
                $('#edit_hari').val(response.hari);
                $('#edit_estimasi').val(response.estimasi_layanan);
                $('#modalEdit').modal('show');
            }
        })
    }
</script>
@endpush