<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Document</title>

    <link rel="stylesheet" href="{{ asset('app-assets/css/bootstrap.min.css') }}">
    <!-- <link type="text/css" href="//ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/south-street/jquery-ui.css" rel="stylesheet"> -->
    <!-- <link rel="stylesheet" type="text/css" href="//keith-wood.name/css/jquery.signature.css"> -->
</head>

<body class="container">
    @if (Session::get('sukses'))
        <script>
            alert('{{ Session::get('sukses') }}')
        </script>
    @endif
    @if (Session::get('gagal'))
        <script>
            alert('{{ Session::get('gagal') }}')
        </script>
    @endif
    <div class="modal fade" id="modal_petugas" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Verifikasi Petugas</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="post" action="{{ url('medical_record/e_rekam_medis/identitas/verifikasi') }}">
                    @csrf
                    <input type="hidden" name="dokumen" value="{{ $dokumen }}">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="">Password :</label>
                            <input type="password" name="pass" placeholder="Input your password" class="form-control"
                                required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Verifikasi</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" id="modal_pasien" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Tanda tangan pasien</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="POST" onsubmit="return cek_persetujuan(this)"
                    action="{{ url('medical_record/e_rekam_medis/identitas/signature') }}">
                    <div class="modal-body">
                        @csrf
                        <input type="hidden" name="dokumen" value="{{ $dokumen }}">
                        <div class="col-md-12">
                            <div class="form-group text-center">
                                <h6>Signature :</h6>
                                <canvas style="border: 2px solid;" id="signature-pad" class="signature-pad" width=400
                                    height=200></canvas>
                                <textarea id="signature64" name="signed" style="display: none"></textarea>
                            </div>
                            <div class="form-group text-center">
                                <button id="clear" type="button" class="btn btn-danger btn-sm">Clear
                                    Signature</button>
                            </div>
                        </div>
                        <br />
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-2" class="text-center">
            <img src="{{ asset('filelogo/kotakihc.png') }}" alt="" style="width:100%">
        </div>
        <div class="col-md-10 pt-3">
            <h4>KLINIK UTAMA DHARMAHUSADA PREMIER</h4>
        </div>
        <div class="col-md-12" style="border-width: 1px; border:1px solid;"></div>
    </div>
    <div class="row pt-4" style="width: 100%; margin-left: 0;">
        <div class="col-md-9"></div>
        <div class="col-md-3">
            <h6 class="text-center">Nomor Rekam Medis<br>{{ $pasien->id }}</h6>
        </div>
    </div>
    <div class="row pt-4" style="width: 100%; margin-left: 0;">
        <div class="col-md-12">
            <h1 class="text-center">REKAM MEDIS PASIEN</h1>
        </div>
        <div class="container">
            <div class="col-md-12" style="padding-top: 30px;">
                <table style="width: 100%; border-collapse: collapse; font-size: 20px;">
                    <tr>
                        <td style="text-align: right; width: 20%;">NAMA PASIEN</td>
                        <td style="padding-left: 5px; padding-right: 5px; width: 5%;"> : </td>
                        <td style="text-align: center; width:75%; padding-top: 8px; padding-bottom: 8px;">
                            <div style="border: 2px solid; padding:10px; border-radius: 10px; box-shadow: 10px 10px;">
                                <h4>{{ $pasien->nama }}</h4>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td style="text-align: right; width: 20%;">ALAMAT</td>
                        <td style="padding-left: 5px; padding-right: 5px; width: 5%;"> : </td>
                        <td style="text-align: center; width:75%; padding-top: 8px; padding-bottom: 8px;">
                            <div style="border: 2px solid; padding:10px; border-radius: 10px; box-shadow: 10px 10px;">
                                <h4>{{ $pasien->alamat }}<br>{{ $pasien->kelurahan . ' - ' . $pasien->kecamatan . ' - ' . $pasien->kabupaten }}
                                </h4>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td style="text-align: right; width: 20%;">STATUS</td>
                        <td style="padding-left: 5px; padding-right: 5px; width: 5%;"> : </td>
                        <td style="text-align: center; width:75%; padding-top: 8px; padding-bottom: 8px;">
                            <div style="border: 2px solid; padding:10px; border-radius: 10px; box-shadow: 10px 10px;">
                                <h4 style="text-transform: uppercase;">
                                    @if ($pasien->carabayar == 'bpjs' || $pasien->carabayar == 'asuransi')
                                        {{ $pasien->asuransi }}
                                    @elseif($pasien->carabayar == 'perusahaan')
                                        {{ $pasien->carabayar . ' - ' . $pasien->nama_perusahaan }}
                                    @else
                                        {{ 'UMUM' }}
                                    @endif
                                </h4>
                            </div>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <div class="row pt-5" style="width: 100%; margin-left: 0;">
        <div class="col-md-12">
            <h1 style="text-align: center; color:red; font-size: 80px; font-weight: bolder;">RAHASIA</h1>
        </div>
    </div>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-10" style="padding-top: 150px;">
            <div style="text-align: left; padding-top: 40px;">
                <p style="color: red;">
                    <span style="font-weight: bold;">PERHATIAN</span><br>
                    1. BERKAS REKAM MEDIS TIDAK BOLEH DIBAWA Pulang<br>
                    2. KEMBALIKAN SECEPATNYA KE BAGIAN REKAM MEDIS (2 X 24 JAM)
                </p>
            </div>
        </div>
        <div class="col-md-2">
            <table style="border-collapse: collapse; font-size: 20px;">
                <tr>
                    <th style="border: 1px solid; padding:10px">2021</th>
                </tr>
                <tr>
                    <th style="border: 1px solid; padding:10px">2022</th>
                </tr>
                <tr>
                    <th style="border: 1px solid; padding:10px">2023</th>
                </tr>
                <tr>
                    <th style="border: 1px solid; padding:10px">2024</th>
                </tr>
                <tr>
                    <th style="border: 1px solid; padding:10px">2025</th>
                </tr>
            </table>
        </div>
    </div>
    <div style="border-width: 1px; border:1px solid red"></div>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-7" class="text-center">
            <img src="{{ asset('filelogo/kotakihc.png') }}" alt="" style="width:30%">
        </div>
        <div class="col-md-5 pt-3">
            <h4>KLINIK UTAMA DHARMAHUSADA PREMIER</h4>
        </div>
        <div class="col-md-12" style="border-width: 1px; border:1px solid;"></div>
    </div>
    <div style="border-width: 1px; border:1px solid"></div>
    <div class="row" style="width:100%; margin-left: 0;">
        <div class="col-md-12 text-center pt-3">
            <p style="font-weight: bold; font-family: serif; font-size: 25px;">REKAM MEDIS PASIEN/PENDERITA GAWAT
                DARURAT</p>
        </div>
    </div>
    <div class="row pb-5" style="width:100%; margin-left: 0;">
        <div style="width: 100%; border:1px solid" class="container pb-3 pt-2">
            <table style="border-collapse: collapse; width: 100%;" class="identitas_pasien">
                <tr>
                    <td style="font-weight: bold;" colspan="3">DATA IDENTITAS PASIEN</td>
                </tr>
                <tr>
                    <td style="width: 20%;">Nama Pasien</td>
                    <td style="padding-left: 3px; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">{{ $pasien->nama }}</td>
                </tr>
                <tr>
                    <td style="width: 20%;">Tanggal Lahir</td>
                    <td style="padding-left: 3px; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">
                        @if ($pasien->tgl_lahir != '')
                            {{ date('d-m-Y', strtotime($pasien->tgl_lahir)) }}
                        @endif
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Jenis Kelamin</td>
                    <td style="padding-left: 3px; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">
                        @if ($pasien->kelamin == 0)
                            {{ 'Laki-Laki' }}@else{{ 'Perempuan' }}
                        @endif
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Agama</td>
                    <td style="padding-left: 3px; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">{{ $pasien->agama }}</td>
                </tr>
                <tr>
                    <td style="width: 20%; vertical-align: top;">Alamat</td>
                    <td style="padding-left: 3px; vertical-align: top; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">
                        {{ $pasien->alamat . ' - ' . $pasien->kabupaten }}
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">No. HP</td>
                    <td style="padding-left: 3px; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">{{ $pasien->telpon }}</td>
                </tr>
                <tr>
                    <td style="width: 20%;">No. Telp</td>
                    <td style="padding-left: 3px; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">{{ $pasien->telpon }}</td>
                </tr>
                <tr>
                    <td style="width: 20%;">Status Perkawinan</td>
                    <td style="padding-left: 3px; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">{{ $pasien->status }}</td>
                </tr>
                <tr>
                    <td style="width: 20%;">Pendidikan</td>
                    <td style="padding-left: 3px; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">{{ $pasien->pendidikan }}</td>
                </tr>
                <tr>
                    <td style="width: 20%;">Pekerjaan</td>
                    <td style="padding-left: 3px; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">{{ $pasien->pekerjaan }}</td>
                </tr>
                <tr>
                    <td style="width: 20%;">Suku/Bangsa/Bahasa</td>
                    <td style="padding-left: 3px; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">{{ $pasien->suku }}</td>
                </tr>
            </table>
            <hr>
            <table style="border-collapse: collapse; width: 100%;" class="identitas_pasien">
                <tr>
                    <td style="font-weight: bold;" colspan="3">ORANG YANG DAPAT DIHUBUNGI</td>
                </tr>
                <tr>
                    <td style="width: 20%;">Nama</td>
                    <td style="padding-left: 3px; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">{{ $pasien->namapenanggungjawab }}</td>
                </tr>
                <tr>
                    <td style="width: 20%;">Alamat</td>
                    <td style="padding-left: 3px; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">
                        {{ $pasien->alamat_pj . ' - ' . $pasien->desa_pj . ' - ' . $pasien->kecamatan_pj . ' - ' . $pasien->kabupaten_pj }}
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">No. Telp</td>
                    <td style="padding-left: 3px; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">{{ $pasien->telponpenanggungjawab }}</td>
                </tr>
            </table>
            <hr>
            <table style="border-collapse: collapse; width: 100%;" class="identitas_pasien">
                <tr>
                    <td style="font-weight: bold;" colspan="3">PENANGGUNG JAWAB BIAYA PERAWATAN</td>
                </tr>
                <tr>
                    <td style="width: 20%;">Nama</td>
                    <td style="padding-left: 3px; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">{{ $pasien->namapenanggungjawab }}</td>
                </tr>
                <tr>
                    <td style="width: 20%;">Alamat</td>
                    <td style="padding-left: 3px; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">
                        {{ $pasien->alamat_pj . ' - ' . $pasien->desa_pj . ' - ' . $pasien->kecamatan_pj . ' - ' . $pasien->kabupaten_pj }}
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">No. Telp</td>
                    <td style="padding-left: 3px; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">{{ $pasien->telponpenanggungjawab }}</td>
                </tr>
                <tr>
                    <td style="width: 20%;">Cara Pembayaran</td>
                    <td style="padding-left: 3px; padding-right: 3px; width:3%;"> : </td>
                    <td style="width: 77%; border-bottom: 2px dotted;">
                        @if ($pasien->carabayar == 'bpjs' || $pasien->carabayar == 'asuransi')
                            {{ $pasien->asuransi }}
                        @elseif($pasien->carabayar == 'perusahaan')
                            {{ $pasien->carabayar . ' - ' . $pasien->nama_perusahaan }}
                        @else
                            {{ 'UMUM' }}
                        @endif
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row" style="width:100%; margin-left: 0;">
        <div class="col-md-6 text-center">
            <p style="font-size: 14px;">PETUGAS PENDAFTARAN</p>
            @if ($rm->id_verifikator == 1)
                @if ($employee)
                    <img src="{{ env('SMIS_UPLOAD_URL') . '/' . $employee->ttd_foto }}" alt=""
                        style="height: 2.5cm; width:5cm;">
                    <p style="font-size: 18px; font-weight: bold; text-transform: uppercase;">
                        ({{ $rm->nama_verifikator }})</p>
                @else
                    <img src="{{ env('SMIS_UPLOAD_URL') }}" alt=""
                        style="height: 2.5cm; width:5cm;">
                    <p style="font-size: 18px; font-weight: bold; text-transform: uppercase;">
                        ({{ $rm->nama_verifikator }})</p>
                @endif
                <hr style="width: 60%; border:1px solid;">
                </hr>
            @else
                <p style=" font-size: 18px;">.................., {{ date('d-m-Y') }} <br>Petugas Pendaftaran Pasien
                </p>
                <br>
                <br>
                <br>
                <br>
                <hr style="width: 60%; border:1px solid;">
                </hr>
            @endif
        </div>
        <div class="col-md-6 text-center">
            <p style="font-size: 14px;">PASIEN / KELUARGA</p>
            @if ($rm->signature_pasien != '')
                <img src="{{ asset('signature_patient/' . $rm->signature_pasien) }}" alt=""
                    style="height: 2.5cm; width:5cm;">
                <p style="font-size: 18px; font-weight: bold; text-transform: uppercase;">({{ $rm->nama_pasien }})</p>
            @else
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
            @endif
            <hr style="width: 60%; border:1px solid;">
            </hr>
        </div>
    </div>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-10 text-center">
            <p>&nbsp;</p>
        </div>
        <div class="col-md-2" style="">
            <img src="{{ asset('filelogo/logoihc.png') }}" style="width: 100%;" alt="">
        </div>
    </div>
    <div style="border-width: 1px; border:1px solid red"></div>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-8">
            <!-- <img src="{{ asset('filelogo/rolasmedika.png') }}" alt="" style="width:40%; margin-left: -30px;"> -->
            <img src="{{ asset('filelogo/kotakihc.png') }}" alt="" style="width:35%; margin-top: -20px;">
        </div>
        <div class="col-md-4">
            <p style="color: #111; font-weight: bold; font-size: 14px; padding-top: 20px;">
                KLINIK UTAMA DHARMAHUSADA PREMIER
                <br><span style="font-size: 12px; font-weight: normal; text-transform: uppercase;">Jl. Raya Dharma
                    Husada Indah No.26, Surabaya<br>(031) 5921101</span>
            </p>
        </div>
    </div>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-12" style="border-width: 1px; border:1px solid;"></div>
    </div>
    <div class="row pl-3 pr-3" style="padding-top: 5px;">
        <div class="col-md-6" style="border:1px solid">
            <table style="border-collapse: collapse; font-size: 14px; margin:10px" class="biodata_3">
                <tr>
                    <td rowspan="2" style="width: 29%; vertical-align: top;">Nama</td>
                    <td rowspan="2" style="padding-left: 5px; padding-right: 5px; width:3%; vertical-align: top;">
                        : </td>
                    <td rowspan="2" style="width: 68%;">{{ $pasien->nama }}</td>
                </tr>
                <tr>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td>Tanggal Lahir</td>
                    <td style="padding-left: 5px; padding-right: 5px;"> : </td>
                    <td>
                        @if ($pasien->tgl_lahir != '')
                            {{ date('d-m-Y', strtotime($pasien->tgl_lahir)) }}
                        @endif
                    </td>
                </tr>
                <tr>
                    <td>Jenis Kelamin</td>
                    <td style="padding-left: 5px; padding-right: 5px;"> : </td>
                    <td>
                        @if ($pasien->kelamin == 0)
                            {{ 'Laki-Laki' }}@else{{ 'Perempuan' }}
                        @endif
                    </td>
                </tr>
                <tr>
                    <td>Telp / No. HP</td>
                    <td style="padding-left: 5px; padding-right: 5px;"> : </td>
                    <td>{{ $pasien->telpon }}</td>
                </tr>
            </table>
        </div>
        <div class="col-md-6" style="border:1px solid">
            <table style="border-collapse: collapse; font-size: 14px; margin:10px; padding-right: 5px;"
                class="biodata_3">
                <tr>
                    <td style="width: 29%; vertical-align: top;">Alamat</td>
                    <td style="padding-left: 5px; padding-right: 5px; width:3%; vertical-align: top;"> : </td>
                    <td style="width: 68%;">{{ $pasien->alamat }}</td>
                </tr>
                <tr>
                    <td></td>
                    <td></td>
                    <td>{{ $pasien->kabupaten }}</td>
                </tr>
                <tr>
                    <td>Status Peserta</td>
                    <td style="padding-left: 5px; padding-right: 5px;"> : </td>
                    <td style="text-transform: uppercase;">
                        @if ($pasien->carabayar == 'bpjs' || $pasien->carabayar == 'asuransi')
                            {{ $pasien->asuransi }}
                        @elseif($pasien->carabayar == 'perusahaan')
                            {{ $pasien->carabayar . ' - ' . $pasien->nama_perusahaan }}
                        @else
                            {{ 'UMUM' }}
                        @endif
                    </td>
                </tr>
                <tr>
                    <td>No. JKN</td>
                    <td style="padding-left: 5px; padding-right: 5px;"> : </td>
                    <td>{{ $pasien->nobpjs }}</td>
                </tr>
                <tr>
                    <td>No. RM</td>
                    <td style="padding-left: 5px; padding-right: 5px;"> : </td>
                    <td>
                        @if (strlen($pasien->id) == 1)
                            {{ '00000' . $pasien->id }}
                        @elseif(strlen($pasien->id) == 2)
                            {{ '0000' . $pasien->id }}
                        @elseif(strlen($pasien->id) == 3)
                            {{ '000' . $pasien->id }}
                        @elseif(strlen($pasien->id) == 4)
                            {{ '00' . $pasien->id }}
                        @elseif(strlen($pasien->id) == 5)
                            {{ '0' . $pasien->id }}
                        @else
                            {{ $pasien->id }}
                        @endif
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-12 text-center pt-4 pb-4">
            <p style="font-weight: bold; font-family: serif; font-size: 20px;">HAK DAN KEWAJIBAN PASIEN</p>
        </div>
    </div>
    <div class="row" style="width:100%; margin-left: 0;">
        <div class="container">
            <div class="col-md-12">
                <p style="font-weight: bold; font-size: 16px;">A. Hak Pasien</p>
                <table style="border-collapse: collapse; padding-left: 25px;" class="hak">
                    <tr>
                        <td>1.</td>
                        <td style="padding-left: 10px;">Memperoleh informasi mengenai tata tertib dan peraturan
                            pelayanan kesehatan yang berlaku di Klinik Utama Dharmahusada Premier.</td>
                    </tr>
                    <tr>
                        <td>2.</td>
                        <td style="padding-left: 10px;">Memperoleh informasi atas</td>
                    </tr>
                </table>
                <table style="border-collapse: collapse; padding-left: 50px;" class="hak">
                    <tr>
                        <td>a.</td>
                        <td style="padding-left: 10px;">Penyakit yang diderita.</td>
                    </tr>
                    <tr>
                        <td>b.</td>
                        <td style="padding-left: 10px;">Tindakan medis yang akan dilakukan dan kemungkinan penyulit
                            sebagai akibat tindakan tersebut, cara mengatasi dan alternatif lainnya.</td>
                    </tr>
                    <tr>
                        <td>c.</td>
                        <td style="padding-left: 10px;">Upuaya pencegahan agar penyakit tidak kambuh lagi dan anggota
                            keluarga/orang lain tidak tertular.</td>
                    </tr>
                </table>
                <table class="mb-3" style="border-collapse: collapse; padding-left: 25px;" class="hak">
                    <tr>
                        <td>3.</td>
                        <td style="padding-left: 10px;">Meminta konsultasi medis.</td>
                    </tr>
                    <tr>
                        <td>4.</td>
                        <td style="padding-left: 10px;">Menyampaikan keluhan, kritik dan saran terkait dengan pelayanan
                            kesehatan.</td>
                    </tr>
                    <tr>
                        <td>5.</td>
                        <td style="padding-left: 10px;">Memperoleh layanan kesehatan yang bermutu dan berkualitas.</td>
                    </tr>
                    <tr>
                        <td>6.</td>
                        <td style="padding-left: 10px;">Memperoleh informasi hasil pemeriksaan, rencana tindakan dan
                            prognosis.</td>
                    </tr>
                    <tr>
                        <td>7.</td>
                        <td style="padding-left: 10px;">Memberikan persetujuan atau menolak tindakan yang akan
                            dilakukan.</td>
                    </tr>
                    <tr>
                        <td>8.</td>
                        <td style="padding-left: 10px;">Didampingi keluarga saat menerima pelayanan kesehatan.</td>
                    </tr>
                </table>
                <p style="font-weight: bold; font-size: 16px;">B. Kewajiban Pasien</p>
                <table style="border-collapse: collapse; padding-left: 25px;" class="hak">
                    <tr>
                        <td>1.</td>
                        <td style="padding-left: 10px;">Membawa kartu identitas (KTP/SIM).</td>
                    </tr>
                    <tr>
                        <td>2.</td>
                        <td style="padding-left: 10px;">Membawa persyaratan Jaminan Pelayanan Kesehatan (Jika ada).
                        </td>
                    </tr>
                </table>
                <table style="border-collapse: collapse; padding-left: 50px;" class="hak">
                    <tr>
                        <td>a.</td>
                        <td style="padding-left: 10px;">Pasien Baru</td>
                    </tr>
                </table>
                <table style="border-collapse: collapse; padding-left: 75px;" class="hak">
                    <tr>
                        <td>1.</td>
                        <td style="padding-left: 10px;">Kartu BPJS / KIS / ASKES yang asli</td>
                    </tr>
                    <tr>
                        <td>2.</td>
                        <td style="padding-left: 10px;">Foto copy Kartu BPJS / KIS / ASKES</td>
                    </tr>
                    <tr>
                        <td>3.</td>
                        <td style="padding-left: 10px;">Foto copy KTP dan KK</td>
                    </tr>
                </table>
                <table style="border-collapse: collapse; padding-left: 50px;" class="hak">
                    <tr>
                        <td>b.</td>
                        <td style="padding-left: 10px;">Pasien Lama</td>
                    </tr>
                </table>
                <table style="border-collapse: collapse; padding-left: 75px;" class="hak">
                    <tr>
                        <td>1.</td>
                        <td style="padding-left: 10px;">Menunjukkan Kartu BPJS / MS / ASKES / Kartu Berobat</td>
                    </tr>
                    <tr>
                        <td>2.</td>
                        <td style="padding-left: 10px;">Mengikuti alur pelayanan kesehatan Klinik Utama Dharmahusada
                            Premier.</td>
                    </tr>
                    <tr>
                        <td>3.</td>
                        <td style="padding-left: 10px;">Mentaati aturan pelayanan dan petunjuk pengobatan.</td>
                    </tr>
                    <tr>
                        <td>4.</td>
                        <td style="padding-left: 10px;">Memberikan informasi yang lengkap dan benar tentang masalah
                            kesehatannya.</td>
                    </tr>
                    <tr>
                        <td>5.</td>
                        <td style="padding-left: 10px;">Membayar biaya pelayanan kesehatan yang telah diberikan sesuai
                            dengan tarif yang berlaku.</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <div class="row pb-4" style="width: 100%; margin-left: 0;">
        <div class="col-md-7 text-center">
            <p>&nbsp;</p>
        </div>
        <div class="col-md-5">
            <img src="{{ asset('filelogo/logoihc.png') }}" style="width: 70%;" alt="">
        </div>
    </div>
    <div style="border-width: 1px; border:1px solid red"></div>
    <div class="row pt-3" style="width:100%; margin-left:0;">
        <div style="float: left; width: 100%; text-align: center;">
            <p style="font-weight: bold; font-family: serif; font-size: 20px;">TATA TERTIB PENGUNJUNG</p>
        </div>
    </div>
    <div class="row" style="width:100%; margin-left:0;">
        <div class="container">
            <div class="col-md-12">
                <table style="border-collapse: collapse;" class="hak">
                    <tr>
                        <td>1.</td>
                        <td style="padding-left: 10px;">Pasien mengambil nomor antrian di loket pendaftaran sebelum ke
                            poli yang dituju.</td>
                    </tr>
                    <tr>
                        <td>2.</td>
                        <td style="padding-left: 10px;">Pasien masuk ke poli yang dituju setelah mendapat panggilan.
                        </td>
                    </tr>
                    <tr>
                        <td>3.</td>
                        <td style="padding-left: 10px;">Pengantar di dalam poli maksimal 2 orang.</td>
                    </tr>
                    <tr>
                        <td>4.</td>
                        <td style="padding-left: 10px;">Dilarang membawa makanan di dalam poli.</td>
                    </tr>
                    <tr>
                        <td>5.</td>
                        <td style="padding-left: 10px;">Bagi orangtua yang membawa anak kecil, mohon diawasi dan tidak
                            diperkenankan menyentuh alat-alat yang ada dalam poli.</td>
                    </tr>
                    <tr>
                        <td>6.</td>
                        <td style="padding-left: 10px;">Bila ada kerusakan barang atau alat di dalam poli dikarenakan
                            kelalaian pengunjung, wajib mengganti kerugian.</td>
                    </tr>
                    <tr>
                        <td>7.</td>
                        <td style="padding-left: 10px;">Dilarang merokok di lingkungan Klinik Utama Dharmahusada
                            Premier.</td>
                    </tr>
                    <tr>
                        <td>8.</td>
                        <td style="padding-left: 10px;">Jagalah kebersihan.</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <div class="row" style="width:100%; margin-left:0;">
        <div style="text-align: center;" class="col-md-12">
            <p style="font-weight: bold; font-family: serif; font-size: 26px;">ALUR PELAYANAN<br><span
                    style="text-transform: uppercase;">Klinik Utama Dharmahusada Premier</span></p>
        </div>
    </div>
    <div class="row" style="width:100%; margin-left:0;">
        <div style="text-align: center;" class="col-md-12">
            <img src="{{ asset('images/alur_pelayanan.png') }}" style="width: 65%;" alt="">
        </div>
    </div>
    <div class="row" style="width:100%; margin-left:0;">
        <div class="col-md-6" onclick="show_modal_pasien()" style="text-align: center;">
            <p style="font-size: 20px;">&nbsp;<br>Pasien / Keluarga</p>
            @if ($rm->signature_pasien != '')
                <img src="{{ asset('signature_patient/' . $rm->signature_pasien) }}" alt=""
                    style="height: 2.5cm; width:5cm;">
                <p style="font-size: 18px; font-weight: bold; text-transform:uppercase">({{ $rm->nama_pasien }})</p>
            @else
                <br>
                Klik Disini
                <br>
                <br>
                <p style="font-size: 18px; font-weight: bold;">(...................................)<br>Tanda tangan &
                    Nama Terang</p>
            @endif
        </div>
        <div class="col-md-6" onclick="show_modal_petugas()" style="text-align: center;">
            @if ($rm->id_verifikator != 0)
                <p style="font-size: 20px;">Surabaya, {{ date('d-m-Y') }} <br>Petugas Pendaftaran Pasien</p>
                @if ($employee)
                    <img src="{{ env('SMIS_UPLOAD_URL') . '/' . $employee->ttd_foto }}" alt=""
                        style="height: 2.5cm; width:5cm;">
                    <p style="font-size: 18px; font-weight: bold; text-transform: uppercase;">
                        ({{ $rm->nama_verifikator }})</p>
                @else
                    <img src="{{ env('SMIS_UPLOAD_URL') }}" alt=""
                        style="height: 2.5cm; width:5cm;">
                    <p style="font-size: 18px; font-weight: bold; text-transform: uppercase;">
                        ({{ $rm->nama_verifikator }})</p>
                @endif
            @else
                <p style=" font-size: 20px;">Surabaya, {{ date('d-m-Y') }} <br>Petugas Pendaftaran Pasien
                </p>
                <br>
                Klik disini
                <br>
                <br>
                <p style="font-size: 18px; font-weight: bold;">(...................................)<br>Tanda tangan &
                    Nama Terang</p>
            @endif
        </div>
    </div>
    {{-- <div style=" border-width: 1px; border:1px solid red">
    </div> --}}
    {{-- <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-12 text-center pt-3">
            <h3>Diverifikasi Oleh</h3>
        </div>
        <div class="col-md-6 pl-0" style="text-align: center; padding:15px;">
            <div style="border: 1px solid; height:200px; display:flex; justify-content: center; align-items: center;"
                onclick="show_modal_pasien()">Pasien</div>
            @if ($rm->tanggal_update != null)
                {{ $rm->nama_pasien }}
            @endif
        </div>
        <div class="col-md-6 pr-0" style="text-align: center; padding:15px;">
            <div style="border: 1px solid; height:200px; display:flex; justify-content: center; align-items: center;"
                onclick="show_modal_petugas()">Petugas Pendaftaran</div>
            {{ strtoupper($rm->nama_verifikator) }}
        </div>
        <div class="col-md-12 pr-0 pl-0">
            <p>Ditanda tangani digital oleh @if ($rm->tanggal_update != 0)
                    {{ $rm->nama_pasien }}
                @endif pada waktu <?php echo $rm->tanggal_update != null ? date('d-m-Y H:i', strtotime($rm->tanggal_update)) : ''; ?></p>
            <p>Diverifikasi digital oleh @if ($rm->id_verifikator != 0)
                    {{ $rm->nama_verifikator }}
                @endif pada waktu <?php echo $rm->id_verifikator != null ? date('d-m-Y H:i', strtotime($rm->tanggal_update)) : ''; ?></p>
        </div>
    </div> --}}
    <div class="row pb-5" style="width:100%; margin-left:0;">
        <div style="text-align: center;" class="col-md-12">
            @if ($rm->id_verifikator != 0)
                <a href="{{ url('medical_record/e_rekam_medis/identitas/pdf?dokumen=' . $dokumen) }}"
                    class="btn btn-success" target="_blank">Download PDF</a>
            @endif
        </div>
    </div>
</body>
<script src="https://code.jquery.com/jquery-3.3.1.min.js"
    integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<script src="{{ asset('app-assets/js/bootstrap.min.js') }}"></script>
<!-- <script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
<script type="text/javascript" src="//keith-wood.name/js/jquery.signature.js"></script> -->
<script src="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature_pad.umd.min.js"></script>
<script>
    const signaturePad = new SignaturePad(document.getElementById('signature-pad'), {
        minWidth: 5,
        maxWidth: 10,
        penColor: 'rgb(0, 0, 0)',
        maxWidth: 2
    });

    $('#clear').click(function(e) {
        e.preventDefault();
        signaturePad.clear();
        $("#signature64").val('');
    });

    function show_modal_petugas() {
        $('#modal_petugas').modal('show');
    }

    function show_modal_pasien() {
        $('#modal_pasien').modal('show');
    }

    function cek_persetujuan() {
        var data = signaturePad.toDataURL('image/png');
        $('#signature64').val(data);

        if ($('#signature64').val() == '') {
            alert('Tambahkan tanda tangan anda dahulu');
            return false;
        }

        if (!confirm(
                'Dengan ini, Anda menyetujui bahwa identitas tersebut adalah benar dan mengikuti tata tertib, hak, dan kewajiban yang berlaku ?'
            )) {
            return false;
        }
    }

    $(document).ready(function() {
        var verif = '{{ $rm->id_verifikator }}';
        if (verif != 0) {
            window.scrollTo(0, document.body.scrollHeight);
        }
    })
</script>

</html>
