<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Surat Keterangan Sakit</title>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="{{ asset('app-assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.7/css/jquery.dataTables.min.css">
</head>

<body>
    <div class="modal fade" id="modal_diagnosa" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Pilih Diagnosa</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-12 table-responsive">
                            <table class="table table-hover table-striped" style="font-size: 13px;"
                                id="tabelListDiagnosa">
                                <thead>
                                    <tr>
                                        <th scope="col">Icd</th>
                                        <th scope="col">Diagnosa</th>
                                        <th scope="col">Sebab</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal_verifikasi" tabindex="-1" role="dialog"
        aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Verifikasi Surat Keterangan Sakit</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="post" action="{{ url('medical_record/e_rekam_medis/surat_keterangan_sakit/save') }}"
                    onsubmit="return cek_form()">
                    @csrf
                    <div class="modal-body">
                        <input type="hidden" value="{{ $dokumen->id }}" name="id_dokumen">
                        <input type="hidden" id="hide_pekerjaan" name="pekerjaan">
                        <input type="hidden" id="hide_hari" name="hari">
                        <input type="hidden" id="hide_mulai" name="dari">
                        <input type="hidden" id="hide_sampai" name="sampai">
                        <input type="hidden" id="hide_diagnosa" name="diagnosa">
                        <input type="hidden" value="{{ $nomor_surat }}" name="no_surat">
                        <div class="form-group">
                            <label for="">Password</label>
                            <input type="password" name="password" class="form-control"
                                placeholder="Masukkan password anda" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Verifikasi</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="container">
        @if ($errors->any())
            @foreach ($errors->all() as $error)
                <div class="alert alert-danger">{{ $error }}</div>
            @endforeach
        @endif
        @if (Session::get('sukses'))
            <script>
                alert('{{ Session::get('sukses') }}')
            </script>
        @endif
        @if (Session::get('gagal'))
            <script>
                alert('{{ Session::get('gagal') }}')
            </script>
        @endif
        <div class="row pt-3 pb-3" style="width: 100%; margin-left: 0;">
            <div class="col-md-12"
                style="text-align: center; display: flex; flex-direction: row; justify-content: center">
                <img src="{{ asset('filelogo/logo_new.png') }}" alt="" style="width: 10%;">
                <p>
                    <span style="text-transform: uppercase; font-weight:bold; font-size: 25px">KLINIK UTAMA DHARMAHUSADA
                        PREMIER</span><br>
                    Jl. Raya Dharma Husada Indah No.26, Mojo, Kec. Gubeng, Surabaya<br>
                    No. Telp : (031)5921101 | Whatsapp : 0852-3366-4118<br>
                    Email: klinik.dharmahusadapremier@gmail.com | Website:dhpclinic.id
                </p>
            </div>
            <div class="col-md-12 mt-3" style="border:1px solid; border-width: 1px;">
            </div>
            <div class="col-md-12 pt-3">
                <h4 style="text-decoration: underline; text-align: center">Surat Keterangan Sakit</h4>
                <p style="text-align: center">{{ $nomor_surat }}</p>
            </div>
            <div class="col-md-12 pt-3">
                <p>Yang bertanda tangan dibawah ini, menerangkan bahwa : </p>
                <table style="border-collapse: collapse; width:100%;">
                    <tr>
                        <th style="width: 20%">Nama</th>
                        <th style="width: 5%"> : </th>
                        <th style="width: 75%">{{ $pasien->nama }}</th>
                    </tr>
                    <tr>
                        <th>Tempat / Tanggal Lahir</th>
                        <th> : </th>
                        <th>{{ $pasien->tempat_lahir . ' / ' . date('d-m-Y', strtotime($pasien->tgl_lahir)) }}</th>
                    </tr>
                    <tr>
                        <th>Umur</th>
                        <th> : </th>
                        <th>{{ $pasien->umur . ' Tahun' }}</th>
                    </tr>
                    <tr>
                        <th>Jenis Kelamin</th>
                        <th> : </th>
                        <th>{{ $pasien->kelamin ? 'Perempuan' : 'Laki-Laki' }}</th>
                    </tr>
                    <tr>
                        <th>Alamat</th>
                        <th> : </th>
                        <th>{{ $pasien->alamat }}</th>
                    </tr>
                    <tr>
                        <th>Pekerjaan</th>
                        <th> : </th>
                        <th>
                            <input type="text" id="pekerjaan" class="form-control"
                                placeholder="Tambahkan pekerjaan" value="{{ $dokumen->surat_keterangan_sakit ? $dokumen->surat_keterangan_sakit->pekerjaan : '' }}">
                        </th>
                    </tr>
                    <tr>
                        <th>Diagnosa</th>
                        <th> : </th>
                        <th>
                            <div class="input-group-append">
                                <input value="{{ $dokumen->surat_keterangan_sakit ? $dokumen->surat_keterangan_sakit->diagnosa : '' }}" type="text" id="diagnosa" class="form-control" readonly
                                    placeholder="Pilih diagnosa">
                                <div class="input-group-append">
                                    <button onclick="openDiagnosaModal()" type="button" class="btn btn-dark"><i
                                            class="fa fa-list"></i></button>
                                </div>
                            </div>
                        </th>
                    </tr>
                </table>
                <div class="pt-3">
                    <p>Oleh karena S A K I T, perlu diberikan I S T I R A H A T selama <input type="number"
                            min="0" id="hari" value="{{ $dokumen->surat_keterangan_sakit ? $dokumen->surat_keterangan_sakit->hari : '' }}"> hari</p>
                    <p>terhitung mulai tanggal <input type="date" id="mulai" value="{{ $dokumen->surat_keterangan_sakit ? $dokumen->surat_keterangan_sakit->dari_tanggal : '' }}"> s/d
                        <input type="date" id="sampai" value="{{ $dokumen->surat_keterangan_sakit ? $dokumen->surat_keterangan_sakit->sampai_tanggal : '' }}">
                    </p>
                    <p>Demikian surat keterangan ini dibuat dengan sebenarnya dan untuk digunakan semestinya.</p>
                </div>
            </div>
            <div class="col-lg-8"></div>
            <div class="col-lg-4 text-center">
                <?php
                switch (date('m')) {
                    case '01':
                        echo date('d') . ' Januari ' . date('Y');
                        break;
                    case '02':
                        echo date('d') . ' Februari ' . date('Y');
                        break;
                    case '03':
                        echo date('d') . ' Maret ' . date('Y');
                        break;
                    case '04':
                        echo date('d') . ' April ' . date('Y');
                        break;
                    case '05':
                        echo date('d') . ' Mei ' . date('Y');
                        break;
                    case '06':
                        echo date('d') . ' Juni ' . date('Y');
                        break;
                    case '07':
                        echo date('d') . ' Juli ' . date('Y');
                        break;
                    case '08':
                        echo date('d') . ' Agustus ' . date('Y');
                        break;
                    case '09':
                        echo date('d') . ' September ' . date('Y');
                        break;
                    case '10':
                        echo date('d') . ' Oktober ' . date('Y');
                        break;
                    case '11':
                        echo date('d') . ' November ' . date('Y');
                        break;
                    case '12':
                        echo date('d') . ' Desember ' . date('Y');
                        break;
                
                    default:
                        echo '';
                        break;
                }
                ?>
                <br>
                Dokter yang memeriksa
                @if ($dokumen->status == 1)
                    <a href="#" onclick="open_modal_verifikasi('{{ $dokumen->id }}')"
                        style="width:100%; height:200px; display: flex; justify-content: center; align-items: center; text-decoration: none; color:#111;">
                        <img src="{{ env('SMIS_UPLOAD_URL') . '/' . $dokumen->ttd }}"
                            style="height: 2.5cm; width: 5cm;" alt="">
                    </a>
                    {{ $dokumen->nama_verifikator }}
                @else
                    <a href="#" onclick="open_modal_verifikasi('{{ $dokumen->id }}')"
                        style="border: 1px solid; width:100%; height:200px; display: flex; justify-content: center; align-items: center; text-decoration: none; color:#111;">Verifikasi</a>
                @endif
            </div>
            @if ($dokumen->status == 1)
            <div class="col-lg-12 text-center pt-4">
                <a target="_blank" href="{{ url('medical_record/e_rekam_medis/surat_keterangan_sakit/pdf?dokumen='.$dokumen->id) }}" class="btn btn-success">Download PDF</a>
            </div>
            @endif
        </div>
    </div>
</body>
<script src="https://code.jquery.com/jquery-3.3.1.min.js"
    integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<script src="{{ asset('app-assets/js/bootstrap.min.js') }}"></script>
<script src="https://cdn.datatables.net/1.10.7/js/jquery.dataTables.min.js"></script>
<script>
    function openDiagnosaModal() {
        $('#tabelListDiagnosa').dataTable().fnClearTable();
        $('#tabelListDiagnosa').dataTable().fnDestroy();

        $('#tabelListDiagnosa').DataTable({
            serverSide: 'true',
            processing: 'true',
            pagingType: "full",
            deferRender: 'true',
            ajax: "{{ route('surat_sakit.diagnosa') }}", // memanggil route yang menampilkan data json
            columns: [{ // mengambil & menampilkan kolom sesuai tabel database
                    data: 'icd',
                    name: 'icd'
                },
                {
                    data: 'nama',
                    name: 'nama'
                },
                {
                    data: 'sebab',
                    name: 'sebab'
                },
                {
                    data: 'id',
                    name: 'id',
                    render: function(data, type, row, meta) {
                        return '<div class="text-center"><button onclick="setDiagnosa(' + "'" + row
                            .icd + "', '" + row.nama + "')" +
                            '"class="btn btn-dark"><i class="fa fa-check"></i></button></div>';
                    }
                }
            ]
        });
        $('#modal_diagnosa').modal('show');
    }

    function setDiagnosa(icd, nama) {
        document.getElementById("diagnosa").value = icd + " - " + nama;
        $('#modal_diagnosa').modal('hide');
    }

    function open_modal_verifikasi(id_dokumen) {
        window.event.preventDefault();
        $('#id_dokumen').val(id_dokumen);
        $('#modal_verifikasi').modal('show');
    }

    function cek_form() {
        if ($('#pekerjaan').val() == '') {
            alert('Tambahkan pekerjaan dahulu');
            return false;
        }
        if ($('#hari').val() == '') {
            alert('Tambahkan jumlah hari dahulu');
            return false;
        }
        if ($('#hari').val() <= 0) {
            alert('Jumlah hari tidak valid');
            return false;
        }
        if ($('#mulai').val() == '') {
            alert('Pilih tanggal mulai');
            return false;
        }
        if ($('#sampai').val() == '') {
            alert('Pilih tanggal selesai');
            return false;
        }
        if ($('#diagnosa').val() == '') {
            alert('Pilih diagnosa dahulu');
            return false;
        }
        $('#hide_diagnosa').val($('#diagnosa').val());
        $('#hide_pekerjaan').val($('#pekerjaan').val());
        $('#hide_hari').val($('#hari').val());
        $('#hide_mulai').val($('#mulai').val());
        $('#hide_sampai').val($('#sampai').val());
        if (!confirm('Yakin melanjutkan verifikasi dokumen ?')) {
            return false;
        }
    }
</script>

</html>
