<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pembedahan Operasi Kecil</title>

    <style>
        * {
            font-family: sans-serif;
        }

        .pagebreak {
            page-break-before: always;
        }

        /* Clear floats after the columns */
        .row:after {
            content: "";
            display: table;
            clear: both;
        }

        .data_diri tr th {
            text-align: left;
            font-size: 12px;
            vertical-align: top;
        }

        .main_table tr th {
            border: 1px solid;
            padding: 5px;
            border-collapse: collapse;
        }

        .main_table {
            width: 100%;
            font-size: 12px;
            border-collapse: collapse;
        }

        .main_table tr td {
            border: 1px solid;
            padding: 5px;
            border-collapse: collapse;
        }
    </style>
</head>

<body>
    <div class="row pt-3" style="width: 101%; margin-left: 0;">
        <div style="width: 25%; float:left; margin-top:-50px;">
            {{-- <img src="{{ asset('filelogo/kotakihc.png') }}" alt="" style="width: 80%;"> --}}
        </div>
        <div style="width: 50%; float:left; margin-top:-20px;">
            <h3 style="text-transform: uppercase; text-align: center;">KLINIK UTAMA DHARMAHUSADA PREMIER</h3>
        </div>
        <div style="width: 25%; float:left; margin-top:-50px;">
        </div>
        <!-- <div style="border:1px solid; border-width: 1px; width:100%;">
        </div> -->
    </div>
    <div class="row pt-3" style="width: 101%; margin-left: 0; border-bottom:2px solid;">
        <div style="width:100%; float:left;">
            <table style="border-collapse: collapse; text-align: left; font-size:12px;">
                <tr>
                    <th style="text-align: left;">Alamat Kantor</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th style="text-align: left;">Jl. Raya Dharma Husada Indah No.26 Surabaya</th>
                    <th style="padding-left: 30px;text-align: left;">E-mail</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th style="text-align: left;">klinik.dharmahusadapremier@gmail.com</th>
                </tr>
                <tr>
                    <th style="text-align: left;">Telepon</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th style="text-align: left;text-align: left;">(031)5921101</th>
                    <th style="padding-left: 30px;text-align: left;">Whatsapp</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th style="text-align: left;">085233664118</th>
                </tr>
            </table>
        </div>
    </div>
    <div class="row pt-4 pb-3" style="width: 100%; margin-left: 0;">
        <h3 style="text-align:center">PENCATATAN LAPORAN OPERASI / PEMBEDAHAN</h3>
    </div>
    <div class="row pb-5" style="width: 100%; margin-left: 0; border:2px solid;">
        <div class="row" style="border-bottom:2px solid; padding-bottom: 10px; padding-top:10px; width:100%;">
            <div style="width:50%; float:left;">
                <table style="border-collapse: collapse;" class="data_diri">
                    <tr>
                        <th style="width: 20%; padding-left: 10px;">NO. REG</th>
                        <th style="padding-left: 5px; padding-right: 5px; width:5%;"> : </th>
                        <th style="width: 75%;">
                            {{ preg_replace("/[^0-9]/", "", $layanan->id )}}
                        </th>
                    </tr>
                    <tr>
                        <th style="width: 20%; padding-left: 10px;">NAMA</th>
                        <th style="padding-left: 5px; padding-right: 5px; width:5%;"> : </th>
                        <th style="width: 75%;">
                            {{$layanan->nama_pasien}}
                        </th>
                    </tr>
                    <tr>
                        <th style="width: 20%; padding-left: 10px;">ALAMAT</th>
                        <th style="padding-left: 5px; padding-right: 5px; width:5%;"> : </th>
                        <th style="width: 75%;">
                            {{ $pasien->alamat }}, {{ $pasien->nama_kelurahan }}, {{ $pasien->nama_kecamatan }}, {{ $pasien->nama_kabupaten }}
                        </th>
                    </tr>
                </table>
            </div>
            <div style="width:50%; float:left;">
                <table style="border-collapse: collapse;" class="data_diri">
                    <tr>
                        <th>POLI</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>
                            {{$layanan ? strtoupper(str_replace('_', ' ', $layanan->jenislayanan)) : ""}}
                        </th>
                    </tr>
                    <tr>
                        <th>LK / PR</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>
                            {{$pasien->kelamin == 0 ?'Laki-Laki' : 'Perempuan'}}
                        </th>
                    </tr>
                    <tr>
                        <th>UMUR</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>
                            <?php
                            $date = new DateTime($pasien->tgl_lahir);
                            $now = new DateTime();
                            $age = $now->diff($date);
                            echo $age->y . ' Tahun';
                            ?>
                        </th>
                    </tr>
                    <tr>
                        <th>DIAGNOSIS</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>
                            {{ $layanan->diagnosa ? $layanan->diagnosa->kode_icd.'-'.$layanan->diagnosa->nama_icd : '' }}
                        </th>
                    </tr>
                </table>
            </div>
        </div>
        <table style="border-collapse: collapse; font-size:12px;">
            <tr>
                <td colspan="3" style=" padding-left:15px; padding-top:10px; padding-bottom:10px;">KAJIAN PRE OP</td>
            </tr>
            <tr>
                <td style="vertical-align:top; padding-left:15px;">KELUHAN UTAMA</td>
                <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                <td style="padding-bottom: 15px;">
                    {{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->keluhan_utama : '' }}
                </td>
            </tr>
            <tr>
                <td style="vertical-align:top; padding-left:15px;">RPS</td>
                <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                <td style="padding-bottom: 15px;">
                    {{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->rps : '' }}
                </td>
            </tr>
            <tr>
                <td style="vertical-align:top; padding-left:15px;">RPD</td>
                <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                <td style="padding-bottom: 15px;">
                    {{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->rpd : '' }}
                </td>
            </tr>
        </table>
        <div style="width: 100%; border:1px solid;"></div>
        <div style="width:50%; float:left;">
            <table style="border-collapse: collapse; margin-top:15px; font-size:10px;">
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">OPERATOR</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        {{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->operator : '' }}
                    </td>
                </tr>
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">ASISTEN</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        {{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->asisten : '' }}
                    </td>
                </tr>
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">TANGGAL OPERASI</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        {{ $dokumen->pembedahan_operasi_kecil ? date('d-m-Y', strtotime($dokumen->pembedahan_operasi_kecil->tanggal_operasi)) : '' }}
                    </td>
                </tr>
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">MULAI JAM</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        {{ $dokumen->pembedahan_operasi_kecil ? date('H:i', strtotime($dokumen->pembedahan_operasi_kecil->mulai_jam)) : date('H:i', strtotime('+7 hours'.$dokumen->created_at)) }}
                    </td>
                </tr>
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">SELESAI JAM</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        {{ $dokumen->pembedahan_operasi_kecil ? date('H:i', strtotime($dokumen->pembedahan_operasi_kecil->selesai_jam)) : '' }}
                    </td>
                </tr>
            </table>
        </div>
        <div style="width:50%; float:left;">
            <table style="border-collapse: collapse; margin-top:15px; font-size:10px;">
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">TEKNIK OPERASI</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        {{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->teknik_operasi : '' }}
                    </td>
                </tr>
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">JENIS ANESTESI</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        {{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->jenis_anestesi : '' }}
                    </td>
                </tr>
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">JENIS SEDATIF</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        {{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->jenis_sedatif : '' }}
                    </td>
                </tr>
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">LAMA_OPERASI</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        <?php
                        if (isset($dokumen->pembedahan_operasi_kecil)) {
                            $temp = (strtotime($dokumen->pembedahan_operasi_kecil->selesai_jam) - strtotime($dokumen->pembedahan_operasi_kecil->mulai_jam)) / 60;
                            $menit = fmod($temp, 60);
                            echo floor($temp / 60) . ' Jam ' . $menit . ' Menit';
                        }
                        ?>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row" style="border-left:2px solid; border-right:2px solid; width:100.1%;">
        <div style="width:100%;">
            <p style="font-weight:bold;text-align: center;">URAIAN OPERASI</p>
        </div>
    </div>
    <div class="row" style="border:2px solid; width:100.1%;">
        <div style="width:100%; padding-left:10px; font-size:12px;">
            <p>{{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->uraian : '' }}</p>
        </div>
    </div>
    <div class="row" style="border-left:2px solid; border-right:2px solid; width:100.1%;">
        <div style="width:100%;">
            <p style="font-weight:bold;text-align: center;">OBSERVASI PASCA OPERASI</p>
        </div>
        <table class="main_table">
            <thead>
                <tr style="text-align: center;">
                    <th style="border-left: 1px solid transparent;">JAM/MENIT</th>
                    <th>T</th>
                    <th>N</th>
                    <th>RR</th>
                    <th>S</th>
                    <th style="border-right: 1px solid transparent;">KETERANGAN</th>
                </tr>
            </thead>
            <tbody id="list_observasi">
                @if(sizeof($dokumen->observasi_pasca_operasi) < 1) <tr style="text-align: center;">
                    <td colspan="7">Data tidak ditemukan.</td>
                    </tr>
                    @else
                    @foreach($dokumen->observasi_pasca_operasi as $opo)
                    <tr>
                        <td style="text-align: center; border-left: 1px solid transparent;">{{$opo->jam_menit}}</td>
                        <td>{{$opo->t}}</td>
                        <td>{{$opo->n}}</td>
                        <td>{{$opo->rr}}</td>
                        <td>{{$opo->s}}</td>
                        <td style="border-right: 1px solid transparent;">{{$opo->keterangan}}</td>
                    </tr>
                    @endforeach
                    @endif
            </tbody>
        </table>
    </div>
    <div class="row" style="width:100%;">
        <div style="width: 70%; float:left;">
            <p>&nbsp;</p>
        </div>
        <div style="width: 30%; text-align:center; float:left;">
            <p>TTD OPERATOR</p>
            <img src="{{ env('SMIS_UPLOAD_URL').'/'.$dokumen->ttd }}" style="height: 2.5cm; width: 5cm;" alt="">
            <p>{{ $dokumen->nama_verifikator }}</p>
        </div>
    </div>
</body>

</html>