@extends('layouts.app')
@section('content')
    <div class="modal fade" id="modalAdd" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header" style="margin-top: -15px;">
                    <h5 class="modal-title text-primary" id="exampleModalLongTitle">Tambah Asuransi</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('asuransi.store') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body mt-3">
                        <div class="form-group">
                            <label for="">Nama</label>
                            <input type="text" class="form-control" required name="nama" id="nama" placeholder=""
                                value="{{ old('nama') }}">
                        </div>
                        <div class="form-group">
                            <label for="">Alamat</label>
                            <input type="text" class="form-control" required name="alamat" id="alamat" placeholder=""
                                value="{{ old('alamat') }}">
                        </div>
                        <div class="form-group">
                            <label for="">Telpon</label>
                            <input type="text" class="form-control" required name="telpon" id="telpon" placeholder=""
                                value="{{ old('telpon') }}">
                        </div>
                        <div class="form-group">
                            <label for="">Awal Kontrak</label>
                            <input type="text" class="form-control dateformat" required name="awal_kontrak" id="telpon"
                                placeholder="" value="{{ old('awal_kontrak') }}">
                        </div>
                        <div class="form-group">
                            <label for="">Akhir Kontrak</label>
                            <input type="text" class="form-control dateformat" required name="akhir_kontrak" id="telpon"
                                placeholder="" value="{{ old('akhir_kontrak') }}">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" id="modalEdit" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header" style="margin-top: -15px;">
                    <h5 class="modal-title text-primary" id="exampleModalLongTitle">Ubah Asuransi</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('asuransi.update', 0) }}" method="post" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <input type="text" hidden id="id_edit" name="id">
                    <div class="modal-body mt-3">
                        <div class="form-group">
                            <label for="">Nama</label>
                            <input type="text" class="form-control" required name="nama" id="nama_edit"
                                placeholder="">
                        </div>
                        <div class="form-group">
                            <label for="">Alamat</label>
                            <input type="text" class="form-control" required name="alamat" id="alamat_edit"
                                placeholder="">
                        </div>
                        <div class="form-group">
                            <label for="">Telpon</label>
                            <input type="text" class="form-control" required name="telpon" id="telpon_edit"
                                placeholder="">
                        </div>
                        <div class="form-group">
                            <label for="">Awal Kontrak</label>
                            <input type="text" class="form-control dateformat" required name="awal_kontrak" id="awal_kontrak_edit"
                                placeholder="" value="{{ old('awal_kontrak') }}">
                        </div>
                        <div class="form-group">
                            <label for="">Akhir Kontrak</label>
                            <input type="text" class="form-control dateformat" required name="akhir_kontrak" id="akhir_kontrak_edit"
                                placeholder="" value="{{ old('akhir_kontrak') }}">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Data Induk Pendaftaran</h1>
            </div>
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="section-body">
                <div class="card">
                    @include('data_induk_pendaftaran.nav_tab')
                    <h4></h4>
                    <div class="card-body">
                        <div class="card-header" style="margin-left: -25px;">
                            <div class="card-header-form">
                                <form method="get" action="{{ route('asuransi.search') }}">
                                    <div class="input-group">
                                        <input type="text" name="keyword" class="form-control" placeholder="Search"
                                            value="{{ $keyword ?? '' }}">
                                        <div class="input-group-btn ml-2">
                                            <button type="submit" class="btn btn-primary"><i
                                                    class="fas fa-search"></i></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-striped" style="width:100%;">
                                <thead>
                                    <tr class="">
                                        <th>No</th>
                                        <th>Nama</th>
                                        <th>Alamat</th>
                                        <th>Telpon</th>
                                        <th>Awal Kontrak</th>
                                        <th>Akhir Kontrak</th>
                                        <th>
                                            <div class="row">
                                                <button class="btn btn-primary" data-toggle="modal"
                                                    data-target="#modalAdd"><i class="fas fa-plus"></i></button>
                                                <button onclick="downloadExcel()"class="btn btn-info"
                                                    style="margin-left:3px ;"><i style="font-size:12pt;"
                                                        class="fa fa-print"></i></button>
                                            </div>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($data as $key => $dt)
                                        <tr class="">
                                            <td>{{ $key + $data->firstItem() }}</td>
                                            <td>{{ $dt->nama }}</td>
                                            <td>{{ $dt->alamat }}</td>
                                            <td>{{ $dt->telpon }}</td>
                                            <td>{{ strtotime($dt->awal_kontrak) < 0 ? "-" : date('d F Y', strtotime($dt->awal_kontrak)) }}</td>
                                            <td>{{ strtotime($dt->akhir_kontrak) < 0 ? "-" : date('d F Y', strtotime($dt->akhir_kontrak)) }}</td>
                                            <td style="width:5%;">
                                                <div style="display: flex; flex-direction: row;">
                                                    <button onclick="showEditModal('{{ $dt->id }}')"
                                                        class="btn btn-warning mr-1"><i class="fa fa-pencil"></i></button>
                                                    <form action="{{ route('asuransi.destroy', $dt->id) }}"
                                                        method="post" enctype="multipart/form-data">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button
                                                            onclick="return confirm('Yakin melanjutkan hapus data {{ $dt->nama }} ?')"
                                                            class="btn btn-danger"><i class="fas fa-trash"></i></button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr class="text-center">
                                            <td colspan="10">Data tidak ditemukan</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        <div class="row mt-3" style="width: 100%; margin-left:0;">
                            <div class="col-lg-6" style="display: flex; align-items: center;">
                                @if (sizeof($data) > 0)
                                    Showing data {{ $data->firstItem() }} to {{ $data->lastItem() }}, Page
                                    {{ $data->currentPage() }} of {{ $data->lastPage() }} @if ($keyword != '')
                                        (Filtered)
                                    @endif
                                @else
                                    Empty result @if ($keyword != '')
                                        (Filtered)
                                    @endif
                                @endif
                            </div>
                            <div class="col-lg-6" style="justify-content: flex-end; display: flex;">
                                {{ $data->appends(Request::only('keyword'))->links('pagination::bootstrap-4') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script></script>
    <script src="https://code.jquery.com/jquery-3.3.1.min.js"
        integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
    <script>
        $(document).ready(function() {
            // saat input1 berubah ke input-input
            $('#nama, #nama_edit').on('change', function() {
                var text = $(this).val().toLowerCase().replace(/ /g, "-").replace(/\//g, "-");
                $('#slug, #slug_edit').val(text);
            });
        });


        function showEditModal(param) {
            var url = "{{ route('asuransi.edit', ':id') }}";
            url = url.replace(':id', param);

            $.ajax({
                url: url,
                type: 'GET',
                success: function(response) {
                    if (response == null) {
                        return;
                    }
                    $('#id_edit').val(response.id);
                    $('#nama_edit').val(response.nama);
                    $('#alamat_edit').val(response.alamat);
                    $('#telpon_edit').val(response.telpon);
                    $('#awal_kontrak_edit').val(moment(response.awal_kontrak).format("DD-MM-YYYY"));
                    $('#akhir_kontrak_edit').val( moment(response.akhir_kontrak).format("DD-MM-YYYY"));
                    $('#modalEdit').modal('show');
                },
                error: function(request, status, error) {
                    alert("Terjadi error saat edit data, silahkan hubungi admin");
                }
            })
        }

        function downloadExcel() {

            var keyword = $('input[name=keyword]').val();
            var url = "{{ route('asuransi.download') }}/?keyword=" + keyword;
            if (confirm("Apakah anda ingin melanjutkan download ?")) {
                window.location.href = url;
            } else {
                return false;
            }
        }
    </script>
@endsection
@push('scripts')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.2.0/css/datepicker.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.2.0/js/bootstrap-datepicker.min.js"></script>
    <script charset="utf-8">
        $('.select2').select2({
            templateSelection: function(data) {
                var $result = $(
                    '<span class="select2-selection__rendered pt-1">' +
                    data.text +
                    '</span>'
                );

                return $result;
            },
        });

        $(".dateformat")
            .datepicker({
                format: "dd-mm-yyyy",
                autoclose: true,
                language: 'id'
            });
    </script>
@endpush
