<!DOCTYPE html>

<head>
    <title>Display Antrian Pendaftaran</title>
    <link rel="stylesheet" href="{{ asset('app-assets/css/bootstrap.min.css') }}">
    <style>
        * {
            color: #111;
        }

        @media only screen and (max-width: 1440px) {
            #box_kiri_nomor_antrian {
                height: 250px;
            }

            #box_two {
                height: 45%;
            }

            #video {
                height: 310px;
            }
        }

        @media only screen and (min-width: 1441px) {
            #logo {
                width: 100%;
            }

            #box_two {
                height: 50%;
            }

            #box_kiri_nomor_antrian {
                height: 305px;
            }

            #nama_rs {
                font-size: 70px;
            }

            #alamat_rs {
                font-size: 30px;
            }

            #called_loket {
                font-size: 75px;
            }

            #called_nomor {
                font-size: 120px;
                font-weight: bold;
            }

            #box_kiri_nomor_antrian h4 {
                font-size: 50px;
            }

            #video {
                height: 450px;
            }

            #jam {
                font-size: 60px;
            }

            #tanggal {
                font-size: 60px;
            }

            th,
            td {
                font-size: 45px;
            }
        }
    </style>
</head>

<body style="display: flex; justify-content: center; align-items:center;">
    <div class="container-fluid card pl-0 pr-0" style="height: 100vh; background-color: lightblue;">
        <div class="row pt-5 pb-5" style="width:100%; margin-left: 0; background-color: #fff;">
            <div class="col-lg-2" style="padding-left: 40px;">
                <img id="logo" src="{{ asset('filelogo/logo_ideplex.png') }}" alt="" style="width: 70%;">
            </div>
            <div class="col-lg-6" style="margin-left: -70px;">
                <h1 id="nama_rs">KLINIK INOVASI IDE UTAMA</h1>
                <h5 id="alamat_rs">Perumahan D'Gardenia City E 15, Bakalan, Cemeng Bakalan, Sidoarjo, Sidoarjo Regency,
                    East Java 61234</h5>
            </div>
            <div class="col-lg-4">
                <h2 id="jam"></h2>
                <h2 id="tanggal"></h2>
            </div>
        </div>
        <div class="row pt-5" id="box_two" style="width:100%; margin-left: 0; background-color: lightblue;">
            <div class="col-lg-5">
                <div class="row" style="width:100%; margin-left: 0;">
                    <div class="col-lg-12 text-center" style="border:3px solid">
                        <h4 id="called_loket">&nbsp</h4>
                    </div>
                    <div id="box_kiri_nomor_antrian" class="col-lg-12 mt-3 pt-2 text-center" style="border:3px solid;">
                        <h4>NOMOR ANTRIAN</h4>
                        <br>
                        <br>
                        <h1 id="called_nomor">&nbsp</h1>
                    </div>
                </div>
            </div>
            <div class="col-lg-1"></div>
            <div class="col-lg-6">
                <div class="row" style="width:100%; margin-left: 0;">
                    <div class="col-lg-12 text-center"
                        style="border:3px solid; height:100px; display: flex; justify-content: center; align-items: center;">
                        <h4>ANTRIAN MANUAL</h4>
                    </div>
                    <div id="box_kiri_nomor_antrian" class="col-lg-12 mt-3 pt-2 text-center" style="border:3px solid;">
                        <h4>NOMOR ANTRIAN</h4>
                        <br>
                        <br>
                        <h1 style="font-size: 100px;" id="called_nomor_manual">&nbsp</h1>
                    </div>
                </div>
                <!-- <iframe style="width:100%;" id="video" src="https://www.youtube.com/embed/4gtY9dQmX1g?autoplay=1&cc_load_policy=1" frameborder="0" allowfullscreen></iframe> -->
            </div>
        </div>
        <div class="row pt-5" style="width:100%; margin-left: 0; background-color: lightblue;">
            <div class="col-lg-12">
                <table class="table table-striped" style="font-size: 25px;">
                    <thead>
                        <tr class="text-center">
                            <th>Loket 1</th>
                            <th>Loket 2</th>
                            <th>Loket 3</th>
                            <th>Loket 4</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="text-center">
                            <td id="loket_1"></td>
                            <td id="loket_2"></td>
                            <td id="loket_3"></td>
                            <td id="loket_4"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
<script src="https://js.pusher.com/7.2/pusher.min.js"></script>
<script src="https://code.jquery.com/jquery-3.3.1.min.js"
    integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<script src="{{ asset('app-assets/js/bootstrap.min.js') }}"></script>
<script>
    let synth = window.speechSynthesis;
    Pusher.logToConsole = false;

    var pusher = new Pusher('6ca432a59ccec540a60b', {
        cluster: 'ap1'
    });

    var channel = pusher.subscribe('my-channel');
    channel.bind('my-event', function(data) {
        console.log(data);
        console.log('cek : '+(data.antrian.unit_kerja == "{{ env('NAMA_KLINIK') }}"));
        if (data.bagian == 'pendaftaran' && data.antrian.unit_kerja == "{{ env('NAMA_KLINIK') }}") {
            if (data.manual == "true") {
                $('#called_nomor_manual').html('A' + data.antrian.last_call);
                var msg = new SpeechSynthesisUtterance('Nomor antrian. A' + data.antrian.last_call +
                    '. Silahkan menuju ' + data.loket);
                msg.rate = 0.9;
                msg.pitch = 1;
                msg.lang = 'id-ID';
                synth.speak(msg);
            } else {
                if (data.pasien_baru == 'true') {
                    var msg = new SpeechSynthesisUtterance(data.pasien + '. Silahkan menuju ' + data.loket);
                    msg.rate = 0.9;
                    msg.pitch = 1;
                    msg.lang = 'id-ID';
                    synth.speak(msg);
                } else {
                    $('#called_nomor').html(data.antrian.nomorantrean);
                    $('#' + data.loket.replaceAll(' ', '_')).html(data.antrian.nomorantrean);
                    var msg = new SpeechSynthesisUtterance('Nomor antrian. ' + data.antrian.nomorantrean +
                        '. Silahkan menuju ' + data.loket);
                    msg.rate = 0.9;
                    msg.pitch = 1;
                    msg.lang = 'id-ID';
                    synth.speak(msg);
                }
            }
        }
    });

    setInterval(function() {
        var time = new Date().toLocaleTimeString();
        var tanggal = new Date().toLocaleDateString();
        var hari = new Date().getDay();
        document.getElementById('jam').innerHTML = time;
        document.getElementById('tanggal').innerHTML = convert_hari(hari) + ', ' + convert_tanggal(tanggal);
    }, 1000)

    function convert_tanggal(param) {
        if (param == '') {
            return '';
        }
        var temp = param.split('/');
        switch (temp[0]) {
            case '1':
                return temp[1] + ' Januari ' + temp[2];
                break;
            case '2':
                return temp[1] + ' Februari ' + temp[2];
                break;
            case '3':
                return temp[1] + ' Maret ' + temp[2];
                break;
            case '4':
                return temp[1] + ' April ' + temp[2];
                break;
            case '5':
                return temp[1] + " Mei " + temp[2];
                break;
            case '6':
                return temp[1] + ' Juni ' + temp[2];
                break;
            case '7':
                return temp[1] + ' Juli ' + temp[2];
                break;
            case '8':
                return temp[1] + ' Agustus ' + temp[2];
                break;
            case '9':
                return temp[1] + ' September ' + temp[2];
                break;
            case '10':
                return temp[1] + ' Oktober ' + temp[2];
                break;
            case '11':
                return temp[1] + ' November ' + temp[2];
                break;
            case '12':
                return temp[1] + ' Desember ' + temp[2];
                break;
            default:
                return '';
                break;
        }
    }

    function convert_hari(param) {
        switch (param) {
            case 1:
                return 'Senin';
                break;
            case 2:
                return 'Selasa';
                break;
            case 3:
                return 'Rabu';
                break;
            case 4:
                return 'Kamis';
                break;
            case 5:
                return "Jum'at";
                break;
            case 6:
                return 'Sabtu';
                break;
            case 7:
                return 'Minggu';
                break;
            default:
                return '';
                break;
        }
    }
</script>
