<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSmisDocCatatanPerkembanganPasienTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('smis_doc_catatan_perkembangan_pasien', function (Blueprint $table) {
            $table->id();
            $table->integer('id_dokumen')->unsigned();
            $table->integer('id_diagnosa')->default(0)->unsigned();
            $table->integer('id_lab')->default(0)->unsigned();
            $table->integer('id_resep')->default(0)->unsigned();
            $table->string('active_form', 64)->default('');
            $table->text('ns')->nullable();
            $table->text('dr')->nullable();
            $table->text('fp')->nullable();
            $table->text('apt')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('smis_doc_catatan_perkembangan_pasien');
    }
}
