<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSmisDocAsesmenKebidananTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('smis_doc_asesmen_kebidanan', function (Blueprint $table) {
            $table->id();
            $table->integer('id_dokumen')->unsigned();
            $table->integer('id_diagnosa')->default(0)->unsigned();
            $table->integer('id_lab')->default(0)->unsigned();
            $table->integer('id_resep')->default(0)->unsigned();
            $table->string('tanggal', 10)->default('');
            $table->string('jam', 10)->default('');
            $table->string('nama_suami', 128)->default('');
            $table->string('no_kk', 128)->default('');
            $table->string('kategori_skrining', 128)->default('');
            $table->string('keluhan_utama', 128)->default('');
            $table->string('riwayat_kehamilan_sekarang', 128)->default('');
            $table->string('golongan_darah', 128)->default('');
            $table->string('imunisasi_tt', 128)->default('');
            $table->string('waktu_imunisasi', 128)->default('');
            $table->string('lama_menikah', 128)->default('');
            $table->string('kb', 128)->default('');
            $table->string('alat_kb', 128)->default('');
            $table->string('gravida', 128)->default('');
            $table->string('para', 128)->default('');
            $table->string('abortus', 128)->default('');
            $table->string('hpht', 20)->default('');
            $table->string('hpl', 20)->default('');
            $table->string('riwayat_penyakit', 128)->default('');
            $table->string('obat_diminum', 128)->default('');
            $table->string('riwayat_penyakit_keluarga', 128)->default('');
            $table->string('alergi_obat', 128)->default('');
            $table->string('generalis_lain', 128)->default('');
            $table->string('tinggi_fundus', 128)->default('');
            $table->string('letak_janin', 128)->default('');
            $table->string('usia_kehamilan', 128)->default('');
            $table->string('djj',128)->default('');
            $table->string('periksaan_lain',128)->default('');
            $table->string('tindakan_medis',128)->default('');
            $table->string('tindak_lanjut',128)->default('');
            $table->text('riwayat_kehamilan_dan_persalinan')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('smis_doc_asesmen_kebidanan');
    }
}
