<?php

namespace App\Services;

use App\Models\TukarTandaTerima;
use Illuminate\Support\Facades\DB;
use Throwable;

/**
 * Class Services
 * @author rivald 
 */

class TukarTandaTerimaService
{

    public function destroy($param)
    {
        try {
            DB::beginTransaction();

            TukarTandaTerima::where('id', $param)->update(['prop' => 'del']);

            DB::table('smis_fr_obat_masuk')
                ->where('id_tt', $param)
                ->update(['id_tt' => 0]);

            DB::table('smis_gu_barang_masuk')
                ->where('id_tt', $param)
                ->update(['id_tt' => 0]);

            DB::commit();
            return 'sukses';
        } catch (Throwable $e) {
            DB::rollback();
            return $e->getMessage();
        }
    }

    public function store($param)
    {
        $id_faktur = $param->id_faktur;
        $label = $param->label;

        try {
            $storeTt = TukarTandaTerima::updateOrCreate(
                [
                    'id' => $param->id
                ],
                $param->except('_token', 'no_faktur', 'id_faktur')
            );

            $id = $storeTt->id;

            DB::beginTransaction();

            DB::table('smis_fr_obat_masuk')
                ->where('id_tt', $id)
                ->update(['id_tt' => 0]);

            DB::table('smis_gu_barang_masuk')
                ->where('id_tt', $id)
                ->update(['id_tt' => 0]);

            DB::commit();

            for ($i = 1; $i < count($id_faktur); $i++) {
                try {
                    DB::beginTransaction();
                    if ($label[$i] == "fr") {

                        DB::table('smis_fr_obat_masuk')
                            ->where('id', $id_faktur[$i])
                            ->update(['id_tt' => $id]);
                    } else {

                        DB::table('smis_gu_barang_masuk')
                            ->where('id', $id_faktur[$i])
                            ->update(['id_tt' => $id]);
                    }
                    DB::commit();
                } catch (Throwable $e) {
                    DB::rollback();
                    return "Error: " . $e->getMessage();
                }
            }
            return "sukses";
        } catch (Throwable $e) {
            DB::rollback();
            return "Error: " . $e->getMessage();
        }
    }

    public function search($param)
    {
        return TukarTandaTerima::where('prop', '')
            ->where(function ($query) use ($param) {
                $query->where(DB::raw('DATE_FORMAT(tanggal, "%d-%m-%Y")'), 'like', "%" . $param->cari . "%")
                    ->orWhere('nama_supplier', 'like', "%" . $param->cari . "%")
                    ->orWhere('no', 'like', "%" . $param->cari . "%");
            });
    }

    public function getFakturById($param)
    {

        $joinTt = DB::table('tukar_tanda_terimas as tt')
            ->leftJoin(DB::raw('(select id,no_bbm ,no_faktur,total_tagihan,tanggal_tempo,"fr" as label, id_tt from smis_fr_obat_masuk where prop = "" and id_tt != 0 
                     union all 
                     select id,no_bbm, no_faktur,total_tagihan,tanggal_tempo,"gu" as label,id_tt from smis_gu_barang_masuk where prop = "" and id_tt != 0) as faktur'), function ($join) {
                $join->on('faktur.id_tt', '=', 'tt.id');
            })
            ->select('tt.*', 'faktur.no_faktur', 'faktur.total_tagihan', 'faktur.tanggal_tempo', 'faktur.label', 'faktur.id as id_faktur', 'faktur.no_bbm')
            ->where('tt.id', $param)
            ->get();

        return $joinTt;
    }

    public function getTandaTerima()
    {
        return TukarTandaTerima::where('prop', '');
    }

    public function getNoTt()
    {
        $number = TukarTandaTerima::select('no', DB::raw("SUBSTRING_INDEX(`no`, '/', -1) AS `nomor`"))->where([
            ['prop', ' '],
            ['no', 'like', '%' . date('y') . '/' . date('m') . '%']
        ])->orderBy('no', 'DESC')->first();

        if (!isset($number->nomor)) {
            return "DHP/" . date('y') . "/" . date('m') . "/1";
        }
        $explode = explode("/", $number->no);

        return $explode[0] . "/" . $explode[1] . "/" . $explode[2] . "/" . ($explode[3] + 1) ?? "failed get number";
    }

    public function getSupplier()
    {
        return DB::table('smis_pb_vendor')->where('prop', '')->select('nama')->get();
    }

    public function getNoFaktur()
    {

        $obatMasuk = DB::table('smis_fr_obat_masuk')
            ->select('id', 'no_faktur', 'total_tagihan', 'tanggal_tempo', 'id_tt', DB::raw("'fr' as label"))
            ->where('prop', '')
            ->where('id_tt', 0);

        $barangMasuk = DB::table('smis_gu_barang_masuk')
            ->select('id', 'no_faktur', 'total_tagihan', 'tanggal_tempo', 'id_tt', DB::raw("'gu' as label"))
            ->where('prop', '')
            ->where('id_tt', 0);

        $faktur = $obatMasuk->unionAll($barangMasuk)->get();

        return $faktur;
    }
}
