<?php

namespace App\Services;

use App\Models\Smis_Er_Resep;
use Illuminate\Support\Facades\DB;

class ResepService
{
    function select($id)
    {
        return Smis_Er_Resep::with('detail')->where('id', $id)->where('prop', '')->first();
    }

    function obat_tersedia($keyword = '')
    {
        $where_keyword = $keyword == '' ? $keyword : "AND s.nama_obat like '%" . $keyword . "%'";

        $query = DB::select("SELECT v_stok.id,
       v_stok.kode_obat,
       v_stok.nama_obat,
       v_stok.nama_jenis_obat,
       GROUP_CONCAT(CONCAT(
           v_stok.sisa, ' ', 
           CONVERT(v_stok.satuan USING utf8), ' ', 
           CONVERT(v_stok.label USING utf8)
       ) ORDER BY v_stok.satuan, v_stok.label ASC SEPARATOR ', ') AS stok
FROM (
    SELECT s.id_obat AS id,
           s.kode_obat,
           s.nama_obat,
           s.nama_jenis_obat,
           SUM(s.sisa) AS sisa,  
           CONVERT(s.satuan USING utf8) AS satuan,
           s.konversi,
           s.satuan_konversi,
           CONVERT(
               CASE s.label 
                   WHEN 'reguler' THEN '(R)'
                   WHEN 'sito' THEN '(S)'
                   ELSE '(K)' 
               END USING utf8
           ) AS label
    FROM smis_frm_" . env('FARMASI') . "_stok_obat s
    LEFT JOIN smis_frm_" . env('FARMASI') . "_obat_masuk m 
        ON s.id_obat_masuk = m.id
    WHERE s.prop = ''
      AND m.prop = ''
      AND m.status = 'sudah'
      " . $where_keyword . "
    GROUP BY s.id_obat
    HAVING SUM(s.sisa) > 0
) v_stok
INNER JOIN smis_pr_barang b 
    ON v_stok.id = b.id
WHERE b.bpjs = 1
  AND b.prop = ''
  AND b.medis = 1
  AND b.inventaris = 0
GROUP BY v_stok.id");
        return $query;
    }

    function harga_obat($id_obat)
    {
        $harga = 0;
        $query = DB::table('smis_fr_margin_jual_per_obat')->where('id_obat', $id_obat)->where('prop', '')->first();

        if ($query) {
            switch ($query->fix_hja) {
                case '0':
                    $dobat = DB::table('smis_fr_dobat_f_masuk')->select('smis_fr_dobat_f_masuk.hna', 'smis_fr_dobat_f_masuk.konversi')->where('smis_fr_dobat_f_masuk.id_obat', $id_obat)->get();

                    $hna_tertinggi = 0;

                    foreach ($dobat as $d_obat) {
                        $temp_harga_jual = $d_obat->hna / $d_obat->konversi;
                        $hna_tertinggi =  $temp_harga_jual > $hna_tertinggi ? $temp_harga_jual : $hna_tertinggi;
                    }

                    $margin_jual = $query->margin_jual / 100;
                    $harga = $hna_tertinggi * (1 + $margin_jual); //ini harga jual

                    break;
                case '1':
                    $harga = $query->harga_jual;
                    break;

                default:
                    # code...
                    break;
            }
        }

        return $harga;
    }

    function store($req)
    {
        $resep = DB::table('smis_er_resep')->where('id', $req->id)->first();

        $arrIns = $req->all();
        unset($arrIns['_token']);
        unset($arrIns['detail']);
        unset($arrIns['id']);

        $arrIns['tanggal'] = date('Y-m-d H:i:s', strtotime($arrIns['tanggal']));

        if ($resep) {
            DB::table('smis_er_resep')->where('id', $resep->id)->update($arrIns);
        } else {
            $id = DB::table('smis_er_resep')->insertGetId($arrIns);
        }

        $id_resep = $resep ? $resep->id : $id;

        $d_resep = json_decode($req->detail);

        for ($i = 0; $i < sizeof($d_resep); $i++) {
            $arrInsD = (array) $d_resep[$i];
            unset($arrInsD['sisa']);

            if ($arrInsD['id'] == '') {
                $arrInsD['id_resep'] = $id_resep;
            }

            if ($arrInsD['id'] == '' && $arrInsD['prop'] == '') {
                DB::table('smis_er_dresep')->insert($arrInsD);
            } else {
                DB::table('smis_er_dresep')->where('id', $arrInsD['id'])->update($arrInsD);
            }
        }

        return Smis_Er_Resep::with('detail')->where('id', $id_resep)->first();
    }

    function lock($req)
    {
        DB::table('smis_er_resep')->where('id', $req->id)->update([
            'locked' => 1
        ]);

        return Smis_Er_Resep::with('detail')->where('id', $req->id)->first();
    }
}
