<?php

namespace App\Services\MedicalRecord\ERekamMedis\DokumenKunjungan;

use App\Models\DokumenKunjungan;
use App\Models\Smis_Er_Resep;
use App\Services\LaboratoriumService;
use App\Services\MedicalRecord\ERekamMedisService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class AsesmenMedisAwalRawatJalanService
{
    function data($req)
    {
        $dokumen = DB::table('dokumen_kunjungan_pasien')->where('id', $req->dokumen)->first();
        $layanan = DB::table('smis_rg_layananpasien')->where('id', $dokumen->noreg)->first();
        $data = DB::table('smis_doc_asesmen_medis_awal_rawat_jalan')->where('id_dokumen', $dokumen->id)->first();

        $diagnosa = DB::table('smis_mr_diagnosa')->where('id', $data->id_diagnosa ?? 0)->first();

        if (is_null($diagnosa)) {
            $diagnosa = DB::table('smis_mr_diagnosa')->where('noreg_pasien', $layanan->id)->where('prop','')->first();
        }

        return [
            'dokumen' => $dokumen,
            'data' => $data,
            'layanan' => $layanan,
            'asuransi' => DB::table('smis_rg_asuransi')->where('id', $layanan->asuransi)->where('prop', '')->first(),
            'pasien' => DB::table('smis_rg_patient')->where('id', $layanan->id_pasien)->first(),
            'employee' => DB::table('smis_hrd_employee')->where('nama', $dokumen->nama_verifikator)->first(),
            'diagnosa' => $diagnosa,
            'dokumen_kunjungan_sebelumnya' => (new ERekamMedisService)->get_dokumen_kunjungan_sebelumnya($req),
            'pengkajian_keperawatan_rawat_jalan' => DB::table('dokumen_kunjungan_pasien')->where('noreg', $dokumen->noreg)
                ->where('dokumen_kunjungan_pasien.nama_dokumen', 'like', '%Pengkajian Keperawatan Rawat Jalan%')
                ->join('smis_doc_pengkajian_keperawatan_rawat_jalan', 'smis_doc_pengkajian_keperawatan_rawat_jalan.id_dokumen', 'dokumen_kunjungan_pasien.id')
                ->select('smis_doc_pengkajian_keperawatan_rawat_jalan.*')
                ->first(),
            'laboratorium' => $data ? (new LaboratoriumService)->select($data->id_lab) : null,
            'kelas' => DB::table('smis_adm_settings')->where('name', 'laboratory-ui-pemeriksaan-default-kelas')->first(),
            'master_hasil' => DB::table('smis_lab_hasil')->where('prop', '')->orderBy('grup')->get(),
            'resep' => $data ? Smis_Er_Resep::with('detail')->where('id', $data->id_resep)->first() : null,
            'ruangan' => DB::table('smis_adm_prototype')->where('slug', 'like', env('slug_klinik'))->where('prop', '')->get(),
            'list_kelas' =>  DB::table('smis_mjm_kelas')->where('prop', '')->get(),
            'pemeriksaan' => DB::table('smis_lab_layanan')->where('prop', '')->get(),
            'employee_auth' => DB::table('smis_hrd_employee')->where('nama', Auth::user()->realname)->where('unit_kerja', env('NAMA_KLINIK'))->first()
        ];
    }

    function store($req)
    {
        $arr_ins = $req->all();

        $arr_ins['kepala'] = $arr_ins['radio_kepala'];
        $arr_ins['thorax'] = $arr_ins['radio_thorax'];
        $arr_ins['abdomen'] = $arr_ins['radio_abdomen'];
        $arr_ins['ekstremitas'] = $arr_ins['radio_ekstremitas'];

        foreach ($arr_ins as $ins => $value) {
            if (is_null($value)) {
                $arr_ins[$ins] = "";
            }
        }

        unset($arr_ins['radio_kepala']);
        unset($arr_ins['radio_thorax']);
        unset($arr_ins['radio_abdomen']);
        unset($arr_ins['radio_ekstremitas']);
        unset($arr_ins['_token']);
        unset($arr_ins['password']);
        unset($arr_ins['dokumen']);

        $arr_ins['updated_at'] = date('Y-m-d H:i:s');

        $query = DB::table('smis_doc_asesmen_medis_awal_rawat_jalan')->updateOrInsert([
            'id_dokumen' => $req->dokumen
        ], $arr_ins);

        if (isset($req->password)) {
            (new ERekamMedisService)->verifikasi_dokumen_kunjungan($req);
        }

        return $query;
    }
}
