<?php

namespace App\Services;

use App\Models\SMIS_Pasien;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class LaboratoriumService{
    function select($id) {
        return DB::table('smis_lab_pesanan')->where('id', $id)->where('prop','')->first();
    }

    function last_by_noreg($noreg) {
        return DB::table('smis_lab_pesanan')->where('noreg_pasien', $noreg)->where('prop','')->orderBy('id', 'desc')->first();
    }

    function store($req)
    {
        $pesanan = DB::table('smis_lab_pesanan')->where('id', $req->id)->where('prop', '')->first();
        $hapusan_darah = '<p>' .
            '<br>' .
            '</p>' .
            '<table class="table table-bordered">' .
            '<tbody>' .
            '<tr>' .
            '<td>' .
            '<span style="font-weight: bold;">Jenis Sel</span>' .
            '</td>' .
            '<td>' .
            '<span style="font-weight: bold;">Hasil Pemeriksaan</span>' .
            '</td>' .
            '</tr>' .
            '<tr>' .
            '<td>Eritrosit</td>' .
            '<td>-</td>' .
            '</tr>' .
            '<tr>' .
            '<td>Leukosit</td>' .
            '<td>-</td>' .
            '</tr>' .
            '<tr>' .
            '<td>Trombosit</td>' .
            '<td>-</td>' .
            '</tr>' .
            '<tr>' .
            '<td>' .
            '<span style="font-weight: bold;">Kesimpulan</span>' .
            '</td>' .
            '<td>-</td>' .
            '</tr>' .
            '</tbody>' .
            '</table>' .
            '<p>' .
            '<br>' .
            '</p>';

        $jumlah_pesanan = DB::table('smis_lab_pesanan')->where('noreg_pasien', $req->noreg)->whereMonth('tanggal', date('m', strtotime($req->tanggal)))->count();
        $layanan_pasien = DB::table('smis_rg_layananpasien')->where('id', env('SLUG_KLINIK').$req->noreg)->first();
        $map_layanan = [];
        $map_harga = [];
        $map_hasil = [];
        $total = 0;
        $layanan = DB::table('smis_lab_layanan')->where('prop', '')->get();
        $list_hasil = DB::table('smis_lab_hasil')->where('prop', '')->get();
        $setting_harga = DB::table('smis_adm_settings')->where('name', 'smis_lab_harga')->where('prop', '')->first();
        $ruangan = DB::table('smis_adm_prototype')->where('slug', $req->ruangan)->first();
        $list_harga = $setting_harga ? $setting_harga->value : [];
        $temp = json_decode($list_harga, true);
        $key = array_keys($temp);

        foreach ($layanan as $lay) {
            if (in_array($lay->slug, $req->pesan_pemeriksaan)) {
                $map_layanan[$lay->slug] = 1;
            } else {
                $map_layanan[$lay->slug] = 0;
            }
        }

        for ($i = 0; $i < sizeof($key); $i++) {
            if (strpos($key[$i], $req->kelas . '_') !== false) {
                $map_harga[$key[$i]] = $temp[$key[$i]];
                $decrease = str_replace($req->kelas . '_', '', $key[$i]);
                if (array_key_exists($decrease, $map_layanan)) {
                    if ($map_layanan[$decrease] == 1) {
                        $total += $temp[$key[$i]];
                    }
                }
            }
        }

        foreach ($list_hasil as $lh) {
            $map_hasil[$lh->slug] = "";
        }

        $umur = substr($req->umur, 0, 2);
        $umur = trim($umur);

        $no_lab = $this->format_no_lab($jumlah_pesanan);

        $pasien = SMIS_Pasien::where('nrm', $req->nrm)->where('id', 'like', '%'.env('slug_klinik').'%')->first();

        $data = [
            'total_biaya' => $total,
            'input_di' => $ruangan ? strtoupper($ruangan->nama) : '',
            'operator' => Auth::user()->realname,
            'prop' => '',
            'tanggal' => $req->tanggal,
            'nama_pasien' => $req->nama_pasien,
            'nrm_pasien' => $req->nrm,
            'noreg_pasien' => env('slug_klinik').$req->noreg,
            'jk' => $pasien ? $pasien->kelamin : 0,
            'kelas' => $req->kelas,
            'umur' => $req->umur,
            'alamat' => $req->alamat,
            'ibu' => $req->ibu ? $req->ibu : '',
            'limapuluh' => $umur >= 50 ? 1 : 0,
            'carabayar' => $req->jenis_pasien,
            'ruangan' => $req->ruangan,
            'no_lab' => 'L' . $no_lab . '/' . $this->romawi(date('m')) . '-' . $this->dua_digit_tahun(date('Y')) . '/LSRB',
            'id_dokter' => $req->id_dokter,
            'nama_dokter' => $req->dokter,
            'id_konsultan' => $req->id_konsultan ? $req->id_konsultan : 0,
            'nama_konsultan' => $req->konsultan ? $req->konsultan : '',
            'id_petugas' => $req->id_petugas ? $req->id_petugas : 0,
            'nama_petugas' => $req->petugas ? $req->petugas : '',
            'periksa' => json_encode($map_layanan),
            'hasil' => json_encode($map_hasil),
            'hapusan_darah' => $hapusan_darah,
            'harga' => json_encode($map_harga),
            'biaya' => $total,
            'waktu_daftar' => date('Y-m-d H:i:s'),
            'uri' => $layanan_pasien ? $layanan_pasien->uri : '',
            'diagnosa' => $req->diagnosa ? $req->diagnosa : '',
        ];

        if ($pesanan) {
            DB::table('smis_lab_pesanan')->where('id', $pesanan->id)->update($data);
        } else {
            $insert_id = DB::table('smis_lab_pesanan')->insertGetId($data);
        }

        return $pesanan ? $pesanan->id : $insert_id;
    }

    function format_no_lab($jumlah)
    {
        $temp = $jumlah + 1;
        if ($temp < 10) {
            return '000' . $temp;
        } else if ($temp > 9 && $temp < 100) {
            return '00' . $temp;
        } else {
            return '0' . $temp;
        }
    }

    function dua_digit_tahun($thn)
    {
        $temp = str_split($thn);
        return $temp[sizeof($temp) - 2] . $temp[sizeof($temp) - 1];
    }

    function romawi($bln)
    {
        switch ($bln) {
            case 1:
                return "I";
                break;
            case 2:
                return "II";
                break;
            case 3:
                return "III";
                break;
            case 4:
                return "IV";
                break;
            case 5:
                return "V";
                break;
            case 6:
                return "VI";
                break;
            case 7:
                return "VII";
                break;
            case 8:
                return "VIII";
                break;
            case 9:
                return "IX";
                break;
            case 10:
                return "X";
                break;
            case 11:
                return "XI";
                break;
            case 12:
                return "XII";
                break;
        }
    }
}