<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;

/**
 * Class Services
 * @author rivald 
 */
class DataIndukKepegawaianService
{

    public function getKopExcel()
    {
        $title = DB::table('smis_adm_settings')->where('name', 'smis_autonomous_title')->first();
        $address = DB::table('smis_adm_settings')->where('name', 'smis_autonomous_address')->first();

        return [
            'title' => $title->value,
            'address' => $address->value
        ];
    }

    public function getDataById($id, $table)
    {
        return DB::table($table)->where([
            ['id', $id],
            ['prop', ' '],
        ])->first();
    }

    public function getData($table)
    {
        return DB::table($table)->where('prop', " ");
    }

    public function deleteData($id, $table)
    {
        try {
            DB::table($table)
                ->where('id', $id)
                ->update([
                    'prop' => "del",
                    'time_updated' => date('Y-m-d H:i:s')
                ]);
            return 'sukses';
        } catch (Exception $th) {
            return $th->getMessage();
        }
    }

    public function getHrdEmploye($jk, $pendidikan)
    {
        return DB::table('smis_hrd_employee')
            ->where('jk', $jk)
            ->where('pendidikan', $pendidikan)
            ->count();
    }

    //Action Bagian 
    public function createBagian($request)
    {
        try {
            DB::table('smis_hrd_job')->insertGetId([
                'nama' => $request->nama,
                'slug' => $request->slug,
                'keterangan' => $request->keterangan ?? " ",
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updateBagian($request)
    {
        try {
            DB::table('smis_hrd_job')
                ->where('id', $request->id)
                ->update([
                    'nama' => $request->nama,
                    'slug' => $request->slug,
                    'keterangan' => $request->keterangan ?? " ",
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchBagian($request)
    {
        $data = DB::table('smis_hrd_job')
            ->where([
                ['prop', ' '],
                ['nama', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['slug', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['keterangan', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }

    //Golongan
    public function createGolongan($request)
    {
        try {
            DB::table('smis_hrd_golongan')->insertGetId([
                'golongan' => $request->nama,
                'keterangan' => $request->keterangan ?? " ",
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updateGolongan($request)
    {
        try {
            DB::table('smis_hrd_golongan')
                ->where('id', $request->id)
                ->update([
                    'golongan' => $request->nama,
                    'keterangan' => $request->keterangan ?? " ",
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchGolongan($request)
    {
        $data = DB::table('smis_hrd_golongan')
            ->where([
                ['prop', ' '],
                ['golongan', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['keterangan', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }

    // Pendidikan Profesi
    public function createPendidikanProfesi($request)
    {
        try {
            DB::table('smis_hrd_pendidikan_profesi')->insertGetId([
                'nama_pendidikan_profesi' => $request->nama,
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updatePendidikanProfesi($request)
    {
        try {
            DB::table('smis_hrd_pendidikan_profesi')
                ->where('id', $request->id)
                ->update([
                    'nama_pendidikan_profesi' => $request->nama,
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchPendidikanProfesi($request)
    {
        $data = DB::table('smis_hrd_pendidikan_profesi')
            ->where([
                ['prop', ' '],
                ['nama_pendidikan_profesi', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }

    //Ruangan Pegawai
    public function createRuanganPegawai($request)
    {
        try {
            DB::table('smis_hrd_ruangan_pegawai')->insertGetId([
                'ruangan_pegawai' => $request->nama,
                'keterangan' => $request->keterangan ?? " ",
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updateRuanganPegawai($request)
    {
        try {
            DB::table('smis_hrd_ruangan_pegawai')
                ->where('id', $request->id)
                ->update([
                    'ruangan_pegawai' => $request->nama,
                    'keterangan' => $request->keterangan ?? " ",
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchRuanganPegawai($request)
    {
        $data = DB::table('smis_hrd_ruangan_pegawai')
            ->where([
                ['prop', ' '],
                ['ruangan_pegawai', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['keterangan', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }

    // Bank Pegawai 
    public function createBankPegawai($request)
    {
        try {
            DB::table('smis_hrd_bank')->insertGetId([
                'nama' => $request->nama,
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updateBankPegawai($request)
    {
        try {
            DB::table('smis_hrd_bank')
                ->where('id', $request->id)
                ->update([
                    'nama' => $request->nama,
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchBankPegawai($request)
    {
        $data = DB::table('smis_hrd_bank')
            ->where([
                ['prop', ' '],
                ['nama', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }

    // Status Pegawai
    public function createStatusPegawai($request)
    {
        try {
            DB::table('smis_hrd_status_tenaga')->insertGetId([
                'status_tenaga' => $request->nama,
                'keterangan' => $request->keterangan ?? " ",
                'time_updated' => date('Y-m-d H:i:s'),
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updateStatusPegawai($request)
    {
        try {
            DB::table('smis_hrd_status_tenaga')
                ->where('id', $request->id)
                ->update([
                    'status_tenaga' => $request->nama,
                    'keterangan' => $request->keterangan ?? " ",
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchStatusPegawai($request)
    {
        $data = DB::table('smis_hrd_status_tenaga')
            ->where([
                ['prop', ' '],
                ['status_tenaga', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }

    //Pendidikan
    public function createPendidikan($request)
    {
        try {
            DB::table('smis_hrd_pendidikan')->insertGetId([
                'pendidikan' => $request->nama,
                'keterangan' => $request->keterangan ?? " ",
                'butuh_pr' => $request->k_perempuan,
                'butuh_lk' => $request->k_laki,
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updatePendidikan($request)
    {
        try {
            DB::table('smis_hrd_pendidikan')
                ->where('id', $request->id)
                ->update([
                    'pendidikan' => $request->nama,
                    'keterangan' => $request->keterangan ?? " ",
                    'butuh_pr' => $request->k_perempuan,
                    'butuh_lk' => $request->k_laki,
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchPendidikan($request)
    {
        $data = DB::table('smis_hrd_pendidikan')
            ->where([
                ['prop', ' '],
                ['pendidikan', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }

    public function createUnitKerja($request)
    {
        try {
            DB::table('smis_hrd_unit_kerja')->insertGetId([
                'unit_kerja' => $request->unit_kerja,
                'keterangan' => $request->keterangan ?? " ",
                'kota' => $request->kota,
                'time_updated' => date('Y-m-d H:i:s'),
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updateUnitKerja($request)
    {
        try {
            DB::table('smis_hrd_unit_kerja')
                ->where('id', $request->id)
                ->update([
                    'unit_kerja' => $request->unit_kerja,
                    'keterangan' => $request->keterangan ?? " ",
                    'kota' => $request->kota,
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchUnitKerja($request)
    {
        $data = DB::table('smis_hrd_unit_kerja')
            ->where([
                ['prop', ' '],
                ['unit_kerja', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['keterangan', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['kota', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }
}
