<?php

namespace App\Services;

use App\Http\Controllers\Controller;
use App\Models\Mjkn_Patient;
use App\Models\SMIS_Pasien;
use App\Models\Propinsi;
use App\Models\Kabupaten;
use App\Models\Kecamatan;
use App\Models\Kelurahan;
use Illuminate\Support\Facades\DB;
use App\Models\JadwalPoli;
use App\Models\Antrian;
use Illuminate\Support\Facades\Validator;
use App\Helpers\GeneralHelper as GH;
use App\Http\Controllers\GuestRegistrationController;
use App\Models\RsCredential;
use App\Models\SMIS_Ksr_Kolektif;
use App\Models\SMIS_LayananPasien;
use App\Models\SMIS_Mjm_Tarif_Pendaftaran;
use App\Models\SMIS_Rwt_Antrian;
use App\Models\SmisAdmPrototype;
use App\Models\SmisAdmSettings;
use App\Models\SmisHrdEmployee;
use DateTime;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Schema;
use stdClass;

class AntrianPendaftaranService extends Controller
{
    function pasien_mjkn_daftar($id)
    {
        $mjkn = Mjkn_Patient::findOrFail($id);
        $cek = null;

        if ($mjkn->nobpjs != '') {
            $cek = SMIS_Pasien::where('nobpjs', $mjkn->nobpjs)->first();
        }

        if (is_null($cek)) {
            $cek = SMIS_Pasien::where('ktp', $mjkn->nik)->first();
            if (is_null($cek)) {
                $cek = SMIS_Pasien::where('nama', $mjkn->nama)->where('tgl_lahir', $mjkn->tgl_lahir)->first();
            }
        }

        if ($cek) {
            $update = Mjkn_Patient::where('id', $id)->update([
                'nrm' => $cek->id,
                'origin_updated' => 'verified'
            ]);

            DB::table('smis_rg_patient')->where('id', $cek->id)->update([
                'ktp' => $mjkn->nik,
                'nobpjs' => $mjkn->nobpjs,
                'telpon' => $mjkn->telepon
            ]);
            return $update;
        }

        if ($mjkn->kelamin == 0) {
            $sebutan = 'Tn.';
        } else if ($mjkn->kelamin == 1) {
            $sebutan = 'Ny.';
        } else {
            $sebutan = '';
        }

        $propinsi = Propinsi::findOrFail($mjkn->id_propinsi);
        $kabupaten = Kabupaten::findOrFail($mjkn->id_kabupaten);
        $kecamatan = Kecamatan::findOrFail($mjkn->id_kecamatan);
        $kelurahan = Kelurahan::findOrFail($mjkn->id_kelurahan);
        $origin = SmisAdmSettings::where('name', 'smis_autonomous_id')->first();

        $last = SMIS_Pasien::select(DB::raw("MAX(REPLACE(id,'" . env('slug_klinik') . "','')*1) as id"), 'nrm')->where('id', 'like', env('slug_klinik') . '%')->first();
        $last_nrm = SMIS_Pasien::where('id', env('slug_klinik') . (int)$last->id)->first();

        $data_insert = [
            "id" => !is_null($last) ? env('slug_klinik') . (string)((int)str_replace(env('slug_klinik'), '', $last->id) + 1) : env('slug_klinik') . (string)1,
            "nrm" => $last_nrm ? (int)$last_nrm->nrm + 1 : 1,
            'prop' => '',
            "tanggal" => date('Y-m-d'),
            "sebutan" => $sebutan,
            "ukerja" => $mjkn->unit_kerja,
            "kode_faskes" => env('KODE_PPK'),
            "faskes" => $mjkn->unit_kerja,
            "nama" => $mjkn->nama,
            "alamat" => $mjkn->alamat,
            "tempat_lahir" => "",
            "tgl_lahir" => $mjkn->tgl_lahir,
            "status" => "",
            "kelamin" => $mjkn->kelamin,
            "ktp" => $mjkn->nik,
            "rt" => $mjkn->rt,
            "rw" => $mjkn->rw,
            "provinsi" => $mjkn->id_propinsi,
            "nama_provinsi" => $propinsi->nama,
            "kabupaten" => $mjkn->id_kabupaten,
            "nama_kabupaten" => $kabupaten->nama,
            "kecamatan" => $mjkn->id_kecamatan,
            "nama_kecamatan" => $kecamatan->nama,
            "kelurahan" => $mjkn->id_kelurahan,
            "nama_kelurahan" => $kelurahan->nama,
            "nama_kedusunan" => "",
            "kedusunan" => "0",
            "nobpjs" => $mjkn->nobpjs ? $mjkn->nobpjs : '',
            "telpon" => $mjkn->telepon ? $mjkn->telepon : '',
            "pekerjaan" => "",
            "pendidikan" => "",
            "agama" => "",
            "umur" => "",
            "suami" => "",
            "istri" => "",
            "ayah" => "",
            "ibu" => "",
            "jenis" => "",
            "suku" => "",
            "bahasa" => "",
            "email" => "",
            "bbm" => "",
            "gol_darah" => "",
            "document" => "",
            "keterangan" => "",
            "id_karyawan" => "",
            "nama_karyawan" => "",
            "hubungan" => "",
            "synch" => "",
            "fingerprint" => "",
            "fingerprint_proses" => "",
            "profile_number" => "",
            "alamat_keluarga" => "",
            "desa_keluarga" => "",
            "kecamatan_keluarga" => "",
            "pekerjaan_keluarga" => "",
            "kabupaten_keluarga" => "",
            "umur_keluarga" => "",
            "telepon_keluarga" => "",
            "autonomous" => "",
            "duplicate" => 0,
            "origin" => $origin ? $origin->value : "",
            "origin_id" => 0,
            "kartu" => 0,
            "time_updated" => date('Y-m-d H:i:s'),
            "origin_updated" => $origin ? $origin->value : ""
        ];

        $insert = SMIS_Pasien::insert($data_insert);

        Mjkn_Patient::where('id', $id)->update([
            "nrm" => $last_nrm ? (int)$last_nrm->nrm + 1 : 1,
            'origin_updated' => 'verified'
        ]);

        return $data_insert;
    }

    function insert_pasien_anjungan_mandiri($param)
    {
        $last = SMIS_Pasien::orderBy('id', 'desc')->first();
        $propinsi = Propinsi::findOrFail($param->propinsi);
        $kabupaten = Kabupaten::findOrFail($param->kabupaten);
        $kecamatan = Kecamatan::findOrFail($param->kecamatan);
        $kelurahan = Kelurahan::findOrFail($param->kelurahan);

        $last = SMIS_Pasien::select(DB::raw("MAX(REPLACE(id,'" . env('slug_klinik') . "','')*1) as id"), 'nrm')->where('id', 'like', env('slug_klinik') . '%')->first();
        $last_nrm = DB::table('smis_rg_faskes')->where('prefix_id', env('slug_klinik'))->where('prop','')->first();

        $employee = SmisHrdEmployee::where('usname', Auth::user()->username)->where('prop', '')->first();
        $unit_kerja = DB::table('smis_hrd_unit_kerja')->where('unit_kerja', ($employee ? $employee->unit_kerja : ""))->where('prop', '')->first();

        $ss = new SmisService();
        $pasien_pcare = json_decode($ss->post(env('SMIS_URL_GET_PESERTA_BY_BPJS'), [
            [
                'name'     => 'username',
                'contents' => Auth::user()->username
            ],
            [
                'name'     => 'no_bpjs',
                'contents' => $param->nobpjs
            ]
        ])->getBody()->getContents());

        $dataPasien = [
            "id" => !is_null($last) ? env('slug_klinik') . (string)((int)str_replace(env('slug_klinik'), '', $last->id) + 1) : env('slug_klinik') . (string)1,
            "nama" => $param->nama,
            "alamat" => $param->alamat,
            "tgl_lahir" => $param->tanggallahir,
            "kelamin" => $param->kelamin,
            "ktp" => $param->nik,
            "rt" => $param->rt,
            "rw" => $param->rw,
            "provinsi" => $param->propinsi,
            "nama_provinsi" => $propinsi->nama,
            "kabupaten" => $param->kabupaten,
            "nama_kabupaten" => $kabupaten->nama,
            "kecamatan" => $param->kecamatan,
            "nama_kecamatan" => $kecamatan->nama,
            "kelurahan" => $param->kelurahan,
            "nama_kelurahan" => $kelurahan->nama,
            "nobpjs" => $param->nobpjs ? $param->nobpjs : '',
            "telpon" => $param->phone,
            "origin_updated" => 'mobile-jkn',
            "nrm" => $last_nrm ? (int)$last_nrm->last_nrm + 1 : 1,
            "ukerja" => $employee ? $employee->unit_kerja : '',
            'id_unit_kerja' => $unit_kerja ? $unit_kerja->id : 0,
            "faskes" => !is_null($pasien_pcare) ? (!is_null($pasien_pcare->response) ? $pasien_pcare->response->kdProviderPst->nmProvider : '') : '',
            "kode_faskes" => !is_null($pasien_pcare) ? (!is_null($pasien_pcare->response) ? $pasien_pcare->response->kdProviderPst->kdProvider : '') : '',
            "kelas_bpjs" => !is_null($pasien_pcare) ? (!is_null($pasien_pcare->response) ? $pasien_pcare->response->jnsKelas->kode : '') : '',
            "pisat" => !is_null($pasien_pcare) ? (!is_null($pasien_pcare->response) ? $pasien_pcare->response->hubunganKeluarga : '') : '',
            "tanggal" => date('Y-m-d')
        ];
        SMIS_Pasien::insert($dataPasien);
        // $addPasien = SMIS_Pasien::orderBy('id', 'desc')->first();
        return $dataPasien;
    }

    function update_mjkn_patient($req)
    {
        $propinsi = Propinsi::findOrFail($req->propinsi);
        $kabupaten = Kabupaten::findOrFail($req->kabupaten);
        $kecamatan = Kecamatan::findOrFail($req->kecamatan);
        $kelurahan = Kelurahan::findOrFail($req->kelurahan);

        $query = Mjkn_Patient::where('id', $req->id)->update([
            'nobpjs' => $req->nobpjs,
            'nik' => $req->nik,
            // 'no_kk' => $req->no_kk,
            'nama' => $req->nama,
            'kelamin' => $req->kelamin,
            'tgl_lahir' => $req->tgl_lahir,
            'telepon' => $req->telepon,
            'alamat' => $req->alamat,
            'id_propinsi' => $req->propinsi,
            'id_kabupaten' => $req->kabupaten,
            'id_kecamatan' => $req->kecamatan,
            'id_kelurahan' => $req->kelurahan,
            "propinsi" => $propinsi->nama,
            "kabupaten" => $kabupaten->nama,
            "kecamatan" => $kecamatan->nama,
            "kelurahan" => $kelurahan->nama,
            'rt' => $req->rt,
            'rw' => $req->rw,
        ]);
        return $query;
    }

    function pasien_daftar($req)
    {
        if ($req->kedatangan != 'Datang Sendiri') {
            if (!isset($req->jenis_perujuk)) {
                return [
                    'status' => false,
                    'message' => 'Pilih jenis perujuk dahulu',
                    'code' => 201
                ];
            }
            if (!isset($req->id_perujuk)) {
                return [
                    'status' => false,
                    'message' => 'Pilih nama perujuk dahulu',
                    'code' => 201
                ];
            }
        }

        $valid = $this->valid($req->all());

        if ($valid['metadata']['code'] != "200") {
            return [
                'status' => false,
                'message' => $valid['metadata']['message'],
                'code' => 201
            ];
        }

        $poli = explode('-', $req['kodepoli']);
        $jadwal = $valid['response']['jadwal'];
        $pasien = $valid['response']['pasien'];
        $sisakuotajkn = $valid['response']['sisakuotajkn'];
        $sisakuotanonjkn = $valid['response']['sisakuotanonjkn'];
        $generate = GH::generateAntrean($jadwal['kodedokter_bpjs'], $jadwal['id'], $poli[0], $req->tanggalperiksa);
        $mili = strtotime($req->tanggalperiksa . ' ' . $jadwal->jam_mulai);
        $estimasi = ($mili * 1000) + (($generate['angkaantrean'] - 1) * ($jadwal->estimasi_layanan * 60000));

        if (isset($pasien->nik)) {
            if ($pasien->origin_updated != 'verified') {
                return [
                    'status' => false,
                    'message' => 'No. rekam medis anda ' . $pasien['nrm'] . ' tersebut hanya bersifat sementara. Harap datang ke admisi untuk verifikasi & melengkapi data rekam medis dengan membawa kartu identitas, pastikan data anda benar-benar valid & belum pernah terdaftar di RSUD SLG',
                    'code' => 201
                ];
            }
        } else {
            if ($pasien->origin_updated == 'mobile-jkn') {
                return [
                    'status' => false,
                    'message' => 'No. rekam medis anda ' . $pasien['id'] . ' tersebut hanya bersifat sementara. Harap datang ke admisi untuk verifikasi & melengkapi data rekam medis dengan membawa kartu identitas, pastikan data anda benar-benar valid & belum pernah terdaftar di RSUD SLG',
                    'code' => 201
                ];
            }
        }

        $count_baru_lama = SMIS_LayananPasien::where('nrm', $pasien['id'])->count();
        $antrian = new Antrian();
        if ($count_baru_lama > 0) {
            $antrian->pasien_baru = 0;
        } else {
            $antrian->pasien_baru = 1;
        }

        $jp = $req->jenis_pasien ? explode('-', $req->jenis_pasien) : [''];

        $antrian->taskid = 0;
        $antrian->tanggalperiksa = $req->tanggalperiksa;
        $antrian->namapj = $req->nama_pj ? $req->nama_pj : '';
        $antrian->telppj = $req->telp_pj ? $req->telp_pj : '';
        $antrian->jadwal_id = $jadwal['id'];
        $antrian->carabayar = $jp[0] ? $jp[0] : '';
        $antrian->asuransi = isset($req->asuransi) ? $req->asuransi : 0;
        $antrian->perusahaan = isset($req->perusahaan) ? $req->perusahaan : 0;
        $antrian->nomorantrean = $generate['nomorantrean'];
        $antrian->angkaantrean = $generate['angkaantrean'];
        $antrian->kodebooking = $generate['kodebooking'];
        $antrian->norm = $pasien['id'];
        $antrian->namapoli = $jadwal['nama_poli'];
        $antrian->namadokter = $jadwal['nama_dokter'];
        $antrian->estimasidilayani = $estimasi; // masih salah harus di ganti
        $antrian->sisakuotajkn = $sisakuotajkn;
        $antrian->sisakuotanonjkn = $sisakuotanonjkn;
        $antrian->kuotajkn = $jadwal['kuota_jkn'];
        $antrian->kuotanonjkn = $jadwal['kuota_non_jkn'];
        $antrian->kedatangan = $req->kedatangan ? $req->kedatangan : '';
        $antrian->jenis_perujuk = $req->jenis_perujuk ? $req->jenis_perujuk : '';
        $antrian->id_perujuk = $req->id_perujuk ? $req->id_perujuk : 0;
        $antrian->keterangan = 'Peserta harap 60 menit lebih awal guna pencatatan administrasi.';
        $antrian->created_at = date('Y-m-d H:i:s', strtotime('now'));
        $antrian->updated_at = date('Y-m-d H:i:s', strtotime('now'));

        $ref = $req->nomorreferensi ? $req->nomorreferensi : '';
        if (isset($req->nobpjs)) {
            if ($req->nomorreferensi == '-' || $req->nomorreferensi == '') {
                return [
                    'status' => false,
                    'message' => 'Nomor referensi belum sesuai',
                    'code' => 201
                ];
            }
            if (strlen($req->nomorreferensi) < 19) {
                return [
                    'status' => false,
                    'message' => 'Nomor referensi belum sesuai',
                    'code' => 201
                ];
            }
        }

        $param_antrian_bpjs = json_encode([
            'kodebooking' => $generate['kodebooking'],
            'jenispasien' => $req->nobpjs ? 'JKN' : 'NON JKN',
            'nomorkartu' => $req->nobpjs ? $req->nobpjs : '-',
            'nik' => $pasien['ktp'],
            'nohp' => $pasien['telpon'],
            'kodepoli' => $jadwal['kodepoli_bpjs'],
            'namapoli' => $jadwal['nama_poli'],
            'pasienbaru' => $antrian->pasien_baru,
            'norm' => $pasien['id'],
            'tanggalperiksa' => $antrian->tanggalperiksa,
            'kodedokter' => (int)$jadwal['kodedokter_bpjs'],
            'namadokter' => $jadwal['nama_dokter'],
            'jampraktek' => $jadwal['jam_mulai'] . '-' . $jadwal['jam_selesai'],
            'jeniskunjungan' => (int)$req->jenis_kunjungan,
            'nomorreferensi' => $ref,
            'nomorantrean' => $generate['nomorantrean'],
            'angkaantrean' => $generate['angkaantrean'],
            'estimasidilayani' => $estimasi,
            "sisakuotajkn" => $sisakuotajkn,
            "kuotajkn" => $jadwal['kuota_jkn'],
            "sisakuotanonjkn" => $sisakuotanonjkn,
            "kuotanonjkn" => $jadwal['kuota_non_jkn'],
            "keterangan" => $antrian->keterangan
        ]);

        $grc = new GuestRegistrationController();
        $result = $grc->post_bpjs('antrean/add', $param_antrian_bpjs);

        if ($result['status']) {
            if ($result['code'] != 200) {
                return [
                    'status' => false,
                    'message' => $result['message'],
                    'code' => $result['code'],
                ];
            }
            $antrian->response_code = 200;
            $antrian->response_message = 'Ok';
            $antrian->save();
            $ktp = $pasien->nik ? $pasien->nik : $pasien->ktp;
            return [
                'status' => true,
                'message' => 'Ok',
                'pasien' => $pasien,
                'antrian' => $antrian,
                'code' => 200
            ];
        } else {
            return [
                'status' => false,
                'message' => $result['message'],
                'code' => $result['code']
            ];
        }
    }

    function valid($param)
    {
        $poli = explode('-', $param['kodepoli']);
        $jadwal = new JadwalPoli();
        // jika poli tidak ada
        $jadwal = $jadwal->where("kodepoli_bpjs", $poli[0]);
        if (is_null($jadwal->first())) {
            return $this->responseFormat("Poli tidak ditemukan.", 201);
        }
        // jika dokter tidak ada
        $jadwal = $jadwal->where("kodedokter_bpjs", $param['kodedokter']);
        if (is_null($jadwal->first())) {
            return $this->responseFormat("Dokter di Poli ini tidak ditemukan.", 201);
        }
        // jika format tanggal salah
        $checkTgl = Validator::make(["tanggalperiksa" => $param['tanggalperiksa']], [
            'tanggalperiksa' => 'date_format:Y-m-d',
        ]);
        if ($checkTgl->fails()) {
            return $this->responseFormat("Format tanggal salah gunakan format Y-m-d.", 201);
        }
        // jika tanggal telah berlalu
        if (date("Y-m-d") > $param['tanggalperiksa']) {
            return $this->responseFormat("Tanggal periksa yang anda masukkan telah berlalu.", 201);
        }
        // tidak bisa ambil antrian di hari H
        // if (date("Y-m-d") == $param['tanggalperiksa']) {
        //     return $this->responseFormat("Anda tidak dapat mengambil antrian di hari H.", 201);
        // }
        // jika format jam praktek salah
        $jampraktek = explode("-", $param['jampraktek']);
        if (count($jampraktek) < 2 || ($jampraktek[0] == "" && $jampraktek[1] == ""))
            return $this->responseFormat("Format jam praktek salah, contoh yang benar: 08:00-10:00", 201);
        // date_default_timezone_set('Asia/Jakarta');
        // dd(date_create('+7 hours')->format('Y-m-d H:i') . ' - ' . $param['tanggalperiksa'] . ' ' . $jampraktek[1]);
        // exit();
        $sekarang = strtotime('now');
        $str_jadwal = strtotime($param['tanggalperiksa'] . ' ' . $jampraktek[1]);
        if ($sekarang > $str_jadwal) {
            return $this->responseFormat("Pendaftaran ke poli " . $poli[1] . " sudah tutup jam " . $jampraktek[1], 201);
        }
        // jika jadwal tidak ada
        $hari = date("N", strtotime($param['tanggalperiksa']));
        $jadwal = $jadwal->where("hari", $hari);
        $jadwal = $jadwal->where("jam_mulai", $jampraktek[0]);
        $jadwal = $jadwal->where("jam_selesai", $jampraktek[1])->first();
        if (is_null($jadwal)) {
            return $this->responseFormat("Jadwal tidak ditemukan.", 201);
        }

        if ($param['nobpjs'] != '' && $param['nobpjs'] != null) { // jika pasien bpjs
            $pasien = SMIS_Pasien::where("nobpjs", $param['nobpjs'])->first();
            if (is_null($pasien)) {
                $pasien = Mjkn_Patient::where('nobpjs', $param['nobpjs'])->first();
            }
        } else { // jika pasien non bpjs
            $pasien = SMIS_Pasien::where("ktp", $param['ktp'])->first();
            if (is_null($pasien)) {
                $pasien = Mjkn_Patient::where('nik', $param['ktp'])->first();
            }
        }
        // dd($param);
        if (is_null($pasien)) {
            return $this->responseFormat("Data Pasien tidak ditemukan, silahkan daftar baru.", 202);
        }
        // dd($pasien);
        // last antrian
        $lastAntrian = Antrian::where(['jadwal_id' => $jadwal->id, 'tanggalperiksa' => $param['tanggalperiksa']])->orderBy("id", "desc")->first();
        // sisa antrian jkn
        if (!is_null($lastAntrian))
            $sisakuotajkn = $lastAntrian->sisakuotajkn;
        else
            $sisakuotajkn = $jadwal->kuota_jkn;
        if (isset($param['nobpjs'])) { // jika pasien bpjs
            if ($sisakuotajkn <= 0) { // jika kuota jkn habis
                return $this->responseFormat("Sisa kuota Pasien BPJS sudah habis.", 201);
            }
            $sisakuotajkn = $sisakuotajkn - 1;
        }
        // sisa antrian non jkn
        if (!is_null($lastAntrian))
            $sisakuotanonjkn = $lastAntrian->sisakuotanonjkn;
        else
            $sisakuotanonjkn = $jadwal->kuota_non_jkn;
        if (!isset($param['nobpjs'])) { // jika pasien non bpjs
            if ($sisakuotanonjkn <= 0) { // jika kuota non jkn habis
                return $this->responseFormat("Sisa kuota Pasien Non BPJS sudah habis.", 201);
            }
            $sisakuotanonjkn = $sisakuotanonjkn - 1;
        }

        // jika sudah ambil antrian
        if (!is_null(Antrian::where(['jadwal_id' => $jadwal->id, 'tanggalperiksa' => $param['tanggalperiksa']])->where("norm", $pasien->id)->where('taskid', '!=', 99)->first()))
            return $this->responseFormat("Anda telah mengambil Antrian di poli ini untuk tanggal " . date('d-m-Y', strtotime($param['tanggalperiksa'])), 201);
        // jika validasi sudah benar
        return $this->responseFormat("ok", 200, ["jadwal" => $jadwal, "sisakuotajkn" => $sisakuotajkn, "sisakuotanonjkn" => $sisakuotanonjkn, "pasien" => $pasien]);
    }

    function hadir($data)
    {
        try {
            $client = new Client([
                'verify' => false
            ]);

            $credentials = RsCredential::where('layanan', 'like', 'antrian')->where('slug_klinik', env('slug_klinik'))->first();

            if (is_null($credentials)) {
                return [
                    'status' => false,
                    'message' => 'Credentials tidak ditemukan'
                ];
            }

            date_default_timezone_set('UTC');
            $timeStamp = strval(time() - strtotime('1970-01-01 00:00:00'));
            $signature = $this->get_signature($timeStamp, $credentials->cons_id, $credentials->cons_secret);

            $response = $client->request('post', $credentials->base_url . '/antrean/panggil', [
                'headers' => [
                    'x-cons-id'     => $credentials->cons_id,
                    'x-timestamp'  => $timeStamp,
                    'x-signature'   => $signature,
                    'user_key' => $credentials->user_key,
                ],
                'body' => json_encode($data)
            ]);

            $result = json_decode($response->getBody()->getContents());

            if ($result->metadata->code == 200) {
                return [
                    'status' => true,
                    'code' => $result->metadata->code,
                    'message' => $result->metadata->message,
                ];
            } else {
                return [
                    'status' => false,
                    'code' => $result->metadata->code,
                    'message' => $result->metadata->message,
                ];
            }
        } catch (\Throwable $th) {
            return [
                'status' => false,
                'code' => 500,
                'message' => $th->getMessage(),
            ];
        }
    }

    function checkin($req)
    {
        try {
            $antrian = Antrian::where('id', $req->id)->first();

            $cek_layanan = SMIS_LayananPasien::where('nrm', $antrian->norm)->where('selesai', 0)->first();

            $taskid = 3;

            // if ($antrian->pasien_baru == 1) {
            //     $taskid = 1;
            // }

            $wak = strtotime(now());
            Antrian::where('id', $req->id)->update([
                'taskid' => $taskid,
                'waktu_checkin' => $wak . '000',
            ]);

            $poli_local = [];
            $proto = SmisAdmPrototype::where('parent', 'rawat')->where('prop', '<>', 'del')->where('slug', 'like', '%' . env('slug_klinik') . '%')->get();
            foreach ($proto as $pro) {
                $cek = SmisAdmSettings::where('name', 'smis-rs-urjip-' . $pro->slug)->select('value')->first();
                if ($cek) {
                    if ($cek->value == 'URJ') {
                        array_push($poli_local, $pro);
                    }
                }
            }
            $pasien = SMIS_Pasien::where('id', $antrian->id_pasien)->first();
            $jadwal = JadwalPoli::findOrFail($antrian->jadwal_id);
            $ss = new SmisService();
            $get_peserta = json_decode($ss->post(env('SMIS_URL_GET_PESERTA_BY_BPJS'), [
                [
                    'name'     => 'username',
                    'contents' => Auth::user()->username
                ],
                [
                    'name'     => 'no_bpjs',
                    'contents' => $antrian->nobpjs
                ]
            ])->getBody()->getContents());

            $peserta = null;

            if (!is_null($get_peserta)) {
                $peserta = $get_peserta->response;
            }

            $data_add_peserta = [
                [
                    'name' => 'username',
                    'contents' => Auth::user()->username
                ],
                [
                    'name' => 'kdProviderPeserta',
                    'contents' => $peserta ? $peserta->kdProviderPst->kdProvider : $pasien->kode_faskes
                ],
                [
                    'name' => 'tglDaftar',
                    'contents' => date('d-m-Y')
                ],
                [
                    'name' => 'noKartu',
                    'contents' => $pasien->nobpjs
                ],
                [
                    'name' => 'kdPoli',
                    'contents' => $jadwal->kodepoli_bpjs
                ],
                [
                    'name' => 'keluhan',
                    'contents' => $antrian->keluhan
                ],
                [
                    'name' => 'kunjSakit',
                    'contents' => true
                ],
                [
                    'name' => 'sistole',
                    'contents' => 0
                ],
                [
                    'name' => 'diastole',
                    'contents' => 0
                ],
                [
                    'name' => 'beratBadan',
                    'contents' => 0
                ],
                [
                    'name' => 'tinggiBadan',
                    'contents' => 0
                ],
                [
                    'name' => 'respRate',
                    'contents' => 0
                ],
                [
                    'name' => 'heartRate',
                    'contents' => 0
                ],
                [
                    'name' => 'lingkarPerut',
                    'contents' => 0
                ],
                [
                    'name' => 'rujukBalik',
                    'contents' => 0
                ],
                [
                    'name' => 'kode_tkp',
                    'contents' => 10
                ],
                [
                    'name' => 'kode_poli',
                    'contents' => $jadwal->kodepoli_bpjs
                ],
                [
                    'name' => 'kode_provider',
                    'contents' => $peserta ? $peserta->kdProviderPst->kdProvider : ''
                ],
                [
                    'name' => 'kode_provider_tujuan',
                    'contents' => env('KODE_PPK')
                ],
                [
                    'name' => 'kunjungan_sakit',
                    'contents' => 1
                ],
                [
                    'name' => 'tgl_daftar',
                    'contents' => date('d-m-Y')
                ],
            ];

            if ($antrian->carabayar == 'bpjs') {
                $data_hadir = [
                    "tanggalperiksa" => $antrian->tanggalperiksa,
                    "kodepoli" => $jadwal->kodepoli_bpjs,
                    "nomorkartu" => $antrian->nobpjs,
                    "status" => 1,
                    "waktu" => $wak . '000'
                ];

                $kehadiran = $this->hadir($data_hadir);

                // if ($kehadiran['code'] != 200) {
                //     return [
                //         'status' => false,
                //         'message' => $kehadiran['message']
                //     ];
                // }
            }

            $resp_add_peserta = null;

            if ($antrian->source != 1) {
                if ($antrian->carabayar == 'bpjs') {
                    $add_peserta = $ss->post(env('SMIS_URL_ADD_PESERTA'), $data_add_peserta);
                    $resp_add_peserta = json_decode($add_peserta->getBody()->getContents());

                    if ($add_peserta->getStatusCode() == 200) {
                        if ($resp_add_peserta->metaData->code != 201) {
                            return [
                                'status' => false,
                                'message' => $resp_add_peserta->metaData->message
                            ];
                        }
                    } else {
                        return [
                            'status' => false,
                            'message' => $add_peserta->getReasonPhrase()
                        ];
                    }
                }
            }

            DB::beginTransaction();
            $data_layanan = $this->data_layanan_pasien($pasien, $antrian, $peserta, $resp_add_peserta);
            $add_layanan = DB::table('smis_rg_layananpasien')->insert($data_layanan);

            DB::table('smis_rg_id_layanan')->where('prefix', env('slug_klinik'))->update([
                'kunjungan' => str_replace(env('slug_klinik'), '', $data_layanan['id'])
            ]);

            $noreg = SMIS_LayananPasien::select(DB::raw("MAX(REPLACE(id,'" . env('slug_klinik') . "','')*1) as id"))->where('id', 'like', env('slug_klinik') . '%')->first();

            foreach ($poli_local as $pl) {
                if ($pl->slug == $jadwal->slug_poli) {
                    $add_riwayat_antrian = DB::table('smis_rwt_antrian_' . $jadwal->slug_poli)->insert($this->data_riwayat_antrian($data_layanan, $pasien, $jadwal, $wak, $antrian));
                }
            }

            $add_ksr = DB::table('smis_ksr_kolektif')->insert($this->data_ksr_kolektif($data_layanan, $pasien, $antrian, $wak));

            DB::table('antrians')->where('id', $req->id)->update([
                'noreg' => env('slug_klinik') . $noreg->id,
            ]);

            DB::commit();

            if ($antrian->pasien_baru == 1) {
                return [
                    'status' => true,
                    'message' => 'Harap menuju ke pendaftaran untuk melengkapi data rekam medis',
                ];
            }
            return [
                'status' => true,
                'message' => 'Anda berhasil checkin',
            ];
        } catch (\Throwable $th) {
            DB::rollBack();
            return [
                'status' => false,
                'message' => $th->getMessage()
            ];
        }
    }

    function get_signature($timeStamp, $cons_id, $cons_secret)
    {
        $signature = hash_hmac('sha256', $cons_id . "&" . $timeStamp, $cons_secret, true);
        $encodedSignature = base64_encode($signature);
        return $encodedSignature;
    }

    function data_ksr_kolektif($layanan, $pasien, $antrian, $waktu)
    {
        $tabel_ksr = new SMIS_Ksr_Kolektif();
        $tabel_ksr = $tabel_ksr->getTable();
        $columns = Schema::getColumnListing($tabel_ksr);
        $dataArray = [];

        $jadwal = JadwalPoli::where('id', $antrian->jadwal_id)->first();

        foreach ($columns as $column) {
            $type_column = Schema::getColumnType($tabel_ksr, $column);

            $default_input = "";
            if (in_array($type_column, ["integer", "boolean", 'tinyinteger'])) $default_input = 0;
            if (in_array($type_column, ["string", "text", 'varchar'])) $default_input = "";
            if (in_array($type_column, ["datetime"])) $default_input = '0000-00-00 00:00:00';

            $dataArray[$column] = @$layanan[$column] ?? $default_input;

            $last = SMIS_Ksr_Kolektif::orderBy('id', 'desc')->first();
            $urutan = SmisAdmSettings::where('name', 'cashier-replace-order-registration')->first();
            $nama_grup = SmisAdmSettings::where('name', 'cashier-replace-tipe-registration')->first();
            $map = SmisAdmSettings::where('name', 'cashier-map-area-registration')->first();

            $barulama = $antrian->pasien_baru == 1 ? 0 : 1;

            $karcis = SMIS_Mjm_Tarif_Pendaftaran::where('ruangan', $jadwal->slug_poli)->where('carabayar', $antrian->carabayar)
                ->where('jenis_kunjungan', 'Kunjungan Sakit')->where('jenis_pasien', $barulama)->first();

            $tarif = 0;

            // if (strpos($antrian->carabayar, 'bpjs') !== false) {
            //     $tarif = 10000;
            // } else {
            if ($karcis) {
                $tarif = $antrian->jenis_kunjungan == 'SKS' ? 0 : $karcis->total_tarif;
            }
            // }

            $dataArray['id'] = $last ? (int) $last->id + 1 : 1;
            $dataArray['urutan'] = $urutan ? $urutan->value : '';
            $dataArray['nama_grup'] = $nama_grup ? $nama_grup->value : '';
            $dataArray['jenis_tagihan'] = $nama_grup ? $nama_grup->value : '';
            $dataArray['nama_tagihan'] = 'Karcis Pendaftaran Pasien (' . strtoupper($jadwal->slug_poli) . ')';
            $dataArray['id_unit'] = $layanan['id'];
            $dataArray['noreg_pasien'] = $layanan['id'];
            $dataArray['nrm_pasien'] = $pasien->nrm;
            $dataArray['nama_pasien'] = $pasien->nama;
            $dataArray['jenis_tagihan'] = 'registration';
            $dataArray['nama_grup'] = 'registration';
            $dataArray['nama_dokter'] = $antrian->namadokter;
            $dataArray['ruangan'] = $nama_grup ? $nama_grup->value : '';
            $dataArray['ruangan_map'] = $map ? $map->value : '';
            $dataArray['tanggal'] = $this->convertTanggal($antrian->tanggalperiksa);
            $dataArray['quantity'] = 1;
            $dataArray['hidden'] = 0;
            $dataArray['status'] = 0;
            $dataArray['ruangan_kasir'] = $nama_grup ? $nama_grup->value : '';
            $dataArray['id_kwitansi'] = 0;
            $dataArray['akunting'] = 0;
            $dataArray['ruangan'] = 'pendaftaran';
            $dataArray['ruangan_kasir'] = $map ? strtolower($map->value) : '';
            $dataArray['nama_tagihan'] = 'Karcis Pendaftaran Pasien (' . strtoupper($jadwal->slug_poli) . ')';
            $dataArray['akunting_only'] = 0;
            $dataArray['akunting_nama'] = 'Karcis Pendaftaran Pasien (' . strtoupper($jadwal->slug_poli) . ')';
            $dataArray['keterangan'] = 'Karcis ' . $jadwal->slug_poli . ' Senilai Rp. ' . number_format($tarif, 0, ',', '.') . ',00 Belum dibayar';
            $dataArray['total'] = $tarif;
            $dataArray['nilai'] = $tarif;
            $dataArray['dari'] = date('Y-m-d H:i:s', $waktu);
            $dataArray['sampai'] = date('Y-m-d H:i:s', $waktu);

            return $dataArray;
        }
    }

    function convertTanggal($param)
    {
        $temp = explode('-', $param);
        switch ($temp[1]) {
            case '01':
                return $temp[2] . ' Januari ' . $temp[0];
                break;
            case '02':
                return $temp[2] . ' Februari ' . $temp[0];
                break;
            case '03':
                return $temp[2] . ' Maret ' . $temp[0];
                break;
            case '04':
                return $temp[2] . ' April ' . $temp[0];
                break;
            case '05':
                return $temp[2] . ' Mei ' . $temp[0];
                break;
            case '06':
                return $temp[2] . ' Juni ' . $temp[0];
                break;
            case '07':
                return $temp[2] . ' Juli ' . $temp[0];
                break;
            case '08':
                return $temp[2] . ' Agustus ' . $temp[0];
                break;
            case '09':
                return $temp[2] . ' September ' . $temp[0];
                break;
            case '10':
                return $temp[2] . ' Oktober ' . $temp[0];
                break;
            case '11':
                return $temp[2] . ' November ' . $temp[0];
                break;
            case '12':
                return $temp[2] . ' Desember ' . $temp[0];
                break;
            default:
                return '';
                break;
        }
    }

    function data_riwayat_antrian($layanan, $pasien, $jadwal, $waktu, $antrian)
    {
        $tabel_riwayat = new SMIS_Rwt_Antrian();
        $tabel_riwayat = $tabel_riwayat->getTable();
        $columns = Schema::getColumnListing($tabel_riwayat);
        $dataArray = [];

        foreach ($columns as $column) {
            $type_column = Schema::getColumnType($tabel_riwayat, $column);

            $default_input = "";
            if (in_array($type_column, ["integer", "boolean", 'tinyinteger'])) $default_input = 0;
            if (in_array($type_column, ["string", "text", 'varchar'])) $default_input = "";
            if (in_array($type_column, ["datetime"])) $default_input = '0000-00-00 00:00:00';

            $dataArray[$column] = @$layanan[$column] ?? $default_input;

            $kunjungan = DB::table('smis_rwt_antrian_' . $jadwal->slug_poli)->where('nrm_pasien', $pasien->id)->count();
            $origin_id_max = DB::table('smis_rwt_antrian_' . $jadwal->slug_poli)->orderBy('origin_id', 'desc')->first();
            $rl52 = SmisAdmSettings::where('name', 'smis-rs-rl52-default-' . $jadwal->slug_poli)->first();
            $origin_updated = SmisAdmSettings::where('name', 'smis_autonomous_id')->first();

            $detail = new stdClass();
            $detail->alamat = $pasien->alamat;
            $detail->ibu = $pasien->ibu;
            $detail->caradatang = $antrian->kedatangan;
            $detail->tgl_lahir = $pasien->tgl_lahir;
            $detail->no_profile = '';
            $detail->faskes = '';
            $dataArray['waktu'] = date('Y-m-d H:i:s', $waktu);
            $dataArray['no_register'] = $layanan['id'];
            $dataArray['no_bpjs'] = $antrian->nobpjs;
            $dataArray['kunjungan'] = $kunjungan == '0' ? 'Baru' : 'Lama';
            $dataArray['nama_pasien'] = $pasien->nama;
            $dataArray['jk'] = $pasien->kelamin;
            $dataArray['carabayar'] = $layanan['carabayar'];
            $dataArray['nrm_pasien'] = $pasien->nrm;
            $dataArray['nomor'] = $layanan['no_urut'];
            $dataArray['umur'] = $layanan['umur'];
            $dataArray['golongan_umur'] = $layanan['gol_umur'];
            $dataArray['asal'] = 'Pendaftaran';
            $dataArray['alamat'] = $pasien->alamat;
            $dataArray['autonomous'] = '[' . ($dataArray['origin_updated'] = $origin_updated ? $origin_updated->value : '') . ']';
            $dataArray['origin'] = $origin_updated ? $origin_updated->value : '';
            $dataArray['origin_id'] = $origin_id_max ? (int) $origin_id_max->origin_id + 1 : 1;
            $dataArray['origin_updated'] = $origin_updated ? $origin_updated->value : '';
            $dataArray['time_updated'] = date('Y-m-d H:i:s', $waktu);
            $dataArray['rl52'] = $rl52 ? $rl52->value : '';
            $dataArray['detail'] = json_encode($detail);

            return $dataArray;
        }
    }

    function data_layanan_pasien($req, $ant, $peserta, $add_peserta)
    {
        $jadwal = JadwalPoli::where('id', $ant->jadwal_id)->first();
        $table_pasien = new SMIS_LayananPasien();
        $table_pasien = $table_pasien->getTable();

        $columns = Schema::getColumnListing($table_pasien);
        $dataArray = [];

        foreach ($columns as $column) {
            $type_column = Schema::getColumnType($table_pasien, $column);

            $default_input = "";
            if (in_array($type_column, ["integer", "boolean", 'tinyinteger'])) $default_input = 0;
            if (in_array($type_column, ["string", "text", 'varchar'])) $default_input = "";
            if (in_array($type_column, ["datetime"])) $default_input = '0000-00-00 00:00:00';

            $dataArray[$column] = @$req[$column] ?? $default_input;
        }

        $jml_kunjungan = SMIS_LayananPasien::where('nrm', $req->id)->count();
        $origin_updated = SmisAdmSettings::where('name', 'smis_autonomous_id')->first();

        $barulama = $ant->pasien_baru == 1 ? 0 : 1;

        $karcis = SMIS_Mjm_Tarif_Pendaftaran::where('ruangan', $jadwal->slug_poli)->where('carabayar', $ant->carabayar)
            ->where('jenis_kunjungan', 'Kunjungan Sakit')->where('jenis_pasien', $barulama)->first();

        $tarif = 0;

        // if (strpos($ant->carabayar, 'bpjs') !== false) {
        //     $tarif = 10000;
        // } else {
        if ($karcis) {
            $tarif = $ant->jenis_kunjungan == 'SKS' ? 0 : $karcis->total_tarif;
        }
        // }

        $age = 'TGL LAHIR TDK VALID';
        $gol_umur = 'TGL LAHIR TDK VALID';

        if ($req->tgl_lahir != '0000-00-00') {
            $bday = new DateTime($req->tgl_lahir); // Your date of birth
            $today = new DateTime(date('y-m-d'));
            $diff = $today->diff($bday);
            $age = $diff->y . ' Tahun ' . $diff->m . ' Bulan ' . $diff->d . ' Hari';
            $gol_umur = $this->convert_gol_umur($diff->y, $diff->m, $diff->d);
        }

        $perujuk = DB::table('smis_rg_perujuk')->where('id', $ant->id_perujuk)->first();

        $last = SMIS_LayananPasien::select(DB::raw("MAX(REPLACE(id,'" . env('slug_klinik') . "','')*1) as id"))->where('id', 'like', env('slug_klinik') . '%')->first();
        $dataArray['id'] = !is_null($last) ? env('slug_klinik') . (string)((int)str_replace(env('slug_klinik'), '', $last->id) + 1) : env('slug_klinik') . (string)1;

        $dataArray['no_urut_pcare'] = $add_peserta ? $add_peserta->response->message : '';
        $dataArray['kode_ppk'] = $peserta ? $peserta->kdProviderPst->kdProvider : $req->kode_faskes;
        $dataArray['ppk_bpjs'] = $peserta ? $peserta->kdProviderPst->nmProvider : $req->faskes;
        $dataArray['ppk_bpjs_tujuan'] = $ant->unit_kerja;
        $dataArray['kode_ppk_tujuan'] = env('KODE_PPK');
        $dataArray['unit_kerja'] = $ant->unit_kerja;
        $dataArray['bpjs_kode_poli'] = $jadwal->kodepoli_bpjs;
        $dataArray['carabayar'] = $ant->carabayar;
        $dataArray['jenis_kunjungan'] = $ant->jenis_kunjungan;
        $dataArray['asuransi'] = $ant->asuransi;
        $dataArray['nama_perusahaan'] = $ant->perusahaan;
        $dataArray['id_pasien'] = $req->id;
        $dataArray['nrm'] = $req->nrm;
        $dataArray['nobpjs'] = $req->nobpjs;
        $dataArray['rujukan'] = $ant->jenis_perujuk ? $ant->jenis_perujuk : '';
        $dataArray['id_rujukan'] = $ant->id_perujuk ? $ant->id_perujuk : '';
        $dataArray['nama_rujukan'] = $perujuk ? $perujuk->nama : '';
        $dataArray['umur'] = $age;
        $dataArray['caradatang'] = $ant->kedatangan ? $ant->kedatangan : '';
        $dataArray['gol_umur'] = $gol_umur;
        $dataArray['namapenanggungjawab'] = $ant->namapj ? $ant->namapj : '';
        $dataArray['telponpenanggungjawab'] = $ant->telppj ? $ant->telppj : '';
        $dataArray['no_urut'] = $ant->angkaantrean;
        $dataArray['jenislayanan'] = $jadwal->slug_poli;
        $dataArray['kelamin'] = $req->kelamin;
        $dataArray['barulama'] = $jml_kunjungan == 0 ? 0 : 1;
        $dataArray['no_kunjungan'] = $jml_kunjungan + 1;
        $dataArray['tanggal'] = date('Y-m-d H:i:s', strtotime('now'));
        $dataArray['alamat_pasien'] = $req->alamat;
        $dataArray['nama_provinsi'] = $req->nama_provinsi;
        $dataArray['nama_kabupaten'] = $req->nama_kabupaten;
        $dataArray['nama_kecamatan'] = $req->nama_kecamatan;
        $dataArray['nama_kelurahan'] = $req->nama_kelurahan;
        $dataArray['nama_pasien'] = $req->nama;
        $dataArray['id_dokter'] = $jadwal->id_dokter;
        $dataArray['nama_dokter'] = $jadwal->nama_dokter;
        $dataArray['prop'] = "";
        $dataArray['time_updated'] = date('Y-m-d H:i:s', strtotime('now'));
        $dataArray['origin_updated'] = 'ideklinik_pcare';
        $dataArray['origin'] = "";
        $dataArray['karcis'] = $tarif;
        $dataArray['autonomous'] = "";
        return $dataArray;
    }

    function convert_gol_umur($tahun, $bulan, $hari)
    {
        if ($tahun == 0 && $bulan == 0) {
            return '0 - 28 HR';
        }
        if (($tahun <= 1 && $bulan > 0) && ($tahun <= 1 && $hari >= 0)) {
            return '28 HR - 1 TH';
        }

        if ((($tahun >= 1 && $hari >= 0) || ($tahun >= 1 && $bulan > 0)) && $tahun < 5) {
            return '1 - 4 TH';
        } else if ($tahun >= 5 && $tahun <= 14) {
            return '5-14 TH';
        } else if ($tahun > 14 && $tahun <= 24) {
            return '15-24 TH';
        } else if ($tahun > 24 && $tahun <= 44) {
            return '25-44 TH';
        } else if ($tahun > 44 && $tahun <= 59) {
            return '45-59 TH';
        } else if ($tahun > 59 && $tahun <= 64) {
            return '60-64 TH';
        } else if ($tahun > 64) {
            return '>65 TH';
        }
    }

    function hapus_mjkn($id)
    {
        Mjkn_Patient::findOrFail($id);
        $query = Mjkn_Patient::where('id', $id)->update([
            'origin_updated' => 'deleted'
        ]);
        return $query;
    }
}
