<?php

namespace App\Providers;

use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Blade::directive('currency', function ($expression) {
            return "<?php echo  number_format($expression,0,',','.'); ?>";
        });

        Blade::directive('date', function ($expression) {
            return "<?php echo  date('d-m-Y', strtotime($expression)) ?>";
        });

        Blade::directive('parse_', function ($expression) {
            return "<?php echo  ucwords(str_replace('_', ' ', $expression)) ?>";
        });
    }
}
