<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SMIS_Pasien extends Model
{
    use HasFactory;

    protected $table = 'smis_rg_patient';

    public $incrementing = false;

    function kunjungan(){
        return $this->hasMany('App\Models\SMIS_LayananPasien', 'nrm', 'id')->orderBy('tanggal', 'desc');
    }

    function erm(){
        return $this->hasOne('App\Models\ERekamMedis', 'nrm','id');
    }

    function get_pasien_with_asuransi($rm){
        return SMIS_Pasien::leftJoin('smis_rg_layananpasien', 'smis_rg_patient.id', 'smis_rg_layananpasien.nrm')
                ->leftJoin('smis_rg_asuransi', 'smis_rg_layananpasien.asuransi', 'smis_rg_asuransi.id')
                ->select(
                    'smis_rg_layananpasien.jenislayanan',
                    'smis_rg_layananpasien.kabupaten_pj',
                    'smis_rg_layananpasien.kecamatan_pj',
                    'smis_rg_layananpasien.desa_pj',
                    'smis_rg_layananpasien.alamat_pj',
                    'smis_rg_layananpasien.namapenanggungjawab',
                    'smis_rg_layananpasien.telponpenanggungjawab',
                    'smis_rg_patient.id as nrm',
                    'smis_rg_patient.nobpjs as nobpjs',
                    'smis_rg_patient.nama as nama',
                    'smis_rg_patient.alamat as alamat',
                    'smis_rg_patient.nama_kelurahan as kelurahan',
                    'smis_rg_patient.nama_kecamatan as kecamatan',
                    'smis_rg_patient.nama_kabupaten as kabupaten',
                    'smis_rg_layananpasien.carabayar',
                    'smis_rg_layananpasien.asuransi as asuransi',
                    'smis_rg_layananpasien.nama_perusahaan as perusahaan',
                    'smis_rg_patient.telpon',
                    'smis_rg_patient.pekerjaan',
                    'smis_rg_patient.pendidikan',
                    'smis_rg_patient.suku',
                    'smis_rg_patient.agama',
                    'smis_rg_patient.status',
                    'smis_rg_patient.tgl_lahir',
                    'smis_rg_patient.kelamin',
                    'smis_rg_asuransi.nama as asuransi',
                    'smis_rg_patient.ukerja'
                )
                ->where('smis_rg_patient.id', $rm->nrm)
                ->orderBy('smis_rg_layananpasien.id', 'asc')->first();
    }
}
