<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class KonsultasiPoliLainRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id_kepada' => 'required',
            'kepada' => 'required',
            'tanggal' => 'required',
            'jam' => 'required',
            'jenis' => 'required',
            'keterangan' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'kepada.required' => 'Pilih Kepada Yth dahulu',
            'id_kepada.required' => 'Pilih Kepada Yth dahulu',
            'tanggal.required' => 'Pilih tanggal dahulu',
            'jam.required' => 'Pilih jam dahulu',
            'jenis.required' => 'Pilih jenis konsultasi dahulu',
            'keterangan.required' => 'Keterangan harus diisi',
        ];
    }
}
