<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class InformedConsentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'tanggal' => 'required',
            'jam_awal' => 'required',
            'id_dokter_pelaksana' => 'required',
            'dokter_pelaksana' => 'required',
            'id_pemberi_informasi' => 'required',
            'pemberi_informasi' => 'required',
            'penerima_informasi' => 'required',
            'hubungan' => 'required',
            'dasar_diagnosis' => 'required',
            'tindakan_kedokteran' => 'required',
            'indikasi_tindakan' => 'required',
            'tata_cara' => 'required',
            'tujuan' => 'required',
            'risiko' => 'required',
            'komplikasi' => 'required',
            'prognosis' => 'required',
            'alternatif_resiko' => 'required',
            'lain_lain' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'tanggal.required' => 'Pilih tanggal dahulu',
            'jam_awal.required' => 'Pilih jam awal asesmen dahulu',
            'id_dokter_pelaksana.required' => 'Dokter pelaksana harus diisi',
            'id_pemberi_informasi.required' => 'Pemberi Informasi harus diisi',
            'dokter_pelaksana.required' => 'Dokter pelaksana harus diisi',
            'pemberi_informasi.required' => 'Pemberi Informasi harus diisi',
            'penerima_informasi.required' => 'Penerima Informasi harus diisi',
            'hubungan.required' => 'Hubungan dengan pasien harus diisi',
            'dasar_diagnosis.required' => 'Dasar diagnosis harus diisi',
            'tindakan_kedokteran.required' => 'Tindakan kedokteran harus diisi',
            'indikasi_tindakan.required' => 'Indikasi tindakan harus diisi',
            'tata_cara.required' => 'Tata cara harus diisi',
            'tujuan.required' => 'Tujuan harus diisi',
            'risiko.required' => 'Risiko harus diisi',
            'komplikasi.required' => 'Komplikasi harus diisi',
            'prognosis.required' => 'Prognosis harus diisi',
            'alternatif_resiko.required' => 'Alternatif resiko harus diisi',
            'lain_lain.required' => 'Lain-lain harus diisi',
        ];
    }
}
