<?php

namespace App\Http\Controllers\SatuSehat;

use App\Exports\FailedSatuSehatRawatJalanExport;
use App\Http\Controllers\Controller;
use App\Models\SMIS_LayananPasien;
use App\Models\SMIS_Pasien;
use App\Services\SatuSehat\RawatJalanService;
use App\Services\SatuSehat\SendRequestService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Yajra\DataTables\Facades\DataTables;
use Maatwebsite\Excel\Facades\Excel;

class RawatJalanController extends Controller
{
    function __construct()
    {
        $this->middleware(function ($request, $next) {
            $menu = json_decode(Auth::user()->menu);
            if (property_exists($menu, 'satu_sehat')) {
                $arr = (array) $menu->satu_sehat;
                if ($arr['rawat_jalan'] == 0) {
                    return redirect('home');
                }
            } else {
                return redirect('home');
            }
            return $next($request);
        });
    }

    function index()
    {
        return view('satu_sehat.rawat_jalan.index');
    }

    function filter(Request $req)
    {
        $query = SMIS_LayananPasien::leftJoin('smis_mr_diagnosa', 'smis_mr_diagnosa.noreg_pasien', 'smis_rg_layananpasien.id')
            ->where(function ($q) use ($req) {
                $q->whereDate('smis_rg_layananpasien.tanggal', '>=', $req->dari)->whereDate('smis_rg_layananpasien.tanggal', '<=', $req->sampai);
            })->where('smis_rg_layananpasien.prop', '')->where('smis_rg_layananpasien.uri', 0)->where('smis_rg_layananpasien.id', 'like', '%'.env('slug_klinik').'%')
            ->where('selesai', 1)->where(function($z){
                $z->where('smis_rg_layananpasien.carapulang','!=','Tidak Datang')->orWhere('smis_rg_layananpasien.carapulang','!=','Rawat Inap');
            })
            ->select(
                'smis_rg_layananpasien.id',
                'smis_rg_layananpasien.nama_pasien',
                'smis_rg_layananpasien.nrm',
                'smis_rg_layananpasien.jenislayanan',
                'smis_rg_layananpasien.tanggal',
                'smis_rg_layananpasien.status_ss',
                'smis_mr_diagnosa.nama_icd',
            )->get();
        return response()->json($query);
    }

    function datatable(Request $req)
    {
        $query = SMIS_LayananPasien::leftJoin('smis_mr_diagnosa', 'smis_mr_diagnosa.noreg_pasien', 'smis_rg_layananpasien.id')
            ->where(function ($q) use ($req) {
                $q->whereDate('smis_rg_layananpasien.tanggal', '>=', $req->dari)->whereDate('smis_rg_layananpasien.tanggal', '<=', $req->sampai);
            })->where('smis_rg_layananpasien.prop', '')->where('smis_rg_layananpasien.uri', 0)->where('smis_rg_layananpasien.id', 'like', '%'.env('slug_klinik').'%')
            ->where('selesai', 1)->where(function($z){
                $z->where('smis_rg_layananpasien.carapulang','!=','Tidak Datang')->orWhere('smis_rg_layananpasien.carapulang','!=','Rawat Inap');
            })
            ->select(
                'smis_rg_layananpasien.id',
                'smis_rg_layananpasien.nama_pasien',
                'smis_rg_layananpasien.nrm',
                'smis_rg_layananpasien.jenislayanan',
                'smis_rg_layananpasien.tanggal',
                'smis_rg_layananpasien.status_ss',
                'smis_rg_layananpasien.response_code_satu_sehat',
                'smis_mr_diagnosa.nama_icd',
            );
        return DataTables::of($query)->make(true);
    }

    function send(Request $req)
    {
        try {
            $result = (new RawatJalanService)->send($req->id);
            return response()->json($result);
        } catch (\Throwable $th) {
            return response()->json([
                'code' => 500,
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }

    function export(Request $req){
        return Excel::download(new FailedSatuSehatRawatJalanExport($req), 'Data_gagal_kirim_satu_sehat_tanggal_'.date('d_m_y', strtotime($req->from)).'_sampai_'.date('d_m_y', strtotime($req->to)).'.xlsx');
    }
}
