<?php

namespace App\Http\Controllers;

use App\Http\Requests\PemeriksaanPcrAntigenRequest;
use App\Services\PemeriksaanPcrAntigenService;
use App\Services\SuratKeteranganSehatService;
use Illuminate\Http\Request;
use PDF;
use RealRashid\SweetAlert\Facades\Alert;
use Auth;

class PemeriksaanPcrAntigenController extends Controller
{
    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $menu = json_decode(Auth::user()->menu);
            if (property_exists($menu, 'medical_record')) {
                $arr = (array) $menu->medical_record;
                if ($arr['pemeriksaan_pcr_antigen'] == 0) {
                    return redirect('home');
                }
            } else {
                return redirect('home');
            }
            return $next($request);
        });
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, PemeriksaanPcrAntigenService $pemeriksaanPcrAntigenService)
    {
        return view('pemeriksaan_pcr_antigen.index', [
            'datas' => $pemeriksaanPcrAntigenService->getPemeriksaanPcrAntigen($request->keyword)->paginate(10),
            'keyword' => $request->keyword ?? ""
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(PemeriksaanPcrAntigenService $pemeriksaanPcrAntigenService, SuratKeteranganSehatService $suratKeteranganSehatService)
    {
        return view('pemeriksaan_pcr_antigen.add_edit', [
            'petugas' => $pemeriksaanPcrAntigenService->getPetugas(),
            'tanggal' => $suratKeteranganSehatService->konversiTanggal(date('d-m-Y')),
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(PemeriksaanPcrAntigenRequest $request, PemeriksaanPcrAntigenService $pemeriksaanPcrAntigenService)
    {
        $createData = $pemeriksaanPcrAntigenService->store($request);
        if ($createData == "sukses") {
            Alert::success("Sukses", "Data Berhasil Disimpan");
            return redirect(route('pemeriksaan_pcr_antigen.index'));
        }
        return redirect()->back()->withErrors($createData);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, PemeriksaanPcrAntigenService $pemeriksaanPcrAntigenService)
    {
        $data = $pemeriksaanPcrAntigenService->getPemeriksaanPcrAntigenById($id);
        PDF::setOptions(['defaultFont' => 'sans-serif']);
        $pdf = PDF::loadView('pemeriksaan_pcr_antigen.pdf', ['data' => $data])->setPaper('Letter', 'portrait');
        return $pdf->download('Hasil ' . $data->pemeriksaan . ' ' . $data->nama . '.pdf');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, PemeriksaanPcrAntigenService $pemeriksaanPcrAntigenService, SuratKeteranganSehatService $suratKeteranganSehatService)
    {
        return view('pemeriksaan_pcr_antigen.add_edit', [
            'data' => $pemeriksaanPcrAntigenService->getPemeriksaanPcrAntigenById($id),
            'petugas' => $pemeriksaanPcrAntigenService->getPetugas(),
            'tanggal' => $suratKeteranganSehatService->konversiTanggal(date('d-m-Y')),
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, PemeriksaanPcrAntigenService $pemeriksaanPcrAntigenService)
    {
        $deleteData = $pemeriksaanPcrAntigenService->delete($id);
        if ($deleteData == "sukses") {
            Alert::success("Sukses", "Data Berhasil Dihapus");
            return redirect(route('pemeriksaan_pcr_antigen.index'));
        }
        return redirect()->back()->withErrors($deleteData);
    }
}
