<?php

namespace App\Http\Controllers\MedicalRecord\ERekamMedis;

use App\Http\Controllers\Controller;
use App\Models\DokumenKunjungan;
use App\Models\ERekamMedis;
use App\Models\SMIS_LayananPasien;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ERekamMedisController extends Controller
{
    function index()
    {
        return view('medical_record.e_rekam_medis.index');
    }

    function ajax_cari_pasien(Request $req)
    {
        return response()->json(DB::table('smis_rg_patient')->where('ukerja', env('NAMA_KLINIK'))->where('nrm', $req->nrm)->where('prop','')->first());
    }

    function ajax_history_kunjungan(Request $req)
    {
        $query = SMIS_LayananPasien::with('diagnosa')->where('id_pasien', $req->id)
        ->select('smis_rg_layananpasien.id', 'smis_rg_layananpasien.tanggal','smis_rg_layananpasien.jenislayanan')
        ->orderBy('tanggal', 'desc')->get();
        return response()->json($query);
    }

    function ajax_dokumen_pasien(Request $req)
    {
        $query = DB::table('e_rekam_medis_pasien')->where('nrm', $req->nrm)->where('unit_kerja', env('slug_klinik'))->where('prop','')->get();
        return response()->json($query);
    }

    function ajax_dokumen_kunjungan(Request $req)
    {
        $query = DB::table('dokumen_kunjungan_pasien')->where('noreg', $req->noreg)->where('prop','')->get();
        return response()->json($query);
    }

    function ajax_create_dokumen_pasien(Request $req)
    {
        try {
            if ($req->nrm == null) {
                return response()->json([
                    'status' => false,
                    'code' => 404,
                    'message' => 'Pasien tidak valid',
                ]);
            }

            $pasien = DB::table('smis_rg_patient')->where('nrm', $req->nrm)->where('prop','')->where('id', 'like', '%'.env('slug_klinik').'%')->first();

            ERekamMedis::create([
                'nrm' => $pasien->nrm ?? '',
                'nama_pasien' => $pasien->nama ?? '',
                'nama_dokumen' => $req->dokumen,
                'unit_kerja' => env('slug_klinik'),
            ]);

            return response()->json([
                'status' => true,
                'code' => 200,
                'message' => 'Ok.',
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'code' => 500,
                'message' => $th->getMessage(),
            ]);
        }
    }

    function ajax_create_dokumen_kunjungan(Request $req)
    {
        try {
            $layanan = DB::table('smis_rg_layananpasien')->where('id', $req->noreg)->where('prop','')->first();
            DokumenKunjungan::create([
                'noreg' => $layanan->id ?? '',
                'nrm' => $layanan->nrm ?? '',
                'nama_pasien' => $layanan->nama_pasien ?? '',
                'tanggal' => $layanan ? date('Y-m-d', strtotime($layanan->tanggal)) : '',
                'nama_dokumen' => $req->dokumen,
            ]);

            return response()->json([
                'status' => true,
                'code' => 200,
                'message' => 'Ok.',
                'data' => $layanan
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'code' => 500,
                'message' => $th->getMessage(),
            ]);
        }
    }
}
