<?php

namespace App\Http\Controllers;

use App\Http\Requests\JadwalPoliRequest;
use Illuminate\Http\Request;
use App\Models\ReferensiDokter;
use App\Models\ReferensiPoli;
use App\Models\SmisAdmPrototype;
use App\Models\SmisAdmSettings;
use App\Models\SmisHrdEmployee;
use App\Models\JadwalPoli;
use App\Models\RsCredential;
use Illuminate\Support\Facades\Validator;
use DB;
use GuzzleHttp\Client;
use Auth;

class JadwalPoliLocalController extends Controller
{
    function __construct()
    {
        $this->middleware(function ($request, $next) {
            $menu = json_decode(Auth::user()->menu);
            if (property_exists($menu, 'jadwal_poli')) {
                $arr = (array) $menu->jadwal_poli;
                if ($arr['local'] == 0) {
                    return redirect('home');
                }
            } else {
                return redirect('home');
            }
            return $next($request);
        });
    }

    function index(Request $req)
    {
        $data['poli'] = ReferensiPoli::all();
        $data['dokter'] = ReferensiDokter::all();
        $data['dokter_local'] = SmisHrdEmployee::join('smis_hrd_job', 'smis_hrd_job.id', 'smis_hrd_employee.jabatan')
            ->select('smis_hrd_employee.id', 'smis_hrd_employee.nama')
            ->where('smis_hrd_job.nama', 'like', '%dokter%')->where('smis_hrd_employee.prop', '')->get();

        $poli_local = [];
        $proto = SmisAdmPrototype::where('parent', 'rawat')->where('prop', '<>', 'del')->get();
        foreach ($proto as $pro) {
            $cek = SmisAdmSettings::where('name', 'smis-rs-urjip-' . $pro->slug)->select('value')->first();
            if ($cek) {
                if ($cek->value == 'URJ') {
                    array_push($poli_local, $pro);
                }
            }
        }

        $jadwal_poli = JadwalPoli::where('prop', '')->where('slug_poli', 'like', '%'.env('slug_klinik').'%');

        if ($req->dokter) {
            $jadwal_poli->where('id_dokter', $req->dokter);
        }

        if ($req->hari) {
            $jadwal_poli->where('hari', $req->hari);
        }

        $data['poli_local'] = $poli_local;
        $data['data'] = $jadwal_poli->paginate(10)->setPath('?hari='.$req->hari.'&dokter='.$req->dokter);
        $data['keyword'] = '';
        $data['filter_dokter'] = $req->dokter ?? '';
        $data['filter_hari'] = $req->hari ?? '';
        return view('jadwal_poli.local', $data);
    }

    function ajax_request_select_jadwal_poli(Request $req)
    {
        $data = JadwalPoli::findOrFail($req->id);
        return response()->json($data);
    }

    function post_jadwal_poli(JadwalPoliRequest $req)
    {
        $poli_local = null;
        $proto = SmisAdmPrototype::where('parent', 'rawat')->where('prop', '<>', 'del')->get();
        foreach ($proto as $pro) {
            $cek = SmisAdmSettings::where('name', 'smis-rs-urjip-' . $pro->slug)->select('value')->first();
            if ($cek) {
                if ($cek->value == 'URJ' && $pro->slug == $req->poli) {
                    $poli_local = $pro;
                }
            }
        }
        $dokter = SmisHrdEmployee::findOrFail($req->dokter);
        $poli = ReferensiPoli::where('kode_poli', $req->poli_pcare)->first();
        try {
            $ins = DB::table('smis_rg_jadwalpoli')->insert([
                'kuota' => $req->kuota,
                'kodepoli_bpjs' => $poli ? $poli->kode_poli : '',
                'kodesubspesialis_bpjs' => $poli ? $poli->kode_poli : '',
                'prop' => '',
                'poli_ke' => $req->poli_ke ?? '',
                'nama_poli' => $poli_local ? $poli_local->nama : '',
                'slug_poli' => $poli_local ? $poli_local->slug : '',
                'nama_dokter' => $dokter ? $dokter->nama : '',
                'kodedokter_bpjs' => $req->dokter_bpjs ? $req->dokter_bpjs : '',
                'id_dokter' => $req->dokter ? $req->dokter : '',
                'jam_mulai' => $req->jam_mulai,
                'jam_selesai' => $req->jam_selesai,
                'hari' => $req->hari,
                'estimasi_layanan' => $req->estimasi,
                'bobot' => 0,
                'autonomous' => '',
                'duplicate' => 0,
                'origin' => '',
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => '',
                'nama_poli_pcare' => $poli ? $poli->nama_poli : ''
            ]);

            $data['filter_dokter'] = $req->filter_dokter ?? '';
            $data['filter_hari'] = $req->filter_hari ?? '';
            $data['page'] = $req->page ?? 1;

            return redirect('jadwal_poli/local?dokter='.$data['filter_dokter'].'&hari='.$data['filter_hari'])->with('sukses', 'Jadwal poli berhasil ditambahkan');
        } catch (\Throwable $th) {
            return redirect('jadwal_poli/local')->with('gagal', $th->getMessage());
        }
    }

    function get_signature($timeStamp, $cons_id, $cons_secret)
    {
        $signature = hash_hmac('sha256', $cons_id . "&" . $timeStamp, $cons_secret, true);
        $encodedSignature = base64_encode($signature);
        return $encodedSignature;
    }

    function update_jadwal_poli(JadwalPoliRequest $req)
    {
        $poli_local = null;
        $proto = SmisAdmPrototype::where('parent', 'rawat')->where('prop', '<>', 'del')->get();
        foreach ($proto as $pro) {
            $cek = SmisAdmSettings::where('name', 'smis-rs-urjip-' . $pro->slug)->select('value')->first();
            if ($cek) {
                if ($cek->value == 'URJ' && $pro->slug == $req->poli) {
                    $poli_local = $pro;
                }
            }
        }
        $dokter = SmisHrdEmployee::findOrFail($req->dokter);
        $poli = ReferensiPoli::where('kode_poli', $req->poli_pcare)->first();
        try {
            $ins = DB::table('smis_rg_jadwalpoli')->where('id', $req->id)->update([
                'kuota' => $req->kuota,
                'kodepoli_bpjs' => $poli ? $poli->kode_poli : '',
                'kodesubspesialis_bpjs' => $poli ? $poli->kode_poli : '',
                'prop' => '',
                'poli_ke' => $req->poli_ke ?? '',
                'nama_poli' => $poli_local ? $poli_local->nama : '',
                'slug_poli' => $poli_local ? $poli_local->slug : '',
                'nama_dokter' => $dokter ? $dokter->nama : '',
                'kodedokter_bpjs' => $req->dokter_bpjs ? $req->dokter_bpjs : '',
                'id_dokter' => $req->dokter ? $req->dokter : '',
                'jam_mulai' => $req->jam_mulai,
                'jam_selesai' => $req->jam_selesai,
                'hari' => $req->hari,
                'estimasi_layanan' => $req->estimasi,
                'bobot' => 0,
                'autonomous' => '',
                'duplicate' => 0,
                'origin' => '',
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => '',
                'nama_poli_pcare' => $poli ? $poli->nama_poli : ''
            ]);
            $data['filter_dokter'] = $req->filter_dokter ?? '';
            $data['filter_hari'] = $req->filter_hari ?? '';
            $data['page'] = $req->page ?? 1;

            return redirect('jadwal_poli/local?dokter='.$data['filter_dokter'].'&hari='.$data['filter_hari'])->with('sukses', 'Jadwal poli berhasil diubah');
        } catch (\Throwable $th) {
            return redirect('jadwal_poli/local')->with('gagal', $th->getMessage());
        }
    }

    function delete_jadwal_poli(Request $req)
    {
        $poli = JadwalPoli::findOrFail($req->id);
        try {
            $poli->update([
                'prop' => 'del'
            ]);
            return redirect('jadwal_poli/local')->with('sukses', 'Jadwal poli berhasil dihapus');
        } catch (\Throwable $th) {
            return redirect('jadwal_poli/local')->with('gagal', $th->getMessage());
        }
    }

    function dokter_pcare(Request $req){
        $credentials = RsCredential::where('layanan', 'antrian')->where('slug_klinik', env('slug_klinik'))->first();

        if ($credentials == null) {
            return response()->json([
                'status' => false,
                'message' => 'Credential RS tidak ditemukan'
            ]);
        }

        try {
            date_default_timezone_set('UTC');
            $timeStamp = strval(time() - strtotime('1970-01-01 00:00:00'));
            $signature = $this->get_signature($timeStamp, $credentials->cons_id, $credentials->cons_secret);
            $guzzleClient = new Client([
                'verify' => false
            ]);
            $response = $guzzleClient->request('get', $credentials->base_url . '/ref/dokter/kodepoli/'.$req->poli.'/tanggal/'.$req->tanggal, [
                'headers' => [
                    'X-cons-id'     => $credentials->cons_id,
                    'X-timestamp'  => $timeStamp,
                    'X-signature'   => $signature,
                    'user_key' => $credentials->user_key,
                ]
            ]);
            $list = json_decode($response->getBody()->getContents());
            return [
                'status' => true,
                'data' => $list->metadata->code == 200 ? json_decode($this->decompress($this->stringDecrypt($credentials->cons_id.$credentials->cons_secret.$timeStamp,$list->response))) : [],
            ];
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }

    function poli_pcare(Request $req){
        $credentials = RsCredential::where('layanan', 'antrian')->where('slug_klinik', env('slug_klinik'))->first();

        if ($credentials == null) {
            return response()->json([
                'status' => false,
                'message' => 'Credential RS tidak ditemukan'
            ]);
        }

        try {
            date_default_timezone_set('UTC');
            $timeStamp = strval(time() - strtotime('1970-01-01 00:00:00'));
            $signature = $this->get_signature($timeStamp, $credentials->cons_id, $credentials->cons_secret);
            $guzzleClient = new Client([
                'verify' => false
            ]);
            $response = $guzzleClient->request('get', $credentials->base_url . '/ref/poli/tanggal/'.$req->tanggal, [
                'headers' => [
                    'X-cons-id'     => $credentials->cons_id,
                    'X-timestamp'  => $timeStamp,
                    'X-signature'   => $signature,
                    'user_key' => $credentials->user_key,
                ]
            ]);
            $list = json_decode($response->getBody()->getContents());
            return [
                'status' => true,
                'data' => $list->metadata->code == 200 ? json_decode($this->decompress($this->stringDecrypt($credentials->cons_id.$credentials->cons_secret.$timeStamp,$list->response))) : [],
            ];
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }

    function stringDecrypt($key, $string)
    {
        $encrypt_method = 'AES-256-CBC';

        // hash
        $key_hash = hex2bin(hash('sha256', $key));

        // iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
        $iv = substr(hex2bin(hash('sha256', $key)), 0, 16);

        $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key_hash, OPENSSL_RAW_DATA, $iv);

        return $output;
    }

    function decompress($string){
      
        return \LZCompressor\LZString::decompressFromEncodedURIComponent($string);

    }
}
